# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ZeroTrustRiskScoreIntegrationArgs', 'ZeroTrustRiskScoreIntegration']

@pulumi.input_type
class ZeroTrustRiskScoreIntegrationArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[str],
                 integration_type: pulumi.Input[str],
                 tenant_url: pulumi.Input[str],
                 active: Optional[pulumi.Input[bool]] = None,
                 reference_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ZeroTrustRiskScoreIntegration resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource.
        :param pulumi.Input[str] integration_type: The type of integration, e.g. 'Okta'. Full list of allowed values can be found here: https://developers.cloudflare.com/api/operations/dlp-zt-risk-score-integration-create#request-body
        :param pulumi.Input[str] tenant_url: The base url of the tenant, e.g. 'https://tenant.okta.com'. Must be your Okta Tenant URL and not your custom domain.
        :param pulumi.Input[bool] active: Whether this integration is enabled. If disabled, no risk changes will be exported to the third-party.
        :param pulumi.Input[str] reference_id: A reference id that can be supplied by the client. Currently this should be set to the Access-Okta IDP ID (a UUIDv4). If omitted, a random UUIDv4 is used. https://developers.cloudflare.com/api/operations/access-identity-providers-get-an-access-identity-provider
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "integration_type", integration_type)
        pulumi.set(__self__, "tenant_url", tenant_url)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if reference_id is not None:
            pulumi.set(__self__, "reference_id", reference_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[str]:
        """
        The account identifier to target for the resource.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="integrationType")
    def integration_type(self) -> pulumi.Input[str]:
        """
        The type of integration, e.g. 'Okta'. Full list of allowed values can be found here: https://developers.cloudflare.com/api/operations/dlp-zt-risk-score-integration-create#request-body
        """
        return pulumi.get(self, "integration_type")

    @integration_type.setter
    def integration_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "integration_type", value)

    @property
    @pulumi.getter(name="tenantUrl")
    def tenant_url(self) -> pulumi.Input[str]:
        """
        The base url of the tenant, e.g. 'https://tenant.okta.com'. Must be your Okta Tenant URL and not your custom domain.
        """
        return pulumi.get(self, "tenant_url")

    @tenant_url.setter
    def tenant_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_url", value)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this integration is enabled. If disabled, no risk changes will be exported to the third-party.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="referenceId")
    def reference_id(self) -> Optional[pulumi.Input[str]]:
        """
        A reference id that can be supplied by the client. Currently this should be set to the Access-Okta IDP ID (a UUIDv4). If omitted, a random UUIDv4 is used. https://developers.cloudflare.com/api/operations/access-identity-providers-get-an-access-identity-provider
        """
        return pulumi.get(self, "reference_id")

    @reference_id.setter
    def reference_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reference_id", value)


@pulumi.input_type
class _ZeroTrustRiskScoreIntegrationState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 active: Optional[pulumi.Input[bool]] = None,
                 integration_type: Optional[pulumi.Input[str]] = None,
                 reference_id: Optional[pulumi.Input[str]] = None,
                 tenant_url: Optional[pulumi.Input[str]] = None,
                 well_known_url: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ZeroTrustRiskScoreIntegration resources.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource.
        :param pulumi.Input[bool] active: Whether this integration is enabled. If disabled, no risk changes will be exported to the third-party.
        :param pulumi.Input[str] integration_type: The type of integration, e.g. 'Okta'. Full list of allowed values can be found here: https://developers.cloudflare.com/api/operations/dlp-zt-risk-score-integration-create#request-body
        :param pulumi.Input[str] reference_id: A reference id that can be supplied by the client. Currently this should be set to the Access-Okta IDP ID (a UUIDv4). If omitted, a random UUIDv4 is used. https://developers.cloudflare.com/api/operations/access-identity-providers-get-an-access-identity-provider
        :param pulumi.Input[str] tenant_url: The base url of the tenant, e.g. 'https://tenant.okta.com'. Must be your Okta Tenant URL and not your custom domain.
        :param pulumi.Input[str] well_known_url: The URL for the Shared Signals Framework configuration, e.g. '/.well-known/sse-configuration/{integration*uuid}/'. https://openid.net/specs/openid-sse-framework-1*0.html#rfc.section.6.2.1
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if integration_type is not None:
            pulumi.set(__self__, "integration_type", integration_type)
        if reference_id is not None:
            pulumi.set(__self__, "reference_id", reference_id)
        if tenant_url is not None:
            pulumi.set(__self__, "tenant_url", tenant_url)
        if well_known_url is not None:
            pulumi.set(__self__, "well_known_url", well_known_url)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The account identifier to target for the resource.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this integration is enabled. If disabled, no risk changes will be exported to the third-party.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="integrationType")
    def integration_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of integration, e.g. 'Okta'. Full list of allowed values can be found here: https://developers.cloudflare.com/api/operations/dlp-zt-risk-score-integration-create#request-body
        """
        return pulumi.get(self, "integration_type")

    @integration_type.setter
    def integration_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "integration_type", value)

    @property
    @pulumi.getter(name="referenceId")
    def reference_id(self) -> Optional[pulumi.Input[str]]:
        """
        A reference id that can be supplied by the client. Currently this should be set to the Access-Okta IDP ID (a UUIDv4). If omitted, a random UUIDv4 is used. https://developers.cloudflare.com/api/operations/access-identity-providers-get-an-access-identity-provider
        """
        return pulumi.get(self, "reference_id")

    @reference_id.setter
    def reference_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reference_id", value)

    @property
    @pulumi.getter(name="tenantUrl")
    def tenant_url(self) -> Optional[pulumi.Input[str]]:
        """
        The base url of the tenant, e.g. 'https://tenant.okta.com'. Must be your Okta Tenant URL and not your custom domain.
        """
        return pulumi.get(self, "tenant_url")

    @tenant_url.setter
    def tenant_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_url", value)

    @property
    @pulumi.getter(name="wellKnownUrl")
    def well_known_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL for the Shared Signals Framework configuration, e.g. '/.well-known/sse-configuration/{integration*uuid}/'. https://openid.net/specs/openid-sse-framework-1*0.html#rfc.section.6.2.1
        """
        return pulumi.get(self, "well_known_url")

    @well_known_url.setter
    def well_known_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "well_known_url", value)


class ZeroTrustRiskScoreIntegration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 active: Optional[pulumi.Input[bool]] = None,
                 integration_type: Optional[pulumi.Input[str]] = None,
                 reference_id: Optional[pulumi.Input[str]] = None,
                 tenant_url: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The [Risk Score Integration](https://developers.cloudflare.com/cloudflare-one/insights/risk-score/#send-risk-score-to-okta) resource allows you to transmit changes in User Risk Score to a specified vendor such as Okta.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource.
        :param pulumi.Input[bool] active: Whether this integration is enabled. If disabled, no risk changes will be exported to the third-party.
        :param pulumi.Input[str] integration_type: The type of integration, e.g. 'Okta'. Full list of allowed values can be found here: https://developers.cloudflare.com/api/operations/dlp-zt-risk-score-integration-create#request-body
        :param pulumi.Input[str] reference_id: A reference id that can be supplied by the client. Currently this should be set to the Access-Okta IDP ID (a UUIDv4). If omitted, a random UUIDv4 is used. https://developers.cloudflare.com/api/operations/access-identity-providers-get-an-access-identity-provider
        :param pulumi.Input[str] tenant_url: The base url of the tenant, e.g. 'https://tenant.okta.com'. Must be your Okta Tenant URL and not your custom domain.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ZeroTrustRiskScoreIntegrationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The [Risk Score Integration](https://developers.cloudflare.com/cloudflare-one/insights/risk-score/#send-risk-score-to-okta) resource allows you to transmit changes in User Risk Score to a specified vendor such as Okta.

        :param str resource_name: The name of the resource.
        :param ZeroTrustRiskScoreIntegrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZeroTrustRiskScoreIntegrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 active: Optional[pulumi.Input[bool]] = None,
                 integration_type: Optional[pulumi.Input[str]] = None,
                 reference_id: Optional[pulumi.Input[str]] = None,
                 tenant_url: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZeroTrustRiskScoreIntegrationArgs.__new__(ZeroTrustRiskScoreIntegrationArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["active"] = active
            if integration_type is None and not opts.urn:
                raise TypeError("Missing required property 'integration_type'")
            __props__.__dict__["integration_type"] = integration_type
            __props__.__dict__["reference_id"] = reference_id
            if tenant_url is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_url'")
            __props__.__dict__["tenant_url"] = tenant_url
            __props__.__dict__["well_known_url"] = None
        super(ZeroTrustRiskScoreIntegration, __self__).__init__(
            'cloudflare:index/zeroTrustRiskScoreIntegration:ZeroTrustRiskScoreIntegration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            active: Optional[pulumi.Input[bool]] = None,
            integration_type: Optional[pulumi.Input[str]] = None,
            reference_id: Optional[pulumi.Input[str]] = None,
            tenant_url: Optional[pulumi.Input[str]] = None,
            well_known_url: Optional[pulumi.Input[str]] = None) -> 'ZeroTrustRiskScoreIntegration':
        """
        Get an existing ZeroTrustRiskScoreIntegration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The account identifier to target for the resource.
        :param pulumi.Input[bool] active: Whether this integration is enabled. If disabled, no risk changes will be exported to the third-party.
        :param pulumi.Input[str] integration_type: The type of integration, e.g. 'Okta'. Full list of allowed values can be found here: https://developers.cloudflare.com/api/operations/dlp-zt-risk-score-integration-create#request-body
        :param pulumi.Input[str] reference_id: A reference id that can be supplied by the client. Currently this should be set to the Access-Okta IDP ID (a UUIDv4). If omitted, a random UUIDv4 is used. https://developers.cloudflare.com/api/operations/access-identity-providers-get-an-access-identity-provider
        :param pulumi.Input[str] tenant_url: The base url of the tenant, e.g. 'https://tenant.okta.com'. Must be your Okta Tenant URL and not your custom domain.
        :param pulumi.Input[str] well_known_url: The URL for the Shared Signals Framework configuration, e.g. '/.well-known/sse-configuration/{integration*uuid}/'. https://openid.net/specs/openid-sse-framework-1*0.html#rfc.section.6.2.1
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZeroTrustRiskScoreIntegrationState.__new__(_ZeroTrustRiskScoreIntegrationState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["active"] = active
        __props__.__dict__["integration_type"] = integration_type
        __props__.__dict__["reference_id"] = reference_id
        __props__.__dict__["tenant_url"] = tenant_url
        __props__.__dict__["well_known_url"] = well_known_url
        return ZeroTrustRiskScoreIntegration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        """
        The account identifier to target for the resource.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def active(self) -> pulumi.Output[bool]:
        """
        Whether this integration is enabled. If disabled, no risk changes will be exported to the third-party.
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter(name="integrationType")
    def integration_type(self) -> pulumi.Output[str]:
        """
        The type of integration, e.g. 'Okta'. Full list of allowed values can be found here: https://developers.cloudflare.com/api/operations/dlp-zt-risk-score-integration-create#request-body
        """
        return pulumi.get(self, "integration_type")

    @property
    @pulumi.getter(name="referenceId")
    def reference_id(self) -> pulumi.Output[str]:
        """
        A reference id that can be supplied by the client. Currently this should be set to the Access-Okta IDP ID (a UUIDv4). If omitted, a random UUIDv4 is used. https://developers.cloudflare.com/api/operations/access-identity-providers-get-an-access-identity-provider
        """
        return pulumi.get(self, "reference_id")

    @property
    @pulumi.getter(name="tenantUrl")
    def tenant_url(self) -> pulumi.Output[str]:
        """
        The base url of the tenant, e.g. 'https://tenant.okta.com'. Must be your Okta Tenant URL and not your custom domain.
        """
        return pulumi.get(self, "tenant_url")

    @property
    @pulumi.getter(name="wellKnownUrl")
    def well_known_url(self) -> pulumi.Output[str]:
        """
        The URL for the Shared Signals Framework configuration, e.g. '/.well-known/sse-configuration/{integration*uuid}/'. https://openid.net/specs/openid-sse-framework-1*0.html#rfc.section.6.2.1
        """
        return pulumi.get(self, "well_known_url")

