# MUSICA Authors and Contributors

This file acknowledges all individuals who have contributed to the MUSICA project.

## Core Development Team

The following individuals are the primary developers and maintainers of the MUSICA software:

- **Matthew Dawson** (mattdawson@ucar.edu) - Core Developer
- **Jiwon Gim** (jiwongim@ucar.edu) - Core Developer  
- **David Fillmore** (fillmore@ucar.edu) - Core Developer
- **Kyle Shores** (kshores@ucar.edu) - Core Developer
- **Montek Thind** (mthind@ucar.edu) - Core Developer
- **Jian Sun** - Core Developer

## Scientific Leadership and Vision

The scientific leadership and vision for MUSICA are provided by the authors of the [foundational paper](https://doi.org/10.1175/BAMS-D-19-0331.1). 
This software implements that vision. For a full list of scientific authors, 
please refer to our [CITATION.cff](CITATION.cff) file. To cite the software, use the Zenodo DOI from our latest release.

## Additional Contributors

<!-- Contributors will be added here as they join the project -->
<!-- Format: -->
<!-- - **Name** (affiliation) - Brief description of contribution -->

- **Aidan Winney** - Documentation and Tutorials
- **Angela Pak** - Documentation and Tutorials
- **Dee Grant** - Improving the Python API
- **Qina Tan** - Implementing the CUDA-based Rosenbrock solver

## Recognition Policy

We recognize contributors at different levels based on their involvement:

- **Core Development Team**: Listed in `pyproject.toml`, `.zenodo.json` (creators), and this file
- **Additional Contributors**: Listed in `.zenodo.json` (contributors) and this file
- **All Contributors**: Automatically tracked by GitHub's contributor statistics

See our [Contributing Guide](CONTRIBUTING.md) for more details on how contributions are recognized.

## How to Contribute

We welcome contributions from the community! Please see our [Contributing Guide](CONTRIBUTING.md) for information on how to get involved.

## Acknowledgments

We thank the broader atmospheric chemistry modeling community for their feedback, testing, and contributions to making MUSICA a robust and useful tool for scientific research.

---

## Citation Information

For citation purposes, please refer to our [CITATION.cff](CITATION.cff) file for the appropriate citations based on your use case. The main citations are:

1. **For the MUSICA vision and scientific framework**: [Pfister et al., 2020](https://doi.org/10.1175/BAMS-D-19-0331.1)
2. **For the MUSICA software evaluation**: [Schwantes et al., 2022](https://doi.org/10.1029/2021MS002889)
3. **For the software itself**: Use the Zenodo DOI from our latest release
