# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AccountArgs', 'Account']

@pulumi.input_type
class AccountArgs:
    def __init__(__self__, *,
                 admin_name: pulumi.Input[_builtins.str],
                 edition: pulumi.Input[_builtins.str],
                 email: pulumi.Input[_builtins.str],
                 grace_period_in_days: pulumi.Input[_builtins.int],
                 admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 admin_rsa_public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 admin_user_type: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 consumption_billing_entity: Optional[pulumi.Input[_builtins.str]] = None,
                 first_name: Optional[pulumi.Input[_builtins.str]] = None,
                 is_org_admin: Optional[pulumi.Input[_builtins.str]] = None,
                 last_name: Optional[pulumi.Input[_builtins.str]] = None,
                 must_change_password: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 region_group: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Account resource.
        :param pulumi.Input[_builtins.str] edition: Snowflake Edition of the account. See more about Snowflake Editions in the [official documentation](https://docs.snowflake.com/en/user-guide/intro-editions). Valid options are: `STANDARD` | `ENTERPRISE` | `BUSINESS_CRITICAL`
        :param pulumi.Input[_builtins.int] grace_period_in_days: Specifies the number of days during which the account can be restored (“undropped”). The minimum is 3 days and the maximum is 90 days.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the account.
        :param pulumi.Input[_builtins.str] consumption_billing_entity: Determines which billing entity is responsible for the account's consumption-based billing.
        :param pulumi.Input[_builtins.str] is_org_admin: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Sets an account property that determines whether the ORGADMIN role is enabled in the account. Only an organization administrator (i.e. user with the ORGADMIN role) can set the property.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier (i.e. name) for the account. It must be unique within an organization, regardless of which Snowflake Region the account is in and must start with an alphabetic character and cannot contain spaces or special characters except for underscores (_). Note that if the account name includes underscores, features that do not accept account names with underscores (e.g. Okta SSO or SCIM) can reference a version of the account name that substitutes hyphens (-) for the underscores.
        :param pulumi.Input[_builtins.str] region: [Snowflake Region ID](https://docs.snowflake.com/en/user-guide/admin-account-identifier.html#label-snowflake-region-ids) of the region where the account is created. If no value is provided, Snowflake creates the account in the same Snowflake Region as the current account (i.e. the account in which the CREATE ACCOUNT statement is executed.)
        :param pulumi.Input[_builtins.str] region_group: ID of the region group where the account is created. To retrieve the region group ID for existing accounts in your organization, execute the [SHOW REGIONS](https://docs.snowflake.com/en/sql-reference/sql/show-regions) command. For information about when you might need to specify region group, see [Region groups](https://docs.snowflake.com/en/user-guide/admin-account-identifier.html#label-region-groups).
        """
        pulumi.set(__self__, "admin_name", admin_name)
        pulumi.set(__self__, "edition", edition)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "grace_period_in_days", grace_period_in_days)
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if admin_rsa_public_key is not None:
            pulumi.set(__self__, "admin_rsa_public_key", admin_rsa_public_key)
        if admin_user_type is not None:
            pulumi.set(__self__, "admin_user_type", admin_user_type)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if consumption_billing_entity is not None:
            pulumi.set(__self__, "consumption_billing_entity", consumption_billing_entity)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if is_org_admin is not None:
            pulumi.set(__self__, "is_org_admin", is_org_admin)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if must_change_password is not None:
            pulumi.set(__self__, "must_change_password", must_change_password)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if region_group is not None:
            pulumi.set(__self__, "region_group", region_group)

    @_builtins.property
    @pulumi.getter(name="adminName")
    def admin_name(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "admin_name")

    @admin_name.setter
    def admin_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "admin_name", value)

    @_builtins.property
    @pulumi.getter
    def edition(self) -> pulumi.Input[_builtins.str]:
        """
        Snowflake Edition of the account. See more about Snowflake Editions in the [official documentation](https://docs.snowflake.com/en/user-guide/intro-editions). Valid options are: `STANDARD` | `ENTERPRISE` | `BUSINESS_CRITICAL`
        """
        return pulumi.get(self, "edition")

    @edition.setter
    def edition(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "edition", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="gracePeriodInDays")
    def grace_period_in_days(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the number of days during which the account can be restored (“undropped”). The minimum is 3 days and the maximum is 90 days.
        """
        return pulumi.get(self, "grace_period_in_days")

    @grace_period_in_days.setter
    def grace_period_in_days(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "grace_period_in_days", value)

    @_builtins.property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "admin_password", value)

    @_builtins.property
    @pulumi.getter(name="adminRsaPublicKey")
    def admin_rsa_public_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "admin_rsa_public_key")

    @admin_rsa_public_key.setter
    def admin_rsa_public_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "admin_rsa_public_key", value)

    @_builtins.property
    @pulumi.getter(name="adminUserType")
    def admin_user_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "admin_user_type")

    @admin_user_type.setter
    def admin_user_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "admin_user_type", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comment for the account.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="consumptionBillingEntity")
    def consumption_billing_entity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines which billing entity is responsible for the account's consumption-based billing.
        """
        return pulumi.get(self, "consumption_billing_entity")

    @consumption_billing_entity.setter
    def consumption_billing_entity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "consumption_billing_entity", value)

    @_builtins.property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "first_name", value)

    @_builtins.property
    @pulumi.getter(name="isOrgAdmin")
    def is_org_admin(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Sets an account property that determines whether the ORGADMIN role is enabled in the account. Only an organization administrator (i.e. user with the ORGADMIN role) can set the property.
        """
        return pulumi.get(self, "is_org_admin")

    @is_org_admin.setter
    def is_org_admin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "is_org_admin", value)

    @_builtins.property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_name", value)

    @_builtins.property
    @pulumi.getter(name="mustChangePassword")
    def must_change_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "must_change_password")

    @must_change_password.setter
    def must_change_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "must_change_password", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier (i.e. name) for the account. It must be unique within an organization, regardless of which Snowflake Region the account is in and must start with an alphabetic character and cannot contain spaces or special characters except for underscores (_). Note that if the account name includes underscores, features that do not accept account names with underscores (e.g. Okta SSO or SCIM) can reference a version of the account name that substitutes hyphens (-) for the underscores.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        [Snowflake Region ID](https://docs.snowflake.com/en/user-guide/admin-account-identifier.html#label-snowflake-region-ids) of the region where the account is created. If no value is provided, Snowflake creates the account in the same Snowflake Region as the current account (i.e. the account in which the CREATE ACCOUNT statement is executed.)
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="regionGroup")
    def region_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the region group where the account is created. To retrieve the region group ID for existing accounts in your organization, execute the [SHOW REGIONS](https://docs.snowflake.com/en/sql-reference/sql/show-regions) command. For information about when you might need to specify region group, see [Region groups](https://docs.snowflake.com/en/user-guide/admin-account-identifier.html#label-region-groups).
        """
        return pulumi.get(self, "region_group")

    @region_group.setter
    def region_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_group", value)


@pulumi.input_type
class _AccountState:
    def __init__(__self__, *,
                 admin_name: Optional[pulumi.Input[_builtins.str]] = None,
                 admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 admin_rsa_public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 admin_user_type: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 consumption_billing_entity: Optional[pulumi.Input[_builtins.str]] = None,
                 edition: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 first_name: Optional[pulumi.Input[_builtins.str]] = None,
                 fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
                 grace_period_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 is_org_admin: Optional[pulumi.Input[_builtins.str]] = None,
                 last_name: Optional[pulumi.Input[_builtins.str]] = None,
                 must_change_password: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 region_group: Optional[pulumi.Input[_builtins.str]] = None,
                 show_outputs: Optional[pulumi.Input[Sequence[pulumi.Input['AccountShowOutputArgs']]]] = None):
        """
        Input properties used for looking up and filtering Account resources.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the account.
        :param pulumi.Input[_builtins.str] consumption_billing_entity: Determines which billing entity is responsible for the account's consumption-based billing.
        :param pulumi.Input[_builtins.str] edition: Snowflake Edition of the account. See more about Snowflake Editions in the [official documentation](https://docs.snowflake.com/en/user-guide/intro-editions). Valid options are: `STANDARD` | `ENTERPRISE` | `BUSINESS_CRITICAL`
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.int] grace_period_in_days: Specifies the number of days during which the account can be restored (“undropped”). The minimum is 3 days and the maximum is 90 days.
        :param pulumi.Input[_builtins.str] is_org_admin: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Sets an account property that determines whether the ORGADMIN role is enabled in the account. Only an organization administrator (i.e. user with the ORGADMIN role) can set the property.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier (i.e. name) for the account. It must be unique within an organization, regardless of which Snowflake Region the account is in and must start with an alphabetic character and cannot contain spaces or special characters except for underscores (_). Note that if the account name includes underscores, features that do not accept account names with underscores (e.g. Okta SSO or SCIM) can reference a version of the account name that substitutes hyphens (-) for the underscores.
        :param pulumi.Input[_builtins.str] region: [Snowflake Region ID](https://docs.snowflake.com/en/user-guide/admin-account-identifier.html#label-snowflake-region-ids) of the region where the account is created. If no value is provided, Snowflake creates the account in the same Snowflake Region as the current account (i.e. the account in which the CREATE ACCOUNT statement is executed.)
        :param pulumi.Input[_builtins.str] region_group: ID of the region group where the account is created. To retrieve the region group ID for existing accounts in your organization, execute the [SHOW REGIONS](https://docs.snowflake.com/en/sql-reference/sql/show-regions) command. For information about when you might need to specify region group, see [Region groups](https://docs.snowflake.com/en/user-guide/admin-account-identifier.html#label-region-groups).
        :param pulumi.Input[Sequence[pulumi.Input['AccountShowOutputArgs']]] show_outputs: Outputs the result of `SHOW ACCOUNTS` for the given account.
        """
        if admin_name is not None:
            pulumi.set(__self__, "admin_name", admin_name)
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if admin_rsa_public_key is not None:
            pulumi.set(__self__, "admin_rsa_public_key", admin_rsa_public_key)
        if admin_user_type is not None:
            pulumi.set(__self__, "admin_user_type", admin_user_type)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if consumption_billing_entity is not None:
            pulumi.set(__self__, "consumption_billing_entity", consumption_billing_entity)
        if edition is not None:
            pulumi.set(__self__, "edition", edition)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if fully_qualified_name is not None:
            pulumi.set(__self__, "fully_qualified_name", fully_qualified_name)
        if grace_period_in_days is not None:
            pulumi.set(__self__, "grace_period_in_days", grace_period_in_days)
        if is_org_admin is not None:
            pulumi.set(__self__, "is_org_admin", is_org_admin)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if must_change_password is not None:
            pulumi.set(__self__, "must_change_password", must_change_password)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if region_group is not None:
            pulumi.set(__self__, "region_group", region_group)
        if show_outputs is not None:
            pulumi.set(__self__, "show_outputs", show_outputs)

    @_builtins.property
    @pulumi.getter(name="adminName")
    def admin_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "admin_name")

    @admin_name.setter
    def admin_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "admin_name", value)

    @_builtins.property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "admin_password", value)

    @_builtins.property
    @pulumi.getter(name="adminRsaPublicKey")
    def admin_rsa_public_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "admin_rsa_public_key")

    @admin_rsa_public_key.setter
    def admin_rsa_public_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "admin_rsa_public_key", value)

    @_builtins.property
    @pulumi.getter(name="adminUserType")
    def admin_user_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "admin_user_type")

    @admin_user_type.setter
    def admin_user_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "admin_user_type", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comment for the account.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="consumptionBillingEntity")
    def consumption_billing_entity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines which billing entity is responsible for the account's consumption-based billing.
        """
        return pulumi.get(self, "consumption_billing_entity")

    @consumption_billing_entity.setter
    def consumption_billing_entity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "consumption_billing_entity", value)

    @_builtins.property
    @pulumi.getter
    def edition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Snowflake Edition of the account. See more about Snowflake Editions in the [official documentation](https://docs.snowflake.com/en/user-guide/intro-editions). Valid options are: `STANDARD` | `ENTERPRISE` | `BUSINESS_CRITICAL`
        """
        return pulumi.get(self, "edition")

    @edition.setter
    def edition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edition", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "first_name", value)

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @fully_qualified_name.setter
    def fully_qualified_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fully_qualified_name", value)

    @_builtins.property
    @pulumi.getter(name="gracePeriodInDays")
    def grace_period_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of days during which the account can be restored (“undropped”). The minimum is 3 days and the maximum is 90 days.
        """
        return pulumi.get(self, "grace_period_in_days")

    @grace_period_in_days.setter
    def grace_period_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "grace_period_in_days", value)

    @_builtins.property
    @pulumi.getter(name="isOrgAdmin")
    def is_org_admin(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Sets an account property that determines whether the ORGADMIN role is enabled in the account. Only an organization administrator (i.e. user with the ORGADMIN role) can set the property.
        """
        return pulumi.get(self, "is_org_admin")

    @is_org_admin.setter
    def is_org_admin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "is_org_admin", value)

    @_builtins.property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_name", value)

    @_builtins.property
    @pulumi.getter(name="mustChangePassword")
    def must_change_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "must_change_password")

    @must_change_password.setter
    def must_change_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "must_change_password", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier (i.e. name) for the account. It must be unique within an organization, regardless of which Snowflake Region the account is in and must start with an alphabetic character and cannot contain spaces or special characters except for underscores (_). Note that if the account name includes underscores, features that do not accept account names with underscores (e.g. Okta SSO or SCIM) can reference a version of the account name that substitutes hyphens (-) for the underscores.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        [Snowflake Region ID](https://docs.snowflake.com/en/user-guide/admin-account-identifier.html#label-snowflake-region-ids) of the region where the account is created. If no value is provided, Snowflake creates the account in the same Snowflake Region as the current account (i.e. the account in which the CREATE ACCOUNT statement is executed.)
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="regionGroup")
    def region_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the region group where the account is created. To retrieve the region group ID for existing accounts in your organization, execute the [SHOW REGIONS](https://docs.snowflake.com/en/sql-reference/sql/show-regions) command. For information about when you might need to specify region group, see [Region groups](https://docs.snowflake.com/en/user-guide/admin-account-identifier.html#label-region-groups).
        """
        return pulumi.get(self, "region_group")

    @region_group.setter
    def region_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_group", value)

    @_builtins.property
    @pulumi.getter(name="showOutputs")
    def show_outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccountShowOutputArgs']]]]:
        """
        Outputs the result of `SHOW ACCOUNTS` for the given account.
        """
        return pulumi.get(self, "show_outputs")

    @show_outputs.setter
    def show_outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccountShowOutputArgs']]]]):
        pulumi.set(self, "show_outputs", value)


@pulumi.type_token("snowflake:index/account:Account")
class Account(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_name: Optional[pulumi.Input[_builtins.str]] = None,
                 admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 admin_rsa_public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 admin_user_type: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 consumption_billing_entity: Optional[pulumi.Input[_builtins.str]] = None,
                 edition: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 first_name: Optional[pulumi.Input[_builtins.str]] = None,
                 grace_period_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 is_org_admin: Optional[pulumi.Input[_builtins.str]] = None,
                 last_name: Optional[pulumi.Input[_builtins.str]] = None,
                 must_change_password: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 region_group: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/account:Account example '"<organization_name>"."<account_name>"'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the account.
        :param pulumi.Input[_builtins.str] consumption_billing_entity: Determines which billing entity is responsible for the account's consumption-based billing.
        :param pulumi.Input[_builtins.str] edition: Snowflake Edition of the account. See more about Snowflake Editions in the [official documentation](https://docs.snowflake.com/en/user-guide/intro-editions). Valid options are: `STANDARD` | `ENTERPRISE` | `BUSINESS_CRITICAL`
        :param pulumi.Input[_builtins.int] grace_period_in_days: Specifies the number of days during which the account can be restored (“undropped”). The minimum is 3 days and the maximum is 90 days.
        :param pulumi.Input[_builtins.str] is_org_admin: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Sets an account property that determines whether the ORGADMIN role is enabled in the account. Only an organization administrator (i.e. user with the ORGADMIN role) can set the property.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier (i.e. name) for the account. It must be unique within an organization, regardless of which Snowflake Region the account is in and must start with an alphabetic character and cannot contain spaces or special characters except for underscores (_). Note that if the account name includes underscores, features that do not accept account names with underscores (e.g. Okta SSO or SCIM) can reference a version of the account name that substitutes hyphens (-) for the underscores.
        :param pulumi.Input[_builtins.str] region: [Snowflake Region ID](https://docs.snowflake.com/en/user-guide/admin-account-identifier.html#label-snowflake-region-ids) of the region where the account is created. If no value is provided, Snowflake creates the account in the same Snowflake Region as the current account (i.e. the account in which the CREATE ACCOUNT statement is executed.)
        :param pulumi.Input[_builtins.str] region_group: ID of the region group where the account is created. To retrieve the region group ID for existing accounts in your organization, execute the [SHOW REGIONS](https://docs.snowflake.com/en/sql-reference/sql/show-regions) command. For information about when you might need to specify region group, see [Region groups](https://docs.snowflake.com/en/user-guide/admin-account-identifier.html#label-region-groups).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/account:Account example '"<organization_name>"."<account_name>"'
        ```

        :param str resource_name: The name of the resource.
        :param AccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_name: Optional[pulumi.Input[_builtins.str]] = None,
                 admin_password: Optional[pulumi.Input[_builtins.str]] = None,
                 admin_rsa_public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 admin_user_type: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 consumption_billing_entity: Optional[pulumi.Input[_builtins.str]] = None,
                 edition: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 first_name: Optional[pulumi.Input[_builtins.str]] = None,
                 grace_period_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 is_org_admin: Optional[pulumi.Input[_builtins.str]] = None,
                 last_name: Optional[pulumi.Input[_builtins.str]] = None,
                 must_change_password: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 region_group: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccountArgs.__new__(AccountArgs)

            if admin_name is None and not opts.urn:
                raise TypeError("Missing required property 'admin_name'")
            __props__.__dict__["admin_name"] = None if admin_name is None else pulumi.Output.secret(admin_name)
            __props__.__dict__["admin_password"] = None if admin_password is None else pulumi.Output.secret(admin_password)
            __props__.__dict__["admin_rsa_public_key"] = admin_rsa_public_key
            __props__.__dict__["admin_user_type"] = admin_user_type
            __props__.__dict__["comment"] = comment
            __props__.__dict__["consumption_billing_entity"] = consumption_billing_entity
            if edition is None and not opts.urn:
                raise TypeError("Missing required property 'edition'")
            __props__.__dict__["edition"] = edition
            if email is None and not opts.urn:
                raise TypeError("Missing required property 'email'")
            __props__.__dict__["email"] = None if email is None else pulumi.Output.secret(email)
            __props__.__dict__["first_name"] = None if first_name is None else pulumi.Output.secret(first_name)
            if grace_period_in_days is None and not opts.urn:
                raise TypeError("Missing required property 'grace_period_in_days'")
            __props__.__dict__["grace_period_in_days"] = grace_period_in_days
            __props__.__dict__["is_org_admin"] = is_org_admin
            __props__.__dict__["last_name"] = None if last_name is None else pulumi.Output.secret(last_name)
            __props__.__dict__["must_change_password"] = must_change_password
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["region_group"] = region_group
            __props__.__dict__["fully_qualified_name"] = None
            __props__.__dict__["show_outputs"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["adminName", "adminPassword", "email", "firstName", "lastName"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Account, __self__).__init__(
            'snowflake:index/account:Account',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_name: Optional[pulumi.Input[_builtins.str]] = None,
            admin_password: Optional[pulumi.Input[_builtins.str]] = None,
            admin_rsa_public_key: Optional[pulumi.Input[_builtins.str]] = None,
            admin_user_type: Optional[pulumi.Input[_builtins.str]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            consumption_billing_entity: Optional[pulumi.Input[_builtins.str]] = None,
            edition: Optional[pulumi.Input[_builtins.str]] = None,
            email: Optional[pulumi.Input[_builtins.str]] = None,
            first_name: Optional[pulumi.Input[_builtins.str]] = None,
            fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
            grace_period_in_days: Optional[pulumi.Input[_builtins.int]] = None,
            is_org_admin: Optional[pulumi.Input[_builtins.str]] = None,
            last_name: Optional[pulumi.Input[_builtins.str]] = None,
            must_change_password: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            region_group: Optional[pulumi.Input[_builtins.str]] = None,
            show_outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccountShowOutputArgs', 'AccountShowOutputArgsDict']]]]] = None) -> 'Account':
        """
        Get an existing Account resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the account.
        :param pulumi.Input[_builtins.str] consumption_billing_entity: Determines which billing entity is responsible for the account's consumption-based billing.
        :param pulumi.Input[_builtins.str] edition: Snowflake Edition of the account. See more about Snowflake Editions in the [official documentation](https://docs.snowflake.com/en/user-guide/intro-editions). Valid options are: `STANDARD` | `ENTERPRISE` | `BUSINESS_CRITICAL`
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.int] grace_period_in_days: Specifies the number of days during which the account can be restored (“undropped”). The minimum is 3 days and the maximum is 90 days.
        :param pulumi.Input[_builtins.str] is_org_admin: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Sets an account property that determines whether the ORGADMIN role is enabled in the account. Only an organization administrator (i.e. user with the ORGADMIN role) can set the property.
        :param pulumi.Input[_builtins.str] name: Specifies the identifier (i.e. name) for the account. It must be unique within an organization, regardless of which Snowflake Region the account is in and must start with an alphabetic character and cannot contain spaces or special characters except for underscores (_). Note that if the account name includes underscores, features that do not accept account names with underscores (e.g. Okta SSO or SCIM) can reference a version of the account name that substitutes hyphens (-) for the underscores.
        :param pulumi.Input[_builtins.str] region: [Snowflake Region ID](https://docs.snowflake.com/en/user-guide/admin-account-identifier.html#label-snowflake-region-ids) of the region where the account is created. If no value is provided, Snowflake creates the account in the same Snowflake Region as the current account (i.e. the account in which the CREATE ACCOUNT statement is executed.)
        :param pulumi.Input[_builtins.str] region_group: ID of the region group where the account is created. To retrieve the region group ID for existing accounts in your organization, execute the [SHOW REGIONS](https://docs.snowflake.com/en/sql-reference/sql/show-regions) command. For information about when you might need to specify region group, see [Region groups](https://docs.snowflake.com/en/user-guide/admin-account-identifier.html#label-region-groups).
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccountShowOutputArgs', 'AccountShowOutputArgsDict']]]] show_outputs: Outputs the result of `SHOW ACCOUNTS` for the given account.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccountState.__new__(_AccountState)

        __props__.__dict__["admin_name"] = admin_name
        __props__.__dict__["admin_password"] = admin_password
        __props__.__dict__["admin_rsa_public_key"] = admin_rsa_public_key
        __props__.__dict__["admin_user_type"] = admin_user_type
        __props__.__dict__["comment"] = comment
        __props__.__dict__["consumption_billing_entity"] = consumption_billing_entity
        __props__.__dict__["edition"] = edition
        __props__.__dict__["email"] = email
        __props__.__dict__["first_name"] = first_name
        __props__.__dict__["fully_qualified_name"] = fully_qualified_name
        __props__.__dict__["grace_period_in_days"] = grace_period_in_days
        __props__.__dict__["is_org_admin"] = is_org_admin
        __props__.__dict__["last_name"] = last_name
        __props__.__dict__["must_change_password"] = must_change_password
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["region_group"] = region_group
        __props__.__dict__["show_outputs"] = show_outputs
        return Account(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="adminName")
    def admin_name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "admin_name")

    @_builtins.property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "admin_password")

    @_builtins.property
    @pulumi.getter(name="adminRsaPublicKey")
    def admin_rsa_public_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "admin_rsa_public_key")

    @_builtins.property
    @pulumi.getter(name="adminUserType")
    def admin_user_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "admin_user_type")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a comment for the account.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="consumptionBillingEntity")
    def consumption_billing_entity(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Determines which billing entity is responsible for the account's consumption-based billing.
        """
        return pulumi.get(self, "consumption_billing_entity")

    @_builtins.property
    @pulumi.getter
    def edition(self) -> pulumi.Output[_builtins.str]:
        """
        Snowflake Edition of the account. See more about Snowflake Editions in the [official documentation](https://docs.snowflake.com/en/user-guide/intro-editions). Valid options are: `STANDARD` | `ENTERPRISE` | `BUSINESS_CRITICAL`
        """
        return pulumi.get(self, "edition")

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter(name="firstName")
    def first_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "first_name")

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> pulumi.Output[_builtins.str]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @_builtins.property
    @pulumi.getter(name="gracePeriodInDays")
    def grace_period_in_days(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the number of days during which the account can be restored (“undropped”). The minimum is 3 days and the maximum is 90 days.
        """
        return pulumi.get(self, "grace_period_in_days")

    @_builtins.property
    @pulumi.getter(name="isOrgAdmin")
    def is_org_admin(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Sets an account property that determines whether the ORGADMIN role is enabled in the account. Only an organization administrator (i.e. user with the ORGADMIN role) can set the property.
        """
        return pulumi.get(self, "is_org_admin")

    @_builtins.property
    @pulumi.getter(name="lastName")
    def last_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "last_name")

    @_builtins.property
    @pulumi.getter(name="mustChangePassword")
    def must_change_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "must_change_password")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the identifier (i.e. name) for the account. It must be unique within an organization, regardless of which Snowflake Region the account is in and must start with an alphabetic character and cannot contain spaces or special characters except for underscores (_). Note that if the account name includes underscores, features that do not accept account names with underscores (e.g. Okta SSO or SCIM) can reference a version of the account name that substitutes hyphens (-) for the underscores.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        [Snowflake Region ID](https://docs.snowflake.com/en/user-guide/admin-account-identifier.html#label-snowflake-region-ids) of the region where the account is created. If no value is provided, Snowflake creates the account in the same Snowflake Region as the current account (i.e. the account in which the CREATE ACCOUNT statement is executed.)
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="regionGroup")
    def region_group(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ID of the region group where the account is created. To retrieve the region group ID for existing accounts in your organization, execute the [SHOW REGIONS](https://docs.snowflake.com/en/sql-reference/sql/show-regions) command. For information about when you might need to specify region group, see [Region groups](https://docs.snowflake.com/en/user-guide/admin-account-identifier.html#label-region-groups).
        """
        return pulumi.get(self, "region_group")

    @_builtins.property
    @pulumi.getter(name="showOutputs")
    def show_outputs(self) -> pulumi.Output[Sequence['outputs.AccountShowOutput']]:
        """
        Outputs the result of `SHOW ACCOUNTS` for the given account.
        """
        return pulumi.get(self, "show_outputs")

