# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetWarehousesResult',
    'AwaitableGetWarehousesResult',
    'get_warehouses',
    'get_warehouses_output',
]

@pulumi.output_type
class GetWarehousesResult:
    """
    A collection of values returned by getWarehouses.
    """
    def __init__(__self__, id=None, like=None, warehouses=None, with_describe=None, with_parameters=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if like and not isinstance(like, str):
            raise TypeError("Expected argument 'like' to be a str")
        pulumi.set(__self__, "like", like)
        if warehouses and not isinstance(warehouses, list):
            raise TypeError("Expected argument 'warehouses' to be a list")
        pulumi.set(__self__, "warehouses", warehouses)
        if with_describe and not isinstance(with_describe, bool):
            raise TypeError("Expected argument 'with_describe' to be a bool")
        pulumi.set(__self__, "with_describe", with_describe)
        if with_parameters and not isinstance(with_parameters, bool):
            raise TypeError("Expected argument 'with_parameters' to be a bool")
        pulumi.set(__self__, "with_parameters", with_parameters)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def like(self) -> Optional[_builtins.str]:
        """
        Filters the output with **case-insensitive** pattern, with support for SQL wildcard characters (`%` and `_`).
        """
        return pulumi.get(self, "like")

    @_builtins.property
    @pulumi.getter
    def warehouses(self) -> Sequence['outputs.GetWarehousesWarehouseResult']:
        """
        Holds the aggregated output of all warehouse details queries.
        """
        return pulumi.get(self, "warehouses")

    @_builtins.property
    @pulumi.getter(name="withDescribe")
    def with_describe(self) -> Optional[_builtins.bool]:
        """
        (Default: `true`) Runs DESC WAREHOUSE for each warehouse returned by SHOW WAREHOUSES. The output of describe is saved to the description field. By default this value is set to true.
        """
        return pulumi.get(self, "with_describe")

    @_builtins.property
    @pulumi.getter(name="withParameters")
    def with_parameters(self) -> Optional[_builtins.bool]:
        """
        (Default: `true`) Runs SHOW PARAMETERS FOR WAREHOUSE for each warehouse returned by SHOW WAREHOUSES. The output of describe is saved to the parameters field as a map. By default this value is set to true.
        """
        return pulumi.get(self, "with_parameters")


class AwaitableGetWarehousesResult(GetWarehousesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWarehousesResult(
            id=self.id,
            like=self.like,
            warehouses=self.warehouses,
            with_describe=self.with_describe,
            with_parameters=self.with_parameters)


def get_warehouses(like: Optional[_builtins.str] = None,
                   with_describe: Optional[_builtins.bool] = None,
                   with_parameters: Optional[_builtins.bool] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWarehousesResult:
    """
    Data source used to get details of filtered warehouses. Filtering is aligned with the current possibilities for [SHOW WAREHOUSES](https://docs.snowflake.com/en/sql-reference/sql/show-warehouses) query (only `like` is supported). The results of SHOW, DESCRIBE, and SHOW PARAMETERS IN are encapsulated in one output collection.


    :param _builtins.str like: Filters the output with **case-insensitive** pattern, with support for SQL wildcard characters (`%` and `_`).
    :param _builtins.bool with_describe: (Default: `true`) Runs DESC WAREHOUSE for each warehouse returned by SHOW WAREHOUSES. The output of describe is saved to the description field. By default this value is set to true.
    :param _builtins.bool with_parameters: (Default: `true`) Runs SHOW PARAMETERS FOR WAREHOUSE for each warehouse returned by SHOW WAREHOUSES. The output of describe is saved to the parameters field as a map. By default this value is set to true.
    """
    __args__ = dict()
    __args__['like'] = like
    __args__['withDescribe'] = with_describe
    __args__['withParameters'] = with_parameters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('snowflake:index/getWarehouses:getWarehouses', __args__, opts=opts, typ=GetWarehousesResult).value

    return AwaitableGetWarehousesResult(
        id=pulumi.get(__ret__, 'id'),
        like=pulumi.get(__ret__, 'like'),
        warehouses=pulumi.get(__ret__, 'warehouses'),
        with_describe=pulumi.get(__ret__, 'with_describe'),
        with_parameters=pulumi.get(__ret__, 'with_parameters'))
def get_warehouses_output(like: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          with_describe: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                          with_parameters: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWarehousesResult]:
    """
    Data source used to get details of filtered warehouses. Filtering is aligned with the current possibilities for [SHOW WAREHOUSES](https://docs.snowflake.com/en/sql-reference/sql/show-warehouses) query (only `like` is supported). The results of SHOW, DESCRIBE, and SHOW PARAMETERS IN are encapsulated in one output collection.


    :param _builtins.str like: Filters the output with **case-insensitive** pattern, with support for SQL wildcard characters (`%` and `_`).
    :param _builtins.bool with_describe: (Default: `true`) Runs DESC WAREHOUSE for each warehouse returned by SHOW WAREHOUSES. The output of describe is saved to the description field. By default this value is set to true.
    :param _builtins.bool with_parameters: (Default: `true`) Runs SHOW PARAMETERS FOR WAREHOUSE for each warehouse returned by SHOW WAREHOUSES. The output of describe is saved to the parameters field as a map. By default this value is set to true.
    """
    __args__ = dict()
    __args__['like'] = like
    __args__['withDescribe'] = with_describe
    __args__['withParameters'] = with_parameters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('snowflake:index/getWarehouses:getWarehouses', __args__, opts=opts, typ=GetWarehousesResult)
    return __ret__.apply(lambda __response__: GetWarehousesResult(
        id=pulumi.get(__response__, 'id'),
        like=pulumi.get(__response__, 'like'),
        warehouses=pulumi.get(__response__, 'warehouses'),
        with_describe=pulumi.get(__response__, 'with_describe'),
        with_parameters=pulumi.get(__response__, 'with_parameters')))
