# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ScimIntegrationArgs', 'ScimIntegration']

@pulumi.input_type
class ScimIntegrationArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[_builtins.bool],
                 run_as_role: pulumi.Input[_builtins.str],
                 scim_client: pulumi.Input[_builtins.str],
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_password: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ScimIntegration resource.
        :param pulumi.Input[_builtins.bool] enabled: Specify whether the security integration is enabled.
        :param pulumi.Input[_builtins.str] run_as_role: Specify the SCIM role in Snowflake that owns any users and roles that are imported from the identity provider into Snowflake using SCIM. Provider assumes that the specified role is already provided. Valid options are: `OKTA_PROVISIONER` | `AAD_PROVISIONER` | `GENERIC_SCIM_PROVISIONER`.
        :param pulumi.Input[_builtins.str] scim_client: Specifies the client type for the scim integration. Valid options are: `OKTA` | `AZURE` | `GENERIC`.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the integration.
        :param pulumi.Input[_builtins.str] name: String that specifies the identifier (i.e. name) for the integration; must be unique in your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] network_policy: Specifies an existing network policy that controls SCIM network traffic. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] sync_password: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to enable or disable the synchronization of a user password from an Okta SCIM client as part of the API request to Snowflake. This property is not supported for Azure SCIM. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "run_as_role", run_as_role)
        pulumi.set(__self__, "scim_client", scim_client)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_policy is not None:
            pulumi.set(__self__, "network_policy", network_policy)
        if sync_password is not None:
            pulumi.set(__self__, "sync_password", sync_password)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Specify whether the security integration is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="runAsRole")
    def run_as_role(self) -> pulumi.Input[_builtins.str]:
        """
        Specify the SCIM role in Snowflake that owns any users and roles that are imported from the identity provider into Snowflake using SCIM. Provider assumes that the specified role is already provided. Valid options are: `OKTA_PROVISIONER` | `AAD_PROVISIONER` | `GENERIC_SCIM_PROVISIONER`.
        """
        return pulumi.get(self, "run_as_role")

    @run_as_role.setter
    def run_as_role(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "run_as_role", value)

    @_builtins.property
    @pulumi.getter(name="scimClient")
    def scim_client(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the client type for the scim integration. Valid options are: `OKTA` | `AZURE` | `GENERIC`.
        """
        return pulumi.get(self, "scim_client")

    @scim_client.setter
    def scim_client(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "scim_client", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comment for the integration.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        String that specifies the identifier (i.e. name) for the integration; must be unique in your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkPolicy")
    def network_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies an existing network policy that controls SCIM network traffic. For more information about this resource, see docs.
        """
        return pulumi.get(self, "network_policy")

    @network_policy.setter
    def network_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_policy", value)

    @_builtins.property
    @pulumi.getter(name="syncPassword")
    def sync_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to enable or disable the synchronization of a user password from an Okta SCIM client as part of the API request to Snowflake. This property is not supported for Azure SCIM. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "sync_password")

    @sync_password.setter
    def sync_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sync_password", value)


@pulumi.input_type
class _ScimIntegrationState:
    def __init__(__self__, *,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 describe_outputs: Optional[pulumi.Input[Sequence[pulumi.Input['ScimIntegrationDescribeOutputArgs']]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 run_as_role: Optional[pulumi.Input[_builtins.str]] = None,
                 scim_client: Optional[pulumi.Input[_builtins.str]] = None,
                 show_outputs: Optional[pulumi.Input[Sequence[pulumi.Input['ScimIntegrationShowOutputArgs']]]] = None,
                 sync_password: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ScimIntegration resources.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the integration.
        :param pulumi.Input[Sequence[pulumi.Input['ScimIntegrationDescribeOutputArgs']]] describe_outputs: Outputs the result of `DESCRIBE SECURITY INTEGRATIONS` for the given security integration.
        :param pulumi.Input[_builtins.bool] enabled: Specify whether the security integration is enabled.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.str] name: String that specifies the identifier (i.e. name) for the integration; must be unique in your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] network_policy: Specifies an existing network policy that controls SCIM network traffic. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] run_as_role: Specify the SCIM role in Snowflake that owns any users and roles that are imported from the identity provider into Snowflake using SCIM. Provider assumes that the specified role is already provided. Valid options are: `OKTA_PROVISIONER` | `AAD_PROVISIONER` | `GENERIC_SCIM_PROVISIONER`.
        :param pulumi.Input[_builtins.str] scim_client: Specifies the client type for the scim integration. Valid options are: `OKTA` | `AZURE` | `GENERIC`.
        :param pulumi.Input[Sequence[pulumi.Input['ScimIntegrationShowOutputArgs']]] show_outputs: Outputs the result of `SHOW SECURITY INTEGRATIONS` for the given security integration.
        :param pulumi.Input[_builtins.str] sync_password: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to enable or disable the synchronization of a user password from an Okta SCIM client as part of the API request to Snowflake. This property is not supported for Azure SCIM. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if describe_outputs is not None:
            pulumi.set(__self__, "describe_outputs", describe_outputs)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if fully_qualified_name is not None:
            pulumi.set(__self__, "fully_qualified_name", fully_qualified_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_policy is not None:
            pulumi.set(__self__, "network_policy", network_policy)
        if run_as_role is not None:
            pulumi.set(__self__, "run_as_role", run_as_role)
        if scim_client is not None:
            pulumi.set(__self__, "scim_client", scim_client)
        if show_outputs is not None:
            pulumi.set(__self__, "show_outputs", show_outputs)
        if sync_password is not None:
            pulumi.set(__self__, "sync_password", sync_password)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comment for the integration.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="describeOutputs")
    def describe_outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScimIntegrationDescribeOutputArgs']]]]:
        """
        Outputs the result of `DESCRIBE SECURITY INTEGRATIONS` for the given security integration.
        """
        return pulumi.get(self, "describe_outputs")

    @describe_outputs.setter
    def describe_outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScimIntegrationDescribeOutputArgs']]]]):
        pulumi.set(self, "describe_outputs", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specify whether the security integration is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @fully_qualified_name.setter
    def fully_qualified_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fully_qualified_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        String that specifies the identifier (i.e. name) for the integration; must be unique in your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkPolicy")
    def network_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies an existing network policy that controls SCIM network traffic. For more information about this resource, see docs.
        """
        return pulumi.get(self, "network_policy")

    @network_policy.setter
    def network_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_policy", value)

    @_builtins.property
    @pulumi.getter(name="runAsRole")
    def run_as_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the SCIM role in Snowflake that owns any users and roles that are imported from the identity provider into Snowflake using SCIM. Provider assumes that the specified role is already provided. Valid options are: `OKTA_PROVISIONER` | `AAD_PROVISIONER` | `GENERIC_SCIM_PROVISIONER`.
        """
        return pulumi.get(self, "run_as_role")

    @run_as_role.setter
    def run_as_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "run_as_role", value)

    @_builtins.property
    @pulumi.getter(name="scimClient")
    def scim_client(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the client type for the scim integration. Valid options are: `OKTA` | `AZURE` | `GENERIC`.
        """
        return pulumi.get(self, "scim_client")

    @scim_client.setter
    def scim_client(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scim_client", value)

    @_builtins.property
    @pulumi.getter(name="showOutputs")
    def show_outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScimIntegrationShowOutputArgs']]]]:
        """
        Outputs the result of `SHOW SECURITY INTEGRATIONS` for the given security integration.
        """
        return pulumi.get(self, "show_outputs")

    @show_outputs.setter
    def show_outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScimIntegrationShowOutputArgs']]]]):
        pulumi.set(self, "show_outputs", value)

    @_builtins.property
    @pulumi.getter(name="syncPassword")
    def sync_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to enable or disable the synchronization of a user password from an Okta SCIM client as part of the API request to Snowflake. This property is not supported for Azure SCIM. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "sync_password")

    @sync_password.setter
    def sync_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sync_password", value)


@pulumi.type_token("snowflake:index/scimIntegration:ScimIntegration")
class ScimIntegration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 run_as_role: Optional[pulumi.Input[_builtins.str]] = None,
                 scim_client: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_password: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/scimIntegration:ScimIntegration example '"<integration_name>"'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the integration.
        :param pulumi.Input[_builtins.bool] enabled: Specify whether the security integration is enabled.
        :param pulumi.Input[_builtins.str] name: String that specifies the identifier (i.e. name) for the integration; must be unique in your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] network_policy: Specifies an existing network policy that controls SCIM network traffic. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] run_as_role: Specify the SCIM role in Snowflake that owns any users and roles that are imported from the identity provider into Snowflake using SCIM. Provider assumes that the specified role is already provided. Valid options are: `OKTA_PROVISIONER` | `AAD_PROVISIONER` | `GENERIC_SCIM_PROVISIONER`.
        :param pulumi.Input[_builtins.str] scim_client: Specifies the client type for the scim integration. Valid options are: `OKTA` | `AZURE` | `GENERIC`.
        :param pulumi.Input[_builtins.str] sync_password: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to enable or disable the synchronization of a user password from an Okta SCIM client as part of the API request to Snowflake. This property is not supported for Azure SCIM. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScimIntegrationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/scimIntegration:ScimIntegration example '"<integration_name>"'
        ```

        :param str resource_name: The name of the resource.
        :param ScimIntegrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScimIntegrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 run_as_role: Optional[pulumi.Input[_builtins.str]] = None,
                 scim_client: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_password: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScimIntegrationArgs.__new__(ScimIntegrationArgs)

            __props__.__dict__["comment"] = comment
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["name"] = name
            __props__.__dict__["network_policy"] = network_policy
            if run_as_role is None and not opts.urn:
                raise TypeError("Missing required property 'run_as_role'")
            __props__.__dict__["run_as_role"] = run_as_role
            if scim_client is None and not opts.urn:
                raise TypeError("Missing required property 'scim_client'")
            __props__.__dict__["scim_client"] = scim_client
            __props__.__dict__["sync_password"] = sync_password
            __props__.__dict__["describe_outputs"] = None
            __props__.__dict__["fully_qualified_name"] = None
            __props__.__dict__["show_outputs"] = None
        super(ScimIntegration, __self__).__init__(
            'snowflake:index/scimIntegration:ScimIntegration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            describe_outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScimIntegrationDescribeOutputArgs', 'ScimIntegrationDescribeOutputArgsDict']]]]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_policy: Optional[pulumi.Input[_builtins.str]] = None,
            run_as_role: Optional[pulumi.Input[_builtins.str]] = None,
            scim_client: Optional[pulumi.Input[_builtins.str]] = None,
            show_outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScimIntegrationShowOutputArgs', 'ScimIntegrationShowOutputArgsDict']]]]] = None,
            sync_password: Optional[pulumi.Input[_builtins.str]] = None) -> 'ScimIntegration':
        """
        Get an existing ScimIntegration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the integration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScimIntegrationDescribeOutputArgs', 'ScimIntegrationDescribeOutputArgsDict']]]] describe_outputs: Outputs the result of `DESCRIBE SECURITY INTEGRATIONS` for the given security integration.
        :param pulumi.Input[_builtins.bool] enabled: Specify whether the security integration is enabled.
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.str] name: String that specifies the identifier (i.e. name) for the integration; must be unique in your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] network_policy: Specifies an existing network policy that controls SCIM network traffic. For more information about this resource, see docs.
        :param pulumi.Input[_builtins.str] run_as_role: Specify the SCIM role in Snowflake that owns any users and roles that are imported from the identity provider into Snowflake using SCIM. Provider assumes that the specified role is already provided. Valid options are: `OKTA_PROVISIONER` | `AAD_PROVISIONER` | `GENERIC_SCIM_PROVISIONER`.
        :param pulumi.Input[_builtins.str] scim_client: Specifies the client type for the scim integration. Valid options are: `OKTA` | `AZURE` | `GENERIC`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScimIntegrationShowOutputArgs', 'ScimIntegrationShowOutputArgsDict']]]] show_outputs: Outputs the result of `SHOW SECURITY INTEGRATIONS` for the given security integration.
        :param pulumi.Input[_builtins.str] sync_password: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to enable or disable the synchronization of a user password from an Okta SCIM client as part of the API request to Snowflake. This property is not supported for Azure SCIM. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ScimIntegrationState.__new__(_ScimIntegrationState)

        __props__.__dict__["comment"] = comment
        __props__.__dict__["describe_outputs"] = describe_outputs
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["fully_qualified_name"] = fully_qualified_name
        __props__.__dict__["name"] = name
        __props__.__dict__["network_policy"] = network_policy
        __props__.__dict__["run_as_role"] = run_as_role
        __props__.__dict__["scim_client"] = scim_client
        __props__.__dict__["show_outputs"] = show_outputs
        __props__.__dict__["sync_password"] = sync_password
        return ScimIntegration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a comment for the integration.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="describeOutputs")
    def describe_outputs(self) -> pulumi.Output[Sequence['outputs.ScimIntegrationDescribeOutput']]:
        """
        Outputs the result of `DESCRIBE SECURITY INTEGRATIONS` for the given security integration.
        """
        return pulumi.get(self, "describe_outputs")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Specify whether the security integration is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> pulumi.Output[_builtins.str]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        String that specifies the identifier (i.e. name) for the integration; must be unique in your account. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkPolicy")
    def network_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies an existing network policy that controls SCIM network traffic. For more information about this resource, see docs.
        """
        return pulumi.get(self, "network_policy")

    @_builtins.property
    @pulumi.getter(name="runAsRole")
    def run_as_role(self) -> pulumi.Output[_builtins.str]:
        """
        Specify the SCIM role in Snowflake that owns any users and roles that are imported from the identity provider into Snowflake using SCIM. Provider assumes that the specified role is already provided. Valid options are: `OKTA_PROVISIONER` | `AAD_PROVISIONER` | `GENERIC_SCIM_PROVISIONER`.
        """
        return pulumi.get(self, "run_as_role")

    @_builtins.property
    @pulumi.getter(name="scimClient")
    def scim_client(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the client type for the scim integration. Valid options are: `OKTA` | `AZURE` | `GENERIC`.
        """
        return pulumi.get(self, "scim_client")

    @_builtins.property
    @pulumi.getter(name="showOutputs")
    def show_outputs(self) -> pulumi.Output[Sequence['outputs.ScimIntegrationShowOutput']]:
        """
        Outputs the result of `SHOW SECURITY INTEGRATIONS` for the given security integration.
        """
        return pulumi.get(self, "show_outputs")

    @_builtins.property
    @pulumi.getter(name="syncPassword")
    def sync_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to enable or disable the synchronization of a user password from an Okta SCIM client as part of the API request to Snowflake. This property is not supported for Azure SCIM. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "sync_password")

