# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StageArgs', 'Stage']

@pulumi.input_type
class StageArgs:
    def __init__(__self__, *,
                 database: pulumi.Input[_builtins.str],
                 schema: pulumi.Input[_builtins.str],
                 aws_external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 copy_options: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input[_builtins.str]] = None,
                 directory: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 file_format: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 snowflake_iam_user: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_integration: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['StageTagArgs']]]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Stage resource.
        :param pulumi.Input[_builtins.str] database: The database in which to create the stage.
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the stage.
        :param pulumi.Input[_builtins.str] aws_external_id: A unique ID assigned to the specific stage. The ID has the following format: &lt;snowflakeAccount&gt;*SFCRole=&lt;snowflakeRoleId&gt;*&lt;randomId&gt;
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the stage.
        :param pulumi.Input[_builtins.str] copy_options: Specifies the copy options for the stage.
        :param pulumi.Input[_builtins.str] credentials: Specifies the credentials for the stage.
        :param pulumi.Input[_builtins.str] directory: Specifies the directory settings for the stage.
        :param pulumi.Input[_builtins.str] encryption: Specifies the encryption settings for the stage.
        :param pulumi.Input[_builtins.str] file_format: Specifies the file format for the stage. Specifying the default Snowflake value (e.g. TYPE = CSV) will currently result in a permadiff (check #2679). For now, omit the default values; it will be fixed in the upcoming provider versions. Examples of usage: \\n\\n1. with hardcoding value:\\n\\n `file_format="FORMAT_NAME = DB.SCHEMA.FORMATNAME"` \\n\\n2. from dynamic value:\\n\\n `file_format = "FORMAT_NAME = ${snowflake_file_format.myfileformat.fully_qualified_name}"` \\n\\n3. from expression:\\n\\n `file_format = format("FORMAT_NAME =%s.%s.MYFILEFORMAT", var.db_name, each.value.schema_name)`. Reference: #265
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the stage; must be unique for the database and schema in which the stage is created.
        :param pulumi.Input[_builtins.str] snowflake_iam_user: An AWS IAM user created for your Snowflake account. This user is the same for every external S3 stage created in your account.
        :param pulumi.Input[_builtins.str] storage_integration: Specifies the name of the storage integration used to delegate authentication responsibility for external cloud storage to a Snowflake identity and access management (IAM) entity.
        :param pulumi.Input[Sequence[pulumi.Input['StageTagArgs']]] tags: Definitions of a tag to associate with the resource.
        :param pulumi.Input[_builtins.str] url: Specifies the URL for the stage.
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "schema", schema)
        if aws_external_id is not None:
            pulumi.set(__self__, "aws_external_id", aws_external_id)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if copy_options is not None:
            pulumi.set(__self__, "copy_options", copy_options)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if directory is not None:
            pulumi.set(__self__, "directory", directory)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if file_format is not None:
            pulumi.set(__self__, "file_format", file_format)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if snowflake_iam_user is not None:
            pulumi.set(__self__, "snowflake_iam_user", snowflake_iam_user)
        if storage_integration is not None:
            pulumi.set(__self__, "storage_integration", storage_integration)
        if tags is not None:
            warnings.warn("""Use the 'snowflake_tag_association' resource instead.""", DeprecationWarning)
            pulumi.log.warn("""tags is deprecated: Use the 'snowflake_tag_association' resource instead.""")
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Input[_builtins.str]:
        """
        The database in which to create the stage.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Input[_builtins.str]:
        """
        The schema in which to create the stage.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter(name="awsExternalId")
    def aws_external_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique ID assigned to the specific stage. The ID has the following format: &lt;snowflakeAccount&gt;*SFCRole=&lt;snowflakeRoleId&gt;*&lt;randomId&gt;
        """
        return pulumi.get(self, "aws_external_id")

    @aws_external_id.setter
    def aws_external_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_external_id", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comment for the stage.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="copyOptions")
    def copy_options(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the copy options for the stage.
        """
        return pulumi.get(self, "copy_options")

    @copy_options.setter
    def copy_options(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "copy_options", value)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the credentials for the stage.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credentials", value)

    @_builtins.property
    @pulumi.getter
    def directory(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the directory settings for the stage.
        """
        return pulumi.get(self, "directory")

    @directory.setter
    def directory(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "directory", value)

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the encryption settings for the stage.
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption", value)

    @_builtins.property
    @pulumi.getter(name="fileFormat")
    def file_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the file format for the stage. Specifying the default Snowflake value (e.g. TYPE = CSV) will currently result in a permadiff (check #2679). For now, omit the default values; it will be fixed in the upcoming provider versions. Examples of usage: \\n\\n1. with hardcoding value:\\n\\n `file_format="FORMAT_NAME = DB.SCHEMA.FORMATNAME"` \\n\\n2. from dynamic value:\\n\\n `file_format = "FORMAT_NAME = ${snowflake_file_format.myfileformat.fully_qualified_name}"` \\n\\n3. from expression:\\n\\n `file_format = format("FORMAT_NAME =%s.%s.MYFILEFORMAT", var.db_name, each.value.schema_name)`. Reference: #265
        """
        return pulumi.get(self, "file_format")

    @file_format.setter
    def file_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file_format", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier for the stage; must be unique for the database and schema in which the stage is created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="snowflakeIamUser")
    def snowflake_iam_user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An AWS IAM user created for your Snowflake account. This user is the same for every external S3 stage created in your account.
        """
        return pulumi.get(self, "snowflake_iam_user")

    @snowflake_iam_user.setter
    def snowflake_iam_user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snowflake_iam_user", value)

    @_builtins.property
    @pulumi.getter(name="storageIntegration")
    def storage_integration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the storage integration used to delegate authentication responsibility for external cloud storage to a Snowflake identity and access management (IAM) entity.
        """
        return pulumi.get(self, "storage_integration")

    @storage_integration.setter
    def storage_integration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_integration", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Use the 'snowflake_tag_association' resource instead.""")
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StageTagArgs']]]]:
        """
        Definitions of a tag to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StageTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the URL for the stage.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class _StageState:
    def __init__(__self__, *,
                 aws_external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 copy_options: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 directory: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 file_format: Optional[pulumi.Input[_builtins.str]] = None,
                 fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 snowflake_iam_user: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_integration: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['StageTagArgs']]]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Stage resources.
        :param pulumi.Input[_builtins.str] aws_external_id: A unique ID assigned to the specific stage. The ID has the following format: &lt;snowflakeAccount&gt;*SFCRole=&lt;snowflakeRoleId&gt;*&lt;randomId&gt;
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the stage.
        :param pulumi.Input[_builtins.str] copy_options: Specifies the copy options for the stage.
        :param pulumi.Input[_builtins.str] credentials: Specifies the credentials for the stage.
        :param pulumi.Input[_builtins.str] database: The database in which to create the stage.
        :param pulumi.Input[_builtins.str] directory: Specifies the directory settings for the stage.
        :param pulumi.Input[_builtins.str] encryption: Specifies the encryption settings for the stage.
        :param pulumi.Input[_builtins.str] file_format: Specifies the file format for the stage. Specifying the default Snowflake value (e.g. TYPE = CSV) will currently result in a permadiff (check #2679). For now, omit the default values; it will be fixed in the upcoming provider versions. Examples of usage: \\n\\n1. with hardcoding value:\\n\\n `file_format="FORMAT_NAME = DB.SCHEMA.FORMATNAME"` \\n\\n2. from dynamic value:\\n\\n `file_format = "FORMAT_NAME = ${snowflake_file_format.myfileformat.fully_qualified_name}"` \\n\\n3. from expression:\\n\\n `file_format = format("FORMAT_NAME =%s.%s.MYFILEFORMAT", var.db_name, each.value.schema_name)`. Reference: #265
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the stage; must be unique for the database and schema in which the stage is created.
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the stage.
        :param pulumi.Input[_builtins.str] snowflake_iam_user: An AWS IAM user created for your Snowflake account. This user is the same for every external S3 stage created in your account.
        :param pulumi.Input[_builtins.str] storage_integration: Specifies the name of the storage integration used to delegate authentication responsibility for external cloud storage to a Snowflake identity and access management (IAM) entity.
        :param pulumi.Input[Sequence[pulumi.Input['StageTagArgs']]] tags: Definitions of a tag to associate with the resource.
        :param pulumi.Input[_builtins.str] url: Specifies the URL for the stage.
        """
        if aws_external_id is not None:
            pulumi.set(__self__, "aws_external_id", aws_external_id)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if copy_options is not None:
            pulumi.set(__self__, "copy_options", copy_options)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if directory is not None:
            pulumi.set(__self__, "directory", directory)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if file_format is not None:
            pulumi.set(__self__, "file_format", file_format)
        if fully_qualified_name is not None:
            pulumi.set(__self__, "fully_qualified_name", fully_qualified_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if snowflake_iam_user is not None:
            pulumi.set(__self__, "snowflake_iam_user", snowflake_iam_user)
        if storage_integration is not None:
            pulumi.set(__self__, "storage_integration", storage_integration)
        if tags is not None:
            warnings.warn("""Use the 'snowflake_tag_association' resource instead.""", DeprecationWarning)
            pulumi.log.warn("""tags is deprecated: Use the 'snowflake_tag_association' resource instead.""")
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="awsExternalId")
    def aws_external_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique ID assigned to the specific stage. The ID has the following format: &lt;snowflakeAccount&gt;*SFCRole=&lt;snowflakeRoleId&gt;*&lt;randomId&gt;
        """
        return pulumi.get(self, "aws_external_id")

    @aws_external_id.setter
    def aws_external_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aws_external_id", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a comment for the stage.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="copyOptions")
    def copy_options(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the copy options for the stage.
        """
        return pulumi.get(self, "copy_options")

    @copy_options.setter
    def copy_options(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "copy_options", value)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the credentials for the stage.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credentials", value)

    @_builtins.property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database in which to create the stage.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter
    def directory(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the directory settings for the stage.
        """
        return pulumi.get(self, "directory")

    @directory.setter
    def directory(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "directory", value)

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the encryption settings for the stage.
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption", value)

    @_builtins.property
    @pulumi.getter(name="fileFormat")
    def file_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the file format for the stage. Specifying the default Snowflake value (e.g. TYPE = CSV) will currently result in a permadiff (check #2679). For now, omit the default values; it will be fixed in the upcoming provider versions. Examples of usage: \\n\\n1. with hardcoding value:\\n\\n `file_format="FORMAT_NAME = DB.SCHEMA.FORMATNAME"` \\n\\n2. from dynamic value:\\n\\n `file_format = "FORMAT_NAME = ${snowflake_file_format.myfileformat.fully_qualified_name}"` \\n\\n3. from expression:\\n\\n `file_format = format("FORMAT_NAME =%s.%s.MYFILEFORMAT", var.db_name, each.value.schema_name)`. Reference: #265
        """
        return pulumi.get(self, "file_format")

    @file_format.setter
    def file_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file_format", value)

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @fully_qualified_name.setter
    def fully_qualified_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fully_qualified_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier for the stage; must be unique for the database and schema in which the stage is created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schema in which to create the stage.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter(name="snowflakeIamUser")
    def snowflake_iam_user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An AWS IAM user created for your Snowflake account. This user is the same for every external S3 stage created in your account.
        """
        return pulumi.get(self, "snowflake_iam_user")

    @snowflake_iam_user.setter
    def snowflake_iam_user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snowflake_iam_user", value)

    @_builtins.property
    @pulumi.getter(name="storageIntegration")
    def storage_integration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the storage integration used to delegate authentication responsibility for external cloud storage to a Snowflake identity and access management (IAM) entity.
        """
        return pulumi.get(self, "storage_integration")

    @storage_integration.setter
    def storage_integration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_integration", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Use the 'snowflake_tag_association' resource instead.""")
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StageTagArgs']]]]:
        """
        Definitions of a tag to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StageTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the URL for the stage.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)


@pulumi.type_token("snowflake:index/stage:Stage")
class Stage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 copy_options: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 directory: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 file_format: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 snowflake_iam_user: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_integration: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StageTagArgs', 'StageTagArgsDict']]]]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        format is database name | schema name | stage name

        ```sh
        $ pulumi import snowflake:index/stage:Stage example 'dbName|schemaName|stageName'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] aws_external_id: A unique ID assigned to the specific stage. The ID has the following format: &lt;snowflakeAccount&gt;*SFCRole=&lt;snowflakeRoleId&gt;*&lt;randomId&gt;
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the stage.
        :param pulumi.Input[_builtins.str] copy_options: Specifies the copy options for the stage.
        :param pulumi.Input[_builtins.str] credentials: Specifies the credentials for the stage.
        :param pulumi.Input[_builtins.str] database: The database in which to create the stage.
        :param pulumi.Input[_builtins.str] directory: Specifies the directory settings for the stage.
        :param pulumi.Input[_builtins.str] encryption: Specifies the encryption settings for the stage.
        :param pulumi.Input[_builtins.str] file_format: Specifies the file format for the stage. Specifying the default Snowflake value (e.g. TYPE = CSV) will currently result in a permadiff (check #2679). For now, omit the default values; it will be fixed in the upcoming provider versions. Examples of usage: \\n\\n1. with hardcoding value:\\n\\n `file_format="FORMAT_NAME = DB.SCHEMA.FORMATNAME"` \\n\\n2. from dynamic value:\\n\\n `file_format = "FORMAT_NAME = ${snowflake_file_format.myfileformat.fully_qualified_name}"` \\n\\n3. from expression:\\n\\n `file_format = format("FORMAT_NAME =%s.%s.MYFILEFORMAT", var.db_name, each.value.schema_name)`. Reference: #265
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the stage; must be unique for the database and schema in which the stage is created.
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the stage.
        :param pulumi.Input[_builtins.str] snowflake_iam_user: An AWS IAM user created for your Snowflake account. This user is the same for every external S3 stage created in your account.
        :param pulumi.Input[_builtins.str] storage_integration: Specifies the name of the storage integration used to delegate authentication responsibility for external cloud storage to a Snowflake identity and access management (IAM) entity.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StageTagArgs', 'StageTagArgsDict']]]] tags: Definitions of a tag to associate with the resource.
        :param pulumi.Input[_builtins.str] url: Specifies the URL for the stage.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        format is database name | schema name | stage name

        ```sh
        $ pulumi import snowflake:index/stage:Stage example 'dbName|schemaName|stageName'
        ```

        :param str resource_name: The name of the resource.
        :param StageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 copy_options: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input[_builtins.str]] = None,
                 database: Optional[pulumi.Input[_builtins.str]] = None,
                 directory: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 file_format: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 snowflake_iam_user: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_integration: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StageTagArgs', 'StageTagArgsDict']]]]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StageArgs.__new__(StageArgs)

            __props__.__dict__["aws_external_id"] = aws_external_id
            __props__.__dict__["comment"] = comment
            __props__.__dict__["copy_options"] = copy_options
            __props__.__dict__["credentials"] = None if credentials is None else pulumi.Output.secret(credentials)
            if database is None and not opts.urn:
                raise TypeError("Missing required property 'database'")
            __props__.__dict__["database"] = database
            __props__.__dict__["directory"] = directory
            __props__.__dict__["encryption"] = encryption
            __props__.__dict__["file_format"] = file_format
            __props__.__dict__["name"] = name
            if schema is None and not opts.urn:
                raise TypeError("Missing required property 'schema'")
            __props__.__dict__["schema"] = schema
            __props__.__dict__["snowflake_iam_user"] = snowflake_iam_user
            __props__.__dict__["storage_integration"] = storage_integration
            __props__.__dict__["tags"] = tags
            __props__.__dict__["url"] = url
            __props__.__dict__["fully_qualified_name"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["credentials"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Stage, __self__).__init__(
            'snowflake:index/stage:Stage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aws_external_id: Optional[pulumi.Input[_builtins.str]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            copy_options: Optional[pulumi.Input[_builtins.str]] = None,
            credentials: Optional[pulumi.Input[_builtins.str]] = None,
            database: Optional[pulumi.Input[_builtins.str]] = None,
            directory: Optional[pulumi.Input[_builtins.str]] = None,
            encryption: Optional[pulumi.Input[_builtins.str]] = None,
            file_format: Optional[pulumi.Input[_builtins.str]] = None,
            fully_qualified_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            schema: Optional[pulumi.Input[_builtins.str]] = None,
            snowflake_iam_user: Optional[pulumi.Input[_builtins.str]] = None,
            storage_integration: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StageTagArgs', 'StageTagArgsDict']]]]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None) -> 'Stage':
        """
        Get an existing Stage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] aws_external_id: A unique ID assigned to the specific stage. The ID has the following format: &lt;snowflakeAccount&gt;*SFCRole=&lt;snowflakeRoleId&gt;*&lt;randomId&gt;
        :param pulumi.Input[_builtins.str] comment: Specifies a comment for the stage.
        :param pulumi.Input[_builtins.str] copy_options: Specifies the copy options for the stage.
        :param pulumi.Input[_builtins.str] credentials: Specifies the credentials for the stage.
        :param pulumi.Input[_builtins.str] database: The database in which to create the stage.
        :param pulumi.Input[_builtins.str] directory: Specifies the directory settings for the stage.
        :param pulumi.Input[_builtins.str] encryption: Specifies the encryption settings for the stage.
        :param pulumi.Input[_builtins.str] file_format: Specifies the file format for the stage. Specifying the default Snowflake value (e.g. TYPE = CSV) will currently result in a permadiff (check #2679). For now, omit the default values; it will be fixed in the upcoming provider versions. Examples of usage: \\n\\n1. with hardcoding value:\\n\\n `file_format="FORMAT_NAME = DB.SCHEMA.FORMATNAME"` \\n\\n2. from dynamic value:\\n\\n `file_format = "FORMAT_NAME = ${snowflake_file_format.myfileformat.fully_qualified_name}"` \\n\\n3. from expression:\\n\\n `file_format = format("FORMAT_NAME =%s.%s.MYFILEFORMAT", var.db_name, each.value.schema_name)`. Reference: #265
        :param pulumi.Input[_builtins.str] fully_qualified_name: Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        :param pulumi.Input[_builtins.str] name: Specifies the identifier for the stage; must be unique for the database and schema in which the stage is created.
        :param pulumi.Input[_builtins.str] schema: The schema in which to create the stage.
        :param pulumi.Input[_builtins.str] snowflake_iam_user: An AWS IAM user created for your Snowflake account. This user is the same for every external S3 stage created in your account.
        :param pulumi.Input[_builtins.str] storage_integration: Specifies the name of the storage integration used to delegate authentication responsibility for external cloud storage to a Snowflake identity and access management (IAM) entity.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StageTagArgs', 'StageTagArgsDict']]]] tags: Definitions of a tag to associate with the resource.
        :param pulumi.Input[_builtins.str] url: Specifies the URL for the stage.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StageState.__new__(_StageState)

        __props__.__dict__["aws_external_id"] = aws_external_id
        __props__.__dict__["comment"] = comment
        __props__.__dict__["copy_options"] = copy_options
        __props__.__dict__["credentials"] = credentials
        __props__.__dict__["database"] = database
        __props__.__dict__["directory"] = directory
        __props__.__dict__["encryption"] = encryption
        __props__.__dict__["file_format"] = file_format
        __props__.__dict__["fully_qualified_name"] = fully_qualified_name
        __props__.__dict__["name"] = name
        __props__.__dict__["schema"] = schema
        __props__.__dict__["snowflake_iam_user"] = snowflake_iam_user
        __props__.__dict__["storage_integration"] = storage_integration
        __props__.__dict__["tags"] = tags
        __props__.__dict__["url"] = url
        return Stage(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="awsExternalId")
    def aws_external_id(self) -> pulumi.Output[_builtins.str]:
        """
        A unique ID assigned to the specific stage. The ID has the following format: &lt;snowflakeAccount&gt;*SFCRole=&lt;snowflakeRoleId&gt;*&lt;randomId&gt;
        """
        return pulumi.get(self, "aws_external_id")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a comment for the stage.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="copyOptions")
    def copy_options(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the copy options for the stage.
        """
        return pulumi.get(self, "copy_options")

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the credentials for the stage.
        """
        return pulumi.get(self, "credentials")

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Output[_builtins.str]:
        """
        The database in which to create the stage.
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter
    def directory(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the directory settings for the stage.
        """
        return pulumi.get(self, "directory")

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the encryption settings for the stage.
        """
        return pulumi.get(self, "encryption")

    @_builtins.property
    @pulumi.getter(name="fileFormat")
    def file_format(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the file format for the stage. Specifying the default Snowflake value (e.g. TYPE = CSV) will currently result in a permadiff (check #2679). For now, omit the default values; it will be fixed in the upcoming provider versions. Examples of usage: \\n\\n1. with hardcoding value:\\n\\n `file_format="FORMAT_NAME = DB.SCHEMA.FORMATNAME"` \\n\\n2. from dynamic value:\\n\\n `file_format = "FORMAT_NAME = ${snowflake_file_format.myfileformat.fully_qualified_name}"` \\n\\n3. from expression:\\n\\n `file_format = format("FORMAT_NAME =%s.%s.MYFILEFORMAT", var.db_name, each.value.schema_name)`. Reference: #265
        """
        return pulumi.get(self, "file_format")

    @_builtins.property
    @pulumi.getter(name="fullyQualifiedName")
    def fully_qualified_name(self) -> pulumi.Output[_builtins.str]:
        """
        Fully qualified name of the resource. For more information, see [object name resolution](https://docs.snowflake.com/en/sql-reference/name-resolution).
        """
        return pulumi.get(self, "fully_qualified_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the identifier for the stage; must be unique for the database and schema in which the stage is created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Output[_builtins.str]:
        """
        The schema in which to create the stage.
        """
        return pulumi.get(self, "schema")

    @_builtins.property
    @pulumi.getter(name="snowflakeIamUser")
    def snowflake_iam_user(self) -> pulumi.Output[_builtins.str]:
        """
        An AWS IAM user created for your Snowflake account. This user is the same for every external S3 stage created in your account.
        """
        return pulumi.get(self, "snowflake_iam_user")

    @_builtins.property
    @pulumi.getter(name="storageIntegration")
    def storage_integration(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the name of the storage integration used to delegate authentication responsibility for external cloud storage to a Snowflake identity and access management (IAM) entity.
        """
        return pulumi.get(self, "storage_integration")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Use the 'snowflake_tag_association' resource instead.""")
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.StageTag']]]:
        """
        Definitions of a tag to associate with the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the URL for the stage.
        """
        return pulumi.get(self, "url")

