# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['UserProgrammaticAccessTokenArgs', 'UserProgrammaticAccessToken']

@pulumi.input_type
class UserProgrammaticAccessTokenArgs:
    def __init__(__self__, *,
                 user: pulumi.Input[_builtins.str],
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 days_to_expiry: Optional[pulumi.Input[_builtins.int]] = None,
                 disabled: Optional[pulumi.Input[_builtins.str]] = None,
                 expire_rotated_token_after_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 keeper: Optional[pulumi.Input[_builtins.str]] = None,
                 mins_to_bypass_network_policy_requirement: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 role_restriction: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a UserProgrammaticAccessToken resource.
        :param pulumi.Input[_builtins.str] user: The name of the user that the token is associated with. A user cannot use another user's programmatic access token to authenticate. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] comment: Descriptive comment about the programmatic access token.
        :param pulumi.Input[_builtins.str] disabled: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Disables or enables the programmatic access token. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.int] expire_rotated_token_after_hours: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) This field is only used when the token is rotated by changing the `keeper` field. Sets the expiration time of the existing token secret to expire after the specified number of hours. You can set this to a value of 0 to expire the current token secret immediately.
        :param pulumi.Input[_builtins.str] keeper: Arbitrary string that, if and only if, changed from a non-empty to a different non-empty value (or known after apply), will trigger a key to be rotated. When you add this field to the configuration, or remove it from the configuration, the rotation is not triggered. When the token is rotated, the `token` and `rotated_token_name` fields are marked as computed.
        :param pulumi.Input[_builtins.str] name: Specifies the name for the programmatic access token; must be unique for the user. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] role_restriction: The name of the role used for privilege evaluation and object creation. This must be one of the roles that has already been granted to the user. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        pulumi.set(__self__, "user", user)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if days_to_expiry is not None:
            pulumi.set(__self__, "days_to_expiry", days_to_expiry)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if expire_rotated_token_after_hours is not None:
            pulumi.set(__self__, "expire_rotated_token_after_hours", expire_rotated_token_after_hours)
        if keeper is not None:
            pulumi.set(__self__, "keeper", keeper)
        if mins_to_bypass_network_policy_requirement is not None:
            pulumi.set(__self__, "mins_to_bypass_network_policy_requirement", mins_to_bypass_network_policy_requirement)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if role_restriction is not None:
            pulumi.set(__self__, "role_restriction", role_restriction)

    @_builtins.property
    @pulumi.getter
    def user(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the user that the token is associated with. A user cannot use another user's programmatic access token to authenticate. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Descriptive comment about the programmatic access token.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="daysToExpiry")
    def days_to_expiry(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "days_to_expiry")

    @days_to_expiry.setter
    def days_to_expiry(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "days_to_expiry", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Disables or enables the programmatic access token. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter(name="expireRotatedTokenAfterHours")
    def expire_rotated_token_after_hours(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) This field is only used when the token is rotated by changing the `keeper` field. Sets the expiration time of the existing token secret to expire after the specified number of hours. You can set this to a value of 0 to expire the current token secret immediately.
        """
        return pulumi.get(self, "expire_rotated_token_after_hours")

    @expire_rotated_token_after_hours.setter
    def expire_rotated_token_after_hours(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "expire_rotated_token_after_hours", value)

    @_builtins.property
    @pulumi.getter
    def keeper(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Arbitrary string that, if and only if, changed from a non-empty to a different non-empty value (or known after apply), will trigger a key to be rotated. When you add this field to the configuration, or remove it from the configuration, the rotation is not triggered. When the token is rotated, the `token` and `rotated_token_name` fields are marked as computed.
        """
        return pulumi.get(self, "keeper")

    @keeper.setter
    def keeper(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "keeper", value)

    @_builtins.property
    @pulumi.getter(name="minsToBypassNetworkPolicyRequirement")
    def mins_to_bypass_network_policy_requirement(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "mins_to_bypass_network_policy_requirement")

    @mins_to_bypass_network_policy_requirement.setter
    def mins_to_bypass_network_policy_requirement(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "mins_to_bypass_network_policy_requirement", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name for the programmatic access token; must be unique for the user. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="roleRestriction")
    def role_restriction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the role used for privilege evaluation and object creation. This must be one of the roles that has already been granted to the user. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "role_restriction")

    @role_restriction.setter
    def role_restriction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_restriction", value)


@pulumi.input_type
class _UserProgrammaticAccessTokenState:
    def __init__(__self__, *,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 days_to_expiry: Optional[pulumi.Input[_builtins.int]] = None,
                 disabled: Optional[pulumi.Input[_builtins.str]] = None,
                 expire_rotated_token_after_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 keeper: Optional[pulumi.Input[_builtins.str]] = None,
                 mins_to_bypass_network_policy_requirement: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 role_restriction: Optional[pulumi.Input[_builtins.str]] = None,
                 rotated_token_name: Optional[pulumi.Input[_builtins.str]] = None,
                 show_outputs: Optional[pulumi.Input[Sequence[pulumi.Input['UserProgrammaticAccessTokenShowOutputArgs']]]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering UserProgrammaticAccessToken resources.
        :param pulumi.Input[_builtins.str] comment: Descriptive comment about the programmatic access token.
        :param pulumi.Input[_builtins.str] disabled: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Disables or enables the programmatic access token. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.int] expire_rotated_token_after_hours: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) This field is only used when the token is rotated by changing the `keeper` field. Sets the expiration time of the existing token secret to expire after the specified number of hours. You can set this to a value of 0 to expire the current token secret immediately.
        :param pulumi.Input[_builtins.str] keeper: Arbitrary string that, if and only if, changed from a non-empty to a different non-empty value (or known after apply), will trigger a key to be rotated. When you add this field to the configuration, or remove it from the configuration, the rotation is not triggered. When the token is rotated, the `token` and `rotated_token_name` fields are marked as computed.
        :param pulumi.Input[_builtins.str] name: Specifies the name for the programmatic access token; must be unique for the user. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] role_restriction: The name of the role used for privilege evaluation and object creation. This must be one of the roles that has already been granted to the user. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] rotated_token_name: Name of the token that represents the prior secret. This field is updated only when the token is rotated. In this case, the field is marked as computed.
        :param pulumi.Input[Sequence[pulumi.Input['UserProgrammaticAccessTokenShowOutputArgs']]] show_outputs: Outputs the result of `SHOW USER PROGRAMMATIC ACCESS TOKENS` for the given user programmatic access token.
        :param pulumi.Input[_builtins.str] token: The token itself. Use this to authenticate to an endpoint. The data in this field is updated only when the token is created or rotated. In this case, the field is marked as computed.
        :param pulumi.Input[_builtins.str] user: The name of the user that the token is associated with. A user cannot use another user's programmatic access token to authenticate. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if days_to_expiry is not None:
            pulumi.set(__self__, "days_to_expiry", days_to_expiry)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if expire_rotated_token_after_hours is not None:
            pulumi.set(__self__, "expire_rotated_token_after_hours", expire_rotated_token_after_hours)
        if keeper is not None:
            pulumi.set(__self__, "keeper", keeper)
        if mins_to_bypass_network_policy_requirement is not None:
            pulumi.set(__self__, "mins_to_bypass_network_policy_requirement", mins_to_bypass_network_policy_requirement)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if role_restriction is not None:
            pulumi.set(__self__, "role_restriction", role_restriction)
        if rotated_token_name is not None:
            pulumi.set(__self__, "rotated_token_name", rotated_token_name)
        if show_outputs is not None:
            pulumi.set(__self__, "show_outputs", show_outputs)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Descriptive comment about the programmatic access token.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="daysToExpiry")
    def days_to_expiry(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "days_to_expiry")

    @days_to_expiry.setter
    def days_to_expiry(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "days_to_expiry", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Disables or enables the programmatic access token. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter(name="expireRotatedTokenAfterHours")
    def expire_rotated_token_after_hours(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) This field is only used when the token is rotated by changing the `keeper` field. Sets the expiration time of the existing token secret to expire after the specified number of hours. You can set this to a value of 0 to expire the current token secret immediately.
        """
        return pulumi.get(self, "expire_rotated_token_after_hours")

    @expire_rotated_token_after_hours.setter
    def expire_rotated_token_after_hours(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "expire_rotated_token_after_hours", value)

    @_builtins.property
    @pulumi.getter
    def keeper(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Arbitrary string that, if and only if, changed from a non-empty to a different non-empty value (or known after apply), will trigger a key to be rotated. When you add this field to the configuration, or remove it from the configuration, the rotation is not triggered. When the token is rotated, the `token` and `rotated_token_name` fields are marked as computed.
        """
        return pulumi.get(self, "keeper")

    @keeper.setter
    def keeper(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "keeper", value)

    @_builtins.property
    @pulumi.getter(name="minsToBypassNetworkPolicyRequirement")
    def mins_to_bypass_network_policy_requirement(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "mins_to_bypass_network_policy_requirement")

    @mins_to_bypass_network_policy_requirement.setter
    def mins_to_bypass_network_policy_requirement(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "mins_to_bypass_network_policy_requirement", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name for the programmatic access token; must be unique for the user. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="roleRestriction")
    def role_restriction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the role used for privilege evaluation and object creation. This must be one of the roles that has already been granted to the user. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "role_restriction")

    @role_restriction.setter
    def role_restriction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_restriction", value)

    @_builtins.property
    @pulumi.getter(name="rotatedTokenName")
    def rotated_token_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the token that represents the prior secret. This field is updated only when the token is rotated. In this case, the field is marked as computed.
        """
        return pulumi.get(self, "rotated_token_name")

    @rotated_token_name.setter
    def rotated_token_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rotated_token_name", value)

    @_builtins.property
    @pulumi.getter(name="showOutputs")
    def show_outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserProgrammaticAccessTokenShowOutputArgs']]]]:
        """
        Outputs the result of `SHOW USER PROGRAMMATIC ACCESS TOKENS` for the given user programmatic access token.
        """
        return pulumi.get(self, "show_outputs")

    @show_outputs.setter
    def show_outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserProgrammaticAccessTokenShowOutputArgs']]]]):
        pulumi.set(self, "show_outputs", value)

    @_builtins.property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The token itself. Use this to authenticate to an endpoint. The data in this field is updated only when the token is created or rotated. In this case, the field is marked as computed.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the user that the token is associated with. A user cannot use another user's programmatic access token to authenticate. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user", value)


@pulumi.type_token("snowflake:index/userProgrammaticAccessToken:UserProgrammaticAccessToken")
class UserProgrammaticAccessToken(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 days_to_expiry: Optional[pulumi.Input[_builtins.int]] = None,
                 disabled: Optional[pulumi.Input[_builtins.str]] = None,
                 expire_rotated_token_after_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 keeper: Optional[pulumi.Input[_builtins.str]] = None,
                 mins_to_bypass_network_policy_requirement: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 role_restriction: Optional[pulumi.Input[_builtins.str]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/userProgrammaticAccessToken:UserProgrammaticAccessToken example '"<user_name>"|"<token_name>"'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comment: Descriptive comment about the programmatic access token.
        :param pulumi.Input[_builtins.str] disabled: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Disables or enables the programmatic access token. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.int] expire_rotated_token_after_hours: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) This field is only used when the token is rotated by changing the `keeper` field. Sets the expiration time of the existing token secret to expire after the specified number of hours. You can set this to a value of 0 to expire the current token secret immediately.
        :param pulumi.Input[_builtins.str] keeper: Arbitrary string that, if and only if, changed from a non-empty to a different non-empty value (or known after apply), will trigger a key to be rotated. When you add this field to the configuration, or remove it from the configuration, the rotation is not triggered. When the token is rotated, the `token` and `rotated_token_name` fields are marked as computed.
        :param pulumi.Input[_builtins.str] name: Specifies the name for the programmatic access token; must be unique for the user. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] role_restriction: The name of the role used for privilege evaluation and object creation. This must be one of the roles that has already been granted to the user. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] user: The name of the user that the token is associated with. A user cannot use another user's programmatic access token to authenticate. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserProgrammaticAccessTokenArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        ```sh
        $ pulumi import snowflake:index/userProgrammaticAccessToken:UserProgrammaticAccessToken example '"<user_name>"|"<token_name>"'
        ```

        :param str resource_name: The name of the resource.
        :param UserProgrammaticAccessTokenArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserProgrammaticAccessTokenArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 days_to_expiry: Optional[pulumi.Input[_builtins.int]] = None,
                 disabled: Optional[pulumi.Input[_builtins.str]] = None,
                 expire_rotated_token_after_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 keeper: Optional[pulumi.Input[_builtins.str]] = None,
                 mins_to_bypass_network_policy_requirement: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 role_restriction: Optional[pulumi.Input[_builtins.str]] = None,
                 user: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserProgrammaticAccessTokenArgs.__new__(UserProgrammaticAccessTokenArgs)

            __props__.__dict__["comment"] = comment
            __props__.__dict__["days_to_expiry"] = days_to_expiry
            __props__.__dict__["disabled"] = disabled
            __props__.__dict__["expire_rotated_token_after_hours"] = expire_rotated_token_after_hours
            __props__.__dict__["keeper"] = keeper
            __props__.__dict__["mins_to_bypass_network_policy_requirement"] = mins_to_bypass_network_policy_requirement
            __props__.__dict__["name"] = name
            __props__.__dict__["role_restriction"] = role_restriction
            if user is None and not opts.urn:
                raise TypeError("Missing required property 'user'")
            __props__.__dict__["user"] = user
            __props__.__dict__["rotated_token_name"] = None
            __props__.__dict__["show_outputs"] = None
            __props__.__dict__["token"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["token"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(UserProgrammaticAccessToken, __self__).__init__(
            'snowflake:index/userProgrammaticAccessToken:UserProgrammaticAccessToken',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            days_to_expiry: Optional[pulumi.Input[_builtins.int]] = None,
            disabled: Optional[pulumi.Input[_builtins.str]] = None,
            expire_rotated_token_after_hours: Optional[pulumi.Input[_builtins.int]] = None,
            keeper: Optional[pulumi.Input[_builtins.str]] = None,
            mins_to_bypass_network_policy_requirement: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            role_restriction: Optional[pulumi.Input[_builtins.str]] = None,
            rotated_token_name: Optional[pulumi.Input[_builtins.str]] = None,
            show_outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserProgrammaticAccessTokenShowOutputArgs', 'UserProgrammaticAccessTokenShowOutputArgsDict']]]]] = None,
            token: Optional[pulumi.Input[_builtins.str]] = None,
            user: Optional[pulumi.Input[_builtins.str]] = None) -> 'UserProgrammaticAccessToken':
        """
        Get an existing UserProgrammaticAccessToken resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] comment: Descriptive comment about the programmatic access token.
        :param pulumi.Input[_builtins.str] disabled: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Disables or enables the programmatic access token. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        :param pulumi.Input[_builtins.int] expire_rotated_token_after_hours: (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) This field is only used when the token is rotated by changing the `keeper` field. Sets the expiration time of the existing token secret to expire after the specified number of hours. You can set this to a value of 0 to expire the current token secret immediately.
        :param pulumi.Input[_builtins.str] keeper: Arbitrary string that, if and only if, changed from a non-empty to a different non-empty value (or known after apply), will trigger a key to be rotated. When you add this field to the configuration, or remove it from the configuration, the rotation is not triggered. When the token is rotated, the `token` and `rotated_token_name` fields are marked as computed.
        :param pulumi.Input[_builtins.str] name: Specifies the name for the programmatic access token; must be unique for the user. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] role_restriction: The name of the role used for privilege evaluation and object creation. This must be one of the roles that has already been granted to the user. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        :param pulumi.Input[_builtins.str] rotated_token_name: Name of the token that represents the prior secret. This field is updated only when the token is rotated. In this case, the field is marked as computed.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserProgrammaticAccessTokenShowOutputArgs', 'UserProgrammaticAccessTokenShowOutputArgsDict']]]] show_outputs: Outputs the result of `SHOW USER PROGRAMMATIC ACCESS TOKENS` for the given user programmatic access token.
        :param pulumi.Input[_builtins.str] token: The token itself. Use this to authenticate to an endpoint. The data in this field is updated only when the token is created or rotated. In this case, the field is marked as computed.
        :param pulumi.Input[_builtins.str] user: The name of the user that the token is associated with. A user cannot use another user's programmatic access token to authenticate. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserProgrammaticAccessTokenState.__new__(_UserProgrammaticAccessTokenState)

        __props__.__dict__["comment"] = comment
        __props__.__dict__["days_to_expiry"] = days_to_expiry
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["expire_rotated_token_after_hours"] = expire_rotated_token_after_hours
        __props__.__dict__["keeper"] = keeper
        __props__.__dict__["mins_to_bypass_network_policy_requirement"] = mins_to_bypass_network_policy_requirement
        __props__.__dict__["name"] = name
        __props__.__dict__["role_restriction"] = role_restriction
        __props__.__dict__["rotated_token_name"] = rotated_token_name
        __props__.__dict__["show_outputs"] = show_outputs
        __props__.__dict__["token"] = token
        __props__.__dict__["user"] = user
        return UserProgrammaticAccessToken(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Descriptive comment about the programmatic access token.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="daysToExpiry")
    def days_to_expiry(self) -> pulumi.Output[Optional[_builtins.int]]:
        return pulumi.get(self, "days_to_expiry")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Disables or enables the programmatic access token. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter(name="expireRotatedTokenAfterHours")
    def expire_rotated_token_after_hours(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) This field is only used when the token is rotated by changing the `keeper` field. Sets the expiration time of the existing token secret to expire after the specified number of hours. You can set this to a value of 0 to expire the current token secret immediately.
        """
        return pulumi.get(self, "expire_rotated_token_after_hours")

    @_builtins.property
    @pulumi.getter
    def keeper(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Arbitrary string that, if and only if, changed from a non-empty to a different non-empty value (or known after apply), will trigger a key to be rotated. When you add this field to the configuration, or remove it from the configuration, the rotation is not triggered. When the token is rotated, the `token` and `rotated_token_name` fields are marked as computed.
        """
        return pulumi.get(self, "keeper")

    @_builtins.property
    @pulumi.getter(name="minsToBypassNetworkPolicyRequirement")
    def mins_to_bypass_network_policy_requirement(self) -> pulumi.Output[Optional[_builtins.int]]:
        return pulumi.get(self, "mins_to_bypass_network_policy_requirement")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name for the programmatic access token; must be unique for the user. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="roleRestriction")
    def role_restriction(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the role used for privilege evaluation and object creation. This must be one of the roles that has already been granted to the user. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "role_restriction")

    @_builtins.property
    @pulumi.getter(name="rotatedTokenName")
    def rotated_token_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the token that represents the prior secret. This field is updated only when the token is rotated. In this case, the field is marked as computed.
        """
        return pulumi.get(self, "rotated_token_name")

    @_builtins.property
    @pulumi.getter(name="showOutputs")
    def show_outputs(self) -> pulumi.Output[Sequence['outputs.UserProgrammaticAccessTokenShowOutput']]:
        """
        Outputs the result of `SHOW USER PROGRAMMATIC ACCESS TOKENS` for the given user programmatic access token.
        """
        return pulumi.get(self, "show_outputs")

    @_builtins.property
    @pulumi.getter
    def token(self) -> pulumi.Output[_builtins.str]:
        """
        The token itself. Use this to authenticate to an endpoint. The data in this field is updated only when the token is created or rotated. In this case, the field is marked as computed.
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter
    def user(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the user that the token is associated with. A user cannot use another user's programmatic access token to authenticate. Due to technical limitations (read more here), avoid using the following characters: `|`, `.`, `"`.
        """
        return pulumi.get(self, "user")

