"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Configuration = exports.ConfigurationProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const acm_generated_1 = require("./acm.generated");
Object.defineProperty(exports, "ConfigurationProperty", { enumerable: true, get: function () { return acm_generated_1.RosConfiguration; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::ACM::Configuration`, which is used to create a configuration.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosConfiguration`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-acm-configuration
 */
class Configuration extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosConfiguration = new acm_generated_1.RosConfiguration(this, id, {
            group: props.group === undefined || props.group === null ? 'DEFAULT_GROUP' : props.group,
            desc: props.desc,
            type: props.type === undefined || props.type === null ? 'text' : props.type,
            dataId: props.dataId,
            content: props.content,
            namespaceId: props.namespaceId,
            tags: props.tags,
            appName: props.appName,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosConfiguration;
        this.attrDataId = rosConfiguration.attrDataId;
        this.attrGroup = rosConfiguration.attrGroup;
        this.attrNamespaceId = rosConfiguration.attrNamespaceId;
    }
}
exports.Configuration = Configuration;
//# sourceMappingURL=data:application/json;base64,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