/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.rest;

import java.util.HashSet;
import java.util.Set;

public enum DriverState {
    SUBMITTED,
    RUNNING,
    FINISHED,
    RELAUNCHING,
    UNKNOWN,
    KILLED,
    FAILED,
    ERROR,
    UNDEFINED;

    private static Set<DriverState> failedStates;
    private static Set<DriverState> successStates;

    public boolean isFinal() {
        return failedStates.contains((Object)this) || successStates.contains((Object)this);
    }

    public boolean isSuccess() {
        return successStates.contains((Object)this);
    }

    public boolean isFailure() {
        return failedStates.contains((Object)this);
    }

    static {
        failedStates = new HashSet<DriverState>(){
            {
                this.add(UNKNOWN);
                this.add(KILLED);
                this.add(FAILED);
                this.add(ERROR);
            }
        };
        successStates = new HashSet<DriverState>(){
            {
                this.add(FINISHED);
            }
        };
    }
}

