/*
 * Decompiled with CFR 0.152.
 */
package sttp.model;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import sttp.model.Cookie;
import sttp.model.CookieWithMeta;
import sttp.model.Header;
import sttp.model.HeaderNames$;
import sttp.model.MediaType;
import sttp.model.Method;
import sttp.model.Method$;
import sttp.model.Uri;
import sttp.model.internal.Rfc2616$;
import sttp.model.internal.Validate$;

public final class Header$ {
    public static Header$ MODULE$;

    static {
        new Header$();
    }

    public Option<Tuple2<String, String>> unapply(Header h) {
        return new Some((Object)new Tuple2((Object)h.name(), (Object)h.value()));
    }

    public Header unsafeApply(String name, String value) {
        return Validate$.MODULE$.RichEither(this.safeApply(name, value)).getOrThrow();
    }

    public Either<String, Header> safeApply(String name, String value) {
        return Validate$.MODULE$.all((Seq<Option<String>>)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{Rfc2616$.MODULE$.validateToken("Header name", name)}), (Function0 & Serializable & scala.Serializable)() -> MODULE$.apply(name, value));
    }

    public Header notValidated(String name, String value) {
        return this.apply(name, value);
    }

    public Header apply(String name, String value) {
        return new Header(name, value);
    }

    public Header accept(String mediaRanges) {
        return this.apply(HeaderNames$.MODULE$.Accept(), mediaRanges);
    }

    public Header acceptCharset(String charsetRanges) {
        return this.apply(HeaderNames$.MODULE$.AcceptCharset(), charsetRanges);
    }

    public Header acceptEncoding(String encodingRanges) {
        return this.apply(HeaderNames$.MODULE$.AcceptEncoding(), encodingRanges);
    }

    public Header accessControlAllowCredentials(boolean allow) {
        return this.apply(HeaderNames$.MODULE$.AccessControlAllowCredentials(), ((Object)BoxesRunTime.boxToBoolean((boolean)allow)).toString());
    }

    public Header accessControlAllowHeaders(Seq<String> headerNames) {
        return this.apply(HeaderNames$.MODULE$.AccessControlAllowHeaders(), headerNames.mkString(", "));
    }

    public Header accessControlAllowMethods(Seq<Method> methods) {
        return this.apply(HeaderNames$.MODULE$.AccessControlAllowMethods(), ((TraversableOnce)methods.map((Function1 & Serializable & scala.Serializable)x$1 -> ((Method)x$1).method(), Seq$.MODULE$.canBuildFrom())).mkString(", "));
    }

    public Header accessControlAllowOrigin(String originRange) {
        return this.apply(HeaderNames$.MODULE$.AccessControlAllowOrigin(), originRange);
    }

    public Header accessControlExposeHeaders(Seq<String> headerNames) {
        return this.apply(HeaderNames$.MODULE$.AccessControlExposeHeaders(), headerNames.mkString(", "));
    }

    public Header accessControlMaxAge(long deltaSeconds) {
        return this.apply(HeaderNames$.MODULE$.AccessControlMaxAge(), ((Object)BoxesRunTime.boxToLong((long)deltaSeconds)).toString());
    }

    public Header accessControlRequestHeaders(Seq<String> headerNames) {
        return this.apply(HeaderNames$.MODULE$.AccessControlRequestHeaders(), headerNames.mkString(", "));
    }

    public Header accessControlRequestMethod(String method) {
        return this.apply(HeaderNames$.MODULE$.AccessControlRequestMethod(), Method$.MODULE$.toString$extension(method));
    }

    public Header authorization(String authType, String credentials) {
        return this.apply(HeaderNames$.MODULE$.Authorization(), new StringBuilder(1).append(authType).append(" ").append(credentials).toString());
    }

    public Header contentLength(long length) {
        return this.apply(HeaderNames$.MODULE$.ContentLength(), ((Object)BoxesRunTime.boxToLong((long)length)).toString());
    }

    public Header contentEncoding(String encoding) {
        return this.apply(HeaderNames$.MODULE$.ContentEncoding(), encoding);
    }

    public Header contentType(MediaType mediaType) {
        return this.apply(HeaderNames$.MODULE$.ContentType(), mediaType.toString());
    }

    public Header cookie(Cookie firstCookie, Seq<Cookie> otherCookies) {
        Cookie cookie = firstCookie;
        return this.apply(HeaderNames$.MODULE$.Cookie(), ((TraversableOnce)((TraversableLike)otherCookies.$plus$colon((Object)cookie, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toString(), Seq$.MODULE$.canBuildFrom())).mkString("; "));
    }

    public Header etag(String tag) {
        return this.apply(HeaderNames$.MODULE$.Etag(), tag);
    }

    public Header location(String uri) {
        return this.apply(HeaderNames$.MODULE$.Location(), uri);
    }

    public Header location(Uri uri) {
        return this.apply(HeaderNames$.MODULE$.Location(), uri.toString());
    }

    public Header proxyAuthorization(String authType, String credentials) {
        return this.apply(HeaderNames$.MODULE$.ProxyAuthorization(), new StringBuilder(1).append(authType).append(" ").append(credentials).toString());
    }

    public Header setCookie(CookieWithMeta cookie) {
        return this.apply(HeaderNames$.MODULE$.SetCookie(), cookie.toString());
    }

    public Header userAgent(String userAgent) {
        return this.apply(HeaderNames$.MODULE$.UserAgent(), userAgent);
    }

    public Header xForwardedFor(String firstAddress, Seq<String> otherAddresses) {
        String string = firstAddress;
        return this.apply(HeaderNames$.MODULE$.XForwardedFor(), ((TraversableOnce)otherAddresses.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())).mkString(", "));
    }

    private Header$() {
        MODULE$ = this;
    }
}

