/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.launcher;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.spark.launcher.AbstractCommandBuilder;
import org.apache.spark.launcher.CommandBuilderUtils;
import tech.ytsaurus.spyt.patch.annotations.OriginClass;
import tech.ytsaurus.spyt.patch.annotations.Subclass;

@Subclass
@OriginClass(value="org.apache.spark.launcher.AbstractCommandBuilder")
abstract class AbstractCommandBuilderForSpyt
extends AbstractCommandBuilder {
    private static int portDelta = 2;

    AbstractCommandBuilderForSpyt() {
    }

    List<String> buildClassPath(String string) throws IOException {
        int n;
        if (this.isSpytTesting()) {
            return List.of(System.getProperty("java.class.path").split(File.pathSeparator));
        }
        List list = super.buildClassPath(string);
        String string2 = CommandBuilderUtils.findJarsDir((String)this.getSparkHome(), (String)this.getScalaVersion(), (boolean)false);
        for (n = 0; n < list.size() && !((String)list.get(n)).contains(string2); ++n) {
        }
        list.add(n, this.getenv("SPYT_CLASSPATH"));
        String string3 = System.getenv("SPARK_CONNECT_CLASSPATH");
        if (string3 != null) {
            list.add(string3);
        }
        return list;
    }

    List<String> buildJavaCommand(String string2) throws IOException {
        List list = super.buildJavaCommand(string2);
        if (this.isSpytTesting()) {
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            List<String> list2 = runtimeMXBean.getInputArguments();
            List list3 = list2.stream().flatMap(string -> {
                if (string.startsWith("-javaagent:")) {
                    return Stream.of(string);
                }
                if (string.startsWith("-agentlib:jdwp")) {
                    return Stream.of(this.takeFreeJdwpPort((String)string));
                }
                return Stream.empty();
            }).collect(Collectors.toList());
            list.addAll(1, list3);
        }
        return list;
    }

    private boolean isSpytTesting() {
        return System.getenv("SPYT_TESTING") != null;
    }

    private String takeFreeJdwpPort(String string) {
        int n = string.lastIndexOf(":") + 1;
        int n2 = Integer.parseInt(string.substring(n)) + portDelta;
        portDelta += 2;
        return string.substring(0, n) + n2;
    }
}

