/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.launcher;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.spark.launcher.SparkClassCommandBuilder;
import tech.ytsaurus.spyt.patch.annotations.OriginClass;
import tech.ytsaurus.spyt.patch.annotations.Subclass;

@Subclass
@OriginClass(value="org.apache.spark.launcher.SparkClassCommandBuilder")
public class SparkClassCommandBuilderForSpyt
extends SparkClassCommandBuilder {
    private static final Map<String, String> DAEMON_SUBSTITUTES = Map.of("org.apache.spark.deploy.master.YtMaster", "org.apache.spark.deploy.master.Master", "org.apache.spark.deploy.worker.YtWorker", "org.apache.spark.deploy.worker.Worker", "org.apache.spark.deploy.history.YtHistoryServer", "org.apache.spark.deploy.history.HistoryServer");
    private static final Map<String, String> DAEMON_SUBSTITUTES_BACK = DAEMON_SUBSTITUTES.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));

    SparkClassCommandBuilderForSpyt(String string, List<String> list) {
        super(DAEMON_SUBSTITUTES.getOrDefault(string, string), list);
    }

    public List<String> buildCommand(Map<String, String> map) throws IOException, IllegalArgumentException {
        List list = super.buildCommand(map);
        for (int i = 0; i < list.size(); ++i) {
            if (!DAEMON_SUBSTITUTES_BACK.containsKey(list.get(i))) continue;
            list.set(i, DAEMON_SUBSTITUTES_BACK.get(list.get(i)));
        }
        return list;
    }

    List<String> buildJavaCommand(String string) throws IOException {
        List list = super.buildJavaCommand(string);
        list.add("-XX:+IgnoreUnrecognizedVMOptions");
        list.add("--add-opens=java.base/java.lang=ALL-UNNAMED");
        return list;
    }
}

