/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.spyt.patch;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Predicate;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ytsaurus.spyt.patch.SparkPatchClassTransformer;
import tech.ytsaurus.spyt.patch.SparkPatchException;

public class SparkPatchAgent {
    private static final Logger log = LoggerFactory.getLogger(SparkPatchAgent.class);
    private static Predicate<String> classFileFilter = string -> string.endsWith(".class") && !string.startsWith("tech/ytsaurus/");

    public static void premain(String string2, Instrumentation instrumentation) {
        log.info("Starting SparkPatchAgent for hooking on jvm classloader");
        String string3 = System.getProperty("java.class.path");
        String[] stringArray2 = string3.split(File.pathSeparator);
        Stream<String> stream = Arrays.stream(stringArray2).filter(string -> string.contains("spark-adapter-impl-") || string.contains("spark-adapter/impl")).filter(string -> string.endsWith(".jar") || string.endsWith("/classes"));
        String string4 = ManagementFactory.getRuntimeMXBean().getInputArguments().stream().filter(string -> string.startsWith("-javaagent") && string.contains("spark-yt-spark-patch")).map(string -> string.substring(string.indexOf(58) + 1)).findFirst().orElseThrow();
        Stream<String> stream2 = Stream.concat(Stream.of(string4), stream);
        Stream stream3 = stream2.flatMap(string -> {
            if (string.endsWith(".jar")) {
                return SparkPatchAgent.scanJarFile(string);
            }
            return SparkPatchAgent.scanClassesDirectory(string);
        });
        Map<String, String> map = stream3.flatMap(string -> SparkPatchClassTransformer.toOriginClassName(string).stream()).collect(Collectors.toMap(stringArray -> stringArray[0], stringArray -> stringArray[1]));
        instrumentation.addTransformer(new SparkPatchClassTransformer(map));
    }

    private static Stream<String> scanJarFile(String string) {
        Stream<String> stream;
        JarFile jarFile = new JarFile(string);
        try {
            stream = jarFile.versionedStream().map(ZipEntry::getName).filter(classFileFilter).collect(Collectors.toList()).stream();
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                throw new SparkPatchException(iOException);
            }
        }
        jarFile.close();
        return stream;
    }

    private static Stream<String> scanClassesDirectory(String string) {
        Stream<String> stream;
        block8: {
            Path path = Path.of(string, new String[0]);
            Stream<Path> stream2 = Files.walk(path, new FileVisitOption[0]);
            try {
                stream = stream2.map(path2 -> path.relativize((Path)path2).toString()).filter(classFileFilter).collect(Collectors.toList()).stream();
                if (stream2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream2 != null) {
                        try {
                            stream2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new SparkPatchException(iOException);
                }
            }
            stream2.close();
        }
        return stream;
    }

    private static String resourceToString(String string) throws IOException {
        try (InputStream inputStream = SparkPatchAgent.class.getResourceAsStream(string);){
            String string2 = inputStream == null ? null : new String(inputStream.readAllBytes());
            return string2;
        }
    }
}

