/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.spyt.patch;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.bytecode.ClassFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.math.Ordering;
import tech.ytsaurus.spyt.SparkVersionUtils;
import tech.ytsaurus.spyt.patch.MethodProcesor;
import tech.ytsaurus.spyt.patch.SparkPatchAgent;
import tech.ytsaurus.spyt.patch.SparkPatchException;
import tech.ytsaurus.spyt.patch.annotations.AddInterfaces;
import tech.ytsaurus.spyt.patch.annotations.Applicability;
import tech.ytsaurus.spyt.patch.annotations.Decorate;
import tech.ytsaurus.spyt.patch.annotations.DecoratedMethod;
import tech.ytsaurus.spyt.patch.annotations.OriginClass;
import tech.ytsaurus.spyt.patch.annotations.PatchSource;
import tech.ytsaurus.spyt.patch.annotations.Subclass;

class SparkPatchClassTransformer
implements ClassFileTransformer {
    private static final Logger log = LoggerFactory.getLogger(SparkPatchAgent.class);
    private final Map<String, String> classMappings;
    private final Map<String, String> patchedClasses;

    static Optional<String[]> toOriginClassName(String string) {
        try {
            String string2 = string.substring(0, string.length() - 6);
            Optional<ClassFile> optional = SparkPatchClassTransformer.loadClassFile(string);
            if (optional.isEmpty()) {
                return Optional.empty();
            }
            ClassFile classFile = optional.get();
            CtClass ctClass = ClassPool.getDefault().makeClass(classFile);
            String string3 = SparkPatchClassTransformer.getOriginClass(ctClass);
            boolean bl = !ctClass.hasAnnotation(Applicability.class) || SparkPatchClassTransformer.checkApplicability((Applicability)ctClass.getAnnotation(Applicability.class));
            PatchSource patchSource = (PatchSource)ctClass.getAnnotation(PatchSource.class);
            if (patchSource != null) {
                string2 = patchSource.value().replace('.', File.separatorChar);
            }
            if (string3 != null && bl) {
                return Optional.of(new String[]{string2, string3.replace('.', File.separatorChar)});
            }
            return Optional.empty();
        }
        catch (IOException | ClassNotFoundException exception) {
            throw new SparkPatchException(exception);
        }
    }

    static String getOriginClass(CtClass ctClass) throws ClassNotFoundException {
        OriginClass originClass = (OriginClass)ctClass.getAnnotation(OriginClass.class);
        if (originClass != null) {
            String string = originClass.value();
            if (string.endsWith("$") && !ctClass.getName().endsWith("$")) {
                return null;
            }
            return string;
        }
        return null;
    }

    static ClassFile loadClassFile(byte[] byArray) throws IOException {
        return new ClassFile(new DataInputStream(new ByteArrayInputStream(byArray)));
    }

    static Optional<ClassFile> loadClassFile(String string) throws IOException {
        try (InputStream inputStream = SparkPatchClassTransformer.class.getClassLoader().getResourceAsStream(string);){
            Optional<ClassFile> optional = inputStream == null ? Optional.empty() : Optional.of(SparkPatchClassTransformer.loadClassFile(inputStream.readAllBytes()));
            return optional;
        }
    }

    static byte[] serializeClass(ClassFile classFile) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        classFile.write(new DataOutputStream(byteArrayOutputStream));
        byteArrayOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    SparkPatchClassTransformer(Map<String, String> map) {
        this.classMappings = map;
        this.patchedClasses = map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        log.debug("Creating classfile transformer for the following classes: {}", this.patchedClasses);
    }

    @Override
    public byte[] transform(ClassLoader classLoader, String string, Class<?> clazz, ProtectionDomain protectionDomain, byte[] byArray) {
        if (!this.patchedClasses.containsKey(string)) {
            return null;
        }
        try {
            ClassFile classFile = SparkPatchClassTransformer.loadClassFile(this.toPatchClassName(string)).orElseThrow();
            classFile = this.processAnnotations(classFile, classLoader, byArray);
            classFile.renameClass(this.classMappings);
            byte[] byArray2 = SparkPatchClassTransformer.serializeClass(classFile);
            log.info("Patch size for class {} is {} and after patching the size is {}", new Object[]{string, byArray.length, byArray2.length});
            return byArray2;
        }
        catch (Exception exception) {
            log.error(String.format("Can't patch class %s because an exception has occured", string), (Throwable)exception);
            throw new SparkPatchException(exception);
        }
    }

    private String toPatchClassName(String string) {
        return this.patchedClasses.get(string) + ".class";
    }

    private ClassFile processAnnotations(ClassFile classFile, ClassLoader classLoader, byte[] byArray) throws Exception {
        CtClass ctClass = ClassPool.getDefault().makeClass(classFile);
        String string = SparkPatchClassTransformer.getOriginClass(ctClass);
        if (string == null) {
            return classFile;
        }
        ClassFile classFile2 = classFile;
        for (Object object : ctClass.getAnnotations()) {
            CtClass ctClass2;
            String string2;
            if (object instanceof Subclass) {
                string2 = string + "Base";
                log.info("Changing superclass of {} to {}", (Object)string, (Object)string2);
                classFile.setSuperclass(string2);
                classFile.renameClass(string, string2);
                ctClass2 = SparkPatchClassTransformer.loadClassFile(byArray);
                ctClass2.renameClass(string, string2);
                ClassPool.getDefault().makeClass((ClassFile)ctClass2).toClass(classLoader, null);
            }
            if (object instanceof AddInterfaces) {
                string2 = SparkPatchClassTransformer.loadClassFile(byArray);
                for (CtClass ctClass3 : ((AddInterfaces)object).value()) {
                    string2.addInterface(ctClass3.getName());
                }
                ctClass2 = ClassPool.getDefault().makeClass((ClassFile)string2);
                classFile2 = ctClass2.getClassFile();
            }
            if (!(object instanceof Decorate)) continue;
            string2 = SparkPatchClassTransformer.loadClassFile(byArray);
            ctClass2 = ClassPool.getDefault().makeClass((ClassFile)string2);
            for (CtMethod ctMethod : ctClass.getDeclaredMethods()) {
                if (!SparkPatchClassTransformer.checkDecoratedMethod(ctMethod)) continue;
                DecoratedMethod decoratedMethod = (DecoratedMethod)ctMethod.getAnnotation(DecoratedMethod.class);
                String string3 = ctMethod.getName();
                CtMethod ctMethod2 = ctClass2.getMethod(string3, ctMethod.getSignature());
                log.debug("Patching decorated method {} with signature {}", (Object)string3, (Object)ctMethod2.getSignature());
                String string4 = "__" + string3;
                ctMethod2.setName(string4);
                for (Class<? extends MethodProcesor> clazz : decoratedMethod.baseMethodProcessors()) {
                    MethodProcesor methodProcesor = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    methodProcesor.process(ctMethod2);
                }
                CtMethod ctMethod3 = CtNewMethod.copy((CtMethod)ctMethod, (CtClass)ctClass2, null);
                ctClass2.addMethod(ctMethod3);
            }
            classFile2 = ctClass2.getClassFile();
        }
        return classFile2;
    }

    private static boolean checkDecoratedMethod(CtMethod ctMethod) throws Exception {
        return ctMethod.hasAnnotation(DecoratedMethod.class) && (!ctMethod.hasAnnotation(Applicability.class) || SparkPatchClassTransformer.checkApplicability((Applicability)ctMethod.getAnnotation(Applicability.class)));
    }

    private static boolean checkApplicability(Applicability applicability) {
        Ordering ordering = SparkVersionUtils.ordering();
        String string = SparkVersionUtils.currentVersion();
        return !(!applicability.from().isEmpty() && !ordering.gteq((Object)string, (Object)applicability.from()) || !applicability.to().isEmpty() && !ordering.lteq((Object)string, (Object)applicability.to()));
    }
}

