/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.rest;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.deploy.master.DriverState$;
import org.apache.spark.deploy.rest.CreateSubmissionResponse;
import org.apache.spark.deploy.rest.RestSubmissionClient;
import org.apache.spark.deploy.rest.RestSubmissionClient$;
import org.apache.spark.deploy.rest.RestSubmissionClientApp;
import org.apache.spark.deploy.rest.RestSubmitSupport$;
import org.apache.spark.deploy.rest.SubmissionStatusResponse;
import org.apache.spark.deploy.rest.SubmitRestProtocolResponse;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Random;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import tech.ytsaurus.spyt.patch.annotations.OriginClass;
import tech.ytsaurus.spyt.patch.annotations.Subclass;

@ScalaSignature(bytes="\u0006\u0001\u0005%d\u0001B\u0005\u000b\u0001UAQ\u0001\t\u0001\u0005\u0002\u0005BQa\t\u0001\u0005B\u0011BQA\u0013\u0001\u0005\n-Cq\u0001\u001e\u0001\u0012\u0002\u0013%Q\u000fC\u0003\u007f\u0001\u0011\u0005q\u0010C\u0004\u0002\u0010\u0001!\t!!\u0005\t\u000f\u0005]\u0001\u0001\"\u0003\u0002\u001a!9\u00111\u0007\u0001\u0005B\u0005U\"a\u0007*fgR\u001cVOY7jgNLwN\\\"mS\u0016tG/\u00119q'BLHO\u0003\u0002\f\u0019\u0005!!/Z:u\u0015\tia\"\u0001\u0004eKBdw.\u001f\u0006\u0003\u001fA\tQa\u001d9be.T!!\u0005\n\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0012aA8sO\u000e\u00011c\u0001\u0001\u00175A\u0011q\u0003G\u0007\u0002\u0015%\u0011\u0011D\u0003\u0002\u0018%\u0016\u001cHoU;c[&\u001c8/[8o\u00072LWM\u001c;BaB\u0004\"a\u0007\u0010\u000e\u0003qQ!!\b\b\u0002\u0011%tG/\u001a:oC2L!a\b\u000f\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012A\t\t\u0003/\u0001\t1A];o)\u0019)\u0003fN\u001d@\u000bB\u0011qCJ\u0005\u0003O)\u0011!dU;c[&$(+Z:u!J|Go\\2pYJ+7\u000f]8og\u0016DQ!\u000b\u0002A\u0002)\n1\"\u00199q%\u0016\u001cx.\u001e:dKB\u00111\u0006\u000e\b\u0003YI\u0002\"!\f\u0019\u000e\u00039R!a\f\u000b\u0002\rq\u0012xn\u001c;?\u0015\u0005\t\u0014!B:dC2\f\u0017BA\u001a1\u0003\u0019\u0001&/\u001a3fM&\u0011QG\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005M\u0002\u0004\"\u0002\u001d\u0003\u0001\u0004Q\u0013!C7bS:\u001cE.Y:t\u0011\u0015Q$\u00011\u0001<\u0003\u001d\t\u0007\u000f]!sON\u00042\u0001P\u001f+\u001b\u0005\u0001\u0014B\u0001 1\u0005\u0015\t%O]1z\u0011\u0015\u0001%\u00011\u0001B\u0003\u0011\u0019wN\u001c4\u0011\u0005\t\u001bU\"\u0001\b\n\u0005\u0011s!!C*qCJ\\7i\u001c8g\u0011\u001d1%\u0001%AA\u0002\u001d\u000b1!\u001a8w!\u0011Y\u0003J\u000b\u0016\n\u0005%3$aA'ba\u0006\u0019r-\u001a;Tk\nl\u0017n]:j_:\u001cF/\u0019;vgR1AjT)W7\u0016\u0004\"aF'\n\u00059S!\u0001G*vE6L7o]5p]N#\u0018\r^;t%\u0016\u001c\bo\u001c8tK\")\u0001k\u0001a\u0001U\u0005a1/\u001e2nSN\u001c\u0018n\u001c8JI\")!k\u0001a\u0001'\u000611\r\\5f]R\u0004\"a\u0006+\n\u0005US!\u0001\u0006*fgR\u001cVOY7jgNLwN\\\"mS\u0016tG\u000fC\u0003X\u0007\u0001\u0007\u0001,A\u0003sKR\u0014\u0018\u0010\u0005\u0002=3&\u0011!\f\r\u0002\u0004\u0013:$\b\"\u0002/\u0004\u0001\u0004i\u0016!\u0004:fiJL\u0018J\u001c;feZ\fG\u000e\u0005\u0002_G6\tqL\u0003\u0002aC\u0006AA-\u001e:bi&|gN\u0003\u0002ca\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005\u0011|&\u0001\u0003#ve\u0006$\u0018n\u001c8\t\u000f\u0019\u001c\u0001\u0013!a\u0001O\u0006\u0019!O\u001c3\u0011\u0005!\\W\"A5\u000b\u0005)\u0004\u0014\u0001B;uS2L!\u0001\\5\u0003\rI\u000bg\u000eZ8nQ\t\u0019a\u000e\u0005\u0002pe6\t\u0001O\u0003\u0002ra\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005M\u0004(a\u0002;bS2\u0014XmY\u0001\u001eO\u0016$8+\u001e2nSN\u001c\u0018n\u001c8Ti\u0006$Xo\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\taO\u000b\u0002ho.\n\u0001\u0010\u0005\u0002zy6\t!P\u0003\u0002|a\u0006IQO\\2iK\u000e\\W\rZ\u0005\u0003{j\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003M\tw/Y5u\u0003B\u0004H+\u001a:nS:\fG/[8o)!\t\t!a\u0002\u0002\n\u0005-\u0001c\u0001\u001f\u0002\u0004%\u0019\u0011Q\u0001\u0019\u0003\tUs\u0017\u000e\u001e\u0005\u0006!\u0016\u0001\rA\u000b\u0005\u0006\u0001\u0016\u0001\r!\u0011\u0005\u0007\u0003\u001b)\u0001\u0019A/\u0002'\rDWmY6Ti\u0006$Xo]%oi\u0016\u0014h/\u00197\u0002!MDW\u000f\u001e3po:LFo\u00117jK:$H\u0003BA\u0001\u0003'Aa!!\u0006\u0007\u0001\u0004\t\u0015!C:qCJ\\7i\u001c8g\u0003-9(/\u001b;f)>4\u0015\u000e\\3\u0015\r\u0005\u0005\u00111DA\u0018\u0011\u001d\tib\u0002a\u0001\u0003?\tAAZ5mKB!\u0011\u0011EA\u0016\u001b\t\t\u0019C\u0003\u0003\u0002&\u0005\u001d\u0012AA5p\u0015\t\tI#\u0001\u0003kCZ\f\u0017\u0002BA\u0017\u0003G\u0011AAR5mK\"1\u0011\u0011G\u0004A\u0002)\nq!\\3tg\u0006<W-A\u0003ti\u0006\u0014H\u000f\u0006\u0004\u0002\u0002\u0005]\u00121\b\u0005\u0007\u0003sA\u0001\u0019A\u001e\u0002\t\u0005\u0014xm\u001d\u0005\u0006\u0001\"\u0001\r!\u0011\u0015\b\u0001\u0005}\u00121LA/!\u0011\t\t%a\u0016\u000e\u0005\u0005\r#\u0002BA#\u0003\u000f\n1\"\u00198o_R\fG/[8og*!\u0011\u0011JA&\u0003\u0015\u0001\u0018\r^2i\u0015\u0011\ti%a\u0014\u0002\tM\u0004\u0018\u0010\u001e\u0006\u0005\u0003#\n\u0019&\u0001\u0005ziN\fWO];t\u0015\t\t)&\u0001\u0003uK\u000eD\u0017\u0002BA-\u0003\u0007\u00121b\u0014:jO&t7\t\\1tg\u0006)a/\u00197vK\u0006\u0012\u0011qL\u00015_J<g&\u00199bG\",gf\u001d9be.tC-\u001a9m_ft#/Z:u]I+7\u000f^*vE6L7o]5p]\u000ec\u0017.\u001a8u\u0003B\u0004\bf\u0001\u0001\u0002dA!\u0011\u0011IA3\u0013\u0011\t9'a\u0011\u0003\u0011M+(m\u00197bgN\u0004")
@Subclass
@OriginClass(value="org.apache.spark.deploy.rest.RestSubmissionClientApp")
public class RestSubmissionClientAppSpyt
extends RestSubmissionClientApp
implements Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SubmitRestProtocolResponse run(String appResource, String mainClass, String[] appArgs, SparkConf conf, Map<String, String> env) {
        String master = (String)conf.getOption("spark.rest.master").getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException("'spark.rest.master' must be set.");
        });
        return RestSubmitSupport$.MODULE$.instance().createSubmission(appResource, mainClass, appArgs, conf, env, master);
    }

    private SubmissionStatusResponse getSubmissionStatus(String submissionId, RestSubmissionClient client, int retry, Duration retryInterval, Random rnd) {
        SubmissionStatusResponse value;
        Try try_;
        block2: {
            Failure failure;
            boolean bl;
            while (true) {
                Try response = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (SubmissionStatusResponse)client.requestSubmissionStatus(submissionId, client.requestSubmissionStatus$default$2()));
                bl = false;
                failure = null;
                try_ = response;
                if (try_ instanceof Success) break block2;
                if (!(try_ instanceof Failure)) break;
                bl = true;
                failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (retry <= 0) break;
                this.log().error(new StringBuilder(43).append("Exception while getting submission status: ").append(exception.getMessage()).toString());
                int sleepInterval = retryInterval.$greater((Object)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second()) ? 1000 + rnd.nextInt((int)retryInterval.toMillis() - 1000) : rnd.nextInt((int)retryInterval.toMillis());
                Thread.sleep(sleepInterval);
                --retry;
            }
            if (bl) {
                Throwable exception = failure.exception();
                throw exception;
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        SubmissionStatusResponse submissionStatusResponse = value = (SubmissionStatusResponse)success.value();
        return submissionStatusResponse;
    }

    private Random getSubmissionStatus$default$5() {
        return new Random();
    }

    public void awaitAppTermination(String submissionId, SparkConf conf, Duration checkStatusInterval) {
        String string;
        String master = (String)conf.getOption("spark.rest.master").getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException("'spark.rest.master' must be set.");
        });
        RestSubmissionClient client = new RestSubmissionClient(master);
        Set runningStates = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{DriverState$.MODULE$.RUNNING().toString(), DriverState$.MODULE$.SUBMITTED().toString()}));
        SubmissionStatusResponse finalStatus = (SubmissionStatusResponse)package$.MODULE$.Stream().continually((Function0 & Serializable & scala.Serializable)() -> {
            Thread.sleep(checkStatusInterval.toMillis());
            SubmissionStatusResponse response = this.getSubmissionStatus(submissionId, client, 3, checkStatusInterval, this.getSubmissionStatus$default$5());
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Driver report for ").append(submissionId).append(" (state: ").append(response.driverState()).append(")").toString());
            return response;
        }).find((Function1 & Serializable & scala.Serializable)response -> BoxesRunTime.boxToBoolean((boolean)RestSubmissionClientAppSpyt.$anonfun$awaitAppTermination$4(runningStates, response))).get();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Driver ").append(submissionId).append(" finished with status ").append(finalStatus.driverState()).toString());
        String string2 = string = finalStatus.driverState();
        String string3 = DriverState$.MODULE$.FINISHED().toString();
        if (string2 != null ? !string2.equals(string3) : string3 != null) {
            String string4 = string;
            String string5 = DriverState$.MODULE$.FAILED().toString();
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                throw new SparkException(new StringBuilder(14).append("Driver ").append(submissionId).append(" failed").toString());
            }
            throw new SparkException(new StringBuilder(36).append("Driver ").append(submissionId).append(" failed with unexpected error").toString());
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void shutdownYtClient(SparkConf sparkConf) {
        Configuration hadoopConf = SparkHadoopUtil$.MODULE$.newConfiguration(sparkConf);
        FileSystem fs = FileSystem.get((URI)new URI("yt:///"), (Configuration)hadoopConf);
        fs.close();
    }

    private void writeToFile(File file, String message) {
        File tmpFile = new File(file.getParentFile(), new StringBuilder(4).append(file.getName()).append("_tmp").toString());
        FileUtils.writeStringToFile((File)tmpFile, (String)message);
        FileUtils.moveFile((File)tmpFile, (File)file);
    }

    public void start(String[] args, SparkConf conf) {
        Option submissionIdFile = conf.getOption("spark.rest.client.submissionIdFile").map((Function1 & Serializable & scala.Serializable)x$1 -> new File((String)x$1));
        Option submissionErrorFile = conf.getOption("spark.rest.client.submissionErrorFile").map((Function1 & Serializable & scala.Serializable)x$2 -> new File((String)x$2));
        try {
            String string;
            if (args.length < 2) {
                throw scala.sys.package$.MODULE$.error("Usage: RestSubmissionClient [app resource] [main class] [app args*]");
            }
            String appResource = args[0];
            String mainClass = args[1];
            String[] appArgs = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).slice(2, args.length);
            Map confEnv = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])conf.getAll())).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)RestSubmissionClientAppSpyt.$anonfun$start$3(x0$1))))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key.toUpperCase().replace(".", "_")), (Object)value);
                return tuple22;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
            Map env = RestSubmissionClient$.MODULE$.filterSystemEnvironment(scala.sys.package$.MODULE$.env()).$plus$plus((GenTraversableOnce)confEnv);
            try {
                SubmitRestProtocolResponse response;
                SubmitRestProtocolResponse submitRestProtocolResponse = response = this.run(appResource, mainClass, appArgs, conf, (Map<String, String>)env);
                if (!(submitRestProtocolResponse instanceof CreateSubmissionResponse)) {
                    throw new IllegalStateException("Job is not submitted");
                }
                CreateSubmissionResponse createSubmissionResponse = (CreateSubmissionResponse)submitRestProtocolResponse;
                String string2 = createSubmissionResponse.submissionId();
                string = string2;
            }
            finally {
                this.shutdownYtClient(conf);
            }
            String submissionId = string;
            submissionIdFile.foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                this.writeToFile(x$3, submissionId);
                return BoxedUnit.UNIT;
            });
            if (conf.getOption("spark.rest.client.awaitTermination.enabled").forall((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)RestSubmissionClientAppSpyt.$anonfun$start$6(x$4)))) {
                FiniteDuration checkStatusInterval = (FiniteDuration)conf.getOption("spark.rest.client.statusInterval").map((Function1 & Serializable & scala.Serializable)x$5 -> new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(new StringOps(Predef$.MODULE$.augmentString(x$5)).toInt())).seconds()).getOrElse((Function0 & Serializable & scala.Serializable)() -> new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).seconds());
                this.awaitAppTermination(submissionId, conf, (Duration)checkStatusInterval);
            }
        }
        catch (Throwable e) {
            submissionErrorFile.foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                this.writeToFile(x$6, e.getMessage());
                return BoxedUnit.UNIT;
            });
            throw e;
        }
    }

    public static final /* synthetic */ boolean $anonfun$awaitAppTermination$4(Set runningStates$1, SubmissionStatusResponse response) {
        return !runningStates$1.contains((Object)response.driverState());
    }

    public static final /* synthetic */ boolean $anonfun$start$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        boolean bl = key.startsWith("spark.yt") || key.startsWith("spark.hadoop.yt");
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$start$6(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).toBoolean();
    }

    public RestSubmissionClientAppSpyt() {
        Logging.$init$((Logging)this);
    }
}

