/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.master;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.spark.deploy.master.PersistenceEngine;
import org.apache.spark.serializer.DeserializationStream;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import tech.ytsaurus.client.CompoundClient;
import tech.ytsaurus.spyt.wrapper.YtWrapper$;
import tech.ytsaurus.spyt.wrapper.file.YtFileInputStream;

@ScalaSignature(bytes="\u0006\u0001\u00055b\u0001\u0002\u0007\u000e\u0001aA\u0001\"\b\u0001\u0003\u0002\u0003\u0006IA\b\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!A\u0011\u0007\u0001B\u0001B\u0003-!\u0007C\u0003=\u0001\u0011\u0005Q\bC\u0004D\u0001\t\u0007I\u0011\u0002#\t\r-\u0003\u0001\u0015!\u0003F\u0011\u0015a\u0005\u0001\"\u0011N\u0011\u0015q\u0006\u0001\"\u0011`\u0011\u0015\t\u0007\u0001\"\u0011c\u0011\u001d\t9\u0001\u0001C\u0005\u0003\u0013Aq!!\u0007\u0001\t\u0013\tYBA\nZiB+'o]5ti\u0016t7-Z#oO&tWM\u0003\u0002\u000f\u001f\u00051Q.Y:uKJT!\u0001E\t\u0002\r\u0011,\u0007\u000f\\8z\u0015\t\u00112#A\u0003ta\u0006\u00148N\u0003\u0002\u0015+\u00051\u0011\r]1dQ\u0016T\u0011AF\u0001\u0004_J<7\u0001A\n\u0003\u0001e\u0001\"AG\u000e\u000e\u00035I!\u0001H\u0007\u0003#A+'o]5ti\u0016t7-Z#oO&tW-A\u0004cCN,G)\u001b:\u0011\u0005}AcB\u0001\u0011'!\t\tC%D\u0001#\u0015\t\u0019s#\u0001\u0004=e>|GO\u0010\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005J\u0001\u0007!J,G-\u001a4\n\u0005%R#AB*ue&twM\u0003\u0002(I\u0005Q1/\u001a:jC2L'0\u001a:\u0011\u00055zS\"\u0001\u0018\u000b\u0005-\n\u0012B\u0001\u0019/\u0005)\u0019VM]5bY&TXM]\u0001\u0003sR\u0004\"a\r\u001e\u000e\u0003QR!!\u000e\u001c\u0002\r\rd\u0017.\u001a8u\u0015\t9\u0004(\u0001\u0005ziN\fWO];t\u0015\u0005I\u0014\u0001\u0002;fG\"L!a\u000f\u001b\u0003\u001d\r{W\u000e]8v]\u0012\u001cE.[3oi\u00061A(\u001b8jiz\"2AP!C)\ty\u0004\t\u0005\u0002\u001b\u0001!)\u0011\u0007\u0002a\u0002e!)Q\u0004\u0002a\u0001=!)1\u0006\u0002a\u0001Y\u0005\u0019An\\4\u0016\u0003\u0015\u0003\"AR%\u000e\u0003\u001dS!\u0001S\u000b\u0002\u000bMdg\r\u000e6\n\u0005);%A\u0002'pO\u001e,'/\u0001\u0003m_\u001e\u0004\u0013a\u00029feNL7\u000f\u001e\u000b\u0004\u001dJ#\u0006CA(Q\u001b\u0005!\u0013BA)%\u0005\u0011)f.\u001b;\t\u000bM;\u0001\u0019\u0001\u0010\u0002\t9\fW.\u001a\u0005\u0006+\u001e\u0001\rAV\u0001\u0004_\nT\u0007CA,]\u001b\u0005A&BA-[\u0003\u0011a\u0017M\\4\u000b\u0003m\u000bAA[1wC&\u0011Q\f\u0017\u0002\u0007\u001f\nTWm\u0019;\u0002\u0013Ut\u0007/\u001a:tSN$HC\u0001(a\u0011\u0015\u0019\u0006\u00021\u0001\u001f\u0003\u0011\u0011X-\u00193\u0016\u0005\r\u0004Hc\u00013\u0002\u0004Q\u0011Q-\u001f\t\u0004M.tgBA4j\u001d\t\t\u0003.C\u0001&\u0013\tQG%A\u0004qC\u000e\\\u0017mZ3\n\u00051l'aA*fc*\u0011!\u000e\n\t\u0003_Bd\u0001\u0001B\u0003r\u0013\t\u0007!OA\u0001U#\t\u0019h\u000f\u0005\u0002Pi&\u0011Q\u000f\n\u0002\b\u001d>$\b.\u001b8h!\tyu/\u0003\u0002yI\t\u0019\u0011I\\=\t\u000biL\u00019A>\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007E\u0002}\u007f:l\u0011! \u0006\u0003}\u0012\nqA]3gY\u0016\u001cG/C\u0002\u0002\u0002u\u0014\u0001b\u00117bgN$\u0016m\u001a\u0005\u0007\u0003\u000bI\u0001\u0019\u0001\u0010\u0002\rA\u0014XMZ5y\u0003E\u0019XM]5bY&TX-\u00138u_\u001aKG.\u001a\u000b\u0006\u001d\u0006-\u0011q\u0002\u0005\u0007\u0003\u001bQ\u0001\u0019\u0001\u0010\u0002\tA\fG\u000f\u001b\u0005\b\u0003#Q\u0001\u0019AA\n\u0003\u00151\u0018\r\\;f!\ry\u0015QC\u0005\u0004\u0003/!#AB!osJ+g-A\neKN,'/[1mSj,gI]8n\r&dW-\u0006\u0003\u0002\u001e\u0005\rB\u0003BA\u0010\u0003W!B!!\t\u0002&A\u0019q.a\t\u0005\u000bE\\!\u0019\u0001:\t\u000f\u0005\u001d2\u0002q\u0001\u0002*\u0005\tQ\u000e\u0005\u0003}\u007f\u0006\u0005\u0002BBA\u0007\u0017\u0001\u0007a\u0004")
public class YtPersistenceEngine
extends PersistenceEngine {
    private final String baseDir;
    private final Serializer serializer;
    private final CompoundClient yt;
    private final Logger log;

    private Logger log() {
        return this.log;
    }

    public void persist(String name, Object obj) {
        this.log().info(new StringBuilder(15).append("Persist object ").append(name).toString());
        this.serializeIntoFile(new StringBuilder(1).append(this.baseDir).append("/").append(name).toString(), obj);
    }

    public void unpersist(String name) {
        this.log().info(new StringBuilder(17).append("Unpersist object ").append(name).toString());
        YtWrapper$.MODULE$.removeIfExists(new StringBuilder(1).append(this.baseDir).append("/").append(name).toString(), YtWrapper$.MODULE$.removeIfExists$default$2(), this.yt);
    }

    public <T> Seq<T> read(String prefix, ClassTag<T> evidence$1) {
        this.log().info(new StringBuilder(12).append("Read prefix ").append(prefix).toString());
        String[] paths = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])YtWrapper$.MODULE$.listDir(this.baseDir, YtWrapper$.MODULE$.listDir$default$2(), this.yt))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith(prefix)));
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])paths)).map((Function1 & Serializable & scala.Serializable)x$2 -> this.deserializeFromFile((String)x$2, evidence$1), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    private void serializeIntoFile(String path, Object value) {
        this.log().info(new StringBuilder(12).append("Create file ").append(path).toString());
        YtWrapper$.MODULE$.createFile(path, YtWrapper$.MODULE$.createFile$default$2(), YtWrapper$.MODULE$.createFile$default$3(), this.yt);
        this.log().info(new StringBuilder(14).append("Write to file ").append(path).toString());
        OutputStream fileOut = YtWrapper$.MODULE$.writeFile(path, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(5)).minutes(), (Option)None$.MODULE$, this.yt);
        ObjectRef out = ObjectRef.create(null);
        Utils$.MODULE$.tryWithSafeFinally((Function0 & Serializable & scala.Serializable)() -> {
            out$1.elem = $this.serializer.newInstance().serializeStream(fileOut);
            return ((SerializationStream)out$1.elem).writeObject(value, ClassTag$.MODULE$.AnyRef());
        }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                fileOut.close();
                if ((SerializationStream)out$1.elem == null) break block0;
                ((SerializationStream)out$1.elem).close();
            }
        });
    }

    private <T> T deserializeFromFile(String path, ClassTag<T> m) {
        Object object;
        this.log().info(new StringBuilder(17).append("Deserialize file ").append(path).toString());
        YtFileInputStream fileIn = YtWrapper$.MODULE$.readFile(path, YtWrapper$.MODULE$.readFile$default$2(), YtWrapper$.MODULE$.readFile$default$3(), this.yt);
        DeserializationStream in = null;
        try {
            in = this.serializer.newInstance().deserializeStream((InputStream)fileIn);
            object = in.readObject(m);
        }
        finally {
            fileIn.close();
            if (in != null) {
                in.close();
            }
        }
        return (T)object;
    }

    public YtPersistenceEngine(String baseDir, Serializer serializer, CompoundClient yt) {
        this.baseDir = baseDir;
        this.serializer = serializer;
        this.yt = yt;
        this.log = LoggerFactory.getLogger((Class)this.getClass());
        String x$1 = baseDir;
        boolean x$2 = true;
        Option x$3 = YtWrapper$.MODULE$.createDir$default$2();
        YtWrapper$.MODULE$.createDir(x$1, x$3, x$2, yt);
    }
}

