/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.spark.launcher;

import com.codahale.metrics.MetricRegistry;
import java.io.Closeable;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;
import tech.ytsaurus.client.CompoundClient;
import tech.ytsaurus.spark.launcher.AutoScaler;
import tech.ytsaurus.spark.launcher.AutoScaler$DoNothing$;
import tech.ytsaurus.spark.launcher.AutoScaler$Metrics$;
import tech.ytsaurus.spark.launcher.ClusterStateService;
import tech.ytsaurus.spark.launcher.ClusterStateService$;
import tech.ytsaurus.spyt.wrapper.discovery.DiscoveryService;

public final class AutoScaler$ {
    public static AutoScaler$ MODULE$;
    private final Logger tech$ytsaurus$spark$launcher$AutoScaler$$log;
    private final ThreadFactory threadFactory;
    private final ScheduledThreadPoolExecutor scheduler;

    static {
        new AutoScaler$();
    }

    public Logger tech$ytsaurus$spark$launcher$AutoScaler$$log() {
        return this.tech$ytsaurus$spark$launcher$AutoScaler$$log;
    }

    private ThreadFactory threadFactory() {
        return this.threadFactory;
    }

    private ScheduledThreadPoolExecutor scheduler() {
        return this.scheduler;
    }

    public Function2<Seq<AutoScaler.Action>, ClusterStateService.State, Tuple2<Seq<AutoScaler.Action>, AutoScaler.Action>> autoScaleFunctionSliding(AutoScaler.Conf conf, Function1<ClusterStateService.State, AutoScaler.Action> f) {
        return (arg_0, arg_1) -> AutoScaler$.$anonfun$autoScaleFunctionSliding$1(conf, f, arg_0, arg_1);
    }

    public Function1<ClusterStateService.State, AutoScaler.Action> autoScaleFunctionBasic(AutoScaler.Conf conf) {
        return (Function1 & Serializable & scala.Serializable)x0$1 -> {
            long optimalSlots;
            long slots;
            AutoScaler.SparkState sparkState;
            AutoScaler.OperationState operationState;
            ClusterStateService.State state = x0$1;
            if (state != null) {
                operationState = state.operationState();
                sparkState = state.sparkState();
                slots = state.userSlots();
                long expectedWorkers = sparkState.busyWorkers() + operationState.plannedJobs();
                MODULE$.tech$ytsaurus$spark$launcher$AutoScaler$$log().debug(new StringBuilder(49).append("Expected workers count: ").append(expectedWorkers).append(",").append(" freeWorkers=").append(sparkState.freeWorkers()).append(", freeJobs=").append(operationState.freeJobs()).toString());
            } else {
                throw new MatchError((Object)state);
            }
            AutoScaler$DoNothing$ autoScaler$DoNothing$ = sparkState.freeWorkers() > conf.maxFreeWorkers() && sparkState.waitingApps() == 0L ? ((optimalSlots = Math.max(sparkState.busyWorkers(), conf.maxFreeWorkers())) < slots ? new AutoScaler.SetUserSlot(slots - conf.slotDecrementStep()) : AutoScaler$DoNothing$.MODULE$) : (sparkState.freeWorkers() < conf.minFreeWorkers() && operationState.freeJobs() > 0L ? new AutoScaler.SetUserSlot(Math.min(operationState.maxJobs(), slots + conf.slotIncrementStep())) : AutoScaler$DoNothing$.MODULE$);
            return autoScaler$DoNothing$;
        };
    }

    public AutoScaler build(AutoScaler.Conf conf, DiscoveryService discoveryService, CompoundClient yt) {
        ClusterStateService stateService = ClusterStateService$.MODULE$.apply(discoveryService, yt);
        return this.autoScaler(stateService, Nil$.MODULE$, this.autoScaleFunctionSliding(conf, this.autoScaleFunctionBasic(conf)));
    }

    public Set<String> jobsToStop(ClusterStateService clusterStateService, long currentSlots, long newSlots) {
        return newSlots < currentSlots ? (Set)clusterStateService.idleJobs().toSet().take((int)(currentSlots - newSlots)) : (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
    }

    public <T> AutoScaler autoScaler(ClusterStateService clusterStateService, T zero, Function2<T, ClusterStateService.State, Tuple2<T, AutoScaler.Action>> f) {
        AtomicReference st = new AtomicReference(zero);
        return () -> {
            MODULE$.tech$ytsaurus$spark$launcher$AutoScaler$$log().debug("Autoscaling...");
            clusterStateService.query().foreach((Function1 & Serializable & scala.Serializable)clusterState -> {
                AutoScaler$.$anonfun$autoScaler$2(f, st, clusterStateService, clusterState);
                return BoxedUnit.UNIT;
            });
        };
    }

    public Closeable start(AutoScaler autoScaler, AutoScaler.Conf c, MetricRegistry metricRegistry) {
        this.tech$ytsaurus$spark$launcher$AutoScaler$$log().info(new StringBuilder(38).append("Starting autoscaler service: period = ").append(c.period()).toString());
        AutoScaler$Metrics$.MODULE$.metricRegistry().set(metricRegistry);
        ScheduledFuture<?> f = this.scheduler().scheduleAtFixedRate(() -> {
            try {
                MODULE$.tech$ytsaurus$spark$launcher$AutoScaler$$log().debug("Autoscaler called");
                autoScaler.apply();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    MODULE$.tech$ytsaurus$spark$launcher$AutoScaler$$log().error("Autoscaler failed", e);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                throw throwable;
            }
        }, c.period().toNanos(), c.period().toNanos(), TimeUnit.NANOSECONDS);
        return () -> f.cancel(false);
    }

    public static final /* synthetic */ Iterable $anonfun$autoScaleFunctionSliding$2(AutoScaler.Action x0$2) {
        Iterable iterable;
        AutoScaler.Action action = x0$2;
        if (action instanceof AutoScaler.SetUserSlot) {
            AutoScaler.SetUserSlot setUserSlot = (AutoScaler.SetUserSlot)action;
            long count = setUserSlot.count();
            iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)BoxesRunTime.boxToLong((long)count)));
        } else if (AutoScaler$DoNothing$.MODULE$.equals(action)) {
            iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
        } else {
            throw new MatchError((Object)action);
        }
        return iterable;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static final /* synthetic */ Tuple2 $anonfun$autoScaleFunctionSliding$1(AutoScaler.Conf conf$1, Function1 f$1, Seq x0$1, ClusterStateService.State x1$1) {
        block4: {
            block2: {
                block3: {
                    var6_4 = new Tuple2((Object)x0$1, (Object)x1$1);
                    if (var6_4 == null) break block2;
                    window = (Seq)var6_4._1();
                    newState = (ClusterStateService.State)var6_4._2();
                    AutoScaler$.MODULE$.tech$ytsaurus$spark$launcher$AutoScaler$$log().debug(new StringBuilder(29).append("windowSize=").append(conf$1.slidingWindowSize()).append(" window=").append(window).append(" newState=").append(newState).toString());
                    expectedAction = (AutoScaler.Action)f$1.apply((Object)newState);
                    slots = (Seq)window.flatMap((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$autoScaleFunctionSliding$2(tech.ytsaurus.spark.launcher.AutoScaler$Action ), (Ltech/ytsaurus/spark/launcher/AutoScaler$Action;)Lscala/collection/Iterable;)(), Seq$.MODULE$.canBuildFrom());
                    var12_9 = expectedAction;
                    if (!AutoScaler$DoNothing$.MODULE$.equals(var12_9)) break block3;
                    var5_10 /* !! */  = AutoScaler$DoNothing$.MODULE$;
                    break block4;
                }
                if (!(var12_9 instanceof AutoScaler.SetUserSlot)) ** GOTO lbl-1000
                var13_11 = (AutoScaler.SetUserSlot)var12_9;
                count = var13_11.count();
                if (slots.nonEmpty() && BoxesRunTime.unboxToLong((Object)slots.last()) > count) {
                    var5_10 /* !! */  = AutoScaler$DoNothing$.MODULE$;
                } else lbl-1000:
                // 2 sources

                {
                    var5_10 /* !! */  = var12_9;
                }
                break block4;
            }
            throw new MatchError((Object)var6_4);
        }
        action = var5_10 /* !! */ ;
        newWindow = conf$1.slidingWindowSize() < 1 ? (Seq)Nil$.MODULE$ : (window.size() < conf$1.slidingWindowSize() ? (Seq)window.$colon$plus((Object)action, Seq$.MODULE$.canBuildFrom()) : (Seq)((SeqLike)window.tail()).$colon$plus((Object)action, Seq$.MODULE$.canBuildFrom()));
        var4_15 = new Tuple2((Object)newWindow, (Object)action);
        return var4_15;
    }

    public static final /* synthetic */ void $anonfun$autoScaler$2(Function2 f$2, AtomicReference st$1, ClusterStateService clusterStateService$1, ClusterStateService.State clusterState) {
        Tuple2 tuple2 = (Tuple2)f$2.apply(st$1.get(), (Object)clusterState);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object newState = tuple2._1();
        AutoScaler.Action action = (AutoScaler.Action)tuple2._2();
        Tuple2 tuple22 = new Tuple2(newState, (Object)action);
        Tuple2 tuple23 = tuple22;
        Object newState2 = tuple23._1();
        AutoScaler.Action action2 = (AutoScaler.Action)tuple23._2();
        st$1.set(newState2);
        AutoScaler$Metrics$.MODULE$.updateState(clusterState);
        AutoScaler.Action action3 = action2;
        if (action3 instanceof AutoScaler.SetUserSlot) {
            AutoScaler.SetUserSlot setUserSlot = (AutoScaler.SetUserSlot)action3;
            long count = setUserSlot.count();
            Set<String> toStop = MODULE$.jobsToStop(clusterStateService$1, clusterState.userSlots(), count);
            MODULE$.tech$ytsaurus$spark$launcher$AutoScaler$$log().info(new StringBuilder(46).append("Updating user slots: ").append(count).append(", stop following jobs: [").append(toStop.mkString(", ")).append("]").toString());
            clusterStateService$1.setUserSlots(count, toStop);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (AutoScaler$DoNothing$.MODULE$.equals(action3)) {
            MODULE$.tech$ytsaurus$spark$launcher$AutoScaler$$log().info("Nothing to do");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)action3);
        }
    }

    private AutoScaler$() {
        MODULE$ = this;
        this.tech$ytsaurus$spark$launcher$AutoScaler$$log = LoggerFactory.getLogger(this.getClass());
        this.threadFactory = new ThreadFactory(){
            private final AtomicLong count;

            private AtomicLong count() {
                return this.count;
            }

            /*
             * WARNING - void declaration
             */
            public Thread newThread(Runnable runnable) {
                void var2_2;
                Thread thread = Executors.defaultThreadFactory().newThread(runnable);
                thread.setDaemon(true);
                thread.setUncaughtExceptionHandler((x$1, ex) -> AutoScaler$.MODULE$.tech$ytsaurus$spark$launcher$AutoScaler$$log().error("Uncaught exception in autoscaler thread", ex));
                thread.setName(new StringOps(Predef$.MODULE$.augmentString("auto-scaler-%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.count().getAndIncrement())})));
                return var2_2;
            }
            {
                this.count = new AtomicLong(0L);
            }
        };
        this.scheduler = new ScheduledThreadPoolExecutor(1, this.threadFactory());
    }
}

