/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.spark.launcher;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Try;
import tech.ytsaurus.client.CompoundClient;
import tech.ytsaurus.client.request.AbortJob;
import tech.ytsaurus.client.request.GetOperation;
import tech.ytsaurus.client.request.ResumeOperation;
import tech.ytsaurus.client.request.SuspendOperation;
import tech.ytsaurus.client.request.UpdateOperationParameters;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.spark.launcher.AutoScaler;
import tech.ytsaurus.spark.launcher.ClusterStateService;
import tech.ytsaurus.spark.launcher.ClusterStateService$;
import tech.ytsaurus.spark.launcher.SparkStateService;
import tech.ytsaurus.spark.launcher.SparkStateService$;
import tech.ytsaurus.spyt.wrapper.LogLazy;
import tech.ytsaurus.spyt.wrapper.discovery.Address;
import tech.ytsaurus.spyt.wrapper.discovery.CypressDiscoveryService$;
import tech.ytsaurus.spyt.wrapper.discovery.DiscoveryService;
import tech.ytsaurus.spyt.wrapper.discovery.OperationSet;
import tech.ytsaurus.ysontree.YTreeNode;

public final class ClusterStateService$
implements LogLazy {
    public static ClusterStateService$ MODULE$;
    private final Logger tech$ytsaurus$spark$launcher$ClusterStateService$$log;

    static {
        new ClusterStateService$();
    }

    public LogLazy.RichLogger RichLogger(Logger log) {
        return LogLazy.RichLogger$((LogLazy)this, (Logger)log);
    }

    public Logger tech$ytsaurus$spark$launcher$ClusterStateService$$log() {
        return this.tech$ytsaurus$spark$launcher$ClusterStateService$$log;
    }

    public ClusterStateService apply(DiscoveryService discoveryService, CompoundClient yt) {
        return new ClusterStateService(discoveryService, yt){
            private final SparkStateService sparkStateService;
            private final DiscoveryService discoveryService$1;
            private final CompoundClient yt$1;

            private SparkStateService sparkStateService() {
                return this.sparkStateService;
            }

            public Option<ClusterStateService.State> query() {
                None$ none$;
                Some some;
                OperationSet operationSet;
                ClusterStateService$.MODULE$.tech$ytsaurus$spark$launcher$ClusterStateService$$log().debug("Querying cluster state");
                Option option = this.discoveryService$1.operations();
                if (option instanceof Some && (operationSet = (OperationSet)(some = (Some)option).value()) != null) {
                    None$ none$2;
                    Set children = operationSet.children();
                    if (children.isEmpty()) {
                        ClusterStateService$.MODULE$.tech$ytsaurus$spark$launcher$ClusterStateService$$log().error("Autoscaler operation with empty children ops called");
                        none$2 = None$.MODULE$;
                    } else {
                        String workersOp = (String)children.iterator().next();
                        ClusterStateService$.MODULE$.tech$ytsaurus$spark$launcher$ClusterStateService$$log().info(new StringBuilder(17).append("Worker operation ").append(workersOp).toString());
                        YTreeNode opStats = (YTreeNode)this.yt$1.getOperation(new GetOperation(GUID.valueOf((String)workersOp))).join();
                        Option totalJobs = CypressDiscoveryService$.MODULE$.YTreeNodeExt(opStats).longAttribute((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spec", "tasks", "workers", "job_count"}));
                        Option runningJobs = CypressDiscoveryService$.MODULE$.YTreeNodeExt(opStats).longAttribute((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"brief_progress", "jobs", "running"}));
                        Option currentUserSlots = CypressDiscoveryService$.MODULE$.YTreeNodeExt(opStats).longAttribute((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"runtime_parameters", "scheduling_options_per_pool_tree", "physical", "resource_limits", "user_slots"}));
                        Option operationState = totalJobs.flatMap((Function1 & Serializable & scala.Serializable)total -> anon.1.$anonfun$query$1(runningJobs, currentUserSlots, BoxesRunTime.unboxToLong((Object)total)));
                        ClusterStateService$.MODULE$.tech$ytsaurus$spark$launcher$ClusterStateService$$log().debug(new StringBuilder(26).append("operation ").append(workersOp).append(" state: ").append(operationState).append(" slots: ").append(currentUserSlots).toString());
                        Try<AutoScaler.SparkState> sparkState = this.sparkStateService().query();
                        ClusterStateService$.MODULE$.tech$ytsaurus$spark$launcher$ClusterStateService$$log().info(new StringBuilder(13).append("spark state: ").append(sparkState).toString());
                        Option state = operationState.flatMap((Function1 & Serializable & scala.Serializable)operation -> sparkState.toOption().flatMap((Function1 & Serializable & scala.Serializable)spark -> currentUserSlots.orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)BoxesRunTime.boxToLong((long)operation.maxJobs()))).map((Function1 & Serializable & scala.Serializable)slots -> anon.1.$anonfun$query$8(operation, spark, BoxesRunTime.unboxToLong((Object)slots)))));
                        ClusterStateService$.MODULE$.tech$ytsaurus$spark$launcher$ClusterStateService$$log().info(new StringBuilder(14).append("result state: ").append(state).toString());
                        none$2 = state;
                    }
                    none$ = none$2;
                } else if (None$.MODULE$.equals(option)) {
                    ClusterStateService$.MODULE$.tech$ytsaurus$spark$launcher$ClusterStateService$$log().error("Autoscaler not supported for single op mode");
                    none$ = None$.MODULE$;
                } else {
                    throw new MatchError((Object)option);
                }
                return none$;
            }

            private void stopJob(GUID jobId) {
                ClusterStateService$.MODULE$.tech$ytsaurus$spark$launcher$ClusterStateService$$log().info(new StringBuilder(13).append("Stopping job ").append(jobId).toString());
                this.yt$1.abortJob(new AbortJob(jobId));
            }

            private void suspendOperation(GUID operationId) {
                ClusterStateService$.MODULE$.tech$ytsaurus$spark$launcher$ClusterStateService$$log().info(new StringBuilder(21).append("Suspending operation ").append(operationId).toString());
                this.yt$1.suspendOperation(((SuspendOperation.BuilderBase)SuspendOperation.builder().setOperationId(operationId)).setAbortRunningJobs(false).build()).join();
            }

            private void resumeOperation(GUID operationId) {
                ClusterStateService$.MODULE$.tech$ytsaurus$spark$launcher$ClusterStateService$$log().info(new StringBuilder(19).append("Resuming operation ").append(operationId).toString());
                this.yt$1.resumeOperation(new ResumeOperation(operationId)).join();
            }

            private void updateUserSlots(GUID operationId, long userSlots) {
                ClusterStateService$.MODULE$.tech$ytsaurus$spark$launcher$ClusterStateService$$log().info(new StringBuilder(47).append("Updating operation parameters for ").append(operationId).append(": user_slots=").append(userSlots).toString());
                UpdateOperationParameters req = ((UpdateOperationParameters.BuilderBase)UpdateOperationParameters.builder().setOperationId(operationId)).addSchedulingOptions("physical", new UpdateOperationParameters.SchedulingOptions().setResourceLimits(new UpdateOperationParameters.ResourceLimits().setUserSlots(userSlots))).build();
                this.yt$1.updateOperationParameters(req).join();
            }

            public void setUserSlots(long slots, Set<String> stopWorkers) {
                GUID op = GUID.valueOf((String)((String)((OperationSet)this.discoveryService$1.operations().get()).children().iterator().next()));
                if (stopWorkers.nonEmpty()) {
                    try {
                        this.suspendOperation(op);
                        ((IterableLike)stopWorkers.map((Function1 & Serializable & scala.Serializable)x$1 -> GUID.valueOf((String)x$1), Set$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)jobId -> {
                            anon.1.$anonfun$setUserSlots$2(this, jobId);
                            return BoxedUnit.UNIT;
                        });
                        this.updateUserSlots(op, slots);
                    }
                    finally {
                        this.resumeOperation(op);
                    }
                } else {
                    this.updateUserSlots(op, slots);
                }
            }

            public Set<String> setUserSlots$default$2() {
                return (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
            }

            public Seq<String> idleJobs() {
                return (Seq)((GenericTraversableTemplate)this.sparkStateService().activeWorkers().map((Function1 & Serializable & scala.Serializable)x$1 -> (Seq)this.sparkStateService().idleWorkers((Seq<SparkStateService.WorkerInfo>)x$1).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.ytJobId(), Seq$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$)).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo));
            }

            public static final /* synthetic */ AutoScaler.OperationState $anonfun$query$4(long total$1, long running$1, long slots) {
                return new AutoScaler.OperationState(total$1, running$1, Math.max(0L, slots - running$1));
            }

            public static final /* synthetic */ Option $anonfun$query$2(Option currentUserSlots$1, long total$1, long running) {
                return currentUserSlots$1.orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)BoxesRunTime.boxToLong((long)total$1))).map((Function1 & Serializable & scala.Serializable)slots -> anon.1.$anonfun$query$4(total$1, running, BoxesRunTime.unboxToLong((Object)slots)));
            }

            public static final /* synthetic */ Option $anonfun$query$1(Option runningJobs$1, Option currentUserSlots$1, long total) {
                return runningJobs$1.flatMap((Function1 & Serializable & scala.Serializable)running -> anon.1.$anonfun$query$2(currentUserSlots$1, total, BoxesRunTime.unboxToLong((Object)running)));
            }

            public static final /* synthetic */ ClusterStateService.State $anonfun$query$8(AutoScaler.OperationState operation$1, AutoScaler.SparkState spark$1, long slots) {
                return new ClusterStateService.State(operation$1, spark$1, slots);
            }

            public static final /* synthetic */ void $anonfun$setUserSlots$2(anon.1 $this, GUID jobId) {
                $this.stopJob(jobId);
            }
            {
                this.discoveryService$1 = discoveryService$1;
                this.yt$1 = yt$1;
                this.sparkStateService = SparkStateService$.MODULE$.sparkStateService(((Address)discoveryService$1.discoverAddress().get()).webUiUri(), ((Address)discoveryService$1.discoverAddress().get()).restHostAndPort());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$query$1$adapted(scala.Option scala.Option java.lang.Object ), $anonfun$query$5(scala.util.Try scala.Option tech.ytsaurus.spark.launcher.AutoScaler$OperationState ), $anonfun$setUserSlots$1(java.lang.String ), $anonfun$setUserSlots$2$adapted(tech.ytsaurus.spark.launcher.ClusterStateService$$anon$1 tech.ytsaurus.core.GUID ), $anonfun$idleJobs$1(tech.ytsaurus.spark.launcher.ClusterStateService$$anon$1 scala.collection.Seq ), $anonfun$idleJobs$3(), $anonfun$idleJobs$4(scala.Option ), $anonfun$query$3(long ), $anonfun$query$4$adapted(long long java.lang.Object ), $anonfun$query$2$adapted(scala.Option long java.lang.Object ), $anonfun$query$7(tech.ytsaurus.spark.launcher.AutoScaler$OperationState ), $anonfun$query$8$adapted(tech.ytsaurus.spark.launcher.AutoScaler$OperationState tech.ytsaurus.spark.launcher.AutoScaler$SparkState java.lang.Object ), $anonfun$query$6(scala.Option tech.ytsaurus.spark.launcher.AutoScaler$OperationState tech.ytsaurus.spark.launcher.AutoScaler$SparkState ), $anonfun$idleJobs$2(tech.ytsaurus.spark.launcher.SparkStateService$WorkerInfo )}, serializedLambda);
            }
        };
    }

    private ClusterStateService$() {
        MODULE$ = this;
        LogLazy.$init$((LogLazy)this);
        this.tech$ytsaurus$spark$launcher$ClusterStateService$$log = LoggerFactory.getLogger(this.getClass());
    }
}

