/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.spark.launcher;

import java.io.File;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Set;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import tech.ytsaurus.client.CompoundClient;
import tech.ytsaurus.spark.launcher.WorkerLogLauncher;
import tech.ytsaurus.spark.launcher.WorkerLogWriter;
import tech.ytsaurus.spyt.wrapper.LogLazy;
import tech.ytsaurus.spyt.wrapper.YtWrapper$;
import tech.ytsaurus.spyt.wrapper.model.WorkerLogBlock;
import tech.ytsaurus.spyt.wrapper.model.WorkerLogBlock$;
import tech.ytsaurus.spyt.wrapper.model.WorkerLogSchema$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001B\n\u0015\u0001uA\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tu\u0001\u0011\t\u0011)A\u0006w!)\u0011\t\u0001C\u0001\u0005\"9q\t\u0001b\u0001\n\u0003A\u0005BB3\u0001A\u0003%\u0011\nC\u0004g\u0001\t\u0007I\u0011A4\t\r-\u0004\u0001\u0015!\u0003i\u0011\u001da\u0007A1A\u0005\n5DaA\u001e\u0001!\u0002\u0013q\u0007BB<\u0001\t\u0003!\u0002\u0010C\u0003}\u0001\u0011\u0005\u0003\u0010C\u0003~\u0001\u0011%a\u0010C\u0004\u0002.\u0001!I!a\f\t\u0013\u0005m\u0002A1A\u0005\n\u0005u\u0002\u0002CA#\u0001\u0001\u0006I!a\u0010\t\u000f\u0005\u001d\u0003\u0001\"\u0003\u0002J!I\u0011q\u000b\u0001\u0012\u0002\u0013%\u0011\u0011\f\u0005\u0007\u0003_\u0002A\u0011\u0001=\u0003%1{wmU3sm&\u001cWMU;o]\u0006\u0014G.\u001a\u0006\u0003+Y\t\u0001\u0002\\1v]\u000eDWM\u001d\u0006\u0003/a\tQa\u001d9be.T!!\u0007\u000e\u0002\u0011e$8/Y;skNT\u0011aG\u0001\u0005i\u0016\u001c\u0007n\u0001\u0001\u0014\t\u0001qb%\u000b\t\u0003?\u0011j\u0011\u0001\t\u0006\u0003C\t\nA\u0001\\1oO*\t1%\u0001\u0003kCZ\f\u0017BA\u0013!\u0005\u0019y%M[3diB\u0011qdJ\u0005\u0003Q\u0001\u0012\u0001BU;o]\u0006\u0014G.\u001a\t\u0003U=j\u0011a\u000b\u0006\u0003Y5\nqa\u001e:baB,'O\u0003\u0002/1\u0005!1\u000f]=u\u0013\t\u00014FA\u0004M_\u001ed\u0015M_=\u0002\u001f]|'o[3s\u0019><7i\u001c8gS\u001e\u0004\"aM\u001c\u000f\u0005Q*T\"\u0001\u000b\n\u0005Y\"\u0012!E,pe.,'\u000fT8h\u0019\u0006,hn\u00195fe&\u0011\u0001(\u000f\u0002\u0010/>\u00148.\u001a:M_\u001e\u001cuN\u001c4jO*\u0011a\u0007F\u0001\u0003sR\u0004\"\u0001P \u000e\u0003uR!A\u0010\r\u0002\r\rd\u0017.\u001a8u\u0013\t\u0001UH\u0001\bD_6\u0004x.\u001e8e\u00072LWM\u001c;\u0002\rqJg.\u001b;?)\t\u0019e\t\u0006\u0002E\u000bB\u0011A\u0007\u0001\u0005\u0006u\r\u0001\u001da\u000f\u0005\u0006c\r\u0001\rAM\u0001\tM&dW-T3uCV\t\u0011\n\u0005\u0003K#NsV\"A&\u000b\u00051k\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0003\u001d>\u000b!bY8mY\u0016\u001cG/[8o\u0015\u0005\u0001\u0016!B:dC2\f\u0017B\u0001*L\u0005\ri\u0015\r\u001d\t\u0003)ns!!V-\u0011\u0005Y{U\"A,\u000b\u0005ac\u0012A\u0002\u001fs_>$h(\u0003\u0002[\u001f\u00061\u0001K]3eK\u001aL!\u0001X/\u0003\rM#(/\u001b8h\u0015\tQv\n\u0005\u0003`A\n\u0014W\"A(\n\u0005\u0005|%A\u0002+va2,'\u0007\u0005\u0002`G&\u0011Am\u0014\u0002\u0005\u0019>tw-A\u0005gS2,W*\u001a;bA\u0005ia-\u001b8jg\",G\rU1uQN,\u0012\u0001\u001b\t\u0004\u0015&\u001c\u0016B\u00016L\u0005\r\u0019V\r^\u0001\u000fM&t\u0017n\u001d5fIB\u000bG\u000f[:!\u0003\rawnZ\u000b\u0002]B\u0011q\u000e^\u0007\u0002a*\u0011\u0011O]\u0001\u0006g24GG\u001b\u0006\u0002g\u0006\u0019qN]4\n\u0005U\u0004(A\u0002'pO\u001e,'/\u0001\u0003m_\u001e\u0004\u0013\u0001B5oSR$\u0012!\u001f\t\u0003?jL!a_(\u0003\tUs\u0017\u000e^\u0001\u0004eVt\u0017\u0001\u0004:fC\u0012,f\u000e^5m\u000b:$G#B@\u0002\u0014\u0005\r\u0002CBA\u0001\u0003\u0017\t\tB\u0004\u0003\u0002\u0004\u0005\u001dab\u0001,\u0002\u0006%\t\u0001+C\u0002\u0002\n=\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u000e\u0005=!AB*ue\u0016\fWNC\u0002\u0002\n=\u0003Ba\u00181c'\"9\u0011Q\u0003\u0007A\u0002\u0005]\u0011A\u0002:fC\u0012,'\u000f\u0005\u0003\u0002\u001a\u0005}QBAA\u000e\u0015\r\tiBI\u0001\u0003S>LA!!\t\u0002\u001c\t\u0001\"+\u00198e_6\f5mY3tg\u001aKG.\u001a\u0005\b\u0003Ka\u0001\u0019AA\u0014\u0003)IwM\\8sK2\u000b7\u000f\u001e\t\u0004?\u0006%\u0012bAA\u0016\u001f\n9!i\\8mK\u0006t\u0017!E2iK\u000e\\g)\u001b7f\r&t\u0017n\u001d5fIR!\u0011qEA\u0019\u0011\u001d\t\u0019$\u0004a\u0001\u0003k\tAAZ5mKB!\u0011\u0011DA\u001c\u0013\u0011\tI$a\u0007\u0003\t\u0019KG.Z\u0001\u0007oJLG/\u001a:\u0016\u0005\u0005}\u0002c\u0001\u001b\u0002B%\u0019\u00111\t\u000b\u0003\u001f]{'o[3s\u0019><wK]5uKJ\fqa\u001e:ji\u0016\u0014\b%A\fqe>\u001cWm]:Ti\u0012|W\u000f^*uI\u0016\u0014(\u000fR1uCR9\u00110a\u0013\u0002P\u0005M\u0003bBA'!\u0001\u0007\u0011QG\u0001\nI&\u0014Xm\u0019;pefDa!!\u0015\u0011\u0001\u0004\u0019\u0016!C1qa\u0012\u0013\u0018N^3s\u0011!\t)\u0006\u0005I\u0001\u0002\u0004\u0019\u0016AB3yK\u000eLE-A\u0011qe>\u001cWm]:Ti\u0012|W\u000f^*uI\u0016\u0014(\u000fR1uC\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\\)\u001a1+!\u0018,\u0005\u0005}\u0003\u0003BA1\u0003Wj!!a\u0019\u000b\t\u0005\u0015\u0014qM\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u001bP\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003[\n\u0019GA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f!\"\u001e9m_\u0006$Gj\\4t\u0001")
public class LogServiceRunnable
implements Runnable,
LogLazy {
    private final WorkerLogLauncher.WorkerLogConfig workerLogConfig;
    private final CompoundClient yt;
    private final Map<String, Tuple2<Object, Object>> fileMeta;
    private final Set<String> finishedPaths;
    private final Logger log;
    private final WorkerLogWriter writer;

    public LogLazy.RichLogger RichLogger(Logger log) {
        return LogLazy.RichLogger$((LogLazy)this, (Logger)log);
    }

    public Map<String, Tuple2<Object, Object>> fileMeta() {
        return this.fileMeta;
    }

    public Set<String> finishedPaths() {
        return this.finishedPaths;
    }

    private Logger log() {
        return this.log;
    }

    public void init() {
        YtWrapper$.MODULE$.createDir(this.workerLogConfig.tablesPath(), (Option)None$.MODULE$, true, this.yt);
        YtWrapper$.MODULE$.createDynTableAndMount(WorkerLogSchema$.MODULE$.getMetaPath(this.workerLogConfig.tablesPath()), WorkerLogSchema$.MODULE$.metaSchema(), YtWrapper$.MODULE$.createDynTableAndMount$default$3(), YtWrapper$.MODULE$.createDynTableAndMount$default$4(), this.yt);
    }

    @Override
    public void run() {
        try {
            this.log().info(new StringBuilder(25).append("WorkerLog configuration: ").append(this.workerLogConfig).toString());
            this.init();
            while (!Thread.interrupted()) {
                try {
                    this.uploadLogs();
                }
                catch (Exception e) {
                    this.log().error(new StringBuilder(28).append("Error while uploading logs: ").append(e.getMessage()).toString());
                }
                Thread.sleep(this.workerLogConfig.updateInterval().toMillis());
            }
        }
        catch (InterruptedException e) {
            this.log().info("WorkerLogService was interrupted");
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Stream<Tuple2<Object, String>> readUntilEnd(RandomAccessFile reader, boolean ignoreLast) {
        void var3_3;
        Stream stream = (Stream)package$.MODULE$.Stream().continually((Function0 & Serializable & scala.Serializable)() -> new Tuple2((Object)Option$.MODULE$.apply((Object)reader.readLine()), (Object)BoxesRunTime.boxToLong((long)reader.getFilePointer()))).takeWhile((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogServiceRunnable.$anonfun$readUntilEnd$2(x0$1))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option line = (Option)tuple2._1();
            long seek = tuple2._2$mcJ$sp();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)seek), line.get());
            return tuple22;
        }, Stream$.MODULE$.canBuildFrom());
        return ignoreLast ? stream.dropRight(1) : var3_3;
    }

    private boolean checkFileFinished(File file) {
        return new File(new StringBuilder(10).append(file.getParentFile().getAbsolutePath()).append("/").append(file.getName()).append("_finished").toString()).exists();
    }

    private WorkerLogWriter writer() {
        return this.writer;
    }

    private void processStdoutStderrData(File directory, String appDriver, String execId) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])directory.list())).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)LogServiceRunnable.$anonfun$processStdoutStderrData$1(x))))).foreach((Function1 & Serializable & scala.Serializable)logFileName -> {
            Nil$ nil$;
            String logPath = new StringBuilder(1).append(directory.getAbsolutePath()).append("/").append((String)logFileName).toString();
            File logFile = new File(logPath);
            this.RichLogger(this.log()).traceLazy((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Found log file ").append(logPath).toString());
            LocalDateTime creationTime = ((FileTime)Files.getAttribute(Path.of(logPath, new String[0]), "creationTime", new LinkOption[0])).toInstant().atOffset(ZoneOffset.UTC).toLocalDateTime();
            if (this.finishedPaths().contains((Object)logPath)) {
                nil$ = Nil$.MODULE$;
            } else {
                boolean bl;
                if (this.checkFileFinished(logFile)) {
                    this.finishedPaths().add((Object)logPath);
                    bl = false;
                } else {
                    bl = true;
                }
                boolean ignoreLast = bl;
                try (RandomAccessFile reader = new RandomAccessFile(logFile, "r");){
                    Tuple2 tuple2 = (Tuple2)this.fileMeta().apply((Object)logPath);
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    long currentSeek = tuple2._1$mcJ$sp();
                    long currentLine = tuple2._2$mcJ$sp();
                    Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(currentSeek, currentLine);
                    Tuple2.mcJJ.sp sp3 = sp2;
                    long currentSeek2 = sp3._1$mcJ$sp();
                    long currentLine2 = sp3._2$mcJ$sp();
                    reader.seek(currentSeek2);
                    this.writer().setCreationTime(appDriver, execId, (String)logFileName, creationTime);
                    Stream<Tuple2<Object, String>> ans = this.readUntilEnd(reader, ignoreLast);
                    Tuple2 tuple22 = (Tuple2)ans.foldLeft((Object)new Tuple2.mcJI.sp(currentSeek2, 0), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                        int len;
                        Tuple2 tuple2;
                        block3: {
                            Tuple2 tuple22;
                            block2: {
                                tuple22 = new Tuple2(x0$1, x1$1);
                                if (tuple22 == null) break block2;
                                Tuple2 tuple23 = (Tuple2)tuple22._1();
                                tuple2 = (Tuple2)tuple22._2();
                                if (tuple23 == null) break block2;
                                len = tuple23._2$mcI$sp();
                                if (tuple2 != null) break block3;
                            }
                            throw new MatchError((Object)tuple22);
                        }
                        long seek = tuple2._1$mcJ$sp();
                        String line = (String)tuple2._2();
                        WorkerLogBlock block = $this.workerLogConfig.enableJson() ? WorkerLogBlock$.MODULE$.fromJson(line, logFileName, appDriver, execId, currentLine2 + (long)len, creationTime) : WorkerLogBlock$.MODULE$.fromMessage(line, logFileName, appDriver, execId, currentLine2 + (long)len, creationTime);
                        int written = this.writer().write(block);
                        Tuple2.mcJI.sp sp2 = new Tuple2.mcJI.sp(seek, len + written);
                        return sp2;
                    });
                    if (tuple22 == null) {
                        throw new MatchError((Object)tuple22);
                    }
                    long lastSeek = tuple22._1$mcJ$sp();
                    int length = tuple22._2$mcI$sp();
                    Tuple2.mcJI.sp sp4 = new Tuple2.mcJI.sp(lastSeek, length);
                    Tuple2.mcJI.sp sp5 = sp4;
                    long lastSeek2 = sp5._1$mcJ$sp();
                    int length2 = sp5._2$mcI$sp();
                    if (!this.fileMeta().contains((Object)logPath) && length2 == 0) {
                        this.writer().newEmptyFile((Tuple3<String, String, String>)new Tuple3((Object)appDriver, (Object)execId, logFileName));
                    }
                    this.fileMeta().update((Object)logPath, (Object)new Tuple2.mcJJ.sp(lastSeek2, currentLine2 + (long)length2));
                    nil$ = BoxedUnit.UNIT;
                }
            }
            return nil$;
        });
    }

    private String processStdoutStderrData$default$3() {
        return "";
    }

    public void uploadLogs() {
        this.RichLogger(this.log()).debugLazy((Function0 & Serializable & scala.Serializable)() -> "Started scanning logs");
        File appsFolder = new File(this.workerLogConfig.scanDirectory());
        if (appsFolder.exists()) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])appsFolder.list())).foreach((Function1 & Serializable & scala.Serializable)dirName -> {
                Nil$ nil$;
                String fullPath = new StringBuilder(1).append(appsFolder.getAbsolutePath()).append("/").append((String)dirName).toString();
                File file = new File(fullPath);
                if (file.getName().startsWith("app-")) {
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])file.list())).foreach((Function1 & Serializable & scala.Serializable)executorId -> {
                        LogServiceRunnable.$anonfun$uploadLogs$3(this, file, dirName, executorId);
                        return BoxedUnit.UNIT;
                    });
                    nil$ = BoxedUnit.UNIT;
                } else if (file.getName().startsWith("driver-")) {
                    this.processStdoutStderrData(file, (String)dirName, this.processStdoutStderrData$default$3());
                    nil$ = BoxedUnit.UNIT;
                } else {
                    nil$ = Nil$.MODULE$;
                }
                return nil$;
            });
            this.writer().flush();
        } else {
            this.RichLogger(this.log()).debugLazy((Function0 & Serializable & scala.Serializable)() -> "No logs folder");
        }
        this.RichLogger(this.log()).debugLazy((Function0 & Serializable & scala.Serializable)() -> "Finished scanning logs");
    }

    public static final /* synthetic */ boolean $anonfun$readUntilEnd$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option line = (Option)tuple2._1();
        boolean bl = line.nonEmpty();
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$processStdoutStderrData$1(String x) {
        String string = x;
        String string2 = "stdout";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = x;
        String string4 = "stderr";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public static final /* synthetic */ void $anonfun$uploadLogs$3(LogServiceRunnable $this, File file$1, String dirName$1, String executorId) {
        String executorPath = new StringBuilder(1).append(file$1.getAbsolutePath()).append("/").append(executorId).toString();
        $this.processStdoutStderrData(new File(executorPath), dirName$1, executorId);
    }

    public LogServiceRunnable(WorkerLogLauncher.WorkerLogConfig workerLogConfig, CompoundClient yt) {
        this.workerLogConfig = workerLogConfig;
        this.yt = yt;
        LogLazy.$init$((LogLazy)this);
        this.fileMeta = ((Map)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$)).withDefaultValue((Object)new Tuple2.mcJJ.sp(0L, 0L));
        this.finishedPaths = (Set)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.log = LoggerFactory.getLogger(this.getClass());
        this.writer = new WorkerLogWriter(workerLogConfig, yt);
    }
}

