/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.spark.launcher;

import cats.Apply;
import cats.data.NonEmptyList;
import cats.data.Validated;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Error;
import io.circe.HCursor;
import io.circe.KeyDecoder$;
import io.circe.generic.decoding.DerivedDecoder;
import io.circe.generic.decoding.DerivedDecoder$;
import io.circe.generic.decoding.ReprDecoder;
import io.circe.generic.decoding.ReprDecoder$;
import io.circe.generic.semiauto$;
import io.circe.parser.package$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.RichLong$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;
import shapeless.;
import shapeless.DefaultSymbolicLabelling$;
import shapeless.Generic$;
import shapeless.HList;
import shapeless.HNil;
import shapeless.HNil$;
import shapeless.LabelledGeneric$;
import shapeless.Lazy$;
import shapeless.Witness$;
import shapeless.ops.hlist;
import sttp.client.HttpError;
import sttp.client.HttpURLConnectionBackend$;
import sttp.client.Response;
import sttp.client.SttpBackend;
import sttp.model.Uri;
import tech.ytsaurus.spark.launcher.AutoScaler;
import tech.ytsaurus.spark.launcher.SparkStateService;
import tech.ytsaurus.spark.launcher.SparkStateService$;
import tech.ytsaurus.spark.launcher.rest.AppStatusesRestClient;
import tech.ytsaurus.spark.launcher.rest.AppStatusesRestClient$;
import tech.ytsaurus.spark.launcher.rest.AppStatusesRestClient$AppState$RUNNING$;
import tech.ytsaurus.spark.launcher.rest.AppStatusesRestClient$AppState$WAITING$;
import tech.ytsaurus.spyt.HostAndPort;

public final class SparkStateService$ {
    public static SparkStateService$ MODULE$;
    private final int tech$ytsaurus$spark$launcher$SparkStateService$$sparkStateQueryThreads;
    private final Logger tech$ytsaurus$spark$launcher$SparkStateService$$log;

    static {
        new SparkStateService$();
    }

    public int tech$ytsaurus$spark$launcher$SparkStateService$$sparkStateQueryThreads() {
        return this.tech$ytsaurus$spark$launcher$SparkStateService$$sparkStateQueryThreads;
    }

    public Logger tech$ytsaurus$spark$launcher$SparkStateService$$log() {
        return this.tech$ytsaurus$spark$launcher$SparkStateService$$log;
    }

    public SparkStateService sparkStateService(URI webUi, HostAndPort rest) {
        return new SparkStateService(rest, webUi){
            private final AppStatusesRestClient restClient;
            private final SttpBackend<Object, Nothing$, Nothing$> backend;
            private final ExecutorService es;
            private final ExecutionContext ec;
            private final HostAndPort rest$1;
            private final URI webUi$1;

            private AppStatusesRestClient restClient() {
                return this.restClient;
            }

            private SttpBackend<Object, Nothing$, Nothing$> backend() {
                return this.backend;
            }

            private ExecutorService es() {
                return this.es;
            }

            private ExecutionContext ec() {
                return this.ec;
            }

            public Try<AutoScaler.SparkState> query() {
                return this.activeWorkers().flatMap((Function1 & Serializable & scala.Serializable)ws -> {
                    SparkStateService$.MODULE$.tech$ytsaurus$spark$launcher$SparkStateService$$log().info(new StringBuilder(16).append("active workers: ").append(ws).toString());
                    Try allWorkerStats = (Try)this.workerStats((Seq<SparkStateService.WorkerInfo>)ws).foldLeft((Object)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                        Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Try ac = (Try)tuple2._1();
                        Try r = (Try)tuple2._2();
                        Try try_ = ac.flatMap((Function1 & Serializable & scala.Serializable)as -> r.map((Function1 & Serializable & scala.Serializable)a -> (Seq)as.$colon$plus(a, Seq$.MODULE$.canBuildFrom())));
                        return try_;
                    });
                    return allWorkerStats.flatMap((Function1 & Serializable & scala.Serializable)stats -> this.masterStats().flatMap((Function1 & Serializable & scala.Serializable)master -> this.queryAppStatuses().map((Function1 & Serializable & scala.Serializable)apps -> new AutoScaler.SparkState(ws.size(), stats.count((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$query$9(x$2))), master.waitingApps(), BoxesRunTime.unboxToLong((Object)((TraversableOnce)stats.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)anon.1.$anonfun$query$10(x$3)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), BoxesRunTime.unboxToLong((Object)((TraversableOnce)stats.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)anon.1.$anonfun$query$11(x$4)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), apps.maxWaitingTimeMs()))));
                });
            }

            private Try<SparkStateService.AppStatusesStats> queryAppStatuses() {
                return this.restClient().getAppStatuses().flatMap((Function1 & Serializable & scala.Serializable)appStatuses -> this.restClient().getSubmissionStatuses().map((Function1 & Serializable & scala.Serializable)submissionStatuses -> {
                    SparkStateService$.MODULE$.tech$ytsaurus$spark$launcher$SparkStateService$$log().debug(new StringBuilder(37).append("app statuses: ").append(appStatuses).append(", submission statuses: ").append(submissionStatuses).toString());
                    Seq activeApps = (Seq)appStatuses.filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$queryAppStatuses$3(x$5)));
                    long maxAppWaitingTime = BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)activeApps.filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$queryAppStatuses$4(x$6)))).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)anon.1.$anonfun$queryAppStatuses$5(x$7)), Seq$.MODULE$.canBuildFrom())).foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(x$8, x$9) -> RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(x$8), x$9)));
                    long maxSubmissionWaitingTIme = BoxesRunTime.unboxToLong((Object)((TraversableOnce)submissionStatuses.map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)anon.1.$anonfun$queryAppStatuses$7(x$10)), Seq$.MODULE$.canBuildFrom())).foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(x$11, x$12) -> RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(x$11), x$12)));
                    SparkStateService$.MODULE$.tech$ytsaurus$spark$launcher$SparkStateService$$log().debug(new StringBuilder(47).append("maxAppWaitingTime: ").append(maxAppWaitingTime).append(", maxSubmissionWaitingTime: ").append(maxSubmissionWaitingTIme).toString());
                    return new SparkStateService.AppStatusesStats(activeApps.count((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$queryAppStatuses$9(x$13))), activeApps.count((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$queryAppStatuses$10(x$14))), RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(maxAppWaitingTime), maxSubmissionWaitingTIme));
                }));
            }

            public Try<SparkStateService.MasterStats> masterStats() {
                Uri uri = sttp.client.package$.MODULE$.UriContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/metrics/master/prometheus"}))).uri((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.webUi$1}));
                SparkStateService$.MODULE$.tech$ytsaurus$spark$launcher$SparkStateService$$log().debug(new StringBuilder(9).append("querying ").append(uri).toString());
                return (Try)((Either)((Response)sttp.client.package$.MODULE$.basicRequest().get(uri).send(this.backend(), Predef.$eq$colon$eq$.MODULE$.tpEquals())).body()).fold((Function1 & Serializable & scala.Serializable)error -> new Failure((Throwable)new HttpError(error)), (Function1 & Serializable & scala.Serializable)body2 -> this.parseMasterMetrics((String)body2));
            }

            public Try<Seq<SparkStateService.AppStats>> appStats() {
                Uri uri = sttp.client.package$.MODULE$.UriContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/metrics/applications/prometheus"}))).uri((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.webUi$1}));
                SparkStateService$.MODULE$.tech$ytsaurus$spark$launcher$SparkStateService$$log().debug(new StringBuilder(9).append("querying ").append(uri).toString());
                return (Try)((Either)((Response)sttp.client.package$.MODULE$.basicRequest().get(uri).send(this.backend(), Predef.$eq$colon$eq$.MODULE$.tpEquals())).body()).fold((Function1 & Serializable & scala.Serializable)error -> new Failure((Throwable)new HttpError(error)), (Function1 & Serializable & scala.Serializable)body2 -> this.parseAppMetrics((String)body2));
            }

            public Try<Seq<SparkStateService.WorkerInfo>> activeWorkers() {
                Uri uri = sttp.client.package$.MODULE$.UriContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"http://", "/v1/submissions/master"}))).uri((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.rest$1.asString()}));
                SparkStateService$.MODULE$.tech$ytsaurus$spark$launcher$SparkStateService$$log().debug(new StringBuilder(9).append("querying ").append(uri).toString());
                return (Try)((Either)((Response)sttp.client.package$.MODULE$.basicRequest().get(uri).send(this.backend(), Predef.$eq$colon$eq$.MODULE$.tpEquals())).body()).fold((Function1 & Serializable & scala.Serializable)error -> new Failure((Throwable)new HttpError(error)), (Function1 & Serializable & scala.Serializable)body2 -> this.parseWorkersList((String)body2).map((Function1 & Serializable & scala.Serializable)x$15 -> (Seq)((TraversableLike)x$15.filter((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$activeWorkers$4(x$16)))).filter((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$activeWorkers$5(x$17)))).toTry(Predef$.MODULE$.$conforms()));
            }

            private Either<Error, Seq<SparkStateService.WorkerInfo>> parseWorkersList(String body2) {
                public final class Tech_ytsaurus_spark_launcher_SparkStateService$$anon$1$anon$lazy$macro$7$1
                implements scala.Serializable {
                    private ReprDecoder<.colon.colon<String, .colon.colon<Seq<String>, HNil>>> inst$macro$6;
                    private DerivedDecoder<SparkStateService.ResourceInfo> inst$macro$1;
                    private volatile byte bitmap$0;

                    private ReprDecoder<.colon.colon<String, .colon.colon<Seq<String>, HNil>>> inst$macro$6$lzycompute() {
                        Tech_ytsaurus_spark_launcher_SparkStateService$$anon$1$anon$lazy$macro$7$1 var1_1 = this;
                        synchronized (var1_1) {
                            if ((byte)(this.bitmap$0 & 1) == 0) {
                                this.inst$macro$6 = new ReprDecoder<.colon.colon<String, .colon.colon<Seq<String>, HNil>>>(null){
                                    private final Decoder<String> circeGenericDecoderForname;
                                    private final Decoder<Seq<String>> circeGenericDecoderForaddresses;

                                    public final Either<DecodingFailure, .colon.colon<String, .colon.colon<Seq<String>, HNil>>> apply(HCursor c) {
                                        return (Either)ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForname.tryDecode(c.downField("name")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForaddresses.tryDecode(c.downField("addresses")), (Object)ReprDecoder$.MODULE$.hnilResult(), (Apply)Decoder$.MODULE$.resultInstance()), (Apply)Decoder$.MODULE$.resultInstance());
                                    }

                                    public final Validated<NonEmptyList<DecodingFailure>, .colon.colon<String, .colon.colon<Seq<String>, HNil>>> decodeAccumulating(HCursor c) {
                                        return (Validated)ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForname.tryDecodeAccumulating(c.downField("name")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForaddresses.tryDecodeAccumulating(c.downField("addresses")), (Object)ReprDecoder$.MODULE$.hnilResultAccumulating(), (Apply)Decoder$.MODULE$.accumulatingResultInstance()), (Apply)Decoder$.MODULE$.accumulatingResultInstance());
                                    }
                                    {
                                        this.circeGenericDecoderForname = Decoder$.MODULE$.decodeString();
                                        this.circeGenericDecoderForaddresses = Decoder$.MODULE$.decodeSeq(Decoder$.MODULE$.decodeString());
                                    }
                                };
                                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                            }
                        }
                        return this.inst$macro$6;
                    }

                    public ReprDecoder<.colon.colon<String, .colon.colon<Seq<String>, HNil>>> inst$macro$6() {
                        return (byte)(this.bitmap$0 & 1) == 0 ? this.inst$macro$6$lzycompute() : this.inst$macro$6;
                    }

                    private DerivedDecoder<SparkStateService.ResourceInfo> inst$macro$1$lzycompute() {
                        Tech_ytsaurus_spark_launcher_SparkStateService$$anon$1$anon$lazy$macro$7$1 var1_1 = this;
                        synchronized (var1_1) {
                            if ((byte)(this.bitmap$0 & 2) == 0) {
                                this.inst$macro$1 = DerivedDecoder$.MODULE$.deriveDecoder(LabelledGeneric$.MODULE$.materializeProduct(DefaultSymbolicLabelling$.MODULE$.instance((HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "name"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "addresses"), (HList)HNil$.MODULE$))), Generic$.MODULE$.instance((Function1 & Serializable & scala.Serializable)x0$3 -> {
                                    SparkStateService.ResourceInfo resourceInfo = x0$3;
                                    if (resourceInfo == null) {
                                        throw new MatchError((Object)resourceInfo);
                                    }
                                    String pat$macro$4 = resourceInfo.name();
                                    Seq<String> pat$macro$5 = resourceInfo.addresses();
                                    .colon.colon colon2 = new .colon.colon((Object)pat$macro$4, (HList)new .colon.colon(pat$macro$5, (HList)HNil$.MODULE$));
                                    return colon2;
                                }, (Function1 & Serializable & scala.Serializable)x0$4 -> {
                                    Seq pat$macro$5;
                                    String pat$macro$4;
                                    block3: {
                                        .colon.colon colon2;
                                        block2: {
                                            colon2 = x0$4;
                                            if (colon2 == null) break block2;
                                            pat$macro$4 = (String)colon2.head();
                                            .colon.colon colon3 = (.colon.colon)colon2.tail();
                                            if (colon3 == null) break block2;
                                            pat$macro$5 = (Seq)colon3.head();
                                            HNil hNil = (HNil)colon3.tail();
                                            if (HNil$.MODULE$.equals(hNil)) break block3;
                                        }
                                        throw new MatchError((Object)colon2);
                                    }
                                    SparkStateService.ResourceInfo resourceInfo = new SparkStateService.ResourceInfo(pat$macro$4, (Seq<String>)pat$macro$5);
                                    return resourceInfo;
                                }), hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hnilZipWithKeys(), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "addresses"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "name"))), Predef$.MODULE$.$conforms()), Lazy$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.inst$macro$6()));
                                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                            }
                        }
                        return this.inst$macro$1;
                    }

                    public DerivedDecoder<SparkStateService.ResourceInfo> inst$macro$1() {
                        return (byte)(this.bitmap$0 & 2) == 0 ? this.inst$macro$1$lzycompute() : this.inst$macro$1;
                    }

                    public Tech_ytsaurus_spark_launcher_SparkStateService$$anon$1$anon$lazy$macro$7$1(anon.1 $outer) {
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$inst$macro$1$1(tech.ytsaurus.spark.launcher.SparkStateService$ResourceInfo ), $anonfun$inst$macro$1$2(shapeless.$colon$colon ), $anonfun$inst$macro$1$3(tech.ytsaurus.spark.launcher.SparkStateService$$anon$1$anon$lazy$macro$7$1 )}, serializedLambda);
                    }
                }
                DerivedDecoder<SparkStateService.ResourceInfo> inst$macro$8 = new Tech_ytsaurus_spark_launcher_SparkStateService$$anon$1$anon$lazy$macro$7$1(null).inst$macro$1();
                Decoder resourceDecoder = semiauto$.MODULE$.deriveDecoder(Lazy$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> inst$macro$8));
                public final class Tech_ytsaurus_spark_launcher_SparkStateService$$anon$1$anon$lazy$macro$27$1
                implements scala.Serializable {
                    private ReprDecoder<.colon.colon<String, .colon.colon<String, .colon.colon<Object, .colon.colon<Object, .colon.colon<Object, .colon.colon<String, .colon.colon<Object, .colon.colon<Map<String, SparkStateService.ResourceInfo>, HNil>>>>>>>>> inst$macro$26;
                    private DerivedDecoder<SparkStateService.WorkerInfo> inst$macro$9;
                    private volatile byte bitmap$0;
                    public final Decoder resourceDecoder$1;

                    private ReprDecoder<.colon.colon<String, .colon.colon<String, .colon.colon<Object, .colon.colon<Object, .colon.colon<Object, .colon.colon<String, .colon.colon<Object, .colon.colon<Map<String, SparkStateService.ResourceInfo>, HNil>>>>>>>>> inst$macro$26$lzycompute() {
                        Tech_ytsaurus_spark_launcher_SparkStateService$$anon$1$anon$lazy$macro$27$1 var1_1 = this;
                        synchronized (var1_1) {
                            if ((byte)(this.bitmap$0 & 1) == 0) {
                                this.inst$macro$26 = new ReprDecoder<.colon.colon<String, .colon.colon<String, .colon.colon<Object, .colon.colon<Object, .colon.colon<Object, .colon.colon<String, .colon.colon<Object, .colon.colon<Map<String, SparkStateService.ResourceInfo>, HNil>>>>>>>>>(this){
                                    private final Decoder<Object> circeGenericDecoderFormemory;
                                    private final Decoder<String> circeGenericDecoderForwebUiAddress;
                                    private final Decoder<Object> circeGenericDecoderForalive;
                                    private final Decoder<Map<String, SparkStateService.ResourceInfo>> circeGenericDecoderForresources;

                                    public final Either<DecodingFailure, .colon.colon<String, .colon.colon<String, .colon.colon<Object, .colon.colon<Object, .colon.colon<Object, .colon.colon<String, .colon.colon<Object, .colon.colon<Map<String, SparkStateService.ResourceInfo>, HNil>>>>>>>>> apply(HCursor c) {
                                        return (Either)ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForwebUiAddress.tryDecode(c.downField("id")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForwebUiAddress.tryDecode(c.downField("host")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderFormemory.tryDecode(c.downField("port")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderFormemory.tryDecode(c.downField("cores")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderFormemory.tryDecode(c.downField("memory")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForwebUiAddress.tryDecode(c.downField("webUiAddress")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForalive.tryDecode(c.downField("alive")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForresources.tryDecode(c.downField("resources")), (Object)ReprDecoder$.MODULE$.hnilResult(), (Apply)Decoder$.MODULE$.resultInstance()), (Apply)Decoder$.MODULE$.resultInstance()), (Apply)Decoder$.MODULE$.resultInstance()), (Apply)Decoder$.MODULE$.resultInstance()), (Apply)Decoder$.MODULE$.resultInstance()), (Apply)Decoder$.MODULE$.resultInstance()), (Apply)Decoder$.MODULE$.resultInstance()), (Apply)Decoder$.MODULE$.resultInstance());
                                    }

                                    public final Validated<NonEmptyList<DecodingFailure>, .colon.colon<String, .colon.colon<String, .colon.colon<Object, .colon.colon<Object, .colon.colon<Object, .colon.colon<String, .colon.colon<Object, .colon.colon<Map<String, SparkStateService.ResourceInfo>, HNil>>>>>>>>> decodeAccumulating(HCursor c) {
                                        return (Validated)ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForwebUiAddress.tryDecodeAccumulating(c.downField("id")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForwebUiAddress.tryDecodeAccumulating(c.downField("host")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderFormemory.tryDecodeAccumulating(c.downField("port")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderFormemory.tryDecodeAccumulating(c.downField("cores")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderFormemory.tryDecodeAccumulating(c.downField("memory")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForwebUiAddress.tryDecodeAccumulating(c.downField("webUiAddress")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForalive.tryDecodeAccumulating(c.downField("alive")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForresources.tryDecodeAccumulating(c.downField("resources")), (Object)ReprDecoder$.MODULE$.hnilResultAccumulating(), (Apply)Decoder$.MODULE$.accumulatingResultInstance()), (Apply)Decoder$.MODULE$.accumulatingResultInstance()), (Apply)Decoder$.MODULE$.accumulatingResultInstance()), (Apply)Decoder$.MODULE$.accumulatingResultInstance()), (Apply)Decoder$.MODULE$.accumulatingResultInstance()), (Apply)Decoder$.MODULE$.accumulatingResultInstance()), (Apply)Decoder$.MODULE$.accumulatingResultInstance()), (Apply)Decoder$.MODULE$.accumulatingResultInstance());
                                    }
                                    {
                                        this.circeGenericDecoderFormemory = Decoder$.MODULE$.decodeInt();
                                        this.circeGenericDecoderForwebUiAddress = Decoder$.MODULE$.decodeString();
                                        this.circeGenericDecoderForalive = Decoder$.MODULE$.decodeBoolean();
                                        this.circeGenericDecoderForresources = Decoder$.MODULE$.decodeMap(KeyDecoder$.MODULE$.decodeKeyString(), $outer.resourceDecoder$1);
                                    }
                                };
                                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                            }
                        }
                        return this.inst$macro$26;
                    }

                    public ReprDecoder<.colon.colon<String, .colon.colon<String, .colon.colon<Object, .colon.colon<Object, .colon.colon<Object, .colon.colon<String, .colon.colon<Object, .colon.colon<Map<String, SparkStateService.ResourceInfo>, HNil>>>>>>>>> inst$macro$26() {
                        return (byte)(this.bitmap$0 & 1) == 0 ? this.inst$macro$26$lzycompute() : this.inst$macro$26;
                    }

                    private DerivedDecoder<SparkStateService.WorkerInfo> inst$macro$9$lzycompute() {
                        Tech_ytsaurus_spark_launcher_SparkStateService$$anon$1$anon$lazy$macro$27$1 var1_1 = this;
                        synchronized (var1_1) {
                            if ((byte)(this.bitmap$0 & 2) == 0) {
                                this.inst$macro$9 = DerivedDecoder$.MODULE$.deriveDecoder(LabelledGeneric$.MODULE$.materializeProduct(DefaultSymbolicLabelling$.MODULE$.instance((HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "id"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "host"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "port"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "cores"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "memory"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "webUiAddress"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "alive"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "resources"), (HList)HNil$.MODULE$))))))))), Generic$.MODULE$.instance((Function1 & Serializable & scala.Serializable)x0$7 -> {
                                    SparkStateService.WorkerInfo workerInfo = x0$7;
                                    if (workerInfo == null) {
                                        throw new MatchError((Object)workerInfo);
                                    }
                                    String pat$macro$18 = workerInfo.id();
                                    String pat$macro$19 = workerInfo.host();
                                    int pat$macro$20 = workerInfo.port();
                                    int pat$macro$21 = workerInfo.cores();
                                    int pat$macro$22 = workerInfo.memory();
                                    String pat$macro$23 = workerInfo.webUiAddress();
                                    boolean pat$macro$24 = workerInfo.alive();
                                    Map<String, SparkStateService.ResourceInfo> pat$macro$25 = workerInfo.resources();
                                    .colon.colon colon2 = new .colon.colon((Object)pat$macro$18, (HList)new .colon.colon((Object)pat$macro$19, (HList)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)pat$macro$20), (HList)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)pat$macro$21), (HList)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)pat$macro$22), (HList)new .colon.colon((Object)pat$macro$23, (HList)new .colon.colon((Object)BoxesRunTime.boxToBoolean((boolean)pat$macro$24), (HList)new .colon.colon(pat$macro$25, (HList)HNil$.MODULE$))))))));
                                    return colon2;
                                }, (Function1 & Serializable & scala.Serializable)x0$8 -> {
                                    Map pat$macro$25;
                                    boolean pat$macro$24;
                                    String pat$macro$23;
                                    int pat$macro$22;
                                    int pat$macro$21;
                                    int pat$macro$20;
                                    String pat$macro$19;
                                    String pat$macro$18;
                                    block3: {
                                        .colon.colon colon2;
                                        block2: {
                                            colon2 = x0$8;
                                            if (colon2 == null) break block2;
                                            pat$macro$18 = (String)colon2.head();
                                            .colon.colon colon3 = (.colon.colon)colon2.tail();
                                            if (colon3 == null) break block2;
                                            pat$macro$19 = (String)colon3.head();
                                            .colon.colon colon4 = (.colon.colon)colon3.tail();
                                            if (colon4 == null) break block2;
                                            pat$macro$20 = BoxesRunTime.unboxToInt((Object)colon4.head());
                                            .colon.colon colon5 = (.colon.colon)colon4.tail();
                                            if (colon5 == null) break block2;
                                            pat$macro$21 = BoxesRunTime.unboxToInt((Object)colon5.head());
                                            .colon.colon colon6 = (.colon.colon)colon5.tail();
                                            if (colon6 == null) break block2;
                                            pat$macro$22 = BoxesRunTime.unboxToInt((Object)colon6.head());
                                            .colon.colon colon7 = (.colon.colon)colon6.tail();
                                            if (colon7 == null) break block2;
                                            pat$macro$23 = (String)colon7.head();
                                            .colon.colon colon8 = (.colon.colon)colon7.tail();
                                            if (colon8 == null) break block2;
                                            pat$macro$24 = BoxesRunTime.unboxToBoolean((Object)colon8.head());
                                            .colon.colon colon9 = (.colon.colon)colon8.tail();
                                            if (colon9 == null) break block2;
                                            pat$macro$25 = (Map)colon9.head();
                                            HNil hNil = (HNil)colon9.tail();
                                            if (HNil$.MODULE$.equals(hNil)) break block3;
                                        }
                                        throw new MatchError((Object)colon2);
                                    }
                                    SparkStateService.WorkerInfo workerInfo = new SparkStateService.WorkerInfo(pat$macro$18, pat$macro$19, pat$macro$20, pat$macro$21, pat$macro$22, pat$macro$23, pat$macro$24, (Map<String, SparkStateService.ResourceInfo>)pat$macro$25);
                                    return workerInfo;
                                }), hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hnilZipWithKeys(), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "resources"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "alive"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "webUiAddress"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "memory"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "cores"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "port"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "host"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "id"))), Predef$.MODULE$.$conforms()), Lazy$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.inst$macro$26()));
                                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                            }
                        }
                        return this.inst$macro$9;
                    }

                    public DerivedDecoder<SparkStateService.WorkerInfo> inst$macro$9() {
                        return (byte)(this.bitmap$0 & 2) == 0 ? this.inst$macro$9$lzycompute() : this.inst$macro$9;
                    }

                    public Tech_ytsaurus_spark_launcher_SparkStateService$$anon$1$anon$lazy$macro$27$1(anon.1 $outer, Decoder resourceDecoder$1) {
                        this.resourceDecoder$1 = resourceDecoder$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$inst$macro$9$1(tech.ytsaurus.spark.launcher.SparkStateService$WorkerInfo ), $anonfun$inst$macro$9$2(shapeless.$colon$colon ), $anonfun$inst$macro$9$3(tech.ytsaurus.spark.launcher.SparkStateService$$anon$1$anon$lazy$macro$27$1 )}, serializedLambda);
                    }
                }
                DerivedDecoder<SparkStateService.WorkerInfo> inst$macro$28 = new Tech_ytsaurus_spark_launcher_SparkStateService$$anon$1$anon$lazy$macro$27$1(null, resourceDecoder).inst$macro$9();
                Decoder workerDecoder = semiauto$.MODULE$.deriveDecoder(Lazy$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> inst$macro$28));
                SparkStateService$.MODULE$.tech$ytsaurus$spark$launcher$SparkStateService$$log().debug(new StringBuilder(17).append("parseWorkerList:\n").append(body2).toString());
                return package$.MODULE$.parse(body2).map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.hcursor()).flatMap((Function1 & Serializable & scala.Serializable)cursor -> cursor.downField("workers").as(Decoder$.MODULE$.decodeSeq(workerDecoder)).map((Function1 & Serializable & scala.Serializable)workers -> workers));
            }

            public Seq<Try<SparkStateService.WorkerStats>> workerStats(Seq<SparkStateService.WorkerInfo> workers) {
                return (Seq)workers.map((Function1 & Serializable & scala.Serializable)wi -> {
                    SparkStateService$.MODULE$.tech$ytsaurus$spark$launcher$SparkStateService$$log().debug(new StringBuilder(9).append("querying ").append(wi.metricsUrl()).toString());
                    return (Try)((Either)((Response)sttp.client.package$.MODULE$.basicRequest().get(wi.metricsUrl()).send(this.backend(), Predef.$eq$colon$eq$.MODULE$.tpEquals())).body()).fold((Function1 & Serializable & scala.Serializable)error -> new Failure((Throwable)new HttpError(error)), (Function1 & Serializable & scala.Serializable)body2 -> this.parseWorkerMetrics((String)body2, (SparkStateService.WorkerInfo)wi));
                }, Seq$.MODULE$.canBuildFrom());
            }

            public Seq<SparkStateService.WorkerInfo> idleWorkers(Seq<SparkStateService.WorkerInfo> workers) {
                Seq<Try<SparkStateService.WorkerStats>> stats = this.workerStats(workers);
                return (Seq)((TraversableLike)((TraversableLike)((TraversableLike)workers.zip(stats, Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$idleWorkers$1(x$19)))).filter((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$idleWorkers$2(x$20)))).map((Function1 & Serializable & scala.Serializable)x$21 -> (SparkStateService.WorkerInfo)x$21._1(), Seq$.MODULE$.canBuildFrom());
            }

            private Try<Map<String, Object>> parseMetrics(String prefix, String resp, boolean ignoreNotMatching) {
                SparkStateService$.MODULE$.tech$ytsaurus$spark$launcher$SparkStateService$$log().debug(new StringBuilder(16).append("parseMetrics: ").append(prefix).append(": ").append(resp).toString());
                Regex matcher = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(32).append("metrics_").append(prefix).append("_(.*?)_Value\\{.*?} (\\d+)").toString())).r();
                return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(resp)).split('\n'))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Iterable iterable;
                    String string = x0$1;
                    Option option = matcher.unapplySeq((CharSequence)string);
                    if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
                        String name = (String)((LinearSeqOptimized)option.get()).apply(0);
                        String value = (String)((LinearSeqOptimized)option.get()).apply(1);
                        iterable = Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)new Tuple2((Object)name, (Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(value)).toLong()))));
                    } else {
                        if (ignoreNotMatching) {
                            SparkStateService$.MODULE$.tech$ytsaurus$spark$launcher$SparkStateService$$log().debug(new StringBuilder(32).append("Unable to parse metrics string: ").append(string).toString());
                        } else {
                            SparkStateService$.MODULE$.tech$ytsaurus$spark$launcher$SparkStateService$$log().warn(new StringBuilder(32).append("Unable to parse metrics string: ").append(string).toString());
                        }
                        iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    }
                    return iterable;
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms()));
            }

            private boolean parseMetrics$default$3() {
                return false;
            }

            public Try<SparkStateService.WorkerStats> parseWorkerMetrics(String resp, SparkStateService.WorkerInfo wi) {
                return this.parseMetrics("worker", resp, this.parseMetrics$default$3()).map((Function1 & Serializable & scala.Serializable)metrics -> new SparkStateService.WorkerStats(wi.cores(), BoxesRunTime.unboxToLong((Object)metrics.apply((Object)"coresUsed")), BoxesRunTime.unboxToLong((Object)metrics.apply((Object)"executors")), BoxesRunTime.unboxToLong((Object)metrics.apply((Object)"memFree_MB")), BoxesRunTime.unboxToLong((Object)metrics.apply((Object)"memUsed_MB"))));
            }

            public Try<SparkStateService.MasterStats> parseMasterMetrics(String resp) {
                return this.parseMetrics("master", resp, this.parseMetrics$default$3()).map((Function1 & Serializable & scala.Serializable)metrics -> new SparkStateService.MasterStats(BoxesRunTime.unboxToLong((Object)metrics.apply((Object)"aliveWorkers")), BoxesRunTime.unboxToLong((Object)metrics.apply((Object)"workers")), BoxesRunTime.unboxToLong((Object)metrics.apply((Object)"apps")), BoxesRunTime.unboxToLong((Object)metrics.apply((Object)"waitingApps"))));
            }

            public Try<Seq<SparkStateService.AppStats>> parseAppMetrics(String resp) {
                Regex matcher = new StringOps(Predef$.MODULE$.augmentString("^(.*?)_(cores|runtime_ms)$")).r();
                return this.parseMetrics("application", resp, true).map((Function1 & Serializable & scala.Serializable)metrics -> (Seq)((TraversableLike)metrics.flatMap((Function1 & Serializable & scala.Serializable)kv -> Option$.MODULE$.option2Iterable(anon.1.split$1((String)kv._1(), matcher).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String appName = (String)tuple2._1();
                    String metric = (String)tuple2._2();
                    Tuple3 tuple3 = new Tuple3((Object)appName, (Object)metric, (Object)BoxesRunTime.boxToLong((long)kv._2$mcJ$sp()));
                    return tuple3;
                })), Iterable$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$22 -> (String)x$22._1()).toSeq().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String appName = (String)tuple2._1();
                    scala.collection.immutable.Iterable vs = (scala.collection.immutable.Iterable)tuple2._2();
                    Map m = ((TraversableOnce)vs.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                        Tuple3 tuple3 = x0$3;
                        if (tuple3 == null) {
                            throw new MatchError((Object)tuple3);
                        }
                        String metric = (String)tuple3._2();
                        long value = BoxesRunTime.unboxToLong((Object)tuple3._3());
                        Tuple2 tuple2 = new Tuple2((Object)metric, (Object)BoxesRunTime.boxToLong((long)value));
                        return tuple2;
                    }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    SparkStateService.AppStats appStats = new SparkStateService.AppStats(appName, BoxesRunTime.unboxToLong((Object)m.getOrElse((Object)"cores", (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), (Duration)new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(BoxesRunTime.unboxToLong((Object)m.getOrElse((Object)"runtime_ms", (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)))).millis());
                    return appStats;
                }, Seq$.MODULE$.canBuildFrom()));
            }

            public static final /* synthetic */ void $anonfun$ec$1(Throwable ex) {
                SparkStateService$.MODULE$.tech$ytsaurus$spark$launcher$SparkStateService$$log().error("Failed spark state query", ex);
            }

            public static final /* synthetic */ boolean $anonfun$query$9(SparkStateService.WorkerStats x$2) {
                return x$2.coresUsed() > 0L;
            }

            public static final /* synthetic */ long $anonfun$query$10(SparkStateService.WorkerStats x$3) {
                return x$3.coresTotal();
            }

            public static final /* synthetic */ long $anonfun$query$11(SparkStateService.WorkerStats x$4) {
                return x$4.coresUsed();
            }

            public static final /* synthetic */ boolean $anonfun$queryAppStatuses$3(AppStatusesRestClient.AppStatus x$5) {
                return !x$5.state().isFinished();
            }

            public static final /* synthetic */ boolean $anonfun$queryAppStatuses$4(AppStatusesRestClient.AppStatus x$6) {
                AppStatusesRestClient.AppState appState = x$6.state();
                AppStatusesRestClient$AppState$WAITING$ appStatusesRestClient$AppState$WAITING$ = AppStatusesRestClient$AppState$WAITING$.MODULE$;
                return !(appState != null ? !appState.equals(appStatusesRestClient$AppState$WAITING$) : appStatusesRestClient$AppState$WAITING$ != null);
            }

            public static final /* synthetic */ long $anonfun$queryAppStatuses$5(AppStatusesRestClient.AppStatus x$7) {
                return x$7.runtime(x$7.runtime$default$1());
            }

            public static final /* synthetic */ long $anonfun$queryAppStatuses$7(AppStatusesRestClient.SubmissionStatus x$10) {
                return x$10.runtime(x$10.runtime$default$1());
            }

            public static final /* synthetic */ boolean $anonfun$queryAppStatuses$9(AppStatusesRestClient.AppStatus x$13) {
                AppStatusesRestClient.AppState appState = x$13.state();
                AppStatusesRestClient$AppState$RUNNING$ appStatusesRestClient$AppState$RUNNING$ = AppStatusesRestClient$AppState$RUNNING$.MODULE$;
                return !(appState != null ? !appState.equals(appStatusesRestClient$AppState$RUNNING$) : appStatusesRestClient$AppState$RUNNING$ != null);
            }

            public static final /* synthetic */ boolean $anonfun$queryAppStatuses$10(AppStatusesRestClient.AppStatus x$14) {
                AppStatusesRestClient.AppState appState = x$14.state();
                AppStatusesRestClient$AppState$WAITING$ appStatusesRestClient$AppState$WAITING$ = AppStatusesRestClient$AppState$WAITING$.MODULE$;
                return !(appState != null ? !appState.equals(appStatusesRestClient$AppState$WAITING$) : appStatusesRestClient$AppState$WAITING$ != null);
            }

            public static final /* synthetic */ boolean $anonfun$activeWorkers$4(SparkStateService.WorkerInfo x$16) {
                return !x$16.isDriverOp();
            }

            public static final /* synthetic */ boolean $anonfun$activeWorkers$5(SparkStateService.WorkerInfo x$17) {
                return x$17.alive();
            }

            public static final /* synthetic */ boolean $anonfun$idleWorkers$1(Tuple2 x$19) {
                return ((Try)x$19._2()).isSuccess();
            }

            public static final /* synthetic */ boolean $anonfun$idleWorkers$2(Tuple2 x$20) {
                return ((SparkStateService.WorkerStats)((Try)x$20._2()).get()).coresUsed() == 0L;
            }

            private static final Option split$1(String s, Regex matcher$2) {
                None$ none$;
                String string = s;
                Option option = matcher$2.unapplySeq((CharSequence)string);
                if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
                    String appName = (String)((LinearSeqOptimized)option.get()).apply(0);
                    String metric = (String)((LinearSeqOptimized)option.get()).apply(1);
                    none$ = new Some((Object)new Tuple2((Object)appName, (Object)metric));
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            }
            {
                this.rest$1 = rest$1;
                this.webUi$1 = webUi$1;
                this.restClient = AppStatusesRestClient$.MODULE$.create(rest$1);
                this.backend = HttpURLConnectionBackend$.MODULE$.apply(HttpURLConnectionBackend$.MODULE$.apply$default$1(), HttpURLConnectionBackend$.MODULE$.apply$default$2(), HttpURLConnectionBackend$.MODULE$.apply$default$3(), HttpURLConnectionBackend$.MODULE$.apply$default$4());
                this.es = Executors.newFixedThreadPool(SparkStateService$.MODULE$.tech$ytsaurus$spark$launcher$SparkStateService$$sparkStateQueryThreads());
                this.ec = ExecutionContext$.MODULE$.fromExecutorService(this.es(), (Function1 & Serializable & scala.Serializable)ex -> {
                    anon.1.$anonfun$ec$1(ex);
                    return BoxedUnit.UNIT;
                });
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$query$1(tech.ytsaurus.spark.launcher.SparkStateService$$anon$1 scala.collection.Seq ), $anonfun$queryAppStatuses$1(tech.ytsaurus.spark.launcher.SparkStateService$$anon$1 scala.collection.Seq ), $anonfun$masterStats$1(java.lang.String ), $anonfun$masterStats$2(tech.ytsaurus.spark.launcher.SparkStateService$$anon$1 java.lang.String ), $anonfun$appStats$1(java.lang.String ), $anonfun$appStats$2(tech.ytsaurus.spark.launcher.SparkStateService$$anon$1 java.lang.String ), $anonfun$activeWorkers$1(java.lang.String ), $anonfun$activeWorkers$2(tech.ytsaurus.spark.launcher.SparkStateService$$anon$1 java.lang.String ), $anonfun$parseWorkersList$1(io.circe.generic.decoding.DerivedDecoder ), $anonfun$parseWorkersList$2(io.circe.generic.decoding.DerivedDecoder ), $anonfun$parseWorkersList$3(io.circe.Json ), $anonfun$parseWorkersList$4(io.circe.Decoder io.circe.HCursor ), $anonfun$workerStats$1(tech.ytsaurus.spark.launcher.SparkStateService$$anon$1 tech.ytsaurus.spark.launcher.SparkStateService$WorkerInfo ), $anonfun$idleWorkers$1$adapted(scala.Tuple2 ), $anonfun$idleWorkers$2$adapted(scala.Tuple2 ), $anonfun$idleWorkers$3(scala.Tuple2 ), $anonfun$parseMetrics$1(java.lang.String scala.util.matching.Regex boolean ), $anonfun$parseWorkerMetrics$1(tech.ytsaurus.spark.launcher.SparkStateService$WorkerInfo scala.collection.immutable.Map ), $anonfun$parseMasterMetrics$1(scala.collection.immutable.Map ), $anonfun$parseAppMetrics$1(scala.util.matching.Regex scala.collection.immutable.Map ), $anonfun$query$5(scala.collection.Seq tech.ytsaurus.spark.launcher.SparkStateService$WorkerStats ), $anonfun$query$4(scala.util.Try scala.collection.Seq ), $anonfun$query$9$adapted(tech.ytsaurus.spark.launcher.SparkStateService$WorkerStats ), $anonfun$query$10$adapted(tech.ytsaurus.spark.launcher.SparkStateService$WorkerStats ), $anonfun$query$11$adapted(tech.ytsaurus.spark.launcher.SparkStateService$WorkerStats ), $anonfun$query$8(scala.collection.Seq scala.collection.Seq tech.ytsaurus.spark.launcher.SparkStateService$MasterStats tech.ytsaurus.spark.launcher.SparkStateService$AppStatusesStats ), $anonfun$query$7(tech.ytsaurus.spark.launcher.SparkStateService$$anon$1 scala.collection.Seq scala.collection.Seq tech.ytsaurus.spark.launcher.SparkStateService$MasterStats ), $anonfun$query$2(), $anonfun$query$3(scala.util.Try scala.util.Try ), $anonfun$query$6(tech.ytsaurus.spark.launcher.SparkStateService$$anon$1 scala.collection.Seq scala.collection.Seq ), $anonfun$queryAppStatuses$3$adapted(tech.ytsaurus.spark.launcher.rest.AppStatusesRestClient$AppStatus ), $anonfun$queryAppStatuses$4$adapted(tech.ytsaurus.spark.launcher.rest.AppStatusesRestClient$AppStatus ), $anonfun$queryAppStatuses$5$adapted(tech.ytsaurus.spark.launcher.rest.AppStatusesRestClient$AppStatus ), $anonfun$queryAppStatuses$6(long long ), $anonfun$queryAppStatuses$7$adapted(tech.ytsaurus.spark.launcher.rest.AppStatusesRestClient$SubmissionStatus ), $anonfun$queryAppStatuses$8(long long ), $anonfun$queryAppStatuses$9$adapted(tech.ytsaurus.spark.launcher.rest.AppStatusesRestClient$AppStatus ), $anonfun$queryAppStatuses$10$adapted(tech.ytsaurus.spark.launcher.rest.AppStatusesRestClient$AppStatus ), $anonfun$queryAppStatuses$2(scala.collection.Seq scala.collection.Seq ), $anonfun$activeWorkers$4$adapted(tech.ytsaurus.spark.launcher.SparkStateService$WorkerInfo ), $anonfun$activeWorkers$5$adapted(tech.ytsaurus.spark.launcher.SparkStateService$WorkerInfo ), $anonfun$activeWorkers$3(scala.collection.Seq ), $anonfun$parseWorkersList$5(scala.collection.Seq ), $anonfun$workerStats$2(java.lang.String ), $anonfun$workerStats$3(tech.ytsaurus.spark.launcher.SparkStateService$$anon$1 tech.ytsaurus.spark.launcher.SparkStateService$WorkerInfo java.lang.String ), $anonfun$parseMetrics$2(scala.util.matching.Regex boolean java.lang.String ), $anonfun$parseAppMetrics$3(scala.Tuple2 scala.Tuple2 ), $anonfun$parseAppMetrics$6(scala.Tuple3 ), $anonfun$parseAppMetrics$7(), $anonfun$parseAppMetrics$8(), $anonfun$parseAppMetrics$2(scala.util.matching.Regex scala.Tuple2 ), $anonfun$parseAppMetrics$4(scala.Tuple3 ), $anonfun$parseAppMetrics$5(scala.Tuple2 ), $anonfun$ec$1$adapted(java.lang.Throwable )}, serializedLambda);
            }
        };
    }

    private SparkStateService$() {
        MODULE$ = this;
        this.tech$ytsaurus$spark$launcher$SparkStateService$$sparkStateQueryThreads = 8;
        this.tech$ytsaurus$spark$launcher$SparkStateService$$log = LoggerFactory.getLogger(this.getClass());
    }
}

