/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.ysontree;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import tech.ytsaurus.ysontree.YTreeBooleanNode;
import tech.ytsaurus.ysontree.YTreeBooleanNodeImpl;
import tech.ytsaurus.ysontree.YTreeBuilder;
import tech.ytsaurus.ysontree.YTreeDoubleNode;
import tech.ytsaurus.ysontree.YTreeDoubleNodeImpl;
import tech.ytsaurus.ysontree.YTreeEntityNode;
import tech.ytsaurus.ysontree.YTreeEntityNodeImpl;
import tech.ytsaurus.ysontree.YTreeIntegerNode;
import tech.ytsaurus.ysontree.YTreeIntegerNodeImpl;
import tech.ytsaurus.ysontree.YTreeNode;
import tech.ytsaurus.ysontree.YTreeStringNode;
import tech.ytsaurus.ysontree.YTreeStringNodeImpl;

public final class YTree {
    private YTree() {
    }

    public static YTreeNode deepCopy(@Nonnull YTreeNode node) {
        return YTree.builder().value(node).build();
    }

    public static YTreeBuilder builder() {
        return new YTreeBuilder();
    }

    public static YTreeBuilder mapBuilder() {
        return YTree.builder().beginMap();
    }

    public static YTreeBuilder listBuilder() {
        return YTree.builder().beginList();
    }

    public static YTreeBuilder attributesBuilder() {
        return YTree.builder().beginAttributes();
    }

    public static YTreeNode node(@Nullable Object value) {
        return YTree.builder().value(value).build();
    }

    public static YTreeBooleanNode booleanNode(boolean value) {
        return new YTreeBooleanNodeImpl(value, null);
    }

    public static YTreeDoubleNode doubleNode(double value) {
        return new YTreeDoubleNodeImpl(value, null);
    }

    public static YTreeIntegerNode integerNode(long value) {
        return new YTreeIntegerNodeImpl(true, value, null);
    }

    public static YTreeIntegerNode unsignedIntegerNode(long value) {
        return new YTreeIntegerNodeImpl(false, value, null);
    }

    public static YTreeIntegerNode longNode(long value) {
        return new YTreeIntegerNodeImpl(true, value, null);
    }

    public static YTreeIntegerNode unsignedLongNode(long value) {
        return new YTreeIntegerNodeImpl(false, value, null);
    }

    public static YTreeStringNode stringNode(@Nonnull String value) {
        return new YTreeStringNodeImpl(value, null);
    }

    public static YTreeStringNode bytesNode(@Nonnull byte[] value) {
        return new YTreeStringNodeImpl(value, null);
    }

    public static YTreeEntityNode entityNode() {
        return new YTreeEntityNodeImpl(null);
    }

    public static YTreeEntityNode nullNode() {
        return YTree.entityNode();
    }

    public static YTreeNode booleanOrNullNode(@Nullable Boolean value) {
        return value == null ? YTree.nullNode() : YTree.booleanNode(value);
    }

    public static YTreeNode doubleOrNullNode(@Nullable Double value) {
        return value == null ? YTree.nullNode() : YTree.doubleNode(value);
    }

    public static YTreeNode integerOrNullNode(@Nullable Integer value) {
        return value == null ? YTree.nullNode() : YTree.integerNode(value.intValue());
    }

    public static YTreeNode unsignedIntegerOrNullNode(@Nullable Integer value) {
        return value == null ? YTree.nullNode() : YTree.unsignedIntegerNode(value.intValue());
    }

    public static YTreeNode longOrNullNode(@Nullable Long value) {
        return value == null ? YTree.nullNode() : YTree.longNode(value);
    }

    public static YTreeNode unsignedLongOrNullNode(@Nullable Long value) {
        return value == null ? YTree.nullNode() : YTree.unsignedLongNode(value);
    }

    public static YTreeNode stringOrNullNode(@Nullable String value) {
        return value == null ? YTree.nullNode() : YTree.stringNode(value);
    }

    public static YTreeNode bytesOrNullNode(@Nullable byte[] value) {
        return value == null ? YTree.nullNode() : YTree.bytesNode(value);
    }
}

