/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.ysontree;

import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import tech.ytsaurus.yson.YsonConsumer;
import tech.ytsaurus.ysontree.YTreeBooleanNodeImpl;
import tech.ytsaurus.ysontree.YTreeDoubleNodeImpl;
import tech.ytsaurus.ysontree.YTreeEntityNodeImpl;
import tech.ytsaurus.ysontree.YTreeIntegerNodeImpl;
import tech.ytsaurus.ysontree.YTreeListNode;
import tech.ytsaurus.ysontree.YTreeListNodeImpl;
import tech.ytsaurus.ysontree.YTreeMapNode;
import tech.ytsaurus.ysontree.YTreeMapNodeImpl;
import tech.ytsaurus.ysontree.YTreeNode;
import tech.ytsaurus.ysontree.YTreeNodeUtils;
import tech.ytsaurus.ysontree.YTreeStringNodeImpl;

public class YTreeBuilder
implements YsonConsumer {
    private final Deque<State> states = new ArrayDeque<State>();

    public YTreeBuilder apply(Function<YTreeBuilder, YTreeBuilder> func) {
        return func.apply(this);
    }

    public YTreeBuilder value(Collection<?> c) {
        this.beginList();
        for (Object node : c) {
            this.value(node);
        }
        return this.endList();
    }

    public <T> YTreeBuilder value(Collection<? extends T> c, BiFunction<YTreeBuilder, ? super T, YTreeBuilder> f) {
        YTreeBuilder builder = this.beginList();
        for (T e : c) {
            builder = f.apply(builder, (YTreeBuilder)e);
        }
        return builder.endList();
    }

    public YTreeBuilder value(Map<String, ?> m) {
        this.beginMap();
        for (Map.Entry<String, ?> e : m.entrySet()) {
            this.key(e.getKey()).value(e.getValue());
        }
        return this.endMap();
    }

    public YTreeBuilder value(@Nullable Object obj) {
        if (obj == null) {
            return this.entity();
        }
        if (obj instanceof YTreeNode) {
            return this.value((YTreeNode)obj);
        }
        if (obj instanceof Boolean) {
            return this.value((boolean)((Boolean)obj));
        }
        if (obj instanceof Float) {
            return this.value(((Float)obj).floatValue());
        }
        if (obj instanceof Double) {
            return this.value((double)((Double)obj));
        }
        if (obj instanceof Integer) {
            return this.value((int)((Integer)obj));
        }
        if (obj instanceof Long) {
            return this.value((long)((Long)obj));
        }
        if (obj.getClass().getName().equals("ru.yandex.misc.lang.number.UnsignedLong")) {
            try {
                Method method = obj.getClass().getMethod("longValue", new Class[0]);
                return this.value((Long)method.invoke(obj, new Object[0]), false);
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (obj.getClass().getName().equals("ru.yandex.misc.lang.number.UnsignedInteger")) {
            try {
                Method method = obj.getClass().getMethod("longValue", new Class[0]);
                return this.value((Long)method.invoke(obj, new Object[0]), false);
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (obj instanceof String) {
            return this.value((String)obj);
        }
        if (obj instanceof byte[]) {
            return this.value((byte[])obj);
        }
        if (obj instanceof int[]) {
            return this.value((int[])obj);
        }
        if (obj instanceof long[]) {
            return this.value((long[])obj);
        }
        if (obj instanceof float[]) {
            return this.value((float[])obj);
        }
        if (obj instanceof double[]) {
            return this.value((double[])obj);
        }
        if (obj instanceof String[]) {
            return this.value((String[])obj);
        }
        if (obj instanceof Collection) {
            return this.value((Collection)obj);
        }
        if (obj instanceof Map) {
            return this.value((Map)obj);
        }
        throw new IllegalArgumentException("Can't resolve method for " + obj.getClass().getName() + ": " + String.valueOf(obj));
    }

    public YTreeBuilder value(YTreeNode node) {
        YTreeNodeUtils.walk(node, this, true);
        return this;
    }

    public YTreeBuilder value(boolean value) {
        return this.push((Map<String, YTreeNode> attributes) -> new YTreeBooleanNodeImpl(value, (Map<String, YTreeNode>)attributes));
    }

    public YTreeBuilder value(@Nullable Boolean value) {
        return value == null ? this.entity() : this.push((Map<String, YTreeNode> attributes) -> new YTreeBooleanNodeImpl(value, (Map<String, YTreeNode>)attributes));
    }

    public YTreeBuilder value(double value) {
        return this.push((Map<String, YTreeNode> attributes) -> new YTreeDoubleNodeImpl(value, (Map<String, YTreeNode>)attributes));
    }

    public YTreeBuilder value(@Nullable Double value) {
        return value == null ? this.entity() : this.push((Map<String, YTreeNode> attributes) -> new YTreeDoubleNodeImpl(value, (Map<String, YTreeNode>)attributes));
    }

    public YTreeBuilder value(long value) {
        return this.push((Map<String, YTreeNode> attributes) -> new YTreeIntegerNodeImpl(true, value, (Map<String, YTreeNode>)attributes));
    }

    public YTreeBuilder value(@Nullable Long value) {
        return this.value(value, true);
    }

    public YTreeBuilder value(@Nullable Long value, boolean signed) {
        return value == null ? this.entity() : this.push((Map<String, YTreeNode> attributes) -> new YTreeIntegerNodeImpl(signed, value, (Map<String, YTreeNode>)attributes));
    }

    public YTreeBuilder unsignedValue(long value) {
        return this.push((Map<String, YTreeNode> attributes) -> new YTreeIntegerNodeImpl(false, value, (Map<String, YTreeNode>)attributes));
    }

    public YTreeBuilder unsignedValue(@Nullable Long value) {
        return value == null ? this.entity() : this.push((Map<String, YTreeNode> attributes) -> new YTreeIntegerNodeImpl(false, value, (Map<String, YTreeNode>)attributes));
    }

    public YTreeBuilder value(int value) {
        return this.push((Map<String, YTreeNode> attributes) -> new YTreeIntegerNodeImpl(true, value, (Map<String, YTreeNode>)attributes));
    }

    public YTreeBuilder value(@Nullable Integer value) {
        return value == null ? this.entity() : this.push((Map<String, YTreeNode> attributes) -> new YTreeIntegerNodeImpl(true, value.intValue(), (Map<String, YTreeNode>)attributes));
    }

    public YTreeBuilder unsignedValue(int value) {
        return this.push((Map<String, YTreeNode> attributes) -> new YTreeIntegerNodeImpl(false, value, (Map<String, YTreeNode>)attributes));
    }

    public YTreeBuilder unsignedValue(@Nullable Integer value) {
        return value == null ? this.entity() : this.push((Map<String, YTreeNode> attributes) -> new YTreeIntegerNodeImpl(false, value.intValue(), (Map<String, YTreeNode>)attributes));
    }

    public YTreeBuilder value(@Nullable String value) {
        return value == null ? this.entity() : this.push((Map<String, YTreeNode> attributes) -> new YTreeStringNodeImpl(value, (Map<String, YTreeNode>)attributes));
    }

    public YTreeBuilder value(@Nullable byte[] values) {
        return values == null ? this.entity() : this.push((Map<String, YTreeNode> attributes) -> new YTreeStringNodeImpl(values, (Map<String, YTreeNode>)attributes));
    }

    public YTreeBuilder value(int[] values) {
        this.beginList();
        for (int value : values) {
            this.value(value);
        }
        return this.endList();
    }

    public YTreeBuilder value(long[] values) {
        this.beginList();
        for (long value : values) {
            this.value(value);
        }
        return this.endList();
    }

    public YTreeBuilder value(float[] values) {
        this.beginList();
        for (float value : values) {
            this.value(value);
        }
        return this.endList();
    }

    public YTreeBuilder value(double[] values) {
        this.beginList();
        for (double value : values) {
            this.value(value);
        }
        return this.endList();
    }

    public YTreeBuilder value(String[] values) {
        this.beginList();
        for (String value : values) {
            this.value(value);
        }
        return this.endList();
    }

    public YTreeBuilder entity() {
        return this.push(YTreeEntityNodeImpl::new);
    }

    public YTreeBuilder when(boolean condition, Function<YTreeBuilder, YTreeBuilder> callback) {
        if (condition) {
            return callback.apply(this);
        }
        return this;
    }

    public <T> YTreeBuilder forEach(Iterable<T> iterable, BiConsumer<YTreeBuilder, T> actionPerElement) {
        return this.forEach(iterable.iterator(), actionPerElement);
    }

    public <T> YTreeBuilder forEach(Iterator<T> iterator, BiConsumer<YTreeBuilder, T> actionPerElement) {
        while (iterator.hasNext()) {
            actionPerElement.accept(this, (YTreeBuilder)iterator.next());
        }
        return this;
    }

    public YTreeBuilder beginList() {
        Map<String, YTreeNode> attributes = this.getAttributes();
        YTreeListNodeImpl node = new YTreeListNodeImpl(attributes);
        this.states.push(new ListState(node));
        return this;
    }

    public YTreeBuilder endList() {
        if (this.states.isEmpty() || !(this.states.peek() instanceof ListState)) {
            throw new IllegalStateException();
        }
        ListState list = (ListState)this.states.pop();
        return this.push(list.node);
    }

    public YTreeBuilder beginMap() {
        Map<String, YTreeNode> attributes = this.getAttributes();
        YTreeMapNodeImpl node = new YTreeMapNodeImpl(attributes);
        this.states.push(new MapState(node));
        return this;
    }

    public YTreeBuilder endMap() {
        if (this.states.isEmpty() || !(this.states.peek() instanceof MapState)) {
            throw new IllegalStateException();
        }
        MapState map = (MapState)this.states.pop();
        return this.push(map.node);
    }

    public YTreeBuilder beginAttributes() {
        if (!this.states.isEmpty() && this.states.peek() instanceof AttributesState) {
            throw new IllegalArgumentException();
        }
        this.states.push(new AttributesState());
        return this;
    }

    public YTreeBuilder endAttributes() {
        if (this.states.isEmpty() || !(this.states.peek() instanceof AttributesState)) {
            throw new IllegalStateException();
        }
        AttributesState attr = (AttributesState)this.states.peek();
        if (attr.finished) {
            throw new IllegalStateException();
        }
        attr.finished = true;
        return this;
    }

    public YTreeBuilder key(String key) {
        this.states.push(new KeyedItemState(key));
        return this;
    }

    public YTreeNode build() {
        if (this.states.size() != 1) {
            throw new IllegalStateException();
        }
        State s = this.states.pop();
        if (!(s instanceof ResultState)) {
            throw new IllegalStateException();
        }
        return ((ResultState)s).node;
    }

    public YTreeMapNode buildMap() {
        return this.endMap().build().mapNode();
    }

    public YTreeListNode buildList() {
        return this.endList().build().listNode();
    }

    public Map<String, YTreeNode> buildAttributes() {
        Map<String, YTreeNode> attributes = this.endAttributes().getAttributes();
        if (!this.states.isEmpty()) {
            throw new IllegalStateException();
        }
        return attributes;
    }

    public void onInteger(long value) {
        this.value(value);
    }

    public void onUnsignedInteger(long value) {
        this.value(value, false);
    }

    public void onBoolean(boolean value) {
        this.value(value);
    }

    public void onDouble(double value) {
        this.value(value);
    }

    public void onString(@Nonnull String value) {
        this.value(value);
    }

    public void onString(@Nonnull byte[] bytes, int offset, int length) {
        this.value(Arrays.copyOfRange(bytes, offset, offset + length));
    }

    public void onEntity() {
        this.entity();
    }

    public void onListItem() {
    }

    public void onBeginList() {
        this.beginList();
    }

    public void onEndList() {
        this.endList();
    }

    public void onBeginAttributes() {
        this.beginAttributes();
    }

    public void onEndAttributes() {
        this.endAttributes();
    }

    public void onBeginMap() {
        this.beginMap();
    }

    public void onEndMap() {
        this.endMap();
    }

    public void onKeyedItem(@Nonnull byte[] value, int offset, int length) {
        this.onKeyedItem(new String(value, offset, length, StandardCharsets.UTF_8));
    }

    public void onKeyedItem(@Nonnull String key) {
        this.key(key);
    }

    private Map<String, YTreeNode> getAttributes() {
        Map<String, YTreeNode> attributes = null;
        if (!this.states.isEmpty() && this.states.peek() instanceof AttributesState) {
            AttributesState attr = (AttributesState)this.states.peek();
            if (!attr.finished) {
                throw new IllegalStateException();
            }
            attributes = attr.map;
            this.states.pop();
        }
        return attributes;
    }

    private YTreeBuilder push(YTreeNode node) {
        if (this.states.isEmpty()) {
            this.states.push(new ResultState(node));
            return this;
        }
        if (this.states.peek() instanceof KeyedItemState) {
            String key = ((KeyedItemState)this.states.pop()).key;
            if (this.states.isEmpty()) {
                throw new IllegalStateException();
            }
            if (this.states.peek() instanceof MapState) {
                MapState map = (MapState)this.states.peek();
                map.node.put(key, node);
                return this;
            }
            if (this.states.peek() instanceof AttributesState) {
                AttributesState attr = (AttributesState)this.states.peek();
                if (attr.finished) {
                    throw new IllegalStateException();
                }
                attr.map.put(key, node);
                return this;
            }
            throw new IllegalStateException();
        }
        if (this.states.peek() instanceof ListState) {
            ListState list = (ListState)this.states.peek();
            list.node.add(node);
            return this;
        }
        throw new IllegalStateException();
    }

    private YTreeBuilder push(Function<Map<String, YTreeNode>, YTreeNode> function) {
        Map<String, YTreeNode> attributes = this.getAttributes();
        return this.push(function.apply(attributes));
    }

    private static class KeyedItemState
    extends State {
        private final String key;

        KeyedItemState(String key) {
            this.key = key;
        }
    }

    private static class AttributesState
    extends State {
        private final Map<String, YTreeNode> map = new HashMap<String, YTreeNode>();
        private boolean finished = false;

        private AttributesState() {
        }
    }

    private static class MapState
    extends State {
        private final YTreeMapNode node;

        MapState(YTreeMapNode node) {
            this.node = node;
        }
    }

    private static class ListState
    extends State {
        private final YTreeListNode node;

        ListState(YTreeListNode node) {
            this.node = node;
        }
    }

    private static class ResultState
    extends State {
        private final YTreeNode node;

        ResultState(YTreeNode node) {
            this.node = node;
        }
    }

    private static class State {
        private State() {
        }
    }
}

