/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.ysontree;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import tech.ytsaurus.ysontree.YTreeIntegerNode;
import tech.ytsaurus.ysontree.YTreeNode;
import tech.ytsaurus.ysontree.YTreeNodeImpl;

public class YTreeIntegerNodeImpl
extends YTreeNodeImpl
implements YTreeIntegerNode {
    private boolean signed;
    private long value;

    public YTreeIntegerNodeImpl(boolean signed, long value, @Nullable Map<String, YTreeNode> attributes) {
        super(attributes);
        this.signed = signed;
        this.value = value;
    }

    @Override
    public boolean isSigned() {
        return this.signed;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    public long setLong(long newValue) {
        long ret = this.value;
        this.signed = true;
        this.value = newValue;
        return ret;
    }

    @Override
    public long setUnsignedLong(long newValue) {
        long ret = this.value;
        this.signed = false;
        this.value = newValue;
        return ret;
    }

    public int hashCode() {
        return this.hashCodeBase() * 4243 + Long.hashCode(this.value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        if (another == null || !(another instanceof YTreeIntegerNode)) {
            return false;
        }
        YTreeIntegerNode node = (YTreeIntegerNode)another;
        return this.value == node.getLong() && (this.value >= 0L || this.isSigned() == node.isSigned()) && this.equalsBase(node);
    }

    @Override
    @Nonnull
    public Long getBoxedValue() {
        return this.value;
    }
}

