/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.ysontree;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import tech.ytsaurus.ysontree.YTreeBooleanNode;
import tech.ytsaurus.ysontree.YTreeDoubleNode;
import tech.ytsaurus.ysontree.YTreeEntityNode;
import tech.ytsaurus.ysontree.YTreeIntegerNode;
import tech.ytsaurus.ysontree.YTreeListNode;
import tech.ytsaurus.ysontree.YTreeMapNode;
import tech.ytsaurus.ysontree.YTreeScalarNode;
import tech.ytsaurus.ysontree.YTreeStringNode;

public interface YTreeNode {
    public Map<String, YTreeNode> getAttributes();

    public void clearAttributes();

    public boolean containsAttributes();

    public boolean containsAttribute(String var1);

    public Optional<YTreeNode> removeAttribute(String var1);

    public Optional<YTreeNode> putAttribute(String var1, YTreeNode var2);

    default public Set<String> attributeKeys() {
        return this.getAttributes().keySet();
    }

    default public Collection<YTreeNode> attributeValues() {
        return this.getAttributes().values();
    }

    public Optional<YTreeNode> getAttribute(String var1);

    public YTreeNode getAttributeOrThrow(String var1);

    public YTreeNode getAttributeOrThrow(String var1, Supplier<String> var2);

    default public <T extends YTreeNode> T cast() {
        return (T)this;
    }

    default public YTreeListNode listNode() {
        return (YTreeListNode)this.cast();
    }

    default public YTreeMapNode mapNode() {
        return (YTreeMapNode)this.cast();
    }

    default public YTreeBooleanNode booleanNode() {
        return (YTreeBooleanNode)this.cast();
    }

    default public YTreeIntegerNode integerNode() {
        return (YTreeIntegerNode)this.cast();
    }

    default public YTreeDoubleNode doubleNode() {
        return (YTreeDoubleNode)this.cast();
    }

    default public YTreeStringNode stringNode() {
        return (YTreeStringNode)this.cast();
    }

    default public YTreeEntityNode entityNode() {
        return (YTreeEntityNode)this.cast();
    }

    default public <V> YTreeScalarNode<V> scalarNode() {
        return (YTreeScalarNode)this.cast();
    }

    default public List<YTreeNode> asList() {
        throw new UnsupportedOperationException("asList() unsupported in " + String.valueOf(this.getClass()));
    }

    default public Map<String, YTreeNode> asMap() {
        throw new UnsupportedOperationException("asMap() unsupported in " + String.valueOf(this.getClass()));
    }

    default public long longValue() {
        return ((YTreeIntegerNode)this.cast()).getLong();
    }

    default public int intValue() {
        return (int)this.longValue();
    }

    default public double doubleValue() {
        return ((YTreeDoubleNode)this.cast()).getValue();
    }

    default public float floatValue() {
        return (float)((YTreeDoubleNode)this.cast()).getValue();
    }

    default public boolean boolValue() {
        return ((YTreeBooleanNode)this.cast()).getValue();
    }

    default public String stringValue() {
        return ((YTreeStringNode)this.cast()).getValue();
    }

    default public byte[] bytesValue() {
        return ((YTreeStringNode)this.cast()).getBytes();
    }

    default public boolean isListNode() {
        return this instanceof YTreeListNode;
    }

    default public boolean isMapNode() {
        return this instanceof YTreeMapNode;
    }

    default public boolean isBooleanNode() {
        return this instanceof YTreeBooleanNode;
    }

    default public boolean isIntegerNode() {
        return this instanceof YTreeIntegerNode;
    }

    default public boolean isDoubleNode() {
        return this instanceof YTreeDoubleNode;
    }

    default public boolean isStringNode() {
        return this instanceof YTreeStringNode;
    }

    default public boolean isEntityNode() {
        return this instanceof YTreeEntityNode;
    }

    public byte[] toBinary();
}

