/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.ysontree;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import tech.ytsaurus.ysontree.YTreeNode;
import tech.ytsaurus.ysontree.YTreeNodeImpl;
import tech.ytsaurus.ysontree.YTreeStringNode;

public class YTreeStringNodeImpl
extends YTreeNodeImpl
implements YTreeStringNode {
    private byte[] bytes;
    private String value;

    public YTreeStringNodeImpl(String value, @Nullable Map<String, YTreeNode> attributes) {
        super(attributes);
        this.value = value;
    }

    public YTreeStringNodeImpl(byte[] bytes, @Nullable Map<String, YTreeNode> attributes) {
        super(attributes);
        this.bytes = bytes;
    }

    @Override
    public String getValue() {
        if (this.value == null && this.bytes != null) {
            this.value = new String(this.bytes, StandardCharsets.UTF_8);
        }
        return this.value;
    }

    @Override
    public String setValue(String newValue) {
        String ret = this.getValue();
        this.value = newValue;
        this.bytes = null;
        return ret;
    }

    @Override
    public byte[] getBytes() {
        if (this.bytes == null && this.value != null) {
            this.bytes = this.value.getBytes(StandardCharsets.UTF_8);
        }
        return this.bytes;
    }

    @Override
    public byte[] setBytes(byte[] newBytes) {
        byte[] ret = this.getBytes();
        this.bytes = newBytes;
        this.value = null;
        return ret;
    }

    @Override
    @Nonnull
    public String getBoxedValue() {
        String val = this.getValue();
        return val != null ? val : "";
    }

    public int hashCode() {
        return this.hashCodeBase() * 4243 + Arrays.hashCode(this.getBytes());
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        if (another == null || !(another instanceof YTreeStringNode)) {
            return false;
        }
        YTreeStringNode node = (YTreeStringNode)another;
        return Arrays.equals(this.getBytes(), node.getBytes()) && this.equalsBase(node);
    }
}

