/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.ysontree;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import tech.ytsaurus.yson.YsonConsumer;
import tech.ytsaurus.yson.YsonParser;
import tech.ytsaurus.yson.YsonTextWriter;
import tech.ytsaurus.ysontree.YTree;
import tech.ytsaurus.ysontree.YTreeBuilder;
import tech.ytsaurus.ysontree.YTreeNode;
import tech.ytsaurus.ysontree.YTreeNodeUtils;

public final class YTreeTextSerializer {
    private YTreeTextSerializer() {
    }

    public static String serialize(YTreeNode node) {
        StringBuilder sb = new StringBuilder();
        try (YsonTextWriter ysonConsumer = new YsonTextWriter(sb);){
            YTreeNodeUtils.walk(node, (YsonConsumer)ysonConsumer, false);
        }
        return sb.toString();
    }

    public static String stableSerialize(YTreeNode node) {
        StringBuilder sb = new StringBuilder();
        try (YsonTextWriter ysonConsumer = new YsonTextWriter(sb);){
            YTreeNodeUtils.walk(node, (YsonConsumer)ysonConsumer, false, true);
        }
        return sb.toString();
    }

    public static YTreeNode deserialize(InputStream input) {
        YTreeBuilder builder = YTree.builder();
        YsonParser ysonParser = new YsonParser(input);
        ysonParser.parseNode((YsonConsumer)builder);
        return builder.build();
    }

    public static YTreeNode deserialize(String text) {
        return YTreeTextSerializer.deserialize(new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8)));
    }
}

