/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.ytsaurus;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkConf;
import org.apache.spark.TaskContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.shuffle.BaseShuffleHandle;
import org.apache.spark.shuffle.ShuffleBlockResolver;
import org.apache.spark.shuffle.ShuffleHandle;
import org.apache.spark.shuffle.ShuffleManager;
import org.apache.spark.shuffle.ShuffleReadMetricsReporter;
import org.apache.spark.shuffle.ShuffleReader;
import org.apache.spark.shuffle.ShuffleWriteMetricsReporter;
import org.apache.spark.shuffle.ShuffleWriter;
import org.apache.spark.shuffle.sort.SortShuffleManager;
import org.apache.spark.shuffle.ytsaurus.CompoundShuffleHandle;
import org.apache.spark.shuffle.ytsaurus.Config$;
import org.apache.spark.shuffle.ytsaurus.ShuffleUtils$;
import org.apache.spark.shuffle.ytsaurus.YTsaurusShuffleExecutorComponents$;
import org.apache.spark.shuffle.ytsaurus.YTsaurusShuffleReader;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import tech.ytsaurus.client.ApiServiceTransaction;
import tech.ytsaurus.client.CompoundClient;
import tech.ytsaurus.client.request.StartShuffle;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.spyt.wrapper.YtWrapper$;
import tech.ytsaurus.spyt.wrapper.client.YtClientConfiguration;
import tech.ytsaurus.spyt.wrapper.client.YtClientConfigurationConverter$;
import tech.ytsaurus.spyt.wrapper.client.YtClientProvider;
import tech.ytsaurus.spyt.wrapper.client.YtClientProvider$;
import tech.ytsaurus.ysontree.YTreeNode;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001B\n\u0015\u0001}A\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\u0006k\u0001!\tA\u000e\u0005\bu\u0001\u0011\r\u0011\"\u0003<\u0011\u0019I\u0005\u0001)A\u0005y!9!\n\u0001b\u0001\n\u0013Y\u0005BB(\u0001A\u0003%A\nC\u0004Q\u0001\t\u0007I1B)\t\r]\u0003\u0001\u0015!\u0003S\u0011\u001dA\u0006A1A\u0005\neCa\u0001\u0019\u0001!\u0002\u0013Q\u0006bB1\u0001\u0005\u0004%IA\u0019\u0005\u0007Y\u0002\u0001\u000b\u0011B2\t\u000b5\u0004A\u0011\t8\t\u000f\u0005u\u0001\u0001\"\u0011\u0002 !9\u00111\u000b\u0001\u0005B\u0005U\u0003bBAB\u0001\u0011\u0005\u0013Q\u0011\u0005\b\u0003\u001f\u0003A\u0011IAI\u0011\u001d\tI\n\u0001C!\u00037\u0013a#\u0017+tCV\u0014Xo]*ik\u001a4G.Z'b]\u0006<WM\u001d\u0006\u0003+Y\t\u0001\"\u001f;tCV\u0014Xo\u001d\u0006\u0003/a\tqa\u001d5vM\u001adWM\u0003\u0002\u001a5\u0005)1\u000f]1sW*\u00111\u0004H\u0001\u0007CB\f7\r[3\u000b\u0003u\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\u0011'UA\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t1\u0011I\\=SK\u001a\u0004\"a\n\u0015\u000e\u0003YI!!\u000b\f\u0003\u001dMCWO\u001a4mK6\u000bg.Y4feB\u00111FL\u0007\u0002Y)\u0011Q\u0006G\u0001\tS:$XM\u001d8bY&\u0011q\u0006\f\u0002\b\u0019><w-\u001b8h\u0003\u0011\u0019wN\u001c4\u0011\u0005I\u001aT\"\u0001\r\n\u0005QB\"!C*qCJ\\7i\u001c8g\u0003\u0019a\u0014N\\5u}Q\u0011q'\u000f\t\u0003q\u0001i\u0011\u0001\u0006\u0005\u0006a\t\u0001\r!M\u0001\u0011sR\u001cE.[3oiB\u0013xN^5eKJ,\u0012\u0001\u0010\t\u0003{\u001dk\u0011A\u0010\u0006\u0003\u007f\u0001\u000baa\u00197jK:$(BA!C\u0003\u001d9(/\u00199qKJT!a\u0011#\u0002\tM\u0004\u0018\u0010\u001e\u0006\u0003+\u0015S\u0011AR\u0001\u0005i\u0016\u001c\u0007.\u0003\u0002I}\t\u0001\u0012\f^\"mS\u0016tG\u000f\u0015:pm&$WM]\u0001\u0012sR\u001cE.[3oiB\u0013xN^5eKJ\u0004\u0013\u0001D=u\u00072LWM\u001c;D_:4W#\u0001'\u0011\u0005uj\u0015B\u0001(?\u0005UIFo\u00117jK:$8i\u001c8gS\u001e,(/\u0019;j_:\fQ\"\u001f;DY&,g\u000e^\"p]\u001a\u0004\u0013\u0001C=u\u00072LWM\u001c;\u0016\u0003I\u0003\"aU+\u000e\u0003QS!a\u0010#\n\u0005Y#&AD\"p[B|WO\u001c3DY&,g\u000e^\u0001\nsR\u001cE.[3oi\u0002\n\u0001\u0002Z3mK\u001e\fG/Z\u000b\u00025B\u00111LX\u0007\u00029*\u0011QLF\u0001\u0005g>\u0014H/\u0003\u0002`9\n\u00112k\u001c:u'\",hM\u001a7f\u001b\u0006t\u0017mZ3s\u0003%!W\r\\3hCR,\u0007%A\u0007sK\u0006$7i\u001c8gS\u001e|\u0005\u000f^\u000b\u0002GB\u0019\u0011\u0005\u001a4\n\u0005\u0015\u0014#AB(qi&|g\u000e\u0005\u0002hU6\t\u0001N\u0003\u0002j\t\u0006A\u0011p]8oiJ,W-\u0003\u0002lQ\nI\u0011\f\u0016:fK:{G-Z\u0001\u000fe\u0016\fGmQ8oM&<w\n\u001d;!\u0003=\u0011XmZ5ti\u0016\u00148\u000b[;gM2,WCB8\u0000\u0003'\tI\u0002F\u0002qgb\u0004\"aJ9\n\u0005I4\"!D*ik\u001a4G.\u001a%b]\u0012dW\rC\u0003u\u001b\u0001\u0007Q/A\u0005tQV4g\r\\3JIB\u0011\u0011E^\u0005\u0003o\n\u00121!\u00138u\u0011\u0015IX\u00021\u0001{\u0003)!W\r]3oI\u0016t7-\u001f\t\beml\u0018\u0011CA\f\u0013\ta\bDA\tTQV4g\r\\3EKB,g\u000eZ3oGf\u0004\"A`@\r\u0001\u00119\u0011\u0011A\u0007C\u0002\u0005\r!!A&\u0012\t\u0005\u0015\u00111\u0002\t\u0004C\u0005\u001d\u0011bAA\u0005E\t9aj\u001c;iS:<\u0007cA\u0011\u0002\u000e%\u0019\u0011q\u0002\u0012\u0003\u0007\u0005s\u0017\u0010E\u0002\u007f\u0003'!q!!\u0006\u000e\u0005\u0004\t\u0019AA\u0001W!\rq\u0018\u0011\u0004\u0003\b\u00037i!\u0019AA\u0002\u0005\u0005\u0019\u0015!C4fi^\u0013\u0018\u000e^3s+\u0019\t\t#a\u000b\u00020QQ\u00111EA\u0019\u0003k\ty$!\u0013\u0011\u000f\u001d\n)#!\u000b\u0002.%\u0019\u0011q\u0005\f\u0003\u001bMCWO\u001a4mK^\u0013\u0018\u000e^3s!\rq\u00181\u0006\u0003\b\u0003\u0003q!\u0019AA\u0002!\rq\u0018q\u0006\u0003\b\u0003+q!\u0019AA\u0002\u0011\u0019\t\u0019D\u0004a\u0001a\u00061\u0001.\u00198eY\u0016Dq!a\u000e\u000f\u0001\u0004\tI$A\u0003nCBLE\rE\u0002\"\u0003wI1!!\u0010#\u0005\u0011auN\\4\t\u000f\u0005\u0005c\u00021\u0001\u0002D\u000591m\u001c8uKb$\bc\u0001\u001a\u0002F%\u0019\u0011q\t\r\u0003\u0017Q\u000b7o[\"p]R,\u0007\u0010\u001e\u0005\b\u0003\u0017r\u0001\u0019AA'\u0003\u001diW\r\u001e:jGN\u00042aJA(\u0013\r\t\tF\u0006\u0002\u001c'\",hM\u001a7f/JLG/Z'fiJL7m\u001d*fa>\u0014H/\u001a:\u0002\u0013\u001d,GOU3bI\u0016\u0014XCBA,\u0003C\n)\u0007\u0006\t\u0002Z\u0005\u001d\u0014\u0011NA7\u0003c\n)(!\u001f\u0002|A9q%a\u0017\u0002`\u0005\r\u0014bAA/-\ti1\u000b[;gM2,'+Z1eKJ\u00042A`A1\t\u001d\t\ta\u0004b\u0001\u0003\u0007\u00012A`A3\t\u001d\tYb\u0004b\u0001\u0003\u0007Aa!a\r\u0010\u0001\u0004\u0001\bBBA6\u001f\u0001\u0007Q/A\u0007ti\u0006\u0014H/T1q\u0013:$W\r\u001f\u0005\u0007\u0003_z\u0001\u0019A;\u0002\u0017\u0015tG-T1q\u0013:$W\r\u001f\u0005\u0007\u0003gz\u0001\u0019A;\u0002\u001dM$\u0018M\u001d;QCJ$\u0018\u000e^5p]\"1\u0011qO\bA\u0002U\fA\"\u001a8e!\u0006\u0014H/\u001b;j_:Dq!!\u0011\u0010\u0001\u0004\t\u0019\u0005C\u0004\u0002L=\u0001\r!! \u0011\u0007\u001d\ny(C\u0002\u0002\u0002Z\u0011!d\u00155vM\u001adWMU3bI6+GO]5dgJ+\u0007o\u001c:uKJ\f\u0011#\u001e8sK\u001eL7\u000f^3s'\",hM\u001a7f)\u0011\t9)!$\u0011\u0007\u0005\nI)C\u0002\u0002\f\n\u0012qAQ8pY\u0016\fg\u000eC\u0003u!\u0001\u0007Q/\u0001\u0003ti>\u0004HCAAJ!\r\t\u0013QS\u0005\u0004\u0003/\u0013#\u0001B+oSR\fAc\u001d5vM\u001adWM\u00117pG.\u0014Vm]8mm\u0016\u0014XCAAO!\r9\u0013qT\u0005\u0004\u0003C3\"\u0001F*ik\u001a4G.\u001a\"m_\u000e\\'+Z:pYZ,'\u000f")
public class YTsaurusShuffleManager
implements ShuffleManager,
Logging {
    private final SparkConf conf;
    private final YtClientProvider ytClientProvider;
    private final YtClientConfiguration ytClientConf;
    private final CompoundClient ytClient;
    private final SortShuffleManager delegate;
    private final Option<YTreeNode> readConfigOpt;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public final <K, C> ShuffleReader<K, C> getReader(ShuffleHandle handle, int startPartition, int endPartition, TaskContext context, ShuffleReadMetricsReporter metrics) {
        return ShuffleManager.getReader$((ShuffleManager)this, (ShuffleHandle)handle, (int)startPartition, (int)endPartition, (TaskContext)context, (ShuffleReadMetricsReporter)metrics);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private YtClientProvider ytClientProvider() {
        return this.ytClientProvider;
    }

    private YtClientConfiguration ytClientConf() {
        return this.ytClientConf;
    }

    private CompoundClient ytClient() {
        return this.ytClient;
    }

    private SortShuffleManager delegate() {
        return this.delegate;
    }

    private Option<YTreeNode> readConfigOpt() {
        return this.readConfigOpt;
    }

    public <K, V, C> ShuffleHandle registerShuffle(int shuffleId, ShuffleDependency<K, V, C> dependency) {
        BaseShuffleHandle baseHandle = (BaseShuffleHandle)this.delegate().registerShuffle(shuffleId, dependency);
        FiniteDuration shuffleTransactionTimeout = Duration$.MODULE$.apply(BoxesRunTime.unboxToLong((Object)this.conf.get(Config$.MODULE$.YTSAURUS_SHUFFLE_TRANSACTION_TIMEOUT())), TimeUnit.MILLISECONDS);
        ApiServiceTransaction shuffleTransaction = YtWrapper$.MODULE$.createTransaction((Option)None$.MODULE$, (Duration)shuffleTransactionTimeout, YtWrapper$.MODULE$.createTransaction$default$3(), YtWrapper$.MODULE$.createTransaction$default$4(), YtWrapper$.MODULE$.createTransaction$default$5(), this.ytClient());
        int partitionCount = dependency.partitioner().numPartitions();
        StartShuffle.Builder reqBuilder = (StartShuffle.Builder)StartShuffle.builder().setAccount((String)this.conf.get(Config$.MODULE$.YTSAURUS_SHUFFLE_ACCOUNT())).setPartitionCount(partitionCount).setParentTransactionId(shuffleTransaction.getId());
        ((Option)this.conf.get(Config$.MODULE$.YTSAURUS_SHUFFLE_MEDIUM())).foreach((Function1 & Serializable & scala.Serializable)x$1 -> (StartShuffle.Builder)reqBuilder.setMedium(x$1));
        ((Option)this.conf.get(Config$.MODULE$.YTSAURUS_SHUFFLE_REPLICATION_FACTOR())).foreach((Function1 & Serializable & scala.Serializable)rf -> YTsaurusShuffleManager.$anonfun$registerShuffle$2(reqBuilder, BoxesRunTime.unboxToInt((Object)rf)));
        tech.ytsaurus.client.request.ShuffleHandle ytShuffleHandle = (tech.ytsaurus.client.request.ShuffleHandle)this.ytClient().startShuffle(reqBuilder.build()).join();
        if (this.isTraceEnabled()) {
            this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("REGISTERED SHUFFLE: ").append(shuffleId).append(", DESCRIPTOR: ").append(ytShuffleHandle.getPayload()).toString());
        }
        CompoundShuffleHandle handle = new CompoundShuffleHandle(baseHandle, ytShuffleHandle, partitionCount);
        this.conf.set(Config$.MODULE$.shuffleTransactionId(shuffleId), shuffleTransaction.getId().toString());
        return handle;
    }

    public <K, V> ShuffleWriter<K, V> getWriter(ShuffleHandle handle, long mapId, TaskContext context, ShuffleWriteMetricsReporter metrics) {
        if (this.isTraceEnabled()) {
            String info = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(306).append("\n           |CREATE SHUFFLE WRITER\n           |=======================\n           |shuffleId = ").append(handle.shuffleId()).append("\n           |mapId = ").append(mapId).append("\n           |stageId=").append(context.stageId()).append("\n           |stageAttempNumber=").append(context.stageAttemptNumber()).append("\n           |partitionId=").append(context.partitionId()).append("\n           |numPartitions=").append(context.numPartitions()).append("\n           |attemptNumber=").append(context.attemptNumber()).append("\n           |taskAttemptId=").append(context.taskAttemptId()).append("\n           |props=").append(context.getLocalProperties()).append("\n           |").toString())).stripMargin();
            this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> info);
        }
        CompoundShuffleHandle compoundHandle = (CompoundShuffleHandle)handle;
        YTsaurusShuffleExecutorComponents$.MODULE$.currentHandle().set(compoundHandle);
        YTsaurusShuffleExecutorComponents$.MODULE$.currentMapIndex().set(BoxesRunTime.boxToInteger((int)context.partitionId()));
        return this.delegate().getWriter(compoundHandle.baseHandle(), mapId, context, metrics);
    }

    public <K, C> ShuffleReader<K, C> getReader(ShuffleHandle handle, int startMapIndex, int endMapIndex, int startPartition, int endPartition, TaskContext context, ShuffleReadMetricsReporter metrics) {
        CompoundShuffleHandle compoundHandle = (CompoundShuffleHandle)handle;
        if (this.isTraceEnabled()) {
            String info = new StringBuilder(86).append("CREATING SHUFFLE READER: ").append(handle.shuffleId()).append(", ").append("MAP: (").append(startMapIndex).append(" - ").append(endMapIndex).append("), ").append("PART: (").append(startPartition).append(" - ").append(endPartition).append(") ").append("STAGE: id=").append(context.stageId()).append(" attempt=").append(context.stageAttemptNumber()).append(" ").append("METRICS CLASS: ").append(metrics.getClass()).toString();
            this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> info);
        }
        return new YTsaurusShuffleReader(compoundHandle, startMapIndex, endMapIndex, startPartition, endPartition, context, metrics, this.ytClient(), this.readConfigOpt());
    }

    public boolean unregisterShuffle(int shuffleId) {
        BoxedUnit boxedUnit;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Unregistering shuffle: ").append(shuffleId).toString());
        try {
            String transactionId = this.conf.get(Config$.MODULE$.shuffleTransactionId(shuffleId));
            this.ytClient().abortTransaction(GUID.valueOf((String)transactionId)).join();
            boxedUnit = this.conf.remove(Config$.MODULE$.shuffleTransactionId(shuffleId));
        }
        catch (Exception e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "An exception was thrown while trying to abort shuffle transaction", e);
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.delegate().unregisterShuffle(shuffleId);
    }

    public void stop() {
        try {
            this.ytClient().close();
        }
        finally {
            this.delegate().stop();
        }
    }

    public ShuffleBlockResolver shuffleBlockResolver() {
        return this.delegate().shuffleBlockResolver();
    }

    public static final /* synthetic */ StartShuffle.Builder $anonfun$registerShuffle$2(StartShuffle.Builder reqBuilder$1, int rf) {
        return (StartShuffle.Builder)reqBuilder$1.setReplicationFactor(Predef$.MODULE$.int2Integer(rf));
    }

    public YTsaurusShuffleManager(SparkConf conf) {
        this.conf = conf;
        ShuffleManager.$init$((ShuffleManager)this);
        Logging.$init$((Logging)this);
        this.ytClientProvider = (YtClientProvider)conf.getOption("spark.ytsaurus.client.provider.class").map((Function1 & Serializable & scala.Serializable)className -> (YtClientProvider)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).getOrElse((Function0 & Serializable & scala.Serializable)() -> YtClientProvider$.MODULE$);
        this.ytClientConf = YtClientConfigurationConverter$.MODULE$.ytClientConfiguration(conf);
        this.ytClient = this.ytClientProvider().ytClient(this.ytClientConf());
        this.delegate = new SortShuffleManager(conf);
        this.readConfigOpt = ShuffleUtils$.MODULE$.parseConfig(conf, Config$.MODULE$.YTSAURUS_SHUFFLE_READ_CONFIG());
    }
}

