/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.spyt.shuffle;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Hex;
import org.apache.spark.shuffle.api.ShuffleMapOutputWriter;
import org.apache.spark.shuffle.api.ShufflePartitionWriter;
import org.apache.spark.shuffle.api.metadata.MapOutputCommitMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ytsaurus.client.AsyncWriter;
import tech.ytsaurus.client.rows.UnversionedRow;
import tech.ytsaurus.client.rows.UnversionedValue;
import tech.ytsaurus.core.tables.ColumnValueType;
import tech.ytsaurus.spyt.shuffle.CommitShufflePartitionsListener;

public class YTsaurusShuffleMapOutputWriter
implements ShuffleMapOutputWriter {
    private static final Logger log = LoggerFactory.getLogger(YTsaurusShuffleMapOutputWriter.class);
    private static final List<CommitShufflePartitionsListener> commitAllPartitionListeners = ServiceLoader.load(CommitShufflePartitionsListener.class).stream().map(ServiceLoader.Provider::get).collect(Collectors.toList());
    private final AsyncWriter<UnversionedRow> ytsaurusWriter;
    private final long shuffleId;
    private final long mapTaskId;
    private final int rowSize;
    private final int bufferSize;
    private final long[] partitionLengths;
    private List<UnversionedRow> buffer;
    private CompletableFuture<Void> writeFuture;

    public YTsaurusShuffleMapOutputWriter(AsyncWriter<UnversionedRow> asyncWriter, long l, long l2, int n, int n2, int n3) {
        this.ytsaurusWriter = asyncWriter;
        this.shuffleId = l;
        this.mapTaskId = l2;
        this.rowSize = n2;
        this.bufferSize = n3;
        this.partitionLengths = new long[n];
        this.buffer = this.newBuffer();
        this.writeFuture = CompletableFuture.completedFuture(null);
    }

    public ShufflePartitionWriter getPartitionWriter(int n) {
        log.trace("GETTING PARTITION WRITER FOR {} - {} - {}", new Object[]{this.shuffleId, this.mapTaskId, n});
        return new YTsaurusShufflePartitionWriter(n);
    }

    public MapOutputCommitMessage commitAllPartitions(long[] lArray) {
        if (!this.buffer.isEmpty()) {
            this.flushBuffer();
        }
        this.writeFuture.join();
        this.ytsaurusWriter.finish().join();
        if (log.isTraceEnabled()) {
            log.trace("Bytes has been written for {} - {}; partition lengths are {}", new Object[]{this.shuffleId, this.mapTaskId, Arrays.toString(this.partitionLengths)});
        }
        commitAllPartitionListeners.forEach(CommitShufflePartitionsListener::onCommitPartitions);
        return MapOutputCommitMessage.of((long[])this.partitionLengths);
    }

    public void abort(Throwable throwable) {
        this.ytsaurusWriter.cancel();
    }

    private List<UnversionedRow> newBuffer() {
        return new ArrayList<UnversionedRow>(this.bufferSize);
    }

    private void addToBuffer(UnversionedRow unversionedRow) {
        this.buffer.add(unversionedRow);
        if (this.buffer.size() == this.bufferSize) {
            this.flushBuffer();
            this.buffer = this.newBuffer();
        }
    }

    private void flushBuffer() {
        this.writeFuture.join();
        this.writeFuture = this.ytsaurusWriter.write(this.buffer);
    }

    private class YTsaurusShufflePartitionWriter
    implements ShufflePartitionWriter {
        private final ByteBuffer buffer;
        private long bytesWritten;
        private final int reducePartitionId;

        public YTsaurusShufflePartitionWriter(int n) {
            this.buffer = ByteBuffer.allocate(YTsaurusShuffleMapOutputWriter.this.rowSize);
            this.bytesWritten = 0L;
            this.reducePartitionId = n;
        }

        public OutputStream openStream() throws IOException {
            return new OutputStream(){

                @Override
                public void write(int n) throws IOException {
                    if (!YTsaurusShufflePartitionWriter.this.buffer.hasRemaining()) {
                        this.addRow();
                    }
                    log.trace("SHUFFLE: {} MAP: {} REDUCE PARTITION: {} writing byte {}", new Object[]{YTsaurusShuffleMapOutputWriter.this.shuffleId, YTsaurusShuffleMapOutputWriter.this.mapTaskId, YTsaurusShufflePartitionWriter.this.reducePartitionId, n});
                    YTsaurusShufflePartitionWriter.this.buffer.put((byte)n);
                    ++YTsaurusShufflePartitionWriter.this.bytesWritten;
                }

                @Override
                public void write(byte[] byArray, int n, int n2) throws IOException {
                    if (YTsaurusShufflePartitionWriter.this.buffer.remaining() < n2) {
                        this.addRow();
                    }
                    if (log.isTraceEnabled()) {
                        byte[] byArray2 = new byte[n2];
                        System.arraycopy(byArray, n, byArray2, 0, n2);
                        log.trace("SHUFFLE: {} MAP: {} REDUCE PARTITION: {} writing bytes {}", new Object[]{YTsaurusShuffleMapOutputWriter.this.shuffleId, YTsaurusShuffleMapOutputWriter.this.mapTaskId, YTsaurusShufflePartitionWriter.this.reducePartitionId, Hex.encodeHexString((byte[])byArray2)});
                    }
                    YTsaurusShufflePartitionWriter.this.buffer.put(byArray, n, n2);
                    YTsaurusShufflePartitionWriter.this.bytesWritten += (long)n2;
                }

                private void addRow() {
                    YTsaurusShufflePartitionWriter.this.buffer.flip();
                    byte[] byArray = new byte[YTsaurusShufflePartitionWriter.this.buffer.limit()];
                    YTsaurusShufflePartitionWriter.this.buffer.get(byArray);
                    UnversionedRow unversionedRow = new UnversionedRow(List.of(new UnversionedValue(0, ColumnValueType.INT64, false, (Object)YTsaurusShufflePartitionWriter.this.reducePartitionId), new UnversionedValue(1, ColumnValueType.STRING, false, (Object)byArray)));
                    YTsaurusShuffleMapOutputWriter.this.addToBuffer(unversionedRow);
                    YTsaurusShufflePartitionWriter.this.buffer.clear();
                }

                @Override
                public void close() {
                    if (YTsaurusShufflePartitionWriter.this.buffer.position() > 0) {
                        this.addRow();
                    }
                    YTsaurusShuffleMapOutputWriter.this.partitionLengths[YTsaurusShufflePartitionWriter.this.reducePartitionId] = YTsaurusShufflePartitionWriter.this.bytesWritten;
                }
            };
        }

        public long getNumBytesWritten() {
            return this.bytesWritten;
        }
    }
}

