/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.ytsaurus;

import java.io.Serializable;
import java.net.ServerSocket;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.deploy.ytsaurus.YTsaurusUtils$;
import org.apache.spark.sql.connect.config.Connect$;
import org.apache.spark.sql.connect.service.SparkConnectServer$;
import org.apache.spark.sql.connect.service.SparkConnectService$;
import org.apache.spark.sql.connect.ytsaurus.Config$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.sys.package$;
import scala.util.Either;
import scala.util.Left;
import scala.util.control.NonFatal$;
import tech.ytsaurus.client.YTsaurusClient;
import tech.ytsaurus.client.request.UpdateOperationParameters;
import tech.ytsaurus.client.rpc.YTsaurusClientAuth;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.spyt.wrapper.Utils$;
import tech.ytsaurus.ysontree.YTree;
import tech.ytsaurus.ysontree.YTreeMapNode;
import tech.ytsaurus.ysontree.YTreeNode;

public final class SpytConnectServer$ {
    public static SpytConnectServer$ MODULE$;
    private final Logger log;
    private final int MAX_PORT_RETRIES;

    static {
        new SpytConnectServer$();
    }

    private Logger log() {
        return this.log;
    }

    public void main(String[] args) {
        this.checkAndUpdateGrpcPort();
        Runnable serverRunner = () -> SparkConnectServer$.MODULE$.main(args);
        Thread serverThread = new Thread(serverRunner, "Spark connect server");
        serverThread.start();
        this.waitForGrpcServerStart();
        this.addGrpcEndpointToAnnotation();
        long idleTimeout = BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Config$.MODULE$.YTSAURUS_CONNECT_IDLE_TIMEOUT()));
        while (this.keepListening(idleTimeout)) {
            Thread.sleep(10000L);
        }
        this.log().info(new StringBuilder(64).append("Idle timeout of ").append(idleTimeout).append("ms has passed, shutting down SPYT connect server").toString());
        SparkConnectService$.MODULE$.stop(SparkConnectService$.MODULE$.stop$default$1(), SparkConnectService$.MODULE$.stop$default$2());
        serverThread.join();
    }

    private int MAX_PORT_RETRIES() {
        return this.MAX_PORT_RETRIES;
    }

    private void checkAndUpdateGrpcPort() {
        Object object = new Object();
        try {
            int startingPort = new StringOps(Predef$.MODULE$.augmentString((String)package$.MODULE$.props().apply((Object)Connect$.MODULE$.CONNECT_GRPC_BINDING_PORT().key()))).toInt();
            this.log().info(new StringBuilder(37).append("Checking that grpc port ").append(startingPort).append(" is available").toString());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(startingPort), startingPort + this.MAX_PORT_RETRIES()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)port -> {
                if (MODULE$.isPortFree(port)) {
                    if (port != startingPort) {
                        MODULE$.log().info(new StringBuilder(28).append("Found ").append(port).append(" free port instead of ").append(startingPort).toString());
                        package$.MODULE$.props().update((Object)Connect$.MODULE$.CONNECT_GRPC_BINDING_PORT().key(), (Object)Integer.toString(port));
                    }
                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                }
                MODULE$.log().info(new StringBuilder(37).append("Port ").append(port).append(" is busy, checking the next port").toString());
            });
            this.log().error("Couldn't find free port for Spark Connect gRPC service, aborting");
            System.exit(-1);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private boolean isPortFree(int port) {
        boolean bl;
        block10: {
            boolean bl2;
            ServerSocket ss = null;
            try {
                try {
                    ss = new ServerSocket(port);
                    bl2 = true;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    boolean bl3 = false;
                    bl2 = bl3;
                }
            }
            catch (Throwable throwable) {
                if (ss != null) {
                    try {
                        ss.close();
                    }
                    catch (Throwable throwable3) {}
                }
                throw throwable;
            }
            bl = bl2;
            if (ss == null) break block10;
            try {
                ss.close();
            }
            catch (Throwable throwable) {}
        }
        return bl;
    }

    private void waitForGrpcServerStart() {
        while (SparkConnectService$.MODULE$.listener() == null) {
            Thread.sleep(1000L);
        }
    }

    private boolean keepListening(long idleTimeout) {
        boolean bl;
        Either either = SparkConnectService$.MODULE$.listActiveExecutions();
        if (either instanceof Left) {
            Left left = (Left)either;
            long lastExecutionFinishTime = BoxesRunTime.unboxToLong((Object)left.value());
            bl = System.currentTimeMillis() - lastExecutionFinishTime <= idleTimeout;
        } else {
            bl = true;
        }
        return bl;
    }

    private void addGrpcEndpointToAnnotation() {
        String operationId = System.getenv("YT_OPERATION_ID");
        if (operationId != null) {
            String host = Utils$.MODULE$.ytHostnameOrIpAddress();
            int port = SparkConnectService$.MODULE$.localPort();
            String endpoint = new StringBuilder(1).append(host).append(":").append(port).toString();
            SparkConf conf = SparkEnv$.MODULE$.get().conf();
            String ytProxy = YTsaurusUtils$.MODULE$.parseMasterUrl(conf.get("spark.master"));
            String token = YTsaurusUtils$.MODULE$.getToken(conf);
            YTsaurusClient.ClientBuilder clientBuilder = YTsaurusClient.builder();
            clientBuilder.setCluster(ytProxy);
            clientBuilder.setAuth(YTsaurusClientAuth.builder().setToken(token).build());
            try (YTsaurusClient client = (YTsaurusClient)clientBuilder.build();){
                YTreeMapNode annotations = YTree.mapBuilder().key("spark_connect_endpoint").value(endpoint).buildMap();
                UpdateOperationParameters req = ((UpdateOperationParameters.BuilderBase)UpdateOperationParameters.builder().setOperationId(GUID.valueOf((String)operationId))).setAnnotations((YTreeNode)annotations).build();
                client.updateOperationParameters(req).join();
            }
        }
    }

    private SpytConnectServer$() {
        MODULE$ = this;
        this.log = LoggerFactory.getLogger(this.getClass());
        this.MAX_PORT_RETRIES = 32;
    }
}

