/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.v2;

import java.io.FileNotFoundException;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.metrics.source.HiveCatalogMetrics$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.FileStatusCache;
import org.apache.spark.sql.execution.datasources.NoopCache$;
import org.apache.spark.sql.execution.datasources.PartitionSpec;
import org.apache.spark.sql.v2.YtInMemoryFileIndex;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import tech.ytsaurus.spyt.fs.YtTableFileSystem$;

public final class YtInMemoryFileIndex$
implements Logging {
    public static YtInMemoryFileIndex$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new YtInMemoryFileIndex$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public FileStatusCache $lessinit$greater$default$5() {
        return NoopCache$.MODULE$;
    }

    public Option<PartitionSpec> $lessinit$greater$default$6() {
        return None$.MODULE$;
    }

    public Option<Object> $lessinit$greater$default$7() {
        return None$.MODULE$;
    }

    public Seq<Tuple2<Path, Seq<FileStatus>>> bulkListLeafFiles(Seq<Path> paths, Configuration hadoopConf, PathFilter filter, SparkSession sparkSession, boolean areRootPaths) {
        Tuple2[] tuple2Array;
        boolean ignoreMissingFiles = sparkSession.sessionState().conf().ignoreMissingFiles();
        boolean ignoreLocality = sparkSession.sessionState().conf().ignoreDataLocality();
        if (paths.size() <= sparkSession.sessionState().conf().parallelPartitionDiscoveryThreshold()) {
            if (paths.isEmpty()) {
                return Nil$.MODULE$;
            }
            if (paths.size() > 1 && areRootPaths) {
                return ((MapLike)paths.groupBy((Function1 & Serializable & scala.Serializable)p -> p.getParent()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Path dir = (Path)tuple2._1();
                    Seq children = (Seq)tuple2._2();
                    Set names = ((TraversableOnce)children.map((Function1 & Serializable & scala.Serializable)p -> p.getName(), Seq$.MODULE$.canBuildFrom())).toSet();
                    Seq<FileStatus> leafFiles = MODULE$.listLeafFiles(dir, hadoopConf, filter, (Option<SparkSession>)new Some((Object)sparkSession), ignoreMissingFiles, ignoreLocality, areRootPaths, p -> names.contains((Object)p.getName()));
                    Seq seq = (Seq)((TraversableLike)((IterableLike)children.sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).zip((GenIterable)leafFiles.sortBy((Function1 & Serializable & scala.Serializable)x$9 -> x$9.getPath(), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Path path = (Path)tuple2._1();
                        FileStatus fileStatus = (FileStatus)tuple2._2();
                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)path), (Object)new .colon.colon((Object)fileStatus, (List)Nil$.MODULE$));
                        return tuple22;
                    }, Seq$.MODULE$.canBuildFrom());
                    return seq;
                }, Map$.MODULE$.canBuildFrom())).toSeq();
            }
            return (Seq)paths.map((Function1 & Serializable & scala.Serializable)path -> {
                Seq<FileStatus> leafFiles = MODULE$.listLeafFiles((Path)path, hadoopConf, filter, (Option<SparkSession>)new Some((Object)sparkSession), ignoreMissingFiles, ignoreLocality, areRootPaths, MODULE$.listLeafFiles$default$8());
                return new Tuple2(path, leafFiles);
            }, Seq$.MODULE$.canBuildFrom());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(91).append("Listing leaf files and directories in parallel under ").append(paths.length()).append(" paths.").append(" The first several paths are: ").append(((TraversableOnce)paths.take(10)).mkString(", ")).append(".").toString());
        HiveCatalogMetrics$.MODULE$.incrementParallelListingJobCount(1);
        SparkContext sparkContext = sparkSession.sparkContext();
        SerializableConfiguration serializableConfiguration = new SerializableConfiguration(hadoopConf);
        Seq serializedPaths = (Seq)paths.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.toString(), Seq$.MODULE$.canBuildFrom());
        int parallelPartitionDiscoveryParallelism = sparkSession.sessionState().conf().parallelPartitionDiscoveryParallelism();
        int numParallelism = Math.min(paths.size(), parallelPartitionDiscoveryParallelism);
        String previousJobDescription = sparkContext.getLocalProperty(SparkContext$.MODULE$.SPARK_JOB_DESCRIPTION());
        try {
            String string;
            int n = paths.size();
            switch (n) {
                case 0: {
                    string = "Listing leaf files and directories 0 paths";
                    break;
                }
                case 1: {
                    string = new java.lang.StringBuilder(51).append("Listing leaf files and directories for 1 path:<br/>").append(paths.apply(0)).toString();
                    break;
                }
                default: {
                    string = new java.lang.StringBuilder(56).append("Listing leaf files and directories for ").append(n).append(" paths:<br/>").append(paths.apply(0)).append(", ...").toString();
                    break;
                }
            }
            String description = string;
            sparkContext.setJobDescription(description);
            RDD qual$1 = sparkContext.parallelize(serializedPaths, numParallelism, ClassTag$.MODULE$.apply(String.class));
            Function1 & Serializable & scala.Serializable x$1 = (Function1 & Serializable & scala.Serializable)pathStrings -> {
                Configuration hadoopConf = serializableConfiguration.value();
                return ((IterableLike)pathStrings.map((Function1 & Serializable & scala.Serializable)x$11 -> new Path(x$11)).toSeq().map((Function1 & Serializable & scala.Serializable)path -> {
                    Seq<FileStatus> leafFiles = MODULE$.listLeafFiles((Path)path, hadoopConf, filter, (Option<SparkSession>)None$.MODULE$, ignoreMissingFiles, ignoreLocality, areRootPaths, MODULE$.listLeafFiles$default$8());
                    return new Tuple2(path, leafFiles);
                }, Seq$.MODULE$.canBuildFrom())).iterator();
            };
            boolean x$2 = qual$1.mapPartitions$default$2();
            tuple2Array = (Tuple2[])qual$1.mapPartitions((Function1)x$1, x$2, ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Path path = (Path)tuple2._1();
                Seq statuses = (Seq)tuple2._2();
                Seq serializableStatuses = (Seq)statuses.map((Function1 & Serializable & scala.Serializable)status -> {
                    YtInMemoryFileIndex.SerializableBlockLocation[] serializableBlockLocationArray;
                    FileStatus fileStatus = status;
                    if (fileStatus instanceof LocatedFileStatus) {
                        LocatedFileStatus locatedFileStatus = (LocatedFileStatus)fileStatus;
                        serializableBlockLocationArray = (YtInMemoryFileIndex.SerializableBlockLocation[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])locatedFileStatus.getBlockLocations())).map((Function1 & Serializable & scala.Serializable)loc -> new YtInMemoryFileIndex.SerializableBlockLocation(loc.getNames(), loc.getHosts(), loc.getOffset(), loc.getLength()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(YtInMemoryFileIndex.SerializableBlockLocation.class)));
                    } else {
                        serializableBlockLocationArray = (YtInMemoryFileIndex.SerializableBlockLocation[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(YtInMemoryFileIndex.SerializableBlockLocation.class));
                    }
                    YtInMemoryFileIndex.SerializableBlockLocation[] blockLocations = serializableBlockLocationArray;
                    return new YtInMemoryFileIndex.SerializableFileStatus(status.getPath().toString(), status.getLen(), status.isDirectory(), status.getReplication(), status.getBlockSize(), status.getModificationTime(), status.getAccessTime(), blockLocations);
                }, Seq$.MODULE$.canBuildFrom());
                Tuple2 tuple22 = new Tuple2((Object)path.toString(), (Object)serializableStatuses);
                return tuple22;
            }, ClassTag$.MODULE$.apply(Tuple2.class)).collect();
        }
        finally {
            sparkContext.setJobDescription(previousJobDescription);
        }
        Tuple2[] statusMap = tuple2Array;
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])statusMap)).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String path = (String)tuple2._1();
            Seq serializableStatuses = (Seq)tuple2._2();
            Seq statuses = (Seq)serializableStatuses.map((Function1 & Serializable & scala.Serializable)f -> {
                BlockLocation[] blockLocations = (BlockLocation[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])f.blockLocations())).map((Function1 & Serializable & scala.Serializable)loc -> new BlockLocation(loc.names(), loc.hosts(), loc.offset(), loc.length()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BlockLocation.class)));
                return new LocatedFileStatus(new FileStatus(f.length(), f.isDir(), (int)f.blockReplication(), f.blockSize(), f.modificationTime(), new Path(f.path())), blockLocations);
            }, Seq$.MODULE$.canBuildFrom());
            Tuple2 tuple22 = new Tuple2((Object)new Path(path), (Object)statuses);
            return tuple22;
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    private Seq<FileStatus> listLeafFiles(Path path, Configuration hadoopConf, PathFilter filter, Option<SparkSession> sessionOpt, boolean ignoreMissingFiles, boolean ignoreLocality, boolean isRootPath, PathFilter childFilter) {
        FileStatus[] resolvedLeafStatuses;
        block8: {
            Seq seq;
            FileStatus[] fileStatusArray;
            this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(8).append("Listing ").append(path).toString());
            FileSystem fs = path.getFileSystem(hadoopConf);
            try {
                FileStatus[] fileStatusArray2;
                FileSystem fileSystem = fs;
                if (fileSystem instanceof DistributedFileSystem && !ignoreLocality) {
                    RemoteIterator remoteIter = fs.listLocatedStatus(path);
                    fileStatusArray2 = (FileStatus[])new Iterator<LocatedFileStatus>(remoteIter){
                        private final RemoteIterator remoteIter$1;

                        public Iterator<LocatedFileStatus> seq() {
                            return Iterator.seq$((Iterator)this);
                        }

                        public boolean isEmpty() {
                            return Iterator.isEmpty$((Iterator)this);
                        }

                        public boolean isTraversableAgain() {
                            return Iterator.isTraversableAgain$((Iterator)this);
                        }

                        public boolean hasDefiniteSize() {
                            return Iterator.hasDefiniteSize$((Iterator)this);
                        }

                        public Iterator<LocatedFileStatus> take(int n) {
                            return Iterator.take$((Iterator)this, (int)n);
                        }

                        public Iterator<LocatedFileStatus> drop(int n) {
                            return Iterator.drop$((Iterator)this, (int)n);
                        }

                        public Iterator<LocatedFileStatus> slice(int from, int until) {
                            return Iterator.slice$((Iterator)this, (int)from, (int)until);
                        }

                        public Iterator<LocatedFileStatus> sliceIterator(int from, int until) {
                            return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
                        }

                        public <B> Iterator<B> map(Function1<LocatedFileStatus, B> f) {
                            return Iterator.map$((Iterator)this, f);
                        }

                        public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                            return Iterator.$plus$plus$((Iterator)this, that);
                        }

                        public <B> Iterator<B> flatMap(Function1<LocatedFileStatus, GenTraversableOnce<B>> f) {
                            return Iterator.flatMap$((Iterator)this, f);
                        }

                        public Iterator<LocatedFileStatus> filter(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.filter$((Iterator)this, p);
                        }

                        public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<LocatedFileStatus, B, Object> p) {
                            return Iterator.corresponds$((Iterator)this, that, p);
                        }

                        public Iterator<LocatedFileStatus> withFilter(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.withFilter$((Iterator)this, p);
                        }

                        public Iterator<LocatedFileStatus> filterNot(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.filterNot$((Iterator)this, p);
                        }

                        public <B> Iterator<B> collect(PartialFunction<LocatedFileStatus, B> pf) {
                            return Iterator.collect$((Iterator)this, pf);
                        }

                        public <B> Iterator<B> scanLeft(B z, Function2<B, LocatedFileStatus, B> op) {
                            return Iterator.scanLeft$((Iterator)this, z, op);
                        }

                        public <B> Iterator<B> scanRight(B z, Function2<LocatedFileStatus, B, B> op) {
                            return Iterator.scanRight$((Iterator)this, z, op);
                        }

                        public Iterator<LocatedFileStatus> takeWhile(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.takeWhile$((Iterator)this, p);
                        }

                        public Tuple2<Iterator<LocatedFileStatus>, Iterator<LocatedFileStatus>> partition(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.partition$((Iterator)this, p);
                        }

                        public Tuple2<Iterator<LocatedFileStatus>, Iterator<LocatedFileStatus>> span(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.span$((Iterator)this, p);
                        }

                        public Iterator<LocatedFileStatus> dropWhile(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.dropWhile$((Iterator)this, p);
                        }

                        public <B> Iterator<Tuple2<LocatedFileStatus, B>> zip(Iterator<B> that) {
                            return Iterator.zip$((Iterator)this, that);
                        }

                        public <A1> Iterator<A1> padTo(int len, A1 elem) {
                            return Iterator.padTo$((Iterator)this, (int)len, elem);
                        }

                        public Iterator<Tuple2<LocatedFileStatus, Object>> zipWithIndex() {
                            return Iterator.zipWithIndex$((Iterator)this);
                        }

                        public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                            return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
                        }

                        public <U> void foreach(Function1<LocatedFileStatus, U> f) {
                            Iterator.foreach$((Iterator)this, f);
                        }

                        public boolean forall(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.forall$((Iterator)this, p);
                        }

                        public boolean exists(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.exists$((Iterator)this, p);
                        }

                        public boolean contains(Object elem) {
                            return Iterator.contains$((Iterator)this, (Object)elem);
                        }

                        public Option<LocatedFileStatus> find(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.find$((Iterator)this, p);
                        }

                        public int indexWhere(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.indexWhere$((Iterator)this, p);
                        }

                        public int indexWhere(Function1<LocatedFileStatus, Object> p, int from) {
                            return Iterator.indexWhere$((Iterator)this, p, (int)from);
                        }

                        public <B> int indexOf(B elem) {
                            return Iterator.indexOf$((Iterator)this, elem);
                        }

                        public <B> int indexOf(B elem, int from) {
                            return Iterator.indexOf$((Iterator)this, elem, (int)from);
                        }

                        public BufferedIterator<LocatedFileStatus> buffered() {
                            return Iterator.buffered$((Iterator)this);
                        }

                        public <B> Iterator.GroupedIterator<B> grouped(int size) {
                            return Iterator.grouped$((Iterator)this, (int)size);
                        }

                        public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                            return Iterator.sliding$((Iterator)this, (int)size, (int)step);
                        }

                        public <B> int sliding$default$2() {
                            return Iterator.sliding$default$2$((Iterator)this);
                        }

                        public int length() {
                            return Iterator.length$((Iterator)this);
                        }

                        public Tuple2<Iterator<LocatedFileStatus>, Iterator<LocatedFileStatus>> duplicate() {
                            return Iterator.duplicate$((Iterator)this);
                        }

                        public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                            return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
                        }

                        public <B> void copyToArray(Object xs, int start, int len) {
                            Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
                        }

                        public boolean sameElements(Iterator<?> that) {
                            return Iterator.sameElements$((Iterator)this, that);
                        }

                        public Traversable<LocatedFileStatus> toTraversable() {
                            return Iterator.toTraversable$((Iterator)this);
                        }

                        public Iterator<LocatedFileStatus> toIterator() {
                            return Iterator.toIterator$((Iterator)this);
                        }

                        public Stream<LocatedFileStatus> toStream() {
                            return Iterator.toStream$((Iterator)this);
                        }

                        public String toString() {
                            return Iterator.toString$((Iterator)this);
                        }

                        public List<LocatedFileStatus> reversed() {
                            return TraversableOnce.reversed$((TraversableOnce)this);
                        }

                        public int size() {
                            return TraversableOnce.size$((TraversableOnce)this);
                        }

                        public boolean nonEmpty() {
                            return TraversableOnce.nonEmpty$((TraversableOnce)this);
                        }

                        public int count(Function1<LocatedFileStatus, Object> p) {
                            return TraversableOnce.count$((TraversableOnce)this, p);
                        }

                        public <B> Option<B> collectFirst(PartialFunction<LocatedFileStatus, B> pf) {
                            return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
                        }

                        public <B> B $div$colon(B z, Function2<B, LocatedFileStatus, B> op) {
                            return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
                        }

                        public <B> B $colon$bslash(B z, Function2<LocatedFileStatus, B, B> op) {
                            return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
                        }

                        public <B> B foldLeft(B z, Function2<B, LocatedFileStatus, B> op) {
                            return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
                        }

                        public <B> B foldRight(B z, Function2<LocatedFileStatus, B, B> op) {
                            return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
                        }

                        public <B> B reduceLeft(Function2<B, LocatedFileStatus, B> op) {
                            return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
                        }

                        public <B> B reduceRight(Function2<LocatedFileStatus, B, B> op) {
                            return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
                        }

                        public <B> Option<B> reduceLeftOption(Function2<B, LocatedFileStatus, B> op) {
                            return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
                        }

                        public <B> Option<B> reduceRightOption(Function2<LocatedFileStatus, B, B> op) {
                            return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
                        }

                        public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                            return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
                        }

                        public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                            return TraversableOnce.reduceOption$((TraversableOnce)this, op);
                        }

                        public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                            return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
                        }

                        public <B> B aggregate(Function0<B> z, Function2<B, LocatedFileStatus, B> seqop, Function2<B, B, B> combop) {
                            return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
                        }

                        public <B> B sum(Numeric<B> num) {
                            return (B)TraversableOnce.sum$((TraversableOnce)this, num);
                        }

                        public <B> B product(Numeric<B> num) {
                            return (B)TraversableOnce.product$((TraversableOnce)this, num);
                        }

                        public Object min(Ordering cmp) {
                            return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
                        }

                        public Object max(Ordering cmp) {
                            return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
                        }

                        public Object maxBy(Function1 f, Ordering cmp) {
                            return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                        }

                        public Object minBy(Function1 f, Ordering cmp) {
                            return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                        }

                        public <B> void copyToBuffer(Buffer<B> dest) {
                            TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
                        }

                        public <B> void copyToArray(Object xs, int start) {
                            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
                        }

                        public <B> void copyToArray(Object xs) {
                            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
                        }

                        public <B> Object toArray(ClassTag<B> evidence$1) {
                            return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
                        }

                        public List<LocatedFileStatus> toList() {
                            return TraversableOnce.toList$((TraversableOnce)this);
                        }

                        public Iterable<LocatedFileStatus> toIterable() {
                            return TraversableOnce.toIterable$((TraversableOnce)this);
                        }

                        public Seq<LocatedFileStatus> toSeq() {
                            return TraversableOnce.toSeq$((TraversableOnce)this);
                        }

                        public IndexedSeq<LocatedFileStatus> toIndexedSeq() {
                            return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
                        }

                        public <B> Buffer<B> toBuffer() {
                            return TraversableOnce.toBuffer$((TraversableOnce)this);
                        }

                        public <B> Set<B> toSet() {
                            return TraversableOnce.toSet$((TraversableOnce)this);
                        }

                        public Vector<LocatedFileStatus> toVector() {
                            return TraversableOnce.toVector$((TraversableOnce)this);
                        }

                        public <Col> Col to(CanBuildFrom<Nothing$, LocatedFileStatus, Col> cbf) {
                            return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
                        }

                        public <T, U> Map<T, U> toMap(Predef$.less.colon.less<LocatedFileStatus, Tuple2<T, U>> ev) {
                            return TraversableOnce.toMap$((TraversableOnce)this, ev);
                        }

                        public String mkString(String start, String sep, String end) {
                            return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
                        }

                        public String mkString(String sep) {
                            return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
                        }

                        public String mkString() {
                            return TraversableOnce.mkString$((TraversableOnce)this);
                        }

                        public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                        }

                        public StringBuilder addString(StringBuilder b, String sep) {
                            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
                        }

                        public StringBuilder addString(StringBuilder b) {
                            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
                        }

                        public int sizeHintIfCheap() {
                            return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
                        }

                        public LocatedFileStatus next() {
                            return (LocatedFileStatus)this.remoteIter$1.next();
                        }

                        public boolean hasNext() {
                            return this.remoteIter$1.hasNext();
                        }
                        {
                            this.remoteIter$1 = remoteIter$1;
                            GenTraversableOnce.$init$((GenTraversableOnce)this);
                            TraversableOnce.$init$((TraversableOnce)this);
                            Iterator.$init$((Iterator)this);
                        }
                    }.toArray(ClassTag$.MODULE$.apply(FileStatus.class));
                } else {
                    fileStatusArray2 = fs.listStatus(path, childFilter);
                }
                fileStatusArray = fileStatusArray2;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (!(throwable2 instanceof FileNotFoundException) || !isRootPath && !ignoreMissingFiles) {
                    throw throwable;
                }
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(59).append("The directory ").append(path).append(" was not found. Was it deleted very recently?").toString());
                FileStatus[] fileStatusArray3 = (FileStatus[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(FileStatus.class));
                fileStatusArray = fileStatusArray3;
            }
            FileStatus[] statuses = fileStatusArray;
            FileStatus[] filteredStatuses = (FileStatus[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])statuses)).filterNot((Function1 & Serializable & scala.Serializable)status -> BoxesRunTime.boxToBoolean((boolean)YtInMemoryFileIndex$.MODULE$.shouldFilterOut(status.getPath().getName())));
            Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredStatuses)).partition((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.isDirectory()));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            FileStatus[] dirs = (FileStatus[])tuple2._1();
            FileStatus[] topLevelFiles = (FileStatus[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)dirs, (Object)topLevelFiles);
            Tuple2 tuple23 = tuple22;
            FileStatus[] dirs2 = (FileStatus[])tuple23._1();
            FileStatus[] topLevelFiles2 = (FileStatus[])tuple23._2();
            Option<SparkSession> option = sessionOpt;
            if (option instanceof Some) {
                Some some = (Some)option;
                SparkSession session = (SparkSession)some.value();
                seq = (Seq)this.bulkListLeafFiles((Seq<Path>)((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dirs2)).map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.getPath(), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))), hadoopConf, filter, session, false).flatMap((Function1 & Serializable & scala.Serializable)x$15 -> (Seq)x$15._2(), Seq$.MODULE$.canBuildFrom());
            } else {
                seq = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dirs2)).flatMap((Function1 & Serializable & scala.Serializable)dir -> MODULE$.listLeafFiles(dir.getPath(), hadoopConf, filter, sessionOpt, ignoreMissingFiles, ignoreLocality, false, MODULE$.listLeafFiles$default$8()), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
            }
            Seq nestedFiles = seq;
            FileStatus[] allFiles = (FileStatus[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topLevelFiles2)).$plus$plus((GenTraversableOnce)nestedFiles, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStatus.class)));
            FileStatus[] allLeafStatuses = filter != null ? (FileStatus[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allFiles)).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)filter.accept(f.getPath()))) : allFiles;
            ArrayBuffer missingFiles = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            FileStatus[] filteredLeafStatuses = (FileStatus[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allLeafStatuses)).filterNot((Function1 & Serializable & scala.Serializable)status -> BoxesRunTime.boxToBoolean((boolean)YtInMemoryFileIndex$.MODULE$.shouldFilterOut(status.getPath().getName())));
            resolvedLeafStatuses = (FileStatus[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredLeafStatuses)).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Iterable iterable;
                FileStatus fileStatus = x0$1;
                if (fileStatus instanceof LocatedFileStatus) {
                    LocatedFileStatus locatedFileStatus = (LocatedFileStatus)fileStatus;
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)locatedFileStatus));
                } else if (!ignoreLocality) {
                    Iterable iterable2;
                    try {
                        BlockLocation[] locations = (BlockLocation[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.getFileBlockLocations(fileStatus, 0L, fileStatus.getLen()))).map((Function1 & Serializable & scala.Serializable)loc -> {
                            Class clazz = loc.getClass();
                            Class<BlockLocation> clazz2 = BlockLocation.class;
                            return !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null) ? loc : new BlockLocation(loc.getNames(), loc.getHosts(), loc.getOffset(), loc.getLength());
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BlockLocation.class)));
                        LocatedFileStatus lfs = new LocatedFileStatus(fileStatus.getLen(), fileStatus.isDirectory(), (int)fileStatus.getReplication(), fileStatus.getBlockSize(), fileStatus.getModificationTime(), 0L, null, null, null, null, fileStatus.getPath(), locations);
                        if (fileStatus.isSymlink()) {
                            lfs.setSymlink(fileStatus.getSymlink());
                        }
                        iterable2 = Option$.MODULE$.option2Iterable((Option)new Some((Object)lfs));
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (!(throwable2 instanceof FileNotFoundException) || !ignoreMissingFiles) {
                            throw throwable;
                        }
                        missingFiles.$plus$eq((Object)fileStatus.getPath().toString());
                        Iterable iterable3 = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                        iterable2 = iterable3;
                    }
                    iterable = iterable2;
                } else {
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)fileStatus));
                }
                return iterable;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStatus.class)));
            if (!missingFiles.nonEmpty()) break block8;
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(53).append("the following files were missing during file scan:\n  ").append(missingFiles.mkString("\n  ")).toString());
        }
        return Predef$.MODULE$.wrapRefArray((Object[])resolvedLeafStatuses);
    }

    private PathFilter listLeafFiles$default$8() {
        return YtTableFileSystem$.MODULE$.DEFAULT_FILTER();
    }

    public boolean shouldFilterOut(String pathName) {
        boolean exclude = pathName.startsWith("_") && !pathName.contains("=") || pathName.startsWith(".") || pathName.endsWith("._COPYING_");
        boolean include = pathName.startsWith("_common_metadata") || pathName.startsWith("_metadata");
        return exclude && !include;
    }

    private YtInMemoryFileIndex$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

