/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.spyt.common.utils;

import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class DateTimeTypesConverter$ {
    public static DateTimeTypesConverter$ MODULE$;

    static {
        new DateTimeTypesConverter$();
    }

    public long dateToLong(String dateStr) {
        LocalDate date = LocalDate.parse(dateStr);
        LocalDate epoch = LocalDate.of(1970, 1, 1);
        return ChronoUnit.DAYS.between(epoch, date);
    }

    public String longToDate(long days) {
        LocalDate epoch = LocalDate.of(1970, 1, 1);
        LocalDate date = epoch.plusDays(days);
        return date.toString();
    }

    public Date daysToDate(long days) {
        LocalDate localDate = LocalDate.ofEpochDay(days);
        return Date.valueOf(localDate);
    }

    public long datetimeToLong(String timestampStr) {
        DateTimeFormatter formatter = DateTimeFormatter.ISO_DATE_TIME;
        ZonedDateTime dateTime = ZonedDateTime.parse(timestampStr, formatter).withZoneSameInstant(ZoneOffset.UTC);
        return dateTime.toEpochSecond();
    }

    public String longToDatetime(long seconds) {
        ZonedDateTime dateTime = ZonedDateTime.ofInstant(Instant.ofEpochSecond(seconds), ZoneOffset.UTC);
        return dateTime.format(DateTimeFormatter.ISO_DATE_TIME);
    }

    public long localDateTimeToSeconds(LocalDateTime localDateTime) {
        ZonedDateTime dateTime = localDateTime.atZone(ZoneOffset.UTC);
        return dateTime.toInstant().toEpochMilli() / 1000L;
    }

    public LocalDateTime toLocalDatetime(String dateTimeString) {
        ZonedDateTime zonedDateTime = ZonedDateTime.parse(dateTimeString, DateTimeFormatter.ISO_DATE_TIME);
        return zonedDateTime.toLocalDateTime();
    }

    public long zonedTimestampToLong(String timestampStr) {
        DateTimeFormatter formatter = DateTimeFormatter.ISO_DATE_TIME;
        ZonedDateTime dateTime = ZonedDateTime.parse(timestampStr, formatter).withZoneSameInstant(ZoneOffset.UTC);
        return dateTime.toEpochSecond() * 1000000L + (long)dateTime.get(ChronoField.MICRO_OF_SECOND);
    }

    public long timestampToLong(Timestamp timestamp) {
        return timestamp.getTime() * 1000L + (long)(timestamp.getNanos() / 1000);
    }

    public String longToZonedTimestamp(long microseconds) {
        long seconds = microseconds / 1000000L;
        long microOfSecond = microseconds % 1000000L;
        ZonedDateTime dateTime = ZonedDateTime.ofInstant(Instant.ofEpochSecond(seconds, 0L), ZoneOffset.UTC);
        String formatted = dateTime.format(DateTimeFormatter.ISO_DATE_TIME);
        long arg$macro$1 = microOfSecond;
        return new StringBuilder(0).append((String)new StringOps(Predef$.MODULE$.augmentString(formatted)).dropRight(1)).append(new StringOps(".%06dZ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$1)}))).toString();
    }

    public Timestamp convertUTCtoLocal(String str, int zoneOffsetHour) {
        Instant instant = Instant.parse(str);
        ZoneOffset offset = ZoneOffset.ofHours(zoneOffsetHour);
        ZoneId zoneId = ZoneId.of(offset.getId());
        ZonedDateTime zonedDateTime = instant.atZone(zoneId);
        return Timestamp.valueOf(zonedDateTime.toLocalDateTime());
    }

    public String convertLocalToUTC(Timestamp timestamp, int zoneOffset) {
        ZoneOffset zoneOffsetAdjusted = ZoneOffset.ofHours(zoneOffset);
        ZonedDateTime localDateTime = timestamp.toLocalDateTime().atZone(ZoneId.of(zoneOffsetAdjusted.getId()));
        ZonedDateTime utcDateTime = localDateTime.withZoneSameInstant(ZoneId.of("UTC"));
        return utcDateTime.toInstant().toString();
    }

    public int getUtcHoursOffset() {
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime now = ZonedDateTime.now(zoneId);
        int offsetInSeconds = now.getOffset().getTotalSeconds();
        return offsetInSeconds / 3600;
    }

    private DateTimeTypesConverter$() {
        MODULE$ = this;
    }
}

