/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.spyt.common.utils;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class UuidUtils$ {
    public static UuidUtils$ MODULE$;
    private final int UUID_STRING_LENGTH;
    private final int UUID_BYTES_LENGTH;
    private final Set<Object> HYPHEN_POSITIONS;

    static {
        new UuidUtils$();
    }

    private int UUID_STRING_LENGTH() {
        return this.UUID_STRING_LENGTH;
    }

    private int UUID_BYTES_LENGTH() {
        return this.UUID_BYTES_LENGTH;
    }

    private Set<Object> HYPHEN_POSITIONS() {
        return this.HYPHEN_POSITIONS;
    }

    public byte[] UTF8UuidToBytes(UTF8String uuid) {
        return this.uuidToBytes(uuid.toString());
    }

    public byte[] uuidToBytes(String uuid) {
        this.validateFormat(uuid);
        ByteBuffer bb = ByteBuffer.allocate(this.UUID_BYTES_LENGTH());
        this.parseComponent(uuid, 0, 8, bb, true);
        this.parseComponent(uuid, 9, 13, bb, true);
        this.parseComponent(uuid, 14, 18, bb, true);
        this.parseComponent(uuid, 19, 23, bb, false);
        this.parseComponent(uuid, 24, 36, bb, false);
        return bb.array();
    }

    public UTF8String bytesToUTF8Uuid(byte[] bytes) {
        return UTF8String.fromString((String)this.bytesToUuid(bytes));
    }

    public String bytesToUuid(byte[] bytes) {
        Predef$.MODULE$.require(bytes.length == this.UUID_BYTES_LENGTH(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("UUID must be ").append(MODULE$.UUID_BYTES_LENGTH()).append(" bytes").toString());
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        Seq components = (Seq)new .colon.colon((Object)this.readComponent(bb, 4, true), (List)new .colon.colon((Object)this.readComponent(bb, 2, true), (List)new .colon.colon((Object)this.readComponent(bb, 2, true), (List)new .colon.colon((Object)this.readComponent(bb, 2, false), (List)new .colon.colon((Object)this.readComponent(bb, 6, false), (List)Nil$.MODULE$)))));
        return components.mkString("-");
    }

    private void parseComponent(String s, int start, int end, ByteBuffer bb, boolean reverse) {
        IndexedSeq pairs = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (end - start) / 2).map((Function1 & Serializable & scala.Serializable)i -> UuidUtils$.$anonfun$parseComponent$1(start, s, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq orderedPairs = reverse ? (IndexedSeq)pairs.reverse() : pairs;
        orderedPairs.foreach((Function1 & Serializable & scala.Serializable)pair -> bb.put(MODULE$.parseHexPair((String)pair)));
    }

    private String readComponent(ByteBuffer bb, int byteCount, boolean reverse) {
        byte[] buffer = new byte[byteCount];
        bb.get(buffer);
        byte[] ordered = reverse ? (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(buffer)).reverse() : buffer;
        return this.bytesToHex(ordered);
    }

    private String bytesToHex(byte[] bytes) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).map((Function1 & Serializable & scala.Serializable)b -> UuidUtils$.$anonfun$bytesToHex$1(BoxesRunTime.unboxToByte((Object)b)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString();
    }

    private byte parseHexPair(String pair) {
        int high = this.charToNibble(pair.charAt(0));
        int low = this.charToNibble(pair.charAt(1));
        return (byte)(high << 4 | low);
    }

    private int charToNibble(char c) {
        int n;
        char c2 = c;
        switch (c2) {
            default: 
        }
        if (c >= '0' && c <= '9') {
            n = c - 48;
        } else if (c >= 'a' && c <= 'f') {
            n = c - 97 + 10;
        } else if (c >= 'A' && c <= 'F') {
            n = c - 65 + 10;
        } else {
            throw new IllegalArgumentException(new StringBuilder(23).append("Invalid hex character: ").append(c).toString());
        }
        return n;
    }

    private void validateFormat(String s) {
        Predef$.MODULE$.require(s.length() == this.UUID_STRING_LENGTH(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Invalid UUID length: ").append(s.length()).append(", expected ").append(MODULE$.UUID_STRING_LENGTH()).toString());
        this.HYPHEN_POSITIONS().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)pos -> Predef$.MODULE$.require(s.charAt(pos) == '-', (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Missing hyphen at position ").append(pos).append(" in UUID string").toString()));
    }

    public static final /* synthetic */ String $anonfun$parseComponent$1(int start$1, String s$1, int i) {
        int offset = start$1 + i * 2;
        return s$1.substring(offset, offset + 2);
    }

    public static final /* synthetic */ String $anonfun$bytesToHex$1(byte b) {
        int arg$macro$1 = b & 0xFF;
        return new StringOps("%02x").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$1)}));
    }

    private UuidUtils$() {
        MODULE$ = this;
        this.UUID_STRING_LENGTH = 36;
        this.UUID_BYTES_LENGTH = 16;
        this.HYPHEN_POSITIONS = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{8, 13, 18, 23}));
    }
}

