/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.spyt.fs;

import java.io.Serializable;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.spark.sql.SparkSession$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichLong$;
import tech.ytsaurus.client.CompoundClient;
import tech.ytsaurus.core.cypress.YPath;
import tech.ytsaurus.spyt.fs.YtFileStatus$;
import tech.ytsaurus.spyt.fs.YtFileSystemBase;
import tech.ytsaurus.spyt.fs.YtHadoopPath;
import tech.ytsaurus.spyt.fs.YtTableFileSystem$;
import tech.ytsaurus.spyt.fs.YtTableMeta;
import tech.ytsaurus.spyt.fs.path.YPathEnriched;
import tech.ytsaurus.spyt.fs.path.YPathEnriched$;
import tech.ytsaurus.spyt.wrapper.YtWrapper$;
import tech.ytsaurus.spyt.wrapper.cypress.PathType;
import tech.ytsaurus.spyt.wrapper.cypress.PathType$;
import tech.ytsaurus.spyt.wrapper.cypress.YtAttributes$;
import tech.ytsaurus.spyt.wrapper.table.OptimizeMode;
import tech.ytsaurus.spyt.wrapper.table.TableType;
import tech.ytsaurus.ysontree.YTreeNode;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\u000b\u0017\u0001}AQ\u0001\n\u0001\u0005\u0002\u0015Bqa\n\u0001C\u0002\u0013%\u0001\u0006\u0003\u00042\u0001\u0001\u0006I!\u000b\u0005\u0006e\u0001!Ia\r\u0005\u0006K\u0002!\tE\u001a\u0005\u0006K\u0002!\tE\u001c\u0005\u0006K\u0002!I!\u001e\u0005\b\u0003\u000b\u0001A\u0011BA\u0004\u0011\u001d\t\t\u0002\u0001C\u0005\u0003'A!\"!\b\u0001\u0011\u000b\u0007I\u0011BA\u0010\u0011\u001d\t\t\u0003\u0001C\u0005\u0003GAq!!\f\u0001\t\u0013\ty\u0003C\u0004\u0002:\u0001!\t%a\u000f\t\u000f\u0005e\u0002\u0001\"\u0003\u0002@!9\u0011\u0011\b\u0001\u0005\n\u0005%saBA1-!\u0005\u00111\r\u0004\u0007+YA\t!!\u001a\t\r\u0011\nB\u0011AA7\u0011%\ty'\u0005b\u0001\n\u0003\t\t\bC\u0004\u0002tE\u0001\u000b\u0011\u0002:\u0003#e#H+\u00192mK\u001aKG.Z*zgR,WN\u0003\u0002\u00181\u0005\u0011am\u001d\u0006\u00033i\tAa\u001d9zi*\u00111\u0004H\u0001\tsR\u001c\u0018-\u001e:vg*\tQ$\u0001\u0003uK\u000eD7\u0001A\n\u0003\u0001\u0001\u0002\"!\t\u0012\u000e\u0003YI!a\t\f\u0003!e#h)\u001b7f'f\u001cH/Z7CCN,\u0017A\u0002\u001fj]&$h\bF\u0001'!\t\t\u0003!A\u0002m_\u001e,\u0012!\u000b\t\u0003U=j\u0011a\u000b\u0006\u0003Y5\nQa\u001d7gi)T\u0011AL\u0001\u0004_J<\u0017B\u0001\u0019,\u0005\u0019aunZ4fe\u0006!An\\4!\u00031\u0019X\r^;q\u0007>tG/\u001a=u)\t!$\fE\u00036qi\u0002E+D\u00017\u0015\u00059\u0014!B:dC2\f\u0017BA\u001d7\u0005\u0019!V\u000f\u001d7fgA\u00111HP\u0007\u0002y)\u0011QHF\u0001\u0005a\u0006$\b.\u0003\u0002@y\ti\u0011\fU1uQ\u0016s'/[2iK\u0012\u0004B!\u0011%L\u001d:\u0011!I\u0012\t\u0003\u0007Zj\u0011\u0001\u0012\u0006\u0003\u000bz\ta\u0001\u0010:p_Rt\u0014BA$7\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011J\u0013\u0002\u0004\u001b\u0006\u0004(BA$7!\t\tE*\u0003\u0002N\u0015\n11\u000b\u001e:j]\u001e\u0004\"a\u0014*\u000e\u0003AS!!\u0015\u000e\u0002\u0011e\u001cxN\u001c;sK\u0016L!a\u0015)\u0003\u0013e#&/Z3O_\u0012,\u0007CA+Y\u001b\u00051&BA,\u001b\u0003\u0019\u0019G.[3oi&\u0011\u0011L\u0016\u0002\u000f\u0007>l\u0007o\\;oI\u000ec\u0017.\u001a8u\u0011\u0015YF\u00011\u0001]\u0003\u00051\u0007CA/d\u001b\u0005q&BA\f`\u0015\t\u0001\u0017-\u0001\u0004iC\u0012|w\u000e\u001d\u0006\u0003E6\na!\u00199bG\",\u0017B\u00013_\u0005\u0011\u0001\u0016\r\u001e5\u0002\u00151L7\u000f^*uCR,8\u000f\u0006\u0002h[B\u0019Q\u0007\u001b6\n\u0005%4$!B!se\u0006L\bCA/l\u0013\tagL\u0001\u0006GS2,7\u000b^1ukNDQaW\u0003A\u0002q#2aZ8q\u0011\u0015Yf\u00011\u0001]\u0011\u0015\th\u00011\u0001s\u0003\u00191\u0017\u000e\u001c;feB\u0011Ql]\u0005\u0003iz\u0013!\u0002U1uQ\u001aKG\u000e^3s)\u00191\u0018P_@\u0002\u0004Q\u0011qm\u001e\u0005\u0006q\u001e\u0001\u001d\u0001V\u0001\u0003sRDQ!P\u0004A\u0002iBQa_\u0004A\u0002q\fq\"\u001a=qC:$G)\u001b:fGR|'/\u001f\t\u0003kuL!A \u001c\u0003\u000f\t{w\u000e\\3b]\"1\u0011\u0011A\u0004A\u0002\u0001\u000b!\"\u0019;ue&\u0014W\u000f^3t\u0011\u0015\tx\u00011\u0001s\u0003=a\u0017n\u001d;Zi\u0012K'/Z2u_JLHCBA\u0005\u0003\u001b\ty\u0001F\u0002h\u0003\u0017AQ\u0001\u001f\u0005A\u0004QCQ!\u0010\u0005A\u0002iBQ!\u001d\u0005A\u0002I\f\u0011\u0002\\8dWR\u000b'\r\\3\u0015\r\u0005U\u0011\u0011DA\u000e)\rQ\u0017q\u0003\u0005\u0006q&\u0001\u001d\u0001\u0016\u0005\u0006{%\u0001\rA\u000f\u0005\u0007\u0003\u0003I\u0001\u0019\u0001!\u0002\u0011%\u001cHI]5wKJ,\u0012\u0001`\u0001\u0010Y>\u001c7n\u0015;bi&\u001cG+\u00192mKR1\u0011QEA\u0015\u0003W!2A[A\u0014\u0011\u0015A8\u0002q\u0001U\u0011\u0015i4\u00021\u0001;\u0011\u0019\t\ta\u0003a\u0001\u0001\u0006\u0001Bn\\2l\tft\u0017-\\5d)\u0006\u0014G.\u001a\u000b\u0007\u0003c\t)$a\u000e\u0015\u0007)\f\u0019\u0004C\u0003y\u0019\u0001\u000fA\u000bC\u0003>\u0019\u0001\u0007!\b\u0003\u0004\u0002\u00021\u0001\r\u0001Q\u0001\u000eO\u0016$h)\u001b7f'R\fG/^:\u0015\u0007)\fi\u0004C\u0003\\\u001b\u0001\u0007A\f\u0006\u0004\u0002B\u0005\u0015\u0013q\t\u000b\u0004U\u0006\r\u0003\"\u0002=\u000f\u0001\b!\u0006\"B\u001f\u000f\u0001\u0004Q\u0004BBA\u0001\u001d\u0001\u0007\u0001\t\u0006\u0005\u0002L\u0005=\u0013\u0011KA*)\rQ\u0017Q\n\u0005\u0006q>\u0001\u001d\u0001\u0016\u0005\u00067>\u0001\r\u0001\u0018\u0005\u0006{=\u0001\rA\u000f\u0005\u0007\u0003\u0003y\u0001\u0019\u0001!)\u000f\u0001\t9&!\u0018\u0002`A\u0019Q'!\u0017\n\u0007\u0005mcG\u0001\tTKJL\u0017\r\u001c,feNLwN\\+J\t\u0006)a/\u00197vKz\t\u0011!A\tZiR\u000b'\r\\3GS2,7+_:uK6\u0004\"!I\t\u0014\u0007E\t9\u0007E\u00026\u0003SJ1!a\u001b7\u0005\u0019\te.\u001f*fMR\u0011\u00111M\u0001\u000f\t\u00163\u0015)\u0016'U?\u001aKE\nV#S+\u0005\u0011\u0018a\u0004#F\r\u0006+F\nV0G\u00132#VI\u0015\u0011")
public class YtTableFileSystem
extends YtFileSystemBase {
    public static final long serialVersionUID = 1L;
    private boolean isDriver;
    private final Logger log = LoggerFactory.getLogger((Class)this.getClass());
    private volatile boolean bitmap$0;

    public static PathFilter DEFAULT_FILTER() {
        return YtTableFileSystem$.MODULE$.DEFAULT_FILTER();
    }

    private Logger log() {
        return this.log;
    }

    private Tuple3<YPathEnriched, Map<String, YTreeNode>, CompoundClient> setupContext(Path f) {
        YPathEnriched path = YPathEnriched$.MODULE$.fromPath(f, YPathEnriched$.MODULE$.fromPath$default$2());
        YPath yPath = path.toYPath();
        CompoundClient yt = this.ytClient(path);
        Map attributes = (Map)this.convertExceptions((Function0 & Serializable & scala.Serializable)() -> YtWrapper$.MODULE$.attributes(yPath, path.transaction(), YtWrapper$.MODULE$.attributes$default$3(), yt));
        return new Tuple3((Object)path, (Object)attributes, (Object)yt);
    }

    public FileStatus[] listStatus(Path f) {
        return this.listStatus(f, YtTableFileSystem$.MODULE$.DEFAULT_FILTER());
    }

    public FileStatus[] listStatus(Path f, PathFilter filter) {
        this.RichLogger(this.log()).debugLazy((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("List status ").append(f).toString());
        Tuple3<YPathEnriched, Map<String, YTreeNode>, CompoundClient> tuple3 = this.setupContext(f);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        YPathEnriched path = (YPathEnriched)tuple3._1();
        Map attributes = (Map)tuple3._2();
        CompoundClient yt = (CompoundClient)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)path, (Object)attributes, (Object)yt);
        Tuple3 tuple33 = tuple32;
        YPathEnriched path2 = (YPathEnriched)tuple33._1();
        Map attributes2 = (Map)tuple33._2();
        CompoundClient yt2 = (CompoundClient)tuple33._3();
        return this.listStatus(path2, true, (Map<String, YTreeNode>)attributes2, filter, yt2);
    }

    private FileStatus[] listStatus(YPathEnriched path, boolean expandDirectory, Map<String, YTreeNode> attributes, PathFilter filter, CompoundClient yt) {
        FileStatus[] fileStatusArray;
        PathType pathType = PathType$.MODULE$.fromAttributes(attributes);
        if (PathType.File$.MODULE$.equals(pathType)) {
            fileStatusArray = (FileStatus[])((Object[])new FileStatus[]{this.getFileStatus(path.lock(yt), attributes, yt)});
        } else if (PathType.Table$.MODULE$.equals(pathType)) {
            fileStatusArray = (FileStatus[])((Object[])new FileStatus[]{this.lockTable(path, attributes, yt)});
        } else if (PathType.Directory$.MODULE$.equals(pathType)) {
            fileStatusArray = expandDirectory ? this.listYtDirectory(path, filter, yt) : (FileStatus[])((Object[])new FileStatus[]{this.getFileStatus(path, attributes, yt)});
        } else {
            throw new IllegalArgumentException(new StringBuilder(11).append("Can't list ").append(pathType).toString());
        }
        return fileStatusArray;
    }

    private FileStatus[] listYtDirectory(YPathEnriched path, PathFilter filter, CompoundClient yt) {
        return (FileStatus[])((TraversableOnce)YtWrapper$.MODULE$.listDir(path.toYPath(), path.transaction(), YtAttributes$.MODULE$.tableAttributes(), yt).flatMap((Function1 & Serializable & scala.Serializable)nameWithAttrs -> {
            Nil$ nil$;
            String name = nameWithAttrs.stringValue();
            if (filter.accept(new Path(name))) {
                Map attributes = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(nameWithAttrs.getAttributes()).asScala()).toMap(Predef$.MODULE$.$conforms());
                nil$ = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.listStatus(path.child(name), false, (Map<String, YTreeNode>)attributes, filter, yt)));
            } else {
                nil$ = Nil$.MODULE$;
            }
            return nil$;
        }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(FileStatus.class));
    }

    private FileStatus lockTable(YPathEnriched path, Map<String, YTreeNode> attributes, CompoundClient yt) {
        FileStatus fileStatus;
        TableType tableType = YtWrapper$.MODULE$.tableType(attributes);
        if (TableType.Static$.MODULE$.equals(tableType)) {
            fileStatus = this.lockStaticTable(path, attributes, yt);
        } else if (TableType.Dynamic$.MODULE$.equals(tableType)) {
            fileStatus = this.lockDynamicTable(path, attributes, yt);
        } else {
            throw new MatchError((Object)tableType);
        }
        return fileStatus;
    }

    private boolean isDriver$lzycompute() {
        YtTableFileSystem ytTableFileSystem = this;
        synchronized (ytTableFileSystem) {
            if (!this.bitmap$0) {
                this.isDriver = SparkSession$.MODULE$.getDefaultSession().nonEmpty();
                this.bitmap$0 = true;
            }
        }
        return this.isDriver;
    }

    private boolean isDriver() {
        return !this.bitmap$0 ? this.isDriver$lzycompute() : this.isDriver;
    }

    private FileStatus lockStaticTable(YPathEnriched path, Map<String, YTreeNode> attributes, CompoundClient yt) {
        return this.getFileStatus(path.dropTimestamp().lock(yt), attributes, yt);
    }

    private FileStatus lockDynamicTable(YPathEnriched path, Map<String, YTreeNode> attributes, CompoundClient yt) {
        FileStatus fileStatus;
        if (path.timestamp().isDefined() || path.transaction().isDefined()) {
            fileStatus = this.getFileStatus(path.lock(yt), attributes, yt);
        } else {
            if (!this.isDriver()) {
                this.log().warn("Generating timestamps of dynamic tables on executors causes reading files with different timestamps");
            }
            long ts = YtWrapper$.MODULE$.maxAvailableTimestamp(path.toYPath(), YtWrapper$.MODULE$.maxAvailableTimestamp$default$2(), yt);
            fileStatus = this.getFileStatus(path.withTimestamp(ts), attributes, yt);
        }
        return fileStatus;
    }

    public FileStatus getFileStatus(Path f) {
        Tuple3<YPathEnriched, Map<String, YTreeNode>, CompoundClient> tuple3 = this.setupContext(f);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        YPathEnriched path = (YPathEnriched)tuple3._1();
        Map attributes = (Map)tuple3._2();
        CompoundClient yt = (CompoundClient)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)path, (Object)attributes, (Object)yt);
        Tuple3 tuple33 = tuple32;
        YPathEnriched path2 = (YPathEnriched)tuple33._1();
        Map attributes2 = (Map)tuple33._2();
        CompoundClient yt2 = (CompoundClient)tuple33._3();
        return this.getFileStatus(f, path2, (Map<String, YTreeNode>)attributes2, yt2);
    }

    private FileStatus getFileStatus(YPathEnriched path, Map<String, YTreeNode> attributes, CompoundClient yt) {
        return this.getFileStatus(path.toPath(), path, attributes, yt);
    }

    private FileStatus getFileStatus(Path f, YPathEnriched path, Map<String, YTreeNode> attributes, CompoundClient yt) {
        FileStatus fileStatus;
        this.RichLogger(this.log()).debugLazy((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Get file status ").append(f).toString());
        long modificationTime = YtWrapper$.MODULE$.modificationTimeTs(attributes);
        PathType pathType = YtWrapper$.MODULE$.pathType(attributes);
        if (PathType.File$.MODULE$.equals(pathType)) {
            long size = YtWrapper$.MODULE$.fileSize(attributes);
            fileStatus = new FileStatus(size, false, 1, size, modificationTime, f);
        } else if (PathType.Table$.MODULE$.equals(pathType)) {
            Tuple2.mcJZ.sp sp2;
            long size = RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(YtWrapper$.MODULE$.fileSize(attributes)), 1L);
            OptimizeMode optimizeMode = YtWrapper$.MODULE$.optimizeMode(attributes);
            TableType tableType = YtWrapper$.MODULE$.tableType(attributes);
            if (TableType.Static$.MODULE$.equals(tableType)) {
                sp2 = new Tuple2.mcJZ.sp(YtWrapper$.MODULE$.rowCount(attributes), false);
            } else if (TableType.Dynamic$.MODULE$.equals(tableType)) {
                sp2 = new Tuple2.mcJZ.sp(YtWrapper$.MODULE$.chunkRowCount(attributes), true);
            } else {
                throw new MatchError((Object)tableType);
            }
            Tuple2.mcJZ.sp sp3 = sp2;
            if (sp3 == null) {
                throw new MatchError((Object)sp3);
            }
            long rowCount = sp3._1$mcJ$sp();
            boolean isDynamic = sp3._2$mcZ$sp();
            Tuple2.mcJZ.sp sp4 = new Tuple2.mcJZ.sp(rowCount, isDynamic);
            Tuple2.mcJZ.sp sp5 = sp4;
            long rowCount2 = sp5._1$mcJ$sp();
            boolean isDynamic2 = sp5._2$mcZ$sp();
            YtHadoopPath richPath = new YtHadoopPath(path, new YtTableMeta(rowCount2, size, modificationTime, optimizeMode, isDynamic2));
            fileStatus = YtFileStatus$.MODULE$.toFileStatus(richPath);
        } else if (PathType.Directory$.MODULE$.equals(pathType)) {
            fileStatus = new FileStatus(0L, true, 1, 0L, modificationTime, f);
        } else if (PathType.None$.MODULE$.equals(pathType)) {
            fileStatus = null;
        } else {
            throw new MatchError((Object)pathType);
        }
        return fileStatus;
    }
}

