/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.spyt.serializers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.ClassUtils;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.expressions.UnsafeMapData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.spyt.types.Date32Type;
import org.apache.spark.sql.spyt.types.Datetime64Type;
import org.apache.spark.sql.spyt.types.DatetimeType;
import org.apache.spark.sql.spyt.types.Interval64Type;
import org.apache.spark.sql.spyt.types.Timestamp64Type;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListMap$;
import scala.collection.mutable.Map;
import scala.collection.mutable.MapLike;
import scala.collection.mutable.WrappedArray;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import tech.ytsaurus.spyt.serializers.SchemaConverter$;
import tech.ytsaurus.spyt.serializers.YsonEncoderConfig;
import tech.ytsaurus.spyt.serializers.YsonRowConverter;
import tech.ytsaurus.spyt.serializers.YtTypeHolder;
import tech.ytsaurus.spyt.serializers.YtTypeHolder$;
import tech.ytsaurus.spyt.types.YTsaurusTypes$;
import tech.ytsaurus.yson.YsonConsumer;
import tech.ytsaurus.ysontree.YTree;
import tech.ytsaurus.ysontree.YTreeBinarySerializer;
import tech.ytsaurus.ysontree.YTreeBooleanNode;
import tech.ytsaurus.ysontree.YTreeBuilder;
import tech.ytsaurus.ysontree.YTreeNode;
import tech.ytsaurus.ysontree.YTreeTextSerializer;

public final class YsonRowConverter$ {
    public static YsonRowConverter$ MODULE$;
    private final ThreadLocal<Map<Tuple2<StructType, YtTypeHolder>, YsonRowConverter>> serializer;

    static {
        new YsonRowConverter$();
    }

    public Object deserializeValue(YTreeNode node2, DataType dataType) {
        Long l;
        if (node2.isEntityNode()) {
            l = null;
        } else {
            Object object;
            DataType dataType2 = dataType;
            if (StringType$.MODULE$.equals(dataType2)) {
                YTreeNode yTreeNode = node2;
                String string = yTreeNode instanceof YTreeBooleanNode ? Boolean.toString(node2.boolValue()) : node2.stringValue();
                object = string;
            } else if (LongType$.MODULE$.equals(dataType2)) {
                object = BoxesRunTime.boxToLong((long)node2.longValue());
            } else if (BooleanType$.MODULE$.equals(dataType2)) {
                object = BoxesRunTime.boxToBoolean((boolean)node2.boolValue());
            } else if (DoubleType$.MODULE$.equals(dataType2)) {
                object = BoxesRunTime.boxToDouble((double)node2.doubleValue());
            } else if (BinaryType$.MODULE$.equals(dataType2)) {
                object = node2.bytesValue();
            } else if (dataType2 instanceof ArrayType) {
                Object object2;
                ArrayType arrayType = (ArrayType)dataType2;
                DataType elementType = arrayType.elementType();
                ByteArrayInputStream input = new ByteArrayInputStream((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(node2.toBinary())).dropWhile((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)YsonRowConverter$.$anonfun$deserializeValue$1(BoxesRunTime.unboxToByte((Object)x$6)))));
                List deserialized = YTreeTextSerializer.deserialize((InputStream)input).asList();
                DataType dataType3 = elementType;
                if (StringType$.MODULE$.equals(dataType3)) {
                    ArrayBuilder builder = Array$.MODULE$.newBuilder(ClassTag$.MODULE$.apply(String.class));
                    deserialized.forEach(node -> builder.$plus$eq((Object)node.stringValue()));
                    object2 = builder.result();
                } else if (LongType$.MODULE$.equals(dataType3)) {
                    ArrayBuilder builder = Array$.MODULE$.newBuilder(ClassTag$.MODULE$.Long());
                    deserialized.forEach(node -> builder.$plus$eq((Object)BoxesRunTime.boxToLong((long)node.longValue())));
                    object2 = builder.result();
                } else {
                    throw new MatchError((Object)dataType3);
                }
                object = object2;
            } else {
                throw new MatchError((Object)dataType2);
            }
            l = object;
        }
        return l;
    }

    public boolean tech$ytsaurus$spyt$serializers$YsonRowConverter$$isNull(Object any) {
        Object object = any;
        boolean bl = object == null ? true : None$.MODULE$.equals(object);
        return bl;
    }

    public <TRes, TAlt> TRes extractValue(Object value, Function1<TAlt, TRes> convert, ClassTag<TRes> evidence$1) {
        Class tResClass = ((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass();
        return (TRes)(tResClass.isInstance(value) || ClassUtils.isAssignable(value.getClass(), (Class)tResClass, (boolean)true) ? value : convert.apply(value));
    }

    public void serializeValue(Object value, DataType dataType, YsonEncoderConfig config, YsonConsumer consumer, YtTypeHolder ytType) {
        if (this.tech$ytsaurus$spyt$serializers$YsonRowConverter$$isNull(value)) {
            consumer.onEntity();
        } else {
            DataType dataType2 = dataType;
            if (ByteType$.MODULE$.equals(dataType2)) {
                consumer.onInteger((long)BoxesRunTime.unboxToByte((Object)value));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (ShortType$.MODULE$.equals(dataType2)) {
                consumer.onInteger((long)BoxesRunTime.unboxToShort((Object)value));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (IntegerType$.MODULE$.equals(dataType2)) {
                consumer.onInteger((long)BoxesRunTime.unboxToInt((Object)value));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (LongType$.MODULE$.equals(dataType2)) {
                consumer.onInteger(BoxesRunTime.unboxToLong((Object)value));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (StringType$.MODULE$.equals(dataType2)) {
                Object object = value;
                if (object instanceof UTF8String) {
                    UTF8String uTF8String = (UTF8String)object;
                    byte[] bytes = uTF8String.getBytes();
                    consumer.onString(bytes, 0, bytes.length);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (object instanceof String) {
                    String string = (String)object;
                    consumer.onString(string);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError(object);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (BooleanType$.MODULE$.equals(dataType2)) {
                consumer.onBoolean(BoxesRunTime.unboxToBoolean((Object)value));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (FloatType$.MODULE$.equals(dataType2)) {
                consumer.onDouble((double)BoxesRunTime.unboxToFloat((Object)value));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (DoubleType$.MODULE$.equals(dataType2)) {
                consumer.onDouble(BoxesRunTime.unboxToDouble((Object)value));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (BinaryType$.MODULE$.equals(dataType2)) {
                byte[] bytes = (byte[])value;
                consumer.onString(bytes, 0, bytes.length);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (dataType2 instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)dataType2;
                if (!config.typeV3Format()) {
                    throw new IllegalArgumentException("Writing decimal type without enabled type_v3 is not supported");
                }
                Decimal decimalValue = (Decimal)this.extractValue(value, (Function1 & Serializable & scala.Serializable)x$7 -> Decimal$.MODULE$.apply(x$7), ClassTag$.MODULE$.apply(Decimal.class));
                byte[] binary = SchemaConverter$.MODULE$.decimalToBinary(ytType.ytType(), decimalType, decimalValue);
                consumer.onString(binary, 0, binary.length);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (dataType2 instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType2;
                this.serializeArray(value, arrayType, ytType, config, consumer);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (dataType2 instanceof StructType) {
                StructType structType = (StructType)dataType2;
                this.getOrCreate(structType, ytType, config).serializeStruct(value, consumer);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (dataType2 instanceof MapType) {
                MapType mapType = (MapType)dataType2;
                this.serializeMap(value, mapType, ytType, config, consumer);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (dataType2 instanceof DatetimeType) {
                consumer.onUnsignedInteger(BoxesRunTime.unboxToLong(this.extractValue(value, (Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.toLong()), ClassTag$.MODULE$.Long())));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (DateType$.MODULE$.equals(dataType2)) {
                consumer.onUnsignedInteger((long)BoxesRunTime.unboxToInt((Object)value));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (TimestampType$.MODULE$.equals(dataType2)) {
                consumer.onUnsignedInteger(BoxesRunTime.unboxToLong((Object)value));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (dataType2 instanceof Date32Type) {
                consumer.onInteger((long)BoxesRunTime.unboxToInt(this.extractValue(value, (Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.toInt()), ClassTag$.MODULE$.Int())));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (dataType2 instanceof Datetime64Type) {
                consumer.onInteger(BoxesRunTime.unboxToLong(this.extractValue(value, (Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.toLong()), ClassTag$.MODULE$.Long())));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (dataType2 instanceof Timestamp64Type) {
                consumer.onInteger(BoxesRunTime.unboxToLong(this.extractValue(value, (Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.toLong()), ClassTag$.MODULE$.Long())));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (dataType2 instanceof Interval64Type) {
                consumer.onInteger(BoxesRunTime.unboxToLong(this.extractValue(value, (Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.toLong()), ClassTag$.MODULE$.Long())));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                YTsaurusTypes$.MODULE$.instance().toYsonField(dataType2, value, consumer);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private void serializeArray(Object value, ArrayType arrayType, YtTypeHolder ytType, YsonEncoderConfig config, YsonConsumer consumer) {
        IndexedSeq indexedSeq;
        DataType elementType = arrayType.elementType();
        consumer.onBeginList();
        Object object = value;
        if (object instanceof UnsafeArrayData) {
            UnsafeArrayData unsafeArrayData = (UnsafeArrayData)object;
            indexedSeq = unsafeArrayData.toSeq(elementType);
        } else if (object instanceof WrappedArray.ofRef) {
            WrappedArray.ofRef ofRef2 = (WrappedArray.ofRef)object;
            indexedSeq = ofRef2;
        } else if (object instanceof Seq) {
            Seq seq = (Seq)object;
            indexedSeq = seq;
        } else {
            throw new MatchError(object);
        }
        IndexedSeq iterable = indexedSeq;
        iterable.foreach((Function1 & Serializable & scala.Serializable)row -> {
            YsonRowConverter$.$anonfun$serializeArray$1(consumer, elementType, config, ytType, row);
            return BoxedUnit.UNIT;
        });
        consumer.onEndList();
    }

    private void serializeMapTypeV3(Iterable<Tuple2<Object, Object>> map, MapType mapType, YtTypeHolder ytType, YsonConsumer consumer) {
        if (!mapType.valueContainsNull()) {
            map.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                YsonRowConverter$.$anonfun$serializeMapTypeV3$1(x0$1);
                return BoxedUnit.UNIT;
            });
        }
        consumer.onBeginList();
        map.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            YsonRowConverter$.$anonfun$serializeMapTypeV3$2(consumer, mapType, ytType, x0$2);
            return BoxedUnit.UNIT;
        });
        consumer.onEndList();
    }

    private void serializeMapTypeV1(Iterable<Tuple2<Object, Object>> map, MapType mapType, YsonConsumer consumer) {
        consumer.onBeginMap();
        map.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            YsonRowConverter$.$anonfun$serializeMapTypeV1$1(consumer, mapType, x0$1);
            return BoxedUnit.UNIT;
        });
        consumer.onEndMap();
    }

    private void serializeMap(Object value, MapType mapType, YtTypeHolder ytType, YsonEncoderConfig config, YsonConsumer consumer) {
        Iterable<Tuple2<Object, Object>> map = this.getMapData(value, mapType.keyType(), mapType.valueType());
        if (config.typeV3Format()) {
            this.serializeMapTypeV3(map, mapType, ytType, consumer);
        } else {
            this.serializeMapTypeV1(map, mapType, consumer);
        }
    }

    public YTreeNode serializeToYson(Object value, DataType dataType, boolean skipNulls) {
        YTreeBuilder consumer = YTree.builder();
        this.serializeValue(value, dataType, new YsonEncoderConfig(skipNulls, false), (YsonConsumer)consumer, this.serializeValue$default$5());
        return consumer.build();
    }

    public byte[] serialize(Object value, DataType dataType, boolean skipNulls) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        YTreeBinarySerializer.serialize((YTreeNode)this.serializeToYson(value, dataType, skipNulls), (OutputStream)output);
        return output.toByteArray();
    }

    public YtTypeHolder serializeValue$default$5() {
        return YtTypeHolder$.MODULE$.empty();
    }

    private ThreadLocal<Map<Tuple2<StructType, YtTypeHolder>, YsonRowConverter>> serializer() {
        return this.serializer;
    }

    public YsonRowConverter getOrCreate(StructType schema, YtTypeHolder ytSchema, YsonEncoderConfig config) {
        return (YsonRowConverter)((MapLike)this.serializer().get()).getOrElseUpdate((Object)new Tuple2((Object)schema, (Object)ytSchema), (Function0 & Serializable & scala.Serializable)() -> new YsonRowConverter(schema, ytSchema, config));
    }

    public YtTypeHolder getOrCreate$default$2() {
        return YtTypeHolder$.MODULE$.empty();
    }

    public Iterable<Tuple2<Object, Object>> getMapData(Object value, DataType keyType, DataType valueType) {
        scala.collection.immutable.Map map;
        DataType dataType = keyType;
        if (StringType$.MODULE$.equals(dataType)) {
            map = this.sortMapData(value, valueType);
        } else {
            scala.collection.immutable.Map map2;
            Object object = value;
            if (object instanceof scala.collection.immutable.Map) {
                scala.collection.immutable.Map map3;
                map2 = map3 = (scala.collection.immutable.Map)object;
            } else if (object instanceof UnsafeMapData) {
                UnsafeMapData unsafeMapData = (UnsafeMapData)object;
                map2 = (Iterable)unsafeMapData.keyArray().toSeq(keyType).zip((GenIterable)unsafeMapData.valueArray().toSeq(valueType), IndexedSeq$.MODULE$.canBuildFrom());
            } else {
                throw new MatchError(object);
            }
            map = map2;
        }
        return map;
    }

    public Iterable<Tuple2<Object, Object>> sortMapData(Object mapData, DataType valueType) {
        Iterable iterable;
        Object object = mapData;
        if (object instanceof scala.collection.immutable.Map) {
            scala.collection.immutable.Map map = (scala.collection.immutable.Map)object;
            iterable = (Iterable)map.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$13 -> x$13._1().toString(), (Ordering)Ordering.String$.MODULE$);
        } else if (object instanceof MapData) {
            MapData mapData2 = (MapData)object;
            iterable = (Iterable)((SeqLike)mapData2.keyArray().toSeq((DataType)StringType$.MODULE$).zip((GenIterable)mapData2.valueArray().toSeq(valueType), IndexedSeq$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)x$14 -> (UTF8String)x$14._1(), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
        } else {
            throw new MatchError(object);
        }
        return iterable;
    }

    public static final /* synthetic */ boolean $anonfun$deserializeValue$1(byte x$6) {
        return x$6 != 91;
    }

    public static final /* synthetic */ void $anonfun$serializeArray$1(YsonConsumer consumer$5, DataType elementType$1, YsonEncoderConfig config$1, YtTypeHolder ytType$1, Object row) {
        consumer$5.onListItem();
        MODULE$.serializeValue(row, elementType$1, new YsonEncoderConfig(false, config$1.typeV3Format()), consumer$5, ytType$1.getListItem());
    }

    public static final /* synthetic */ void $anonfun$serializeMapTypeV3$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Object value = tuple2._2();
            if (value == null) {
                throw new IllegalArgumentException("Try to write null value to non-null column");
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$serializeMapTypeV3$2(YsonConsumer consumer$6, MapType mapType$1, YtTypeHolder ytType$2, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object key = tuple2._1();
        Object value = tuple2._2();
        consumer$6.onListItem();
        consumer$6.onBeginList();
        consumer$6.onListItem();
        MODULE$.serializeValue(key, mapType$1.keyType(), new YsonEncoderConfig(false, true), consumer$6, ytType$2.getMapKey());
        consumer$6.onListItem();
        MODULE$.serializeValue(value, mapType$1.valueType(), new YsonEncoderConfig(false, true), consumer$6, ytType$2.getMapValue());
        consumer$6.onEndList();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$serializeMapTypeV1$1(YsonConsumer consumer$7, MapType mapType$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object key = tuple2._1();
        Object mapValue = tuple2._2();
        consumer$7.onKeyedItem(key.toString());
        MODULE$.serializeValue(mapValue, mapType$2.valueType(), new YsonEncoderConfig(false, false), consumer$7, MODULE$.serializeValue$default$5());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private YsonRowConverter$() {
        MODULE$ = this;
        this.serializer = ThreadLocal.withInitial(() -> ListMap$.MODULE$.empty());
    }
}

