/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.spark.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class AdditionalMetrics$ {
    public static AdditionalMetrics$ MODULE$;
    private final Logger log;
    private final Regex deviceName;

    static {
        new AdditionalMetrics$();
    }

    private Logger log() {
        return this.log;
    }

    private Regex deviceName() {
        return this.deviceName;
    }

    private void registerDiskMetrics(MetricRegistry registry, String prefix) {
        this.log().info(new StringBuilder(29).append("Registering disk metrics for ").append(prefix).toString());
        registry.register(new StringBuilder(11).append(prefix).append(".total_disk").toString(), (Metric)new Gauge<Object>(){

            public long getValue() {
                return AdditionalMetrics$.MODULE$.totalDiskSpaceBytes();
            }
        });
        registry.register(new StringBuilder(15).append(prefix).append(".available_disk").toString(), (Metric)new Gauge<Object>(){

            public long getValue() {
                return AdditionalMetrics$.MODULE$.availableDiskSpaceBytes();
            }
        });
        boolean ssd = this.isSsdDisk();
        this.log().info(new StringBuilder(21).append("Running on ssd disk: ").append(ssd).toString());
        registry.register(new StringBuilder(10).append(prefix).append(".total_ssd").toString(), (Metric)new Gauge<Object>(ssd){
            private final boolean ssd$1;

            public long getValue() {
                return this.ssd$1 ? AdditionalMetrics$.MODULE$.totalDiskSpaceBytes() : 0L;
            }
            {
                this.ssd$1 = ssd$1;
            }
        });
        registry.register(new StringBuilder(14).append(prefix).append(".available_ssd").toString(), (Metric)new Gauge<Object>(ssd){
            private final boolean ssd$1;

            public long getValue() {
                return this.ssd$1 ? AdditionalMetrics$.MODULE$.availableDiskSpaceBytes() : 0L;
            }
            {
                this.ssd$1 = ssd$1;
            }
        });
    }

    public void register(MetricRegistry registry, String instance) {
        this.registerDiskMetrics(registry, instance);
    }

    public long totalDiskSpaceBytes() {
        return this.currentDir().getTotalSpace();
    }

    public long availableDiskSpaceBytes() {
        return this.currentDir().getUsableSpace();
    }

    public boolean isSsdDisk() {
        boolean bl;
        try {
            Path currentPath = this.currentDir().toPath();
            String device = this.deviceName(currentPath);
            this.log().info(new StringBuilder(24).append("Detected device name is ").append(device).toString());
            bl = this.isSsd(device);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable ex = (Throwable)option.get();
            this.log().error("Unable to detect disk type, assuming it is hdd", ex);
            boolean bl2 = false;
            bl = bl2;
        }
        return bl;
    }

    public File currentDir() {
        return new File(".");
    }

    private String deviceName(Path path) {
        String p;
        String fsName;
        Path absPath = path.toAbsolutePath();
        String string = fsName = Files.getFileStore(absPath).name();
        Option option = this.deviceName().unapplySeq((CharSequence)string);
        String string2 = !option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0 ? (p = (String)((LinearSeqOptimized)option.get()).apply(0)) : ((Object)absPath.getRoot().resolve(fsName).toRealPath(new LinkOption[0]).getFileName()).toString();
        return string2;
    }

    private boolean isSsd(String devName) {
        boolean bl;
        Path sysinfo = new File("/").toPath().getRoot().resolve("sys").resolve("block");
        Path d2 = (Path)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(Files.newDirectoryStream(sysinfo)).asScala()).filter((Function1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToBoolean((boolean)AdditionalMetrics$.$anonfun$isSsd$1(devName, d)))).toSeq().maxBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)AdditionalMetrics$.$anonfun$isSsd$2(x$1)), (Ordering)Ordering.Int$.MODULE$);
        Path path = d2.resolve("queue").resolve("rotational");
        try (BufferedSource s = Source$.MODULE$.fromFile(path.toFile(), Codec$.MODULE$.fallbackSystemCodec());){
            String string = s.getLines().mkString().trim();
            String string2 = "0";
            bl = !(string != null ? !string.equals(string2) : string2 != null);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$isSsd$1(String devName$1, Path d) {
        return d.getFileName().startsWith(devName$1);
    }

    public static final /* synthetic */ int $anonfun$isSsd$2(Path x$1) {
        return ((Object)x$1).toString().length();
    }

    private AdditionalMetrics$() {
        MODULE$ = this;
        this.log = LoggerFactory.getLogger(this.getClass());
        this.deviceName = new StringOps(Predef$.MODULE$.augmentString("^/dev/(\\D+?)\\d+$")).r();
    }
}

