/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.spark.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Metered;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;
import tech.ytsaurus.spark.metrics.Counter;
import tech.ytsaurus.spark.metrics.DGauge;
import tech.ytsaurus.spark.metrics.IGauge;
import tech.ytsaurus.spark.metrics.JsonMetricEncoder;
import tech.ytsaurus.spark.metrics.Metric;
import tech.ytsaurus.spark.metrics.MetricEncoder;
import tech.ytsaurus.spark.metrics.SolomonConfig;
import tech.ytsaurus.spark.metrics.SolomonConfig$JsonEncoding$;
import tech.ytsaurus.spark.metrics.SolomonConfig$SpackEncoding$;

public final class MetricEncoder$ {
    public static MetricEncoder$ MODULE$;
    private final Logger tech$ytsaurus$spark$metrics$MetricEncoder$$log;

    static {
        new MetricEncoder$();
    }

    public Logger tech$ytsaurus$spark$metrics$MetricEncoder$$log() {
        return this.tech$ytsaurus$spark$metrics$MetricEncoder$$log;
    }

    public MetricEncoder apply(SolomonConfig solomonConfig) {
        SolomonConfig.Encoding encoding = solomonConfig.encoding();
        if (!SolomonConfig$JsonEncoding$.MODULE$.equals(encoding)) {
            if (SolomonConfig$SpackEncoding$.MODULE$.equals(encoding)) {
                throw new IllegalArgumentException("Spack format is not yet supported");
            }
            throw new MatchError((Object)encoding);
        }
        JsonMetricEncoder jsonMetricEncoder = new JsonMetricEncoder(solomonConfig);
        return jsonMetricEncoder;
    }

    public String tech$ytsaurus$spark$metrics$MetricEncoder$$fixName(String name) {
        String string;
        String string2 = name;
        String string3 = "project";
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            string = "project_label";
        } else {
            String string4 = name;
            String string5 = "cluster";
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                string = "host_label";
            } else {
                String string6 = name;
                String string7 = "service";
                string = !(string6 != null ? !string6.equals(string7) : string7 != null) ? "service_label" : name.replace('.', '_');
            }
        }
        return string;
    }

    public <T> Option<Metric> tech$ytsaurus$spark$metrics$MetricEncoder$$fromGauge(String name, Gauge<T> gauge) {
        None$ none$;
        Object object = gauge.getValue();
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            none$ = new Some((Object)new IGauge((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sensor"), (Object)name)}))), n.longValue()));
        } else if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            none$ = new Some((Object)new IGauge((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sensor"), (Object)name)}))), l));
        } else if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            none$ = Float.isNaN(f) ? None$.MODULE$ : new Some((Object)new DGauge((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sensor"), (Object)name)}))), f));
        } else if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            none$ = Double.isNaN(d) ? None$.MODULE$ : new Some((Object)new DGauge((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sensor"), (Object)name)}))), d));
        } else if (object == null) {
            this.tech$ytsaurus$spark$metrics$MetricEncoder$$log().debug(new StringBuilder(14).append("Gauge ").append(name).append(" is null").toString());
            none$ = None$.MODULE$;
        } else {
            this.tech$ytsaurus$spark$metrics$MetricEncoder$$log().debug(new StringBuilder(36).append("Unsupported gauge type: ").append(object.getClass()).append(" for metric ").append(name).toString());
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<Metric> tech$ytsaurus$spark$metrics$MetricEncoder$$fromCounter(String name, com.codahale.metrics.Counter counter) {
        return new Some((Object)new Counter((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sensor"), (Object)name)}))), counter.getCount()));
    }

    public Seq<Metric> tech$ytsaurus$spark$metrics$MetricEncoder$$fromMeter(String name, Metered meter) {
        return (Seq)new .colon.colon((Object)new Counter((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sensor"), (Object)new StringBuilder(6).append(name).append(".count").toString())}))), meter.getCount()), (List)new .colon.colon((Object)new DGauge((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sensor"), (Object)new StringBuilder(10).append(name).append(".mean_rate").toString())}))), meter.getMeanRate()), (List)new .colon.colon((Object)new DGauge((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sensor"), (Object)new StringBuilder(10).append(name).append(".rate_1min").toString())}))), meter.getOneMinuteRate()), (List)new .colon.colon((Object)new DGauge((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sensor"), (Object)new StringBuilder(10).append(name).append(".rate_5min").toString())}))), meter.getFiveMinuteRate()), (List)new .colon.colon((Object)new DGauge((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sensor"), (Object)new StringBuilder(11).append(name).append(".rate_15min").toString())}))), meter.getFifteenMinuteRate()), (List)Nil$.MODULE$)))));
    }

    public Seq<Metric> tech$ytsaurus$spark$metrics$MetricEncoder$$fromHistogram(String name, Histogram hist) {
        Counter counter = new Counter((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sensor"), (Object)new StringBuilder(6).append(name).append(".count").toString())}))), hist.getCount());
        return (Seq)this.fromSnapshot(name, hist.getSnapshot()).$plus$colon((Object)counter, Seq$.MODULE$.canBuildFrom());
    }

    private Seq<Metric> fromSnapshot(String name, Snapshot snapshot) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DGauge[]{new DGauge((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sensor"), (Object)new StringBuilder(5).append(name).append(".mean").toString())}))), snapshot.getMean()), new DGauge((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sensor"), (Object)new StringBuilder(4).append(name).append(".max").toString())}))), snapshot.getMax()), new DGauge((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sensor"), (Object)new StringBuilder(4).append(name).append(".min").toString())}))), snapshot.getMin()), new DGauge((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sensor"), (Object)new StringBuilder(7).append(name).append(".stddev").toString())}))), snapshot.getStdDev()), new DGauge((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sensor"), (Object)new StringBuilder(7).append(name).append(".median").toString())}))), snapshot.getMedian()), new DGauge((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sensor"), (Object)new StringBuilder(4).append(name).append(".p75").toString())}))), snapshot.get75thPercentile()), new DGauge((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sensor"), (Object)new StringBuilder(4).append(name).append(".p95").toString())}))), snapshot.get95thPercentile()), new DGauge((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sensor"), (Object)new StringBuilder(4).append(name).append(".p99").toString())}))), snapshot.get99thPercentile())}));
    }

    public Seq<Metric> tech$ytsaurus$spark$metrics$MetricEncoder$$fromTimer(String name, Timer timer) {
        return (Seq)this.tech$ytsaurus$spark$metrics$MetricEncoder$$fromMeter(name, (Metered)timer).$plus$plus(this.fromSnapshot(name, timer.getSnapshot()), Seq$.MODULE$.canBuildFrom());
    }

    private MetricEncoder$() {
        MODULE$ = this;
        this.tech$ytsaurus$spark$metrics$MetricEncoder$$log = LoggerFactory.getLogger(this.getClass());
    }
}

