/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.spyt.fs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Option$;
import scala.reflect.ScalaSignature;
import tech.ytsaurus.spyt.fs.LocalFSInputStream;
import tech.ytsaurus.spyt.fs.YtFileSystem;

@ScalaSignature(bytes="\u0006\u0001\u0005%d\u0001B\t\u0013\u0001mAQ\u0001\t\u0001\u0005\u0002\u0005Bqa\t\u0001C\u0002\u0013%A\u0005\u0003\u0004.\u0001\u0001\u0006I!\n\u0005\b]\u0001\u0011\r\u0011\"\u00030\u0011\u0019A\u0004\u0001)A\u0005a!I\u0011\b\u0001a\u0001\u0002\u0004%IA\u000f\u0005\n\u0007\u0002\u0001\r\u00111A\u0005\n\u0011C\u0011\"\u0014\u0001A\u0002\u0003\u0005\u000b\u0015B\u001e\t\u000b9\u0003A\u0011I(\t\u000b\r\u0004A\u0011\u00023\t\u000bE\u0004A\u0011\u0002:\t\u0013\u0005\u0015\u0001!%A\u0005\n\u0005\u001d\u0001bBA\u000f\u0001\u0011%\u0011q\u0004\u0005\b\u0003K\u0001A\u0011IA\u0014\u00111\tY\u0004\u0001I\u0001\u0002\u0003\u0005I\u0011AA\u001f\u00119\ty\u0005\u0001I\u0001\u0004\u0003\u0005I\u0011BA)\u0003/\u0012!#\u0017;DC\u000eDW\r\u001a$jY\u0016\u001c\u0016p\u001d;f[*\u00111\u0003F\u0001\u0003MNT!!\u0006\f\u0002\tM\u0004\u0018\u0010\u001e\u0006\u0003/a\t\u0001\"\u001f;tCV\u0014Xo\u001d\u0006\u00023\u0005!A/Z2i\u0007\u0001\u0019\"\u0001\u0001\u000f\u0011\u0005uqR\"\u0001\n\n\u0005}\u0011\"\u0001D-u\r&dWmU=ti\u0016l\u0017A\u0002\u001fj]&$h\bF\u0001#!\ti\u0002!A\u0002m_\u001e,\u0012!\n\t\u0003M-j\u0011a\n\u0006\u0003Q%\nQa\u001d7gi)T\u0011AK\u0001\u0004_J<\u0017B\u0001\u0017(\u0005\u0019aunZ4fe\u0006!An\\4!\u0003i!\u0015JU#D)>\u0013\u0016l\u0018$P%~\u001b\u0015i\u0011%F\t~3\u0015\nT#T+\u0005\u0001\u0004CA\u00197\u001b\u0005\u0011$BA\u001a5\u0003\u0011a\u0017M\\4\u000b\u0003U\nAA[1wC&\u0011qG\r\u0002\u0007'R\u0014\u0018N\\4\u00027\u0011K%+R\"U\u001fJKvLR(S?\u000e\u000b5\tS#E?\u001aKE*R*!\u00035\u0019\u0017m\u00195fI\u0012K'\u000fU1uQV\t1\b\u0005\u0002=\u00036\tQH\u0003\u0002?\u007f\u0005!a-\u001b7f\u0015\t\u0001E'A\u0002oS>L!AQ\u001f\u0003\tA\u000bG\u000f[\u0001\u0012G\u0006\u001c\u0007.\u001a3ESJ\u0004\u0016\r\u001e5`I\u0015\fHCA#L!\t1\u0015*D\u0001H\u0015\u0005A\u0015!B:dC2\f\u0017B\u0001&H\u0005\u0011)f.\u001b;\t\u000f1;\u0011\u0011!a\u0001w\u0005\u0019\u0001\u0010J\u0019\u0002\u001d\r\f7\r[3e\t&\u0014\b+\u0019;iA\u0005Q\u0011N\\5uS\u0006d\u0017N_3\u0015\u0007\u0015\u0003\u0006\fC\u0003R\u0013\u0001\u0007!+A\u0002ve&\u0004\"a\u0015,\u000e\u0003QS!!\u0016\u001b\u0002\u00079,G/\u0003\u0002X)\n\u0019QKU%\t\u000beK\u0001\u0019\u0001.\u0002\t\r|gN\u001a\t\u00037\u0006l\u0011\u0001\u0018\u0006\u00033vS!AX0\u0002\r!\fGm\\8q\u0015\t\u0001\u0017&\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003Er\u0013QbQ8oM&<WO]1uS>t\u0017!D4fi\u000e\u000b7\r[3e\r&dW\r\u0006\u0002fWB\u0011a-[\u0007\u0002O*\u0011\u0001\u000eN\u0001\u0003S>L!A[4\u0003\t\u0019KG.\u001a\u0005\u0006Y*\u0001\r!\\\u0001\u0002MB\u0011a\u000e]\u0007\u0002_*\u00111#X\u0005\u0003\u0005>\f!bY8qsN#(/Z1n)\u0011)5\u000f_?\t\u000bQ\\\u0001\u0019A;\u0002\u0005%t\u0007C\u00014w\u0013\t9xMA\u0006J]B,Ho\u0015;sK\u0006l\u0007\"B=\f\u0001\u0004Q\u0018aA8viB\u0011am_\u0005\u0003y\u001e\u0014AbT;uaV$8\u000b\u001e:fC6DqA`\u0006\u0011\u0002\u0003\u0007q0\u0001\u0007dY>\u001cXm\u0015;sK\u0006l7\u000fE\u0002G\u0003\u0003I1!a\u0001H\u0005\u001d\u0011un\u001c7fC:\fAcY8qsN#(/Z1nI\u0011,g-Y;mi\u0012\u001aTCAA\u0005U\ry\u00181B\u0016\u0003\u0003\u001b\u0001B!a\u0004\u0002\u001a5\u0011\u0011\u0011\u0003\u0006\u0005\u0003'\t)\"A\u0005v]\u000eDWmY6fI*\u0019\u0011qC$\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u001c\u0005E!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006AQn\u001c<f\r&dW\rF\u0003F\u0003C\t\u0019\u0003C\u0003u\u001b\u0001\u0007Q\rC\u0003z\u001b\u0001\u0007Q-\u0001\u0003pa\u0016tGCBA\u0015\u0003_\t\t\u0004E\u0002o\u0003WI1!!\fp\u0005E15\u000bR1uC&s\u0007/\u001e;TiJ,\u0017-\u001c\u0005\u0006Y:\u0001\r!\u001c\u0005\b\u0003gq\u0001\u0019AA\u001b\u0003)\u0011WO\u001a4feNK'0\u001a\t\u0004\r\u0006]\u0012bAA\u001d\u000f\n\u0019\u0011J\u001c;\u0002)A\u0014x\u000e^3di\u0016$Ge\u001d;bi&\u001cH/[2t)\u0011\ty$a\u0013\u0011\t\u0005\u0005\u0013qI\u0007\u0003\u0003\u0007R1!!\u0012p\u0003)1\u0015\u000e\\3TsN$X-\\\u0005\u0005\u0003\u0013\n\u0019E\u0001\u0006Ti\u0006$\u0018n\u001d;jGND\u0001\u0002T\b\u0002\u0002\u0003\u0007\u0011QJ\u0007\u0002\u0001\u0005Q1/\u001e9fe\u0012z\u0007/\u001a8\u0015\r\u0005%\u00121KA+\u0011\u0015a\u0007\u00031\u0001n\u0011\u001d\t\u0019\u0004\u0005a\u0001\u0003kIA!!\n\u0002Z%\u0019\u00111\f\n\u0003!e#h)\u001b7f'f\u001cH/Z7CCN,\u0007f\u0002\u0001\u0002`\u0005\u0015\u0014q\r\t\u0004\r\u0006\u0005\u0014bAA2\u000f\n\u00012+\u001a:jC24VM]:j_:,\u0016\nR\u0001\u0006m\u0006dW/\u001a\u0010\u0002\u0003\u0001")
public class YtCachedFileSystem
extends YtFileSystem {
    public static final long serialVersionUID = 1L;
    private final Logger log = LoggerFactory.getLogger((Class)this.getClass());
    private final String DIRECTORY_FOR_CACHED_FILES;
    private java.nio.file.Path cachedDirPath;

    public /* synthetic */ FileSystem.Statistics protected$statistics(YtCachedFileSystem x$1) {
        return x$1.statistics;
    }

    private /* synthetic */ FSDataInputStream super$open(Path f, int bufferSize) {
        return super.open(f, bufferSize);
    }

    private Logger log() {
        return this.log;
    }

    private String DIRECTORY_FOR_CACHED_FILES() {
        return this.DIRECTORY_FOR_CACHED_FILES;
    }

    private java.nio.file.Path cachedDirPath() {
        return this.cachedDirPath;
    }

    private void cachedDirPath_$eq(java.nio.file.Path x$1) {
        this.cachedDirPath = x$1;
    }

    @Override
    public void initialize(URI uri, Configuration conf) {
        super.initialize(uri, conf);
        this.cachedDirPath_$eq(java.nio.file.Path.of((String)Option$.MODULE$.apply((Object)System.getenv("SPARK_HOME")).getOrElse((Function0 & Serializable & scala.Serializable)() -> System.getProperty("java.io.tmpdir")), this.DIRECTORY_FOR_CACHED_FILES()));
        this.log().info(new StringBuilder(22).append("Path to cached files: ").append(this.cachedDirPath()).toString());
    }

    private File getCachedFile(Path f) {
        String filename = f.toUri().getPath().replace('/', '+');
        java.nio.file.Path localPath = this.cachedDirPath().resolve(filename);
        return localPath.toFile();
    }

    private void copyStream(InputStream in, OutputStream out, boolean closeStreams) {
        try {
            byte[] buf = new byte[8192];
            int n = 0;
            while (n != -1) {
                n = in.read(buf);
                if (n == -1) continue;
                out.write(buf, 0, n);
            }
        }
        finally {
            if (closeStreams) {
                try {
                    in.close();
                }
                finally {
                    out.close();
                }
            }
        }
    }

    private boolean copyStream$default$3() {
        return true;
    }

    private void moveFile(File in, File out) {
        Files.move(java.nio.file.Path.of(in.getPath(), new String[0]), java.nio.file.Path.of(out.getPath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    public FSDataInputStream open(Path f, int bufferSize) {
        return (FSDataInputStream)this.convertExceptions((Function0 & Serializable & scala.Serializable)() -> {
            File cachedFile;
            block7: {
                this.log().info(new StringBuilder(20).append("Cached opening file ").append(f.toUri().toString()).toString());
                this.protected$statistics(this).incrementReadOps(1);
                cachedFile = this.getCachedFile(f);
                if (!cachedFile.exists()) {
                    Files.createDirectories(this.cachedDirPath(), new FileAttribute[0]);
                    File tempFile = new File(this.cachedDirPath().toFile(), new StringBuilder(12).append("caching-").append(UUID.randomUUID()).append(".tmp").toString());
                    try {
                        this.log().info(new StringBuilder(13).append("Fetching ").append(f.toUri().toString()).append(" to ").append(tempFile).toString());
                        FSDataInputStream in = this.super$open(f, bufferSize);
                        FileOutputStream out = new FileOutputStream(tempFile);
                        this.copyStream((InputStream)in, out, this.copyStream$default$3());
                        if (!tempFile.exists()) {
                            throw new IOException(new StringBuilder(30).append("Cached downloading ").append(f.toUri().toString()).append(" to ").append(tempFile).append(" failed").toString());
                        }
                        this.log().info(new StringBuilder(12).append("Copying ").append(tempFile).append(" to ").append(cachedFile).toString());
                        this.moveFile(tempFile, cachedFile);
                        if (!cachedFile.exists()) {
                            throw new IOException(new StringBuilder(34).append("Copying temp file from ").append(tempFile).append(" to ").append(cachedFile).append(" failed").toString());
                        }
                        break block7;
                    }
                    finally {
                        if (tempFile.exists()) {
                            boolean deleteResult = tempFile.delete();
                            this.log().info(new StringBuilder(26).append("Delete temp file ").append(tempFile).append(" status: ").append(deleteResult).toString());
                        }
                    }
                }
                this.log().info("Reusing cached version");
            }
            return new FSDataInputStream((InputStream)((Object)new LocalFSInputStream(cachedFile)));
        });
    }

    public YtCachedFileSystem() {
        this.DIRECTORY_FOR_CACHED_FILES = "cachedDownloadedFiles";
    }
}

