/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.spyt.fs;

import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathNotFoundException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import tech.ytsaurus.client.CompoundClient;
import tech.ytsaurus.spyt.fs.YtFileSystemBase;
import tech.ytsaurus.spyt.fs.path.YPathEnriched;
import tech.ytsaurus.spyt.fs.path.YPathEnriched$;
import tech.ytsaurus.spyt.wrapper.YtWrapper$;
import tech.ytsaurus.spyt.wrapper.cypress.PathType;
import tech.ytsaurus.spyt.wrapper.cypress.YtAttributes$;

@ScalaSignature(bytes="\u0006\u0001A3Aa\u0002\u0005\u0001#!)a\u0003\u0001C\u0001/!9\u0011\u0004\u0001b\u0001\n\u0013Q\u0002BB\u0012\u0001A\u0003%1\u0004C\u0003%\u0001\u0011\u0005S\u0005C\u0003;\u0001\u0011\u00053\bC\u0003>\u0001\u0011\u0005cH\u0001\u0007Zi\u001aKG.Z*zgR,WN\u0003\u0002\n\u0015\u0005\u0011am\u001d\u0006\u0003\u00171\tAa\u001d9zi*\u0011QBD\u0001\tsR\u001c\u0018-\u001e:vg*\tq\"\u0001\u0003uK\u000eD7\u0001A\n\u0003\u0001I\u0001\"a\u0005\u000b\u000e\u0003!I!!\u0006\u0005\u0003!e#h)\u001b7f'f\u001cH/Z7CCN,\u0017A\u0002\u001fj]&$h\bF\u0001\u0019!\t\u0019\u0002!A\u0002m_\u001e,\u0012a\u0007\t\u00039\u0005j\u0011!\b\u0006\u0003=}\tQa\u001d7gi)T\u0011\u0001I\u0001\u0004_J<\u0017B\u0001\u0012\u001e\u0005\u0019aunZ4fe\u0006!An\\4!\u0003)a\u0017n\u001d;Ti\u0006$Xo\u001d\u000b\u0003MU\u00022a\n\u0016-\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#!B!se\u0006L\bCA\u00174\u001b\u0005q#BA\u00050\u0015\t\u0001\u0014'\u0001\u0004iC\u0012|w\u000e\u001d\u0006\u0003e}\ta!\u00199bG\",\u0017B\u0001\u001b/\u0005)1\u0015\u000e\\3Ti\u0006$Xo\u001d\u0005\u0006m\u0011\u0001\raN\u0001\u0002MB\u0011Q\u0006O\u0005\u0003s9\u0012A\u0001U1uQ\u0006iq-\u001a;GS2,7\u000b^1ukN$\"\u0001\f\u001f\t\u000bY*\u0001\u0019A\u001c\u0002\r5\\G-\u001b:t)\ry$i\u0011\t\u0003O\u0001K!!\u0011\u0015\u0003\u000f\t{w\u000e\\3b]\")aG\u0002a\u0001o!)AI\u0002a\u0001\u000b\u0006Q\u0001/\u001a:nSN\u001c\u0018n\u001c8\u0011\u0005\u0019CU\"A$\u000b\u0005\u0011s\u0013BA%H\u0005115\u000fU3s[&\u001c8/[8oQ\u0011\u00011JT(\u0011\u0005\u001db\u0015BA')\u0005A\u0019VM]5bYZ+'o]5p]VKE)A\u0003wC2,XMH\u0001\u0002\u0001")
public class YtFileSystem
extends YtFileSystemBase {
    public static final long serialVersionUID = 1L;
    private final Logger log = LoggerFactory.getLogger((Class)this.getClass());

    private Logger log() {
        return this.log;
    }

    public FileStatus[] listStatus(Path f) {
        FileStatus[] fileStatusArray;
        this.RichLogger(this.log()).debugLazy((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("List status ").append(f).toString());
        YPathEnriched path = YPathEnriched$.MODULE$.fromPath(f, YPathEnriched$.MODULE$.fromPath$default$2());
        CompoundClient yt = this.ytClient(path);
        if (!YtWrapper$.MODULE$.exists(path.toStringYPath(), path.transaction(), yt)) {
            throw new PathNotFoundException(new StringBuilder(19).append("Path ").append(f).append(" doesn't exist").toString());
        }
        PathType pathType = YtWrapper$.MODULE$.pathType(path.toStringYPath(), path.transaction(), yt);
        PathType pathType2 = pathType;
        if (PathType.File$.MODULE$.equals(pathType2)) {
            fileStatusArray = (FileStatus[])((Object[])new FileStatus[]{this.getFileStatus(f)});
        } else if (PathType.Directory$.MODULE$.equals(pathType2)) {
            fileStatusArray = this.listYtDirectory(f, path.toStringYPath(), path.transaction(), yt);
        } else {
            throw new IllegalArgumentException(new StringBuilder(11).append("Can't list ").append(pathType).toString());
        }
        return fileStatusArray;
    }

    public FileStatus getFileStatus(Path f) {
        FileStatus fileStatus;
        PathType pathType;
        this.RichLogger(this.log()).debugLazy((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Get file status ").append(f).toString());
        YPathEnriched path = YPathEnriched$.MODULE$.fromPath(f, YPathEnriched$.MODULE$.fromPath$default$2());
        CompoundClient yt = this.ytClient(path);
        if (!YtWrapper$.MODULE$.exists(path.toStringYPath(), path.transaction(), yt)) {
            throw new FileNotFoundException(new StringBuilder(18).append("File ").append(f).append(" is not found").toString());
        }
        this.statistics.incrementReadOps(1);
        Map attributes = YtWrapper$.MODULE$.attributes(path.toStringYPath(), path.transaction(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{YtAttributes$.MODULE$.type(), YtAttributes$.MODULE$.compressedDataSize(), YtAttributes$.MODULE$.modificationTime()})), yt);
        PathType pathType2 = pathType = YtWrapper$.MODULE$.pathType(attributes);
        if (PathType.File$.MODULE$.equals(pathType2)) {
            fileStatus = new FileStatus(YtWrapper$.MODULE$.fileSize(attributes), false, 1, 0L, YtWrapper$.MODULE$.modificationTimeTs(attributes), f);
        } else if (PathType.Directory$.MODULE$.equals(pathType2)) {
            fileStatus = new FileStatus(0L, true, 1, 0L, 0L, f);
        } else if (PathType.None$.MODULE$.equals(pathType2)) {
            fileStatus = null;
        } else {
            throw new NoSuchElementException(new StringBuilder(20).append("Unknown PathType: '").append(pathType2).append("'").toString());
        }
        return fileStatus;
    }

    @Override
    public boolean mkdirs(Path f, FsPermission permission) {
        this.RichLogger(this.log()).debugLazy((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("Create dir ").append(f).toString());
        YPathEnriched path = YPathEnriched$.MODULE$.fromPath(f, YPathEnriched$.MODULE$.fromPath$default$2());
        CompoundClient yt = this.ytClient(path);
        this.statistics.incrementWriteOps(1);
        String x$1 = path.toStringYPath();
        boolean x$2 = true;
        Option x$3 = YtWrapper$.MODULE$.createDir$default$2();
        YtWrapper$.MODULE$.createDir(x$1, x$3, x$2, yt);
        return true;
    }
}

