/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.typeinfo;

import java.util.Objects;
import tech.ytsaurus.typeinfo.KeyNames;
import tech.ytsaurus.typeinfo.TiType;
import tech.ytsaurus.typeinfo.TypeName;
import tech.ytsaurus.yson.YsonConsumer;

public class DictType
extends TiType {
    private final TiType key;
    private final TiType value;

    public DictType(TiType key, TiType value) {
        super(TypeName.Dict);
        this.key = key;
        this.value = value;
    }

    public TiType getKey() {
        return this.key;
    }

    public TiType getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return String.format("Dict<%s, %s>", this.key, this.value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DictType dictType = (DictType)o;
        return this.key.equals(dictType.key) && this.value.equals(dictType.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{TypeName.Dict, this.key, this.value});
    }

    @Override
    public void serializeTo(YsonConsumer ysonConsumer) {
        ysonConsumer.onBeginMap();
        assert (TypeName.Dict.wireNameBytes != null);
        YsonConsumer.onKeyedItem((YsonConsumer)ysonConsumer, (byte[])KeyNames.TYPE_NAME);
        YsonConsumer.onString((YsonConsumer)ysonConsumer, (byte[])TypeName.Dict.wireNameBytes);
        YsonConsumer.onKeyedItem((YsonConsumer)ysonConsumer, (byte[])KeyNames.KEY);
        this.key.serializeTo(ysonConsumer);
        YsonConsumer.onKeyedItem((YsonConsumer)ysonConsumer, (byte[])KeyNames.VALUE);
        this.value.serializeTo(ysonConsumer);
        ysonConsumer.onEndMap();
    }
}

