/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.typeinfo;

import java.util.HashMap;
import java.util.Map;

class Escape {
    private static final Map<Character, String> ESCAPE_MAP = new HashMap<Character, String>();

    private Escape() {
    }

    static String quote(String value) {
        int curIndex;
        if (value.isEmpty()) {
            return "''";
        }
        int valueLength = value.length();
        for (curIndex = 0; curIndex < valueLength && !Escape.needEscaping(value.charAt(curIndex)); ++curIndex) {
        }
        if (curIndex == valueLength) {
            return "'" + value + "'";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("'");
        sb.append(value, 0, curIndex);
        while (curIndex < valueLength) {
            char c = value.charAt(curIndex);
            Escape.escape(c, sb);
            ++curIndex;
        }
        return sb.toString();
    }

    private static void escape(char c, StringBuilder sb) {
        if (Escape.needEscaping(c)) {
            String escaped = ESCAPE_MAP.get(Character.valueOf(c));
            if (escaped == null) {
                sb.append("\\u").append(String.format("%04x", c));
            } else {
                sb.append(escaped);
            }
        } else {
            sb.append(c);
        }
    }

    private static boolean needEscaping(char c) {
        return c == '\'' || c == '\t' || c == '\n' || c == '\r' || c == '\\' || Character.isISOControl(c);
    }

    static {
        ESCAPE_MAP.put(Character.valueOf('\''), "\\'");
        ESCAPE_MAP.put(Character.valueOf('\t'), "\\t");
        ESCAPE_MAP.put(Character.valueOf('\n'), "\\n");
        ESCAPE_MAP.put(Character.valueOf('\r'), "\\r");
        ESCAPE_MAP.put(Character.valueOf('\\'), "\\\\");
    }
}

