/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.typeinfo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import tech.ytsaurus.typeinfo.Escape;
import tech.ytsaurus.typeinfo.KeyNames;
import tech.ytsaurus.typeinfo.MembersBuilder;
import tech.ytsaurus.typeinfo.TiType;
import tech.ytsaurus.typeinfo.TypeName;
import tech.ytsaurus.yson.YsonConsumer;

public class StructType
extends TiType {
    private final List<Member> members;

    StructType(List<Member> members) {
        super(TypeName.Struct);
        this.members = Collections.unmodifiableList(new ArrayList<Member>(members));
    }

    StructType(Member ... members) {
        super(TypeName.Struct);
        this.members = Collections.unmodifiableList(Arrays.asList(members));
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<Member> getMembers() {
        return this.members;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Struct<");
        this.printMembers(sb);
        sb.append(">");
        return sb.toString();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        StructType that = (StructType)o;
        return this.members.equals(that.members);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.typeName, this.members});
    }

    @Override
    public void serializeTo(YsonConsumer ysonConsumer) {
        ysonConsumer.onBeginMap();
        assert (TypeName.Struct.wireNameBytes != null);
        YsonConsumer.onKeyedItem((YsonConsumer)ysonConsumer, (byte[])KeyNames.TYPE_NAME);
        YsonConsumer.onString((YsonConsumer)ysonConsumer, (byte[])TypeName.Struct.wireNameBytes);
        this.serializeMembers(ysonConsumer);
        ysonConsumer.onEndMap();
    }

    void printMembers(StringBuilder sb) {
        boolean first = true;
        for (Member member : this.members) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(Escape.quote(member.getName()));
            sb.append(": ");
            sb.append(member.getType());
        }
    }

    void serializeMembers(YsonConsumer ysonConsumer) {
        YsonConsumer.onKeyedItem((YsonConsumer)ysonConsumer, (byte[])KeyNames.MEMBERS);
        ysonConsumer.onBeginList();
        for (Member member : this.members) {
            ysonConsumer.onListItem();
            ysonConsumer.onBeginMap();
            YsonConsumer.onKeyedItem((YsonConsumer)ysonConsumer, (byte[])KeyNames.NAME);
            ysonConsumer.onString(member.getName());
            YsonConsumer.onKeyedItem((YsonConsumer)ysonConsumer, (byte[])KeyNames.TYPE);
            member.getType().serializeTo(ysonConsumer);
            ysonConsumer.onEndMap();
        }
        ysonConsumer.onEndList();
    }

    public static class Builder
    extends MembersBuilder<Builder> {
        public StructType build() {
            return new StructType(this.members);
        }

        @Override
        Builder self() {
            return this;
        }
    }

    public static class Member {
        private final String name;
        private final TiType type;

        public Member(String name, TiType type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public TiType getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Member member = (Member)o;
            return this.name.equals(member.name) && this.type.equals(member.type);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type);
        }
    }
}

