/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.typeinfo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import tech.ytsaurus.typeinfo.KeyNames;
import tech.ytsaurus.typeinfo.TiType;
import tech.ytsaurus.typeinfo.TypeName;
import tech.ytsaurus.yson.YsonConsumer;

public class TupleType
extends TiType {
    private final List<TiType> elements;

    public TupleType(TiType ... elements) {
        super(TypeName.Tuple);
        this.elements = Collections.unmodifiableList(Arrays.asList(elements));
    }

    public TupleType(List<TiType> elements) {
        super(TypeName.Tuple);
        this.elements = Collections.unmodifiableList(new ArrayList<TiType>(elements));
    }

    public List<TiType> getElements() {
        return this.elements;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Tuple<");
        this.printElements(sb);
        sb.append(">");
        return sb.toString();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TupleType tupleType = (TupleType)o;
        return this.elements.equals(tupleType.elements);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.elements);
    }

    @Override
    public void serializeTo(YsonConsumer ysonConsumer) {
        ysonConsumer.onBeginMap();
        assert (TypeName.Tuple.wireNameBytes != null);
        YsonConsumer.onKeyedItem((YsonConsumer)ysonConsumer, (byte[])KeyNames.TYPE_NAME);
        YsonConsumer.onString((YsonConsumer)ysonConsumer, (byte[])TypeName.Tuple.wireNameBytes);
        this.serializeElements(ysonConsumer);
        ysonConsumer.onEndMap();
    }

    void printElements(StringBuilder sb) {
        boolean first = true;
        for (TiType type : this.elements) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(type);
        }
    }

    void serializeElements(YsonConsumer ysonConsumer) {
        YsonConsumer.onKeyedItem((YsonConsumer)ysonConsumer, (byte[])KeyNames.ELEMENTS);
        ysonConsumer.onBeginList();
        for (TiType elementType : this.elements) {
            ysonConsumer.onListItem();
            ysonConsumer.onBeginMap();
            YsonConsumer.onKeyedItem((YsonConsumer)ysonConsumer, (byte[])KeyNames.TYPE);
            elementType.serializeTo(ysonConsumer);
            ysonConsumer.onEndMap();
        }
        ysonConsumer.onEndList();
    }
}

