/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.typeinfo;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import tech.ytsaurus.typeinfo.BaseYsonConsumer;
import tech.ytsaurus.typeinfo.KeyNames;
import tech.ytsaurus.typeinfo.StructType;
import tech.ytsaurus.typeinfo.TiType;
import tech.ytsaurus.typeinfo.TypeInfoException;
import tech.ytsaurus.typeinfo.TypeName;
import tech.ytsaurus.yson.YsonConsumer;

class TypeYsonConsumer
implements YsonConsumer {
    @Nullable
    TiType type;
    Deque<YsonConsumer> consumerStack = new ArrayDeque<YsonConsumer>();

    TypeYsonConsumer() {
        this.pushConsumer(new TypeParser(type -> {
            this.type = type;
        }));
    }

    void pushConsumer(YsonConsumer consumer) {
        this.consumerStack.push(consumer);
    }

    void popConsumer() {
        this.consumerStack.pop();
    }

    YsonConsumer peekConsumer() {
        if (this.consumerStack.isEmpty()) {
            throw new IllegalStateException();
        }
        YsonConsumer top = this.consumerStack.peek();
        assert (top != null);
        return top;
    }

    public TiType getType() {
        if (this.type == null) {
            throw new IllegalStateException("Internal error: type is not expected to be null");
        }
        return this.type;
    }

    public void onEntity() {
        this.peekConsumer().onEntity();
    }

    public void onInteger(long value) {
        this.peekConsumer().onInteger(value);
    }

    public void onUnsignedInteger(long value) {
        this.peekConsumer().onUnsignedInteger(value);
    }

    public void onBoolean(boolean value) {
        this.peekConsumer().onBoolean(value);
    }

    public void onDouble(double value) {
        this.peekConsumer().onDouble(value);
    }

    public void onString(@Nonnull byte[] value, int length, int offset) {
        this.peekConsumer().onString(value, length, offset);
    }

    public void onBeginList() {
        this.peekConsumer().onBeginList();
    }

    public void onListItem() {
        this.peekConsumer().onListItem();
    }

    public void onEndList() {
        this.peekConsumer().onEndList();
    }

    public void onBeginAttributes() {
        this.peekConsumer().onBeginAttributes();
    }

    public void onEndAttributes() {
        this.peekConsumer().onEndAttributes();
    }

    public void onBeginMap() {
        this.peekConsumer().onBeginMap();
    }

    public void onEndMap() {
        this.peekConsumer().onEndMap();
    }

    public void onKeyedItem(@Nonnull byte[] value, int offset, int length) {
        this.peekConsumer().onKeyedItem(value, offset, length);
    }

    static boolean checkKey(byte[] lhs, byte[] rhs, int rhsOffset, int rhsLength) {
        return Arrays.equals(lhs, Arrays.copyOfRange(rhs, rhsOffset, rhsOffset + rhsLength));
    }

    static RuntimeException newMissingKeyError(String keyName, @Nullable TypeName typeName) {
        Object message = String.format("Missing required key \"%s\"", keyName);
        if (typeName != null) {
            message = (String)message + String.format(" for type \"%s\"", new Object[]{typeName});
        }
        return new TypeInfoException((String)message);
    }

    @Nullable
    String decodeUtf8(byte[] bytes, int offset, int length) {
        CharBuffer decoded;
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
        try {
            decoded = decoder.decode(ByteBuffer.wrap(bytes, offset, length));
        }
        catch (CharacterCodingException e) {
            return null;
        }
        return decoded.toString();
    }

    class TypeParser
    extends BaseYsonConsumer {
        private final Consumer<TiType> onComplete;
        @Nullable
        private String typeName;
        @Nullable
        private String tag;
        @Nullable
        private TiType item;
        @Nullable
        private Long precision;
        @Nullable
        private Long scale;
        @Nullable
        private List<StructType.Member> members;
        @Nullable
        private List<TiType> elements;
        @Nullable
        private TiType key;
        @Nullable
        private TiType value;

        TypeParser(Consumer<TiType> onComplete) {
            super("type must be either a string or a map");
            this.onComplete = onComplete;
        }

        void complete(TiType type) {
            this.onComplete.accept(type);
            TypeYsonConsumer.this.popConsumer();
        }

        @Override
        public void onBeginMap() {
        }

        @Override
        public void onKeyedItem(byte[] value, int offset, int length) {
            if (TypeYsonConsumer.checkKey(KeyNames.TYPE_NAME, value, offset, length)) {
                TypeYsonConsumer.this.pushConsumer(new StringParser("type_name", v -> {
                    this.typeName = v;
                }));
            } else if (TypeYsonConsumer.checkKey(KeyNames.ITEM, value, offset, length)) {
                TypeYsonConsumer.this.pushConsumer(new TypeParser(type -> {
                    this.item = type;
                }));
            } else if (TypeYsonConsumer.checkKey(KeyNames.TAG, value, offset, length)) {
                TypeYsonConsumer.this.pushConsumer(new StringParser("tag", v -> {
                    this.tag = v;
                }));
            } else if (TypeYsonConsumer.checkKey(KeyNames.PRECISION, value, offset, length)) {
                TypeYsonConsumer.this.pushConsumer(new IntegerParser("precision", v -> {
                    this.precision = v;
                }));
            } else if (TypeYsonConsumer.checkKey(KeyNames.SCALE, value, offset, length)) {
                TypeYsonConsumer.this.pushConsumer(new IntegerParser("scale", v -> {
                    this.scale = v;
                }));
            } else if (TypeYsonConsumer.checkKey(KeyNames.MEMBERS, value, offset, length)) {
                TypeYsonConsumer.this.pushConsumer(new ListParser("members", x$0 -> new MemberParser((Consumer<StructType.Member>)x$0), v -> {
                    this.members = v;
                }));
            } else if (TypeYsonConsumer.checkKey(KeyNames.ELEMENTS, value, offset, length)) {
                TypeYsonConsumer.this.pushConsumer(new ListParser("elements", x$0 -> new ElementParser((Consumer<TiType>)x$0), v -> {
                    this.elements = v;
                }));
            } else if (TypeYsonConsumer.checkKey(KeyNames.KEY, value, offset, length)) {
                TypeYsonConsumer.this.pushConsumer(new TypeParser(v -> {
                    this.key = v;
                }));
            } else if (TypeYsonConsumer.checkKey(KeyNames.VALUE, value, offset, length)) {
                TypeYsonConsumer.this.pushConsumer(new TypeParser(v -> {
                    this.value = v;
                }));
            } else {
                TypeYsonConsumer.this.pushConsumer(new SkippingParser());
            }
        }

        @Override
        public void onString(byte[] value, int offset, int length) {
            this.typeName = TypeYsonConsumer.this.decodeUtf8(value, offset, length);
            this.complete(this.buildType());
        }

        @Override
        public void onEndMap() {
            this.complete(this.buildType());
        }

        TypeName checkedParseTypeName() {
            if (this.typeName == null) {
                throw TypeYsonConsumer.newMissingKeyError("type_name", null);
            }
            return TypeName.fromWireName(this.typeName);
        }

        int checkedGetPrecision() {
            if (this.precision == null) {
                throw TypeYsonConsumer.newMissingKeyError("precision", this.checkedParseTypeName());
            }
            return this.precision.intValue();
        }

        int checkedGetScale() {
            if (this.scale == null) {
                throw TypeYsonConsumer.newMissingKeyError("scale", this.checkedParseTypeName());
            }
            return this.scale.intValue();
        }

        TiType checkedGetItem() {
            if (this.item == null) {
                throw TypeYsonConsumer.newMissingKeyError("item", this.checkedParseTypeName());
            }
            return this.item;
        }

        String checkedGetTag() {
            if (this.tag == null) {
                throw TypeYsonConsumer.newMissingKeyError("tag", this.checkedParseTypeName());
            }
            return this.tag;
        }

        List<StructType.Member> checkedGetMembers() {
            if (this.members == null) {
                throw TypeYsonConsumer.newMissingKeyError("members", this.checkedParseTypeName());
            }
            return this.members;
        }

        TiType buildType() {
            TypeName checkedTypeName = this.checkedParseTypeName();
            switch (checkedTypeName) {
                case Bool: {
                    return TiType.bool();
                }
                case Int8: {
                    return TiType.int8();
                }
                case Int16: {
                    return TiType.int16();
                }
                case Int32: {
                    return TiType.int32();
                }
                case Int64: {
                    return TiType.int64();
                }
                case Uint8: {
                    return TiType.uint8();
                }
                case Uint16: {
                    return TiType.uint16();
                }
                case Uint32: {
                    return TiType.uint32();
                }
                case Uint64: {
                    return TiType.uint64();
                }
                case Float: {
                    return TiType.floatType();
                }
                case Double: {
                    return TiType.doubleType();
                }
                case String: {
                    return TiType.string();
                }
                case Utf8: {
                    return TiType.utf8();
                }
                case Date: {
                    return TiType.date();
                }
                case Datetime: {
                    return TiType.datetime();
                }
                case Timestamp: {
                    return TiType.timestamp();
                }
                case TzDate: {
                    return TiType.tzDate();
                }
                case TzDatetime: {
                    return TiType.tzDatetime();
                }
                case TzTimestamp: {
                    return TiType.tzTimestamp();
                }
                case Interval: {
                    return TiType.interval();
                }
                case Date32: {
                    return TiType.date32();
                }
                case Datetime64: {
                    return TiType.datetime64();
                }
                case Timestamp64: {
                    return TiType.timestamp64();
                }
                case Interval64: {
                    return TiType.interval64();
                }
                case Json: {
                    return TiType.json();
                }
                case Yson: {
                    return TiType.yson();
                }
                case Uuid: {
                    return TiType.uuid();
                }
                case Void: {
                    return TiType.voidType();
                }
                case Null: {
                    return TiType.nullType();
                }
                case Optional: {
                    return TiType.optional(this.checkedGetItem());
                }
                case List: {
                    return TiType.list(this.checkedGetItem());
                }
                case Decimal: {
                    return TiType.decimal(this.checkedGetPrecision(), this.checkedGetScale());
                }
                case Struct: {
                    return new StructType(this.checkedGetMembers());
                }
                case Tuple: {
                    return TiType.tuple(this.checkedGetElements());
                }
                case Dict: {
                    return TiType.dict(this.checkedGetKey(), this.checkedGetValue());
                }
                case Variant: {
                    if (this.members != null && this.elements != null) {
                        throw new TypeInfoException(String.format("Both keys \"members\" and \"elements\" are specified for type \"%s\"", new Object[]{this.checkedParseTypeName()}));
                    }
                    if (this.members != null) {
                        return TiType.variantOverStruct(this.members);
                    }
                    if (this.elements != null) {
                        return TiType.variantOverTuple(this.elements);
                    }
                    throw new TypeInfoException(String.format("Missing both keys \"members\" and \"elements\" for type \"%s\"", new Object[]{this.checkedParseTypeName()}));
                }
                case Tagged: {
                    return TiType.tagged(this.checkedGetItem(), this.checkedGetTag());
                }
            }
            throw new IllegalStateException();
        }

        private TiType checkedGetValue() {
            if (this.value == null) {
                throw TypeYsonConsumer.newMissingKeyError("value", this.checkedParseTypeName());
            }
            return this.value;
        }

        private TiType checkedGetKey() {
            if (this.key == null) {
                throw TypeYsonConsumer.newMissingKeyError("key", this.checkedParseTypeName());
            }
            return this.key;
        }

        private List<TiType> checkedGetElements() {
            if (this.elements == null) {
                throw TypeYsonConsumer.newMissingKeyError("elements", this.checkedParseTypeName());
            }
            return this.elements;
        }
    }

    class SkippingParser
    implements YsonConsumer {
        int nesting = 0;

        SkippingParser() {
        }

        void check() {
            if (this.nesting == 0) {
                TypeYsonConsumer.this.popConsumer();
            }
        }

        public void onEntity() {
            this.check();
        }

        public void onInteger(long value) {
            this.check();
        }

        public void onUnsignedInteger(long value) {
            this.check();
        }

        public void onBoolean(boolean value) {
            this.check();
        }

        public void onDouble(double value) {
            this.check();
        }

        public void onString(byte[] value, int offset, int length) {
            this.check();
        }

        public void onBeginList() {
            ++this.nesting;
        }

        public void onListItem() {
        }

        public void onEndList() {
            --this.nesting;
            this.check();
        }

        public void onBeginAttributes() {
            ++this.nesting;
        }

        public void onEndAttributes() {
            --this.nesting;
        }

        public void onBeginMap() {
            ++this.nesting;
        }

        public void onEndMap() {
            --this.nesting;
            this.check();
        }

        public void onKeyedItem(byte[] value, int offset, int length) {
        }
    }

    class ElementParser
    extends BaseYsonConsumer {
        final Consumer<TiType> onComplete;
        @Nullable
        TiType type;

        ElementParser(Consumer<TiType> onComplete) {
            super("\"elements\" must contain a list of maps");
            this.onComplete = onComplete;
        }

        @Override
        public void onBeginMap() {
        }

        @Override
        public void onKeyedItem(@Nonnull byte[] value, int offset, int length) {
            if (TypeYsonConsumer.checkKey(KeyNames.TYPE, value, offset, length)) {
                TypeYsonConsumer.this.pushConsumer(new TypeParser(v -> {
                    this.type = v;
                }));
            } else {
                TypeYsonConsumer.this.pushConsumer(new SkippingParser());
            }
        }

        @Override
        public void onEndMap() {
            this.onComplete.accept(this.checkedGetType());
            TypeYsonConsumer.this.popConsumer();
        }

        TiType checkedGetType() {
            if (this.type == null) {
                throw TypeYsonConsumer.newMissingKeyError("type", null);
            }
            return this.type;
        }
    }

    class MemberParser
    extends BaseYsonConsumer {
        private final Consumer<StructType.Member> onComplete;
        @Nullable
        String name;
        @Nullable
        TiType type;

        MemberParser(Consumer<StructType.Member> onComplete) {
            super("\"members\" must contain a list of maps");
            this.onComplete = onComplete;
        }

        @Override
        public void onBeginMap() {
        }

        @Override
        public void onKeyedItem(@Nonnull byte[] value, int offset, int length) {
            if (TypeYsonConsumer.checkKey(KeyNames.TYPE, value, offset, length)) {
                TypeYsonConsumer.this.pushConsumer(new TypeParser(v -> {
                    this.type = v;
                }));
            } else if (TypeYsonConsumer.checkKey(KeyNames.NAME, value, offset, length)) {
                TypeYsonConsumer.this.pushConsumer(new StringParser("name", v -> {
                    this.name = v;
                }));
            } else {
                TypeYsonConsumer.this.pushConsumer(new SkippingParser());
            }
        }

        @Override
        public void onEndMap() {
            StructType.Member member = new StructType.Member(this.checkedGetName(), this.checkedGetType());
            this.onComplete.accept(member);
            TypeYsonConsumer.this.popConsumer();
        }

        TiType checkedGetType() {
            if (this.type == null) {
                throw TypeYsonConsumer.newMissingKeyError("type", null);
            }
            return this.type;
        }

        String checkedGetName() {
            if (this.name == null) {
                throw TypeYsonConsumer.newMissingKeyError("name", null);
            }
            return this.name;
        }
    }

    class ListParser<T>
    extends BaseYsonConsumer {
        final Supplier<YsonConsumer> parserSupplier;
        final Consumer<List<T>> onComplete;
        final List<T> list;

        ListParser(String keyName, Function<Consumer<T>, YsonConsumer> parserCreator, Consumer<List<T>> onComplete) {
            super("\"" + keyName + "\" must contain a list");
            this.list = new ArrayList<T>();
            this.parserSupplier = () -> (YsonConsumer)parserCreator.apply(this.list::add);
            this.onComplete = onComplete;
        }

        @Override
        public void onBeginList() {
        }

        @Override
        public void onEndList() {
            this.onComplete.accept(this.list);
            TypeYsonConsumer.this.popConsumer();
        }

        @Override
        public void onListItem() {
            TypeYsonConsumer.this.pushConsumer(this.parserSupplier.get());
        }
    }

    class IntegerParser
    extends BaseYsonConsumer {
        final Consumer<Long> onComplete;

        IntegerParser(String keyName, Consumer<Long> onComplete) {
            super("\"" + keyName + "\" must contain a string");
            this.onComplete = onComplete;
        }

        @Override
        public void onInteger(long value) {
            this.onComplete.accept(value);
            TypeYsonConsumer.this.popConsumer();
        }
    }

    class StringParser
    extends BaseYsonConsumer {
        final Consumer<String> onComplete;
        final String keyName;

        StringParser(String keyName, Consumer<String> onComplete) {
            super("\"" + keyName + "\" must contain a string");
            this.onComplete = onComplete;
            this.keyName = keyName;
        }

        @Override
        public void onString(byte[] value, int offset, int length) {
            String decoded = TypeYsonConsumer.this.decodeUtf8(value, offset, length);
            if (decoded == null) {
                throw new TypeInfoException("\"%s\" must contain valid utf8 string");
            }
            this.onComplete.accept(decoded);
            TypeYsonConsumer.this.popConsumer();
        }
    }
}

