/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.typeinfo;

import java.util.Objects;
import javax.annotation.Nullable;
import tech.ytsaurus.typeinfo.KeyNames;
import tech.ytsaurus.typeinfo.MembersBuilder;
import tech.ytsaurus.typeinfo.StructType;
import tech.ytsaurus.typeinfo.TiType;
import tech.ytsaurus.typeinfo.TupleType;
import tech.ytsaurus.typeinfo.TypeName;
import tech.ytsaurus.yson.YsonConsumer;

public class VariantType
extends TiType {
    private final TiType underlying;

    VariantType(StructType underlying) {
        super(TypeName.Variant);
        this.underlying = underlying;
    }

    VariantType(TupleType underlying) {
        super(TypeName.Variant);
        this.underlying = underlying;
    }

    public TiType getUnderlying() {
        return this.underlying;
    }

    public static Builder overStructBuilder() {
        return new Builder();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Variant<");
        if (this.underlying.isStruct()) {
            this.underlying.asStruct().printMembers(sb);
        } else {
            this.underlying.asTuple().printElements(sb);
        }
        sb.append(">");
        return sb.toString();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VariantType that = (VariantType)o;
        return this.underlying.equals(that.underlying);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{TypeName.Dict, this.underlying});
    }

    @Override
    public void serializeTo(YsonConsumer ysonConsumer) {
        ysonConsumer.onBeginMap();
        assert (TypeName.Variant.wireNameBytes != null);
        YsonConsumer.onKeyedItem((YsonConsumer)ysonConsumer, (byte[])KeyNames.TYPE_NAME);
        YsonConsumer.onString((YsonConsumer)ysonConsumer, (byte[])TypeName.Variant.wireNameBytes);
        if (this.underlying.isStruct()) {
            this.underlying.asStruct().serializeMembers(ysonConsumer);
        } else {
            this.underlying.asTuple().serializeElements(ysonConsumer);
        }
        ysonConsumer.onEndMap();
    }

    public static class Builder
    extends MembersBuilder<Builder> {
        public VariantType build() {
            return new VariantType(new StructType(this.members));
        }

        @Override
        Builder self() {
            return this;
        }
    }
}

