/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.skiff;

import java.io.ByteArrayOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.ysontree.YTreeBinarySerializer;
import tech.ytsaurus.ysontree.YTreeNode;

public class SkiffSerializer
implements AutoCloseable,
Flushable {
    private final OutputStream byteOS;

    public SkiffSerializer(OutputStream byteOS) {
        this.byteOS = byteOS;
    }

    public void write(byte[] bytes) {
        try {
            this.byteOS.write(bytes);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void serializeByte(byte number) {
        try {
            this.byteOS.write(number);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void serializeShort(short number) {
        try {
            this.byteOS.write(number & 0xFF);
            this.byteOS.write(number >> 8 & 0xFF);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void serializeInt(int number) {
        try {
            this.byteOS.write(number & 0xFF);
            this.byteOS.write(number >> 8 & 0xFF);
            this.byteOS.write(number >> 16 & 0xFF);
            this.byteOS.write(number >> 24 & 0xFF);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void serializeLong(long number) {
        try {
            this.byteOS.write((int)(number & 0xFFL));
            this.byteOS.write((int)(number >> 8 & 0xFFL));
            this.byteOS.write((int)(number >> 16 & 0xFFL));
            this.byteOS.write((int)(number >> 24 & 0xFFL));
            this.byteOS.write((int)(number >> 32 & 0xFFL));
            this.byteOS.write((int)(number >> 40 & 0xFFL));
            this.byteOS.write((int)(number >> 48 & 0xFFL));
            this.byteOS.write((int)(number >> 56 & 0xFFL));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void serializeUint8(long number) {
        this.serializeByte((byte)(number & 0xFFL));
    }

    public void serializeUint16(long number) {
        this.serializeShort((short)(number & 0xFFFFL));
    }

    public void serializeUint32(long number) {
        this.serializeInt((int)(number & 0xFFFFFFFFL));
    }

    public void serializeUint64(long number) {
        this.serializeLong(number);
    }

    public void serializeDouble(double number) {
        try {
            this.byteOS.write(ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putDouble(number).array());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void serializeBoolean(boolean bool) {
        try {
            this.byteOS.write(bool ? 1 : 0);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void serializeUtf8(String string) {
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        this.serializeInt(bytes.length);
        try {
            this.byteOS.write(bytes);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void serializeString(byte[] bytes) {
        this.serializeInt(bytes.length);
        try {
            this.byteOS.write(bytes);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void serializeGuid(GUID guid) {
        this.serializeInt(16);
        this.serializeLong(guid.getFirst());
        this.serializeLong(guid.getSecond());
    }

    public void serializeTimestamp(Instant instant) {
        this.serializeUint64(instant.toEpochMilli());
    }

    public void serializeYson(YTreeNode node) {
        ByteArrayOutputStream byteOutputStreamForYson = new ByteArrayOutputStream();
        YTreeBinarySerializer.serialize((YTreeNode)node, (OutputStream)byteOutputStreamForYson);
        byte[] bytes = byteOutputStreamForYson.toByteArray();
        this.serializeInt(bytes.length);
        try {
            this.byteOS.write(bytes);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void flush() throws IOException {
        this.byteOS.flush();
    }

    @Override
    public void close() throws IOException {
        this.byteOS.close();
    }
}

