/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import tech.ytsaurus.client.request.Atomicity;
import tech.ytsaurus.client.request.Durability;
import tech.ytsaurus.client.request.StartTransaction;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.rpcproxy.EAtomicity;
import tech.ytsaurus.rpcproxy.EDurability;
import tech.ytsaurus.rpcproxy.ETransactionType;
import tech.ytsaurus.ysontree.YTreeNode;

public class ApiServiceTransactionOptions {
    private final ETransactionType type;
    private Duration timeout;
    private Instant deadline = null;
    private GUID id;
    private GUID parentId;
    private Boolean autoAbort;
    private Boolean ping;
    private Boolean pingAncestors;
    private Boolean sticky;
    private EAtomicity atomicity;
    private EDurability durability;
    private List<GUID> prerequisiteTransactionIds;
    private Duration pingPeriod = Duration.ofSeconds(5L);
    private Duration failedPingRetryPeriod;
    private final Map<String, YTreeNode> attributes = new HashMap<String, YTreeNode>();
    private Consumer<Exception> onPingFailed;

    public ApiServiceTransactionOptions(ETransactionType type) {
        this.type = Objects.requireNonNull(type);
    }

    public ETransactionType getType() {
        return this.type;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public Instant getDeadline() {
        return this.deadline;
    }

    public GUID getId() {
        return this.id;
    }

    public GUID getParentId() {
        return this.parentId;
    }

    public Boolean getAutoAbort() {
        return this.autoAbort;
    }

    public Boolean getPing() {
        return this.ping;
    }

    public Duration getFailedPingRetryPeriod() {
        return this.failedPingRetryPeriod;
    }

    public Boolean getPingAncestors() {
        return this.pingAncestors;
    }

    public Boolean getSticky() {
        return this.sticky;
    }

    public EAtomicity getAtomicity() {
        return this.atomicity;
    }

    public EDurability getDurability() {
        return this.durability;
    }

    public List<GUID> getPrerequisiteTransactionIds() {
        return this.prerequisiteTransactionIds;
    }

    public Duration getPingPeriod() {
        return this.pingPeriod;
    }

    public ApiServiceTransactionOptions setTimeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public ApiServiceTransactionOptions setDeadline(Instant deadline) {
        this.deadline = deadline;
        return this;
    }

    public ApiServiceTransactionOptions setId(GUID id) {
        this.id = id;
        return this;
    }

    public ApiServiceTransactionOptions setParentId(GUID parentId) {
        this.parentId = parentId;
        return this;
    }

    public ApiServiceTransactionOptions setAutoAbort(Boolean autoAbort) {
        this.autoAbort = autoAbort;
        return this;
    }

    public ApiServiceTransactionOptions setPing(Boolean ping) {
        this.ping = ping;
        return this;
    }

    public ApiServiceTransactionOptions setFailedPingRetryPeriod(Duration failedPingRetryPeriod) {
        this.failedPingRetryPeriod = failedPingRetryPeriod;
        return this;
    }

    public ApiServiceTransactionOptions setOnPingFailed(Consumer<Exception> onPingFailed) {
        this.onPingFailed = onPingFailed;
        return this;
    }

    public ApiServiceTransactionOptions setAttributes(@Nonnull Map<String, YTreeNode> attributes) {
        this.attributes.clear();
        this.attributes.putAll(attributes);
        return this;
    }

    public Map<String, YTreeNode> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public ApiServiceTransactionOptions setPingAncestors(Boolean pingAncestors) {
        this.pingAncestors = pingAncestors;
        return this;
    }

    public ApiServiceTransactionOptions setSticky(Boolean sticky) {
        this.sticky = sticky;
        return this;
    }

    public ApiServiceTransactionOptions setAtomicity(EAtomicity atomicity) {
        this.atomicity = atomicity;
        return this;
    }

    public ApiServiceTransactionOptions setAtomicity(EDurability durability) {
        this.durability = durability;
        return this;
    }

    public ApiServiceTransactionOptions setPrerequisiteTransactionIds(List<GUID> prerequisiteTransactionIds) {
        this.prerequisiteTransactionIds = prerequisiteTransactionIds;
        return this;
    }

    public ApiServiceTransactionOptions setPingPeriod(Duration pingPeriod) {
        this.pingPeriod = pingPeriod;
        return this;
    }

    public StartTransaction toStartTransaction() {
        StartTransaction.Builder startTransactionBuilder;
        switch (this.getType()) {
            case TT_MASTER: {
                if (this.getSticky().booleanValue()) {
                    startTransactionBuilder = StartTransaction.stickyMaster().toBuilder();
                    break;
                }
                startTransactionBuilder = StartTransaction.master().toBuilder();
                break;
            }
            case TT_TABLET: {
                startTransactionBuilder = StartTransaction.tablet().toBuilder();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected type of transaction: " + String.valueOf(this.getType()));
            }
        }
        if (this.timeout != null) {
            startTransactionBuilder.setTimeout(this.timeout);
        }
        if (this.deadline != null) {
            startTransactionBuilder.setDeadline(this.deadline);
        }
        if (this.id != null && !this.id.isEmpty()) {
            startTransactionBuilder.setId(this.id);
        }
        if (this.parentId != null && !this.parentId.isEmpty()) {
            startTransactionBuilder.setParentId(this.parentId);
        }
        if (this.ping != null) {
            startTransactionBuilder.setPing(this.ping);
        }
        if (this.pingAncestors != null) {
            startTransactionBuilder.setPingAncestors(this.pingAncestors);
        }
        if (this.pingPeriod != null) {
            startTransactionBuilder.setPingPeriod(this.pingPeriod);
        }
        if (this.failedPingRetryPeriod != null) {
            startTransactionBuilder.setFailedPingRetryPeriod(this.failedPingRetryPeriod);
        }
        if (this.atomicity != null) {
            switch (this.atomicity) {
                case A_FULL: {
                    startTransactionBuilder.setAtomicity(Atomicity.Full);
                    break;
                }
                case A_NONE: {
                    startTransactionBuilder.setAtomicity(Atomicity.None);
                    break;
                }
            }
        }
        if (this.durability != null) {
            switch (this.durability) {
                case D_SYNC: {
                    startTransactionBuilder.setDurability(Durability.Sync);
                    break;
                }
                case D_ASYNC: {
                    startTransactionBuilder.setDurability(Durability.Async);
                    break;
                }
            }
        }
        if (!this.attributes.isEmpty()) {
            startTransactionBuilder.setAttributes(this.getAttributes());
        }
        if (this.onPingFailed != null) {
            startTransactionBuilder.setOnPingFailed(this.onPingFailed);
        }
        if (this.prerequisiteTransactionIds != null) {
            throw new RuntimeException("prerequisite_transaction_ids is not supported in RPC proxy API yet");
        }
        return startTransactionBuilder.build();
    }
}

