/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import tech.ytsaurus.client.AsyncReader;
import tech.ytsaurus.client.SerializationResolver;
import tech.ytsaurus.client.TableAttachmentReader;
import tech.ytsaurus.client.TableReaderBaseImpl;
import tech.ytsaurus.client.request.ReadTable;

class AsyncTableReaderImpl<T>
extends TableReaderBaseImpl<T>
implements AsyncReader<T> {
    AsyncTableReaderImpl(ReadTable<T> req, Class<T> objectClazz) {
        super(objectClazz);
    }

    AsyncTableReaderImpl(TableAttachmentReader<T> reader) {
        super(reader);
    }

    public CompletableFuture<AsyncReader<T>> waitMetadata(SerializationResolver serializationResolver) {
        return super.waitMetadataImpl(serializationResolver).thenApply(reader -> (AsyncReader)((Object)reader));
    }

    @Override
    public CompletableFuture<Void> acceptAllAsync(Consumer<? super T> consumer, Executor executor) {
        return this.next().thenComposeAsync(rows -> {
            if (rows == null) {
                return CompletableFuture.completedFuture(null);
            }
            for (Object row : rows) {
                consumer.accept((T)row);
            }
            return this.acceptAllAsync(consumer, executor);
        }, executor);
    }

    @Override
    public CompletableFuture<List<T>> next() {
        try {
            List rows = this.read();
            if (rows != null) {
                return CompletableFuture.completedFuture(rows);
            }
            return this.readyEvent().thenCompose(unused -> {
                if (this.canRead()) {
                    return this.next();
                }
                return CompletableFuture.completedFuture(null);
            });
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void close() {
        this.control.cancel();
    }
}

