/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import tech.ytsaurus.client.AsyncWriter;
import tech.ytsaurus.client.SerializationResolver;
import tech.ytsaurus.client.TableRowsWireSerializer;
import tech.ytsaurus.client.TableWriterBaseImpl;
import tech.ytsaurus.client.request.WriteTable;
import tech.ytsaurus.core.tables.TableSchema;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;

@NonNullApi
@NonNullFields
class AsyncTableWriterImpl<T>
extends TableWriterBaseImpl<T>
implements AsyncWriter<T> {
    AsyncTableWriterImpl(WriteTable<T> req, SerializationResolver serializationResolver) {
        super(req, serializationResolver);
    }

    public CompletableFuture<AsyncWriter<T>> startUpload() {
        return super.startUploadImpl().thenApply(writer -> (AsyncWriter)((Object)writer));
    }

    @Override
    public CompletableFuture<Void> write(List<T> rows) {
        Objects.requireNonNull(this.tableRowsSerializer);
        TableSchema schema = this.req.getTableSchema().isPresent() ? this.req.getTableSchema().get() : (this.tableRowsSerializer instanceof TableRowsWireSerializer && ((TableRowsWireSerializer)this.tableRowsSerializer).getSchema().getColumnsCount() > 0 ? ((TableRowsWireSerializer)this.tableRowsSerializer).getSchema() : this.schema);
        return this.writeImpl(rows, schema);
    }

    private CompletableFuture<Void> writeImpl(List<T> rows, TableSchema schema) {
        try {
            if (this.write(rows, schema)) {
                return CompletableFuture.completedFuture(null);
            }
            return this.readyEvent().thenCompose(unused -> this.writeImpl(rows, schema));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

