/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import tech.ytsaurus.client.TableRowsSerializer;
import tech.ytsaurus.client.TableRowsSerializerUtil;
import tech.ytsaurus.client.TableRowsWireSerializer;
import tech.ytsaurus.core.tables.TableSchema;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;

@NonNullApi
@NonNullFields
class Buffer<T> {
    private final TableRowsSerializer<T> tableRowsSerializer;
    @Nullable
    private byte[] serializedRows;
    final CompletableFuture<Void> handled = new CompletableFuture();

    Buffer(TableRowsSerializer<T> rowsSerializer) {
        this.tableRowsSerializer = rowsSerializer;
    }

    public int size() {
        if (this.serializedRows != null) {
            return this.serializedRows.length;
        }
        return this.tableRowsSerializer.size();
    }

    public void write(List<T> rows, TableSchema schema) {
        if (this.serializedRows != null) {
            throw new RuntimeException("Buffer is finished");
        }
        if (this.tableRowsSerializer instanceof TableRowsWireSerializer) {
            ((TableRowsWireSerializer)this.tableRowsSerializer).write(rows, schema);
            return;
        }
        this.tableRowsSerializer.write(rows);
    }

    public byte[] finish() {
        if (this.serializedRows != null) {
            return this.serializedRows;
        }
        try {
            this.serializedRows = TableRowsSerializerUtil.serializeRowsWithDescriptor(this.tableRowsSerializer, this.tableRowsSerializer.getRowsetDescriptor());
        }
        catch (IOException ex) {
            throw new RuntimeException("Serialization was failed, but it wasn't expected");
        }
        return this.serializedRows;
    }
}

