/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ytsaurus.client.DataCenterRpcClientPool;
import tech.ytsaurus.client.HostPort;
import tech.ytsaurus.client.ProxySelector;
import tech.ytsaurus.client.SelfCheckingClientFactory;
import tech.ytsaurus.client.misc.SerializedExecutorService;
import tech.ytsaurus.client.rpc.RpcClient;
import tech.ytsaurus.core.GUID;
import tech.ytsaurus.lang.NonNullApi;
import tech.ytsaurus.lang.NonNullFields;

@NonNullApi
@NonNullFields
class ClientPool
implements DataCenterRpcClientPool {
    private static final Logger logger = LoggerFactory.getLogger(ClientPool.class);
    private final String dataCenterName;
    private final int maxSize;
    private final SelfCheckingClientFactory clientFactory;
    private final ExecutorService unsafeExecutorService;
    private final SerializedExecutorService safeExecutorService;
    private final Random random;
    private final ProxySelector proxySelector;
    private final Map<GUID, PooledRpcClient> activeClients = new HashMap<GUID, PooledRpcClient>();
    private CompletableFuture<Void> nextUpdate = new CompletableFuture();
    private volatile PooledRpcClient[] clientCache = new PooledRpcClient[0];
    @Nullable
    private volatile Runnable onAllBannedCallback = null;

    ClientPool(String dataCenterName, int maxSize, SelfCheckingClientFactory clientFactory, ExecutorService executorService, Random random) {
        this(dataCenterName, maxSize, clientFactory, executorService, random, ProxySelector.random());
    }

    ClientPool(String dataCenterName, int maxSize, SelfCheckingClientFactory clientFactory, ExecutorService executorService, Random random, ProxySelector proxySelector) {
        this.dataCenterName = dataCenterName;
        this.unsafeExecutorService = executorService;
        this.safeExecutorService = new SerializedExecutorService(executorService);
        this.random = random;
        this.maxSize = maxSize;
        this.clientFactory = clientFactory;
        this.proxySelector = proxySelector;
    }

    @Override
    public CompletableFuture<RpcClient> peekClient(CompletableFuture<?> release, Predicate<RpcClient> filter) {
        PooledRpcClient[] goodClientsRef = this.clientCache;
        CompletableFuture<RpcClient> result = new CompletableFuture<RpcClient>();
        if (!this.peekClientImpl(goodClientsRef, result, release, filter)) {
            this.safeExecutorService.submit(() -> this.peekClientUnsafe(result, release, filter));
        }
        return result;
    }

    CompletableFuture<Void> updateWithError(Throwable error) {
        return this.safeExecutorService.submit(() -> this.updateWithErrorUnsafe(error));
    }

    CompletableFuture<Void> updateClients(Collection<HostPort> proxies) {
        return this.safeExecutorService.submit(() -> this.updateClientsUnsafe(new HashSet<HostPort>(proxies)));
    }

    @Override
    public String getDataCenterName() {
        return this.dataCenterName;
    }

    void setOnAllBannedCallback(Runnable onAllBannedCallback) {
        this.onAllBannedCallback = onAllBannedCallback;
    }

    RpcClient[] getAliveClients() {
        PooledRpcClient[] tmp = this.clientCache;
        RpcClient[] result = new RpcClient[tmp.length];
        for (int i = 0; i < tmp.length; ++i) {
            result[i] = tmp[i].publicClient;
        }
        return result;
    }

    private void peekClientUnsafe(CompletableFuture<RpcClient> result, CompletableFuture<?> release, Predicate<RpcClient> filter) {
        if (this.peekClientImpl(this.clientCache, result, release, filter)) {
            return;
        }
        this.nextUpdate.whenComplete((v, t) -> {
            if (this.peekClientImpl(this.clientCache, result, release, filter)) {
                return;
            }
            RuntimeException error = new RuntimeException("Cannot get rpc proxies; DataCenter: " + this.dataCenterName);
            if (t != null) {
                error.initCause((Throwable)t);
            }
            result.completeExceptionally(error);
        });
    }

    private boolean peekClientImpl(PooledRpcClient[] clients, CompletableFuture<RpcClient> result, CompletableFuture<?> release, Predicate<RpcClient> filter) {
        if (clients.length > 0) {
            PooledRpcClient curClient;
            int i;
            int offset = this.random.nextInt(clients.length);
            PooledRpcClient pooledClient = null;
            for (i = 0; i < clients.length; ++i) {
                curClient = clients[(i + offset) % clients.length];
                if (curClient.banned || !filter.test(curClient.publicClient) || !curClient.ref()) continue;
                pooledClient = curClient;
                break;
            }
            if (pooledClient == null) {
                for (i = 0; i < clients.length; ++i) {
                    curClient = clients[(i + offset) % clients.length];
                    if (curClient.banned || !curClient.ref()) continue;
                    pooledClient = curClient;
                    break;
                }
            }
            if (pooledClient != null) {
                if (result.complete(pooledClient.publicClient)) {
                    PooledRpcClient pooledClientClosure = pooledClient;
                    release.whenComplete((o, throwable) -> pooledClientClosure.unref());
                } else {
                    pooledClient.unref();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public CompletableFuture<Integer> banClient(String address) {
        return this.banErrorClient(HostPort.parse(address));
    }

    CompletableFuture<Integer> banErrorClient(HostPort hostPort) {
        return this.safeExecutorService.submit(() -> {
            ArrayList<PooledRpcClient> toBan = new ArrayList<PooledRpcClient>();
            for (PooledRpcClient client : this.activeClients.values()) {
                if (!client.hostPort.equals(hostPort)) continue;
                toBan.add(client);
            }
            for (PooledRpcClient client : toBan) {
                this.banClientUnsafe(client, true);
            }
            return toBan.size();
        });
    }

    private void banErrorClient(PooledRpcClient client) {
        this.safeExecutorService.submit(() -> this.banClientUnsafe(client, true));
    }

    private void updateClientsUnsafe(Set<HostPort> proxies) {
        ArrayList<PooledRpcClient> toBan = new ArrayList<PooledRpcClient>();
        for (PooledRpcClient pooledRpcClient : this.activeClients.values()) {
            if (proxies.contains(pooledRpcClient.hostPort)) {
                proxies.remove(pooledRpcClient.hostPort);
                continue;
            }
            toBan.add(pooledRpcClient);
        }
        for (PooledRpcClient pooledRpcClient : toBan) {
            logger.debug("Banning unknown rpc-proxy connection {}", (Object)pooledRpcClient);
            this.banClientUnsafe(pooledRpcClient, false);
        }
        ArrayList<HostPort> remainingProxies = new ArrayList<HostPort>(proxies);
        this.proxySelector.rank(remainingProxies);
        for (HostPort hostPort : remainingProxies) {
            if (this.activeClients.size() >= this.maxSize) break;
            CompletableFuture<Void> clientStatusFuture = new CompletableFuture<Void>();
            RpcClient rpcClient = this.clientFactory.create(hostPort, this.dataCenterName, clientStatusFuture);
            GUID clientGuid = GUID.create();
            PooledRpcClient pooledClient = new PooledRpcClient(hostPort, rpcClient, clientGuid, clientStatusFuture);
            clientStatusFuture.whenComplete((result, error) -> {
                if (error != null) {
                    logger.debug("Banning {} because of error: ", (Object)pooledClient, error);
                    this.banErrorClient(pooledClient);
                }
            });
            logger.debug("Opened new rpc-proxy connection: {}", (Object)pooledClient);
            this.activeClients.put(clientGuid, pooledClient);
        }
        this.updateGoodClientsCacheUnsafe();
        CompletableFuture<Void> completableFuture = this.nextUpdate;
        this.nextUpdate = new CompletableFuture();
        completableFuture.complete(null);
    }

    private void updateWithErrorUnsafe(Throwable error) {
        CompletableFuture<Void> oldNextUpdate = this.nextUpdate;
        this.nextUpdate = new CompletableFuture();
        oldNextUpdate.completeExceptionally(error);
    }

    private void updateGoodClientsCacheUnsafe() {
        PooledRpcClient[] newCache = new PooledRpcClient[this.activeClients.size()];
        this.clientCache = this.activeClients.values().toArray(newCache);
        logger.debug("Updated client cache; {} clients available", (Object)this.clientCache.length);
    }

    private void banClientUnsafe(PooledRpcClient client, boolean updateClientCache) {
        PooledRpcClient pooledClient = this.activeClients.get(client.guid);
        if (pooledClient == null || pooledClient.banned) {
            return;
        }
        pooledClient.banned = true;
        pooledClient.unref();
        this.activeClients.remove(client.guid);
        if (updateClientCache) {
            this.updateGoodClientsCacheUnsafe();
            Runnable cb = this.onAllBannedCallback;
            if (this.activeClients.isEmpty() && cb != null) {
                this.unsafeExecutorService.execute(cb);
            }
        }
    }

    @NonNullFields
    @NonNullApi
    static class PooledRpcClient {
        final HostPort hostPort;
        final RpcClient publicClient;
        final GUID guid;
        final CompletableFuture<Void> statusFuture;
        volatile boolean banned = false;
        private final AtomicInteger referenceCounter = new AtomicInteger(1);

        PooledRpcClient(HostPort hostPort, RpcClient client, GUID guid, CompletableFuture<Void> clientStatusFuture) {
            this.hostPort = hostPort;
            this.publicClient = client;
            this.guid = guid;
            this.statusFuture = clientStatusFuture;
        }

        boolean ref() {
            int old = this.referenceCounter.getAndUpdate(x -> x == 0 ? 0 : ++x);
            return old > 0;
        }

        void unref() {
            int ref = this.referenceCounter.decrementAndGet();
            if (ref == 0) {
                logger.debug("Releasing rpc-proxy connection {}", (Object)this);
                this.publicClient.unref();
                this.statusFuture.complete(null);
            }
        }

        public String toString() {
            return String.format("[%s/%s]", this.guid, this.hostPort);
        }
    }
}

